/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.NativesDirectoryType;
import org.jackhuang.hmcl.game.QuickPlayOption;
import org.jackhuang.hmcl.game.Renderer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.CommandTooLongException;
import org.jackhuang.hmcl.launch.ExecutionPolicyLimitException;
import org.jackhuang.hmcl.launch.ExitWaiter;
import org.jackhuang.hmcl.launch.Launcher;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.ServerAddress;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemInfo;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public class DefaultLauncher
extends Launcher {
    private final LibraryAnalyzer analyzer;
    private final Map<String, Supplier<Boolean>> forbiddens = Lang.mapOf(Pair.pair("-Xincgc", () -> this.options.getJava().getParsedVersion() >= 9));

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options) {
        this(repository, version, authInfo, options, null);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener) {
        this(repository, version, authInfo, options, listener, true);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener, boolean daemon) {
        super(repository, version, authInfo, options, listener, daemon);
        this.analyzer = LibraryAnalyzer.analyze(version, repository.getGameVersion(version).orElse(null));
    }

    /*
     * Unable to fully structure code
     */
    private Command generateCommandLine(Path nativeFolder) throws IOException {
        block56: {
            block57: {
                res = new CommandBuilder();
                switch (1.$SwitchMap$org$jackhuang$hmcl$game$ProcessPriority[this.options.getProcessPriority().ordinal()]) {
                    case 1: {
                        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) break;
                        res.add(new String[]{"nice", "-n", "-5"});
                        break;
                    }
                    case 2: {
                        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) break;
                        res.add(new String[]{"nice", "-n", "-1"});
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) break;
                        res.add(new String[]{"nice", "-n", "1"});
                        break;
                    }
                    case 5: {
                        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS || !OperatingSystem.CURRENT_OS.isLinuxOrBSD() && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) break;
                        res.add(new String[]{"nice", "-n", "5"});
                    }
                }
                if (StringUtils.isNotBlank(this.options.getWrapper())) {
                    res.addAllWithoutParsing(StringUtils.tokenize(this.options.getWrapper(), this.getEnvVars()));
                }
                res.add(new String[]{this.options.getJava().getBinary().toString()});
                res.addAllWithoutParsing(this.options.getOverrideJavaArguments());
                if (this.options.getMaxMemory() != null && this.options.getMaxMemory() > 0) {
                    res.addDefault("-Xmx", this.options.getMaxMemory() + "m");
                }
                if (this.options.getMinMemory() != null && this.options.getMinMemory() > 0 && (this.options.getMaxMemory() == null || this.options.getMinMemory() <= this.options.getMaxMemory())) {
                    res.addDefault("-Xms", this.options.getMinMemory() + "m");
                }
                if (this.options.getMetaspace() != null && this.options.getMetaspace() > 0) {
                    if (this.options.getJava().getParsedVersion() < 8) {
                        res.addDefault("-XX:PermSize=", this.options.getMetaspace() + "m");
                    } else {
                        res.addDefault("-XX:MetaspaceSize=", this.options.getMetaspace() + "m");
                    }
                }
                res.addAllDefaultWithoutParsing(this.options.getJavaArguments());
                encoding = OperatingSystem.NATIVE_CHARSET;
                fileEncoding = res.addDefault("-Dfile.encoding=", encoding.name());
                if (fileEncoding != null && !"-Dfile.encoding=COMPAT".equals(fileEncoding)) {
                    try {
                        encoding = Charset.forName(fileEncoding.substring("-Dfile.encoding=".length()));
                    }
                    catch (Throwable ex) {
                        Logger.LOG.warning("Bad file encoding", ex);
                    }
                }
                if (this.options.getJava().getParsedVersion() < 19) {
                    res.addDefault("-Dsun.stdout.encoding=", encoding.name());
                    res.addDefault("-Dsun.stderr.encoding=", encoding.name());
                } else {
                    res.addDefault("-Dstdout.encoding=", encoding.name());
                    res.addDefault("-Dstderr.encoding=", encoding.name());
                }
                res.addDefault("-Djava.rmi.server.useCodebaseOnly=", "true");
                res.addDefault("-Dcom.sun.jndi.rmi.object.trustURLCodebase=", "false");
                res.addDefault("-Dcom.sun.jndi.cosnaming.object.trustURLCodebase=", "false");
                formatMsgNoLookups = res.addDefault("-Dlog4j2.formatMsgNoLookups=", "true");
                if (this.isUsingLog4j() && (this.options.isEnableDebugLogOutput() || !"-Dlog4j2.formatMsgNoLookups=false".equals(formatMsgNoLookups))) {
                    res.addDefault("-Dlog4j.configurationFile=", FileUtils.getAbsolutePath(this.getLog4jConfigurationFile()));
                }
                if (!this.options.isNoGeneratedJVMArgs()) {
                    this.appendJvmArgs(res);
                    res.addDefault("-Dminecraft.client.jar=", FileUtils.getAbsolutePath(this.repository.getVersionJar(this.version)));
                    if (OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) {
                        res.addDefault("-Xdock:name=", "Minecraft " + this.version.getId());
                        this.repository.getAssetObject(this.version.getId(), this.version.getAssetIndex().getId(), "icons/minecraft.icns").ifPresent((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$generateCommandLine$0(org.jackhuang.hmcl.util.platform.CommandBuilder java.nio.file.Path ), (Ljava/nio/file/Path;)V)((CommandBuilder)res));
                    }
                    if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
                        res.addDefault("-Duser.home=", this.options.getGameDir().toAbsolutePath().getParent().toString());
                    }
                    if ((proxyType = this.options.getProxyType()) == null) {
                        res.addDefault("-Djava.net.useSystemProxies", "true");
                    } else {
                        proxyHost = this.options.getProxyHost();
                        proxyPort = this.options.getProxyPort();
                        if (StringUtils.isNotBlank(proxyHost) && proxyPort >= 0 && proxyPort <= 65535) {
                            if (proxyType == Proxy.Type.HTTP) {
                                res.addDefault("-Dhttp.proxyHost=", proxyHost);
                                res.addDefault("-Dhttp.proxyPort=", String.valueOf(proxyPort));
                                res.addDefault("-Dhttps.proxyHost=", proxyHost);
                                res.addDefault("-Dhttps.proxyPort=", String.valueOf(proxyPort));
                            } else if (proxyType == Proxy.Type.SOCKS) {
                                res.addDefault("-DsocksProxyHost=", proxyHost);
                                res.addDefault("-DsocksProxyPort=", String.valueOf(proxyPort));
                            }
                        }
                    }
                    javaVersion = this.options.getJava().getParsedVersion();
                    v0 = is64bit = this.options.getJava().getBits() == Bits.BIT_64;
                    if (!this.options.isNoGeneratedOptimizingJVMArgs()) {
                        res.addUnstableDefault("UnlockExperimentalVMOptions", true);
                        res.addUnstableDefault("UnlockDiagnosticVMOptions", true);
                        if (javaVersion >= 8 && res.noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateCommandLine$1(java.lang.String ), (Ljava/lang/String;)Z)())) {
                            res.addUnstableDefault("UseG1GC", true);
                            res.addUnstableDefault("G1MixedGCCountTarget", "5");
                            res.addUnstableDefault("G1NewSizePercent", "20");
                            res.addUnstableDefault("G1ReservePercent", "20");
                            res.addUnstableDefault("MaxGCPauseMillis", "50");
                            res.addUnstableDefault("G1HeapRegionSize", "32m");
                        }
                        res.addUnstableDefault("OmitStackTraceInFastThrow", false);
                        if (javaVersion <= 8) {
                            res.addUnstableDefault("MaxInlineLevel", "15");
                        }
                        if (is64bit && SystemInfo.getTotalMemorySize() > 0x100000000L) {
                            res.addUnstableDefault("DontCompileHugeMethods", false);
                            res.addUnstableDefault("MaxNodeLimit", "240000");
                            res.addUnstableDefault("NodeLimitFudgeFactor", "8000");
                            res.addUnstableDefault("TieredCompileTaskTimeout", "10000");
                            res.addUnstableDefault("ReservedCodeCacheSize", "400M");
                            if (javaVersion >= 9) {
                                res.addUnstableDefault("NonNMethodCodeHeapSize", "12M");
                                res.addUnstableDefault("ProfiledCodeHeapSize", "194M");
                            }
                            if (javaVersion >= 8) {
                                res.addUnstableDefault("NmethodSweepActivity", "1");
                            }
                        }
                        if (is64bit && javaVersion == 25) {
                            res.addUnstableDefault("UseCompactObjectHeaders", true);
                        }
                        if (!is64bit) {
                            res.addDefault("-Xss", "1m");
                        }
                    }
                    if (javaVersion == 16) {
                        res.addDefault("--illegal-access=", "permit");
                    }
                    if (javaVersion == 24 || javaVersion == 25) {
                        res.addDefault("--sun-misc-unsafe-memory-access=", "allow");
                    }
                    res.addDefault("-Dfml.ignoreInvalidMinecraftCertificates=", "true");
                    res.addDefault("-Dfml.ignorePatchDiscrepancies=", "true");
                }
                classpath = this.repository.getClasspath(this.version);
                if (this.analyzer.has(LibraryAnalyzer.LibraryType.CLEANROOM)) {
                    classpath.removeIf((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateCommandLine$2(java.lang.String ), (Ljava/lang/String;)Z)());
                }
                if (!Files.isRegularFile(jar = this.repository.getVersionJar(this.version), new LinkOption[0])) {
                    throw new IOException("Minecraft jar does not exist");
                }
                classpath.add(FileUtils.getAbsolutePath(jar.toAbsolutePath()));
                gameAssets = this.repository.getActualAssetDirectory(this.version.getId(), this.version.getAssetIndex().getId());
                configuration = this.getConfigurations();
                configuration.put("${classpath}", String.join((CharSequence)File.pathSeparator, classpath));
                configuration.put("${game_assets}", FileUtils.getAbsolutePath(gameAssets));
                configuration.put("${assets_root}", FileUtils.getAbsolutePath(gameAssets));
                gameVersion = this.repository.getGameVersion(this.version);
                nativeFolderPath = FileUtils.getAbsolutePath(nativeFolder);
                tempNativeFolder = null;
                if ((OperatingSystem.CURRENT_OS == OperatingSystem.LINUX || OperatingSystem.CURRENT_OS == OperatingSystem.MACOS) && !StringUtils.isASCII((String)nativeFolderPath) && gameVersion.isPresent() && GameVersionNumber.compare(gameVersion.get(), "1.19") < 0) {
                    tempNativeFolder = Paths.get("/", new String[]{"tmp", "hmcl-natives-" + String.valueOf(UUID.randomUUID())});
                    nativeFolderPath = String.valueOf(tempNativeFolder) + File.pathSeparator + (String)nativeFolderPath;
                }
                configuration.put("${natives_directory}", (String)nativeFolderPath);
                res.addAll(Arguments.parseArguments(this.version.getArguments().map((Function<Arguments, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getJvm(), (Lorg/jackhuang/hmcl/game/Arguments;)Ljava/util/List;)()).orElseGet((Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getDefaultJVMArguments(), ()Ljava/util/List;)((DefaultLauncher)this)), configuration));
                argumentsFromAuthInfo = this.authInfo.getLaunchArguments(this.options);
                if (argumentsFromAuthInfo != null && argumentsFromAuthInfo.getJvm() != null && !argumentsFromAuthInfo.getJvm().isEmpty()) {
                    res.addAll(Arguments.parseArguments(argumentsFromAuthInfo.getJvm(), configuration));
                }
                for (String javaAgent : this.options.getJavaAgents()) {
                    res.add(new String[]{"-javaagent:" + javaAgent});
                }
                res.add(new String[]{this.version.getMainClass()});
                res.addAll(Arguments.parseStringArguments(this.version.getMinecraftArguments().map((Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tokenize(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).orElseGet((Supplier<List>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/List;)()), configuration));
                features = this.getFeatures();
                this.version.getArguments().map((Function<Arguments, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getGame(), (Lorg/jackhuang/hmcl/game/Arguments;)Ljava/util/List;)()).ifPresent((Consumer<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$generateCommandLine$3(org.jackhuang.hmcl.util.platform.CommandBuilder java.util.Map java.util.Map java.util.List ), (Ljava/util/List;)V)((CommandBuilder)res, configuration, features));
                if (this.version.getMinecraftArguments().isPresent()) {
                    res.addAll(Arguments.parseArguments(this.getDefaultGameArguments(), configuration, features));
                }
                if (argumentsFromAuthInfo != null && argumentsFromAuthInfo.getGame() != null && !argumentsFromAuthInfo.getGame().isEmpty()) {
                    res.addAll(Arguments.parseArguments(argumentsFromAuthInfo.getGame(), configuration, features));
                }
                if (!((var18_20 = this.options.getQuickPlayOption()) instanceof QuickPlayOption.MultiPlayer)) break block57;
                multiPlayer = (QuickPlayOption.MultiPlayer)var18_20;
                address = multiPlayer.serverIP();
                try {
                    parsed = ServerAddress.parse(address);
                    if (GameVersionNumber.asGameVersion(gameVersion).isAtLeast("1.20", "23w14a")) {
                        res.add(new String[]{"--quickPlayMultiplayer"});
                        res.add(new String[]{parsed.getPort() >= 0 ? address : parsed.getHost() + ":25565"});
                        break block56;
                    }
                    res.add(new String[]{"--server"});
                    res.add(new String[]{parsed.getHost()});
                    res.add(new String[]{"--port"});
                    res.add(new String[]{parsed.getPort() >= 0 ? String.valueOf(parsed.getPort()) : "25565"});
                }
                catch (IllegalArgumentException e) {
                    Logger.LOG.warning("Invalid server address: " + address, e);
                }
                break block56;
            }
            var18_20 = this.options.getQuickPlayOption();
            if (!(var18_20 instanceof QuickPlayOption.SinglePlayer)) ** GOTO lbl-1000
            singlePlayer = (QuickPlayOption.SinglePlayer)var18_20;
            if (GameVersionNumber.asGameVersion(gameVersion).isAtLeast("1.20", "23w14a")) {
                res.add(new String[]{"--quickPlaySingleplayer"});
                res.add(new String[]{singlePlayer.worldFolderName()});
            } else if ((var18_20 = this.options.getQuickPlayOption()) instanceof QuickPlayOption.Realm) {
                realm = (QuickPlayOption.Realm)var18_20;
                if (GameVersionNumber.asGameVersion(gameVersion).isAtLeast("1.20", "23w14a")) {
                    res.add(new String[]{"--quickPlayRealms"});
                    res.add(new String[]{realm.realmID()});
                }
            }
        }
        if (this.options.isFullscreen()) {
            res.add(new String[]{"--fullscreen"});
        }
        if (this.options.getProxyType() == Proxy.Type.SOCKS) {
            proxyHost = this.options.getProxyHost();
            proxyPort = this.options.getProxyPort();
            if (StringUtils.isNotBlank(proxyHost) && proxyPort >= 0 && proxyPort <= 65535) {
                res.add(new String[]{"--proxyHost"});
                res.add(new String[]{proxyHost});
                res.add(new String[]{"--proxyPort"});
                res.add(new String[]{String.valueOf(proxyPort)});
                if (StringUtils.isNotBlank(this.options.getProxyUser()) && StringUtils.isNotBlank(this.options.getProxyPass())) {
                    res.add(new String[]{"--proxyUser"});
                    res.add(new String[]{this.options.getProxyUser()});
                    res.add(new String[]{"--proxyPass"});
                    res.add(new String[]{this.options.getProxyPass()});
                }
            }
        }
        res.addAllWithoutParsing(Arguments.parseStringArguments(this.options.getGameArguments(), configuration));
        res.removeIf((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateCommandLine$4(java.lang.String ), (Ljava/lang/String;)Z)((DefaultLauncher)this));
        return new Command(res, tempNativeFolder, encoding);
    }

    public Map<String, Boolean> getFeatures() {
        return Collections.singletonMap("has_custom_resolution", this.options.getHeight() != null && this.options.getHeight() != 0 && this.options.getWidth() != null && this.options.getWidth() != 0);
    }

    protected Map<String, Supplier<Boolean>> getForbiddens() {
        return this.forbiddens;
    }

    protected List<Argument> getDefaultJVMArguments() {
        return Arguments.DEFAULT_JVM_ARGUMENTS;
    }

    protected List<Argument> getDefaultGameArguments() {
        return Arguments.DEFAULT_GAME_ARGUMENTS;
    }

    protected void appendJvmArgs(CommandBuilder result) {
    }

    public void decompressNatives(Path destination) throws NotDecompressingNativesException {
        try {
            FileUtils.cleanDirectoryQuietly(destination);
            for (Library library : this.version.getLibraries()) {
                if (!library.isNative()) continue;
                new Unzipper(this.repository.getLibraryFile(this.version, library), destination).setFilter((zipEntry, destFile, relativePath) -> {
                    if (!zipEntry.isDirectory() && !zipEntry.isUnixSymlink() && Files.isRegularFile(destFile, new LinkOption[0]) && zipEntry.getSize() == Files.size(destFile)) {
                        return false;
                    }
                    String ext = FileUtils.getExtension(destFile);
                    if (ext.equals("sha1") || ext.equals("git")) {
                        return false;
                    }
                    if (this.options.isUseNativeGLFW() && FileUtils.getName(destFile).toLowerCase(Locale.ROOT).contains("glfw")) {
                        return false;
                    }
                    if (this.options.isUseNativeOpenAL() && FileUtils.getName(destFile).toLowerCase(Locale.ROOT).contains("openal")) {
                        return false;
                    }
                    return library.getExtract().shouldExtract(relativePath);
                }).setReplaceExistentFile(false).unzip();
            }
        }
        catch (IOException e) {
            throw new NotDecompressingNativesException(e);
        }
    }

    private boolean isUsingLog4j() {
        return GameVersionNumber.compare(this.repository.getGameVersion(this.version).orElse("1.7"), "1.7") >= 0;
    }

    public Path getLog4jConfigurationFile() {
        return this.repository.getVersionRoot(this.version.getId()).resolve("log4j2.xml");
    }

    public void extractLog4jConfigurationFile() throws IOException {
        Path targetFile = this.getLog4jConfigurationFile();
        String sourcePath = GameVersionNumber.asGameVersion(this.repository.getGameVersion(this.version)).compareTo("1.12") < 0 ? (this.options.isEnableDebugLogOutput() ? "/assets/game/log4j2-1.7-debug.xml" : "/assets/game/log4j2-1.7.xml") : (this.options.isEnableDebugLogOutput() ? "/assets/game/log4j2-1.12-debug.xml" : "/assets/game/log4j2-1.12.xml");
        try (InputStream input = DefaultLauncher.class.getResourceAsStream(sourcePath);){
            Files.copy(input, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected Map<String, String> getConfigurations() {
        return Lang.mapOf(Pair.pair("${auth_player_name}", this.authInfo.getUsername()), Pair.pair("${auth_session}", this.authInfo.getAccessToken()), Pair.pair("${auth_access_token}", this.authInfo.getAccessToken()), Pair.pair("${auth_uuid}", UUIDTypeAdapter.fromUUID(this.authInfo.getUUID())), Pair.pair("${version_name}", Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId())), Pair.pair("${profile_name}", Optional.ofNullable(this.options.getProfileName()).orElse("Minecraft")), Pair.pair("${version_type}", Optional.ofNullable(this.options.getVersionType()).orElse(this.version.getType().getId())), Pair.pair("${game_directory}", FileUtils.getAbsolutePath(this.repository.getRunDirectory(this.version.getId()))), Pair.pair("${user_type}", this.authInfo.getUserType()), Pair.pair("${assets_index_name}", this.version.getAssetIndex().getId()), Pair.pair("${user_properties}", this.authInfo.getUserProperties()), Pair.pair("${resolution_width}", this.options.getWidth().toString()), Pair.pair("${resolution_height}", this.options.getHeight().toString()), Pair.pair("${library_directory}", FileUtils.getAbsolutePath(this.repository.getLibrariesDirectory(this.version))), Pair.pair("${classpath_separator}", File.pathSeparator), Pair.pair("${primary_jar}", FileUtils.getAbsolutePath(this.repository.getVersionJar(this.version))), Pair.pair("${language}", Locale.getDefault().toLanguageTag()), Pair.pair("${libraries_directory}", FileUtils.getAbsolutePath(this.repository.getLibrariesDirectory(this.version))), Pair.pair("${file_separator}", File.separator), Pair.pair("${primary_jar_name}", FileUtils.getName(this.repository.getVersionJar(this.version))));
    }

    @Override
    public ManagedProcess launch() throws IOException, InterruptedException {
        Process process;
        Path nativeFolder = this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER ? this.repository.getNativeDirectory(this.version.getId(), this.options.getJava().getPlatform()) : Path.of(this.options.getNativesDir(), new String[0]);
        Command command = this.generateCommandLine(nativeFolder);
        List<String> rawCommandLine = command.commandLine.asList();
        if (command.tempNativeFolder != null) {
            Files.deleteIfExists(command.tempNativeFolder);
            Files.createSymbolicLink(command.tempNativeFolder, nativeFolder.toAbsolutePath(), new FileAttribute[0]);
        }
        if (rawCommandLine.stream().anyMatch(StringUtils::isBlank)) {
            throw new IllegalStateException("Illegal command line " + String.valueOf(rawCommandLine));
        }
        if (this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER) {
            this.decompressNatives(nativeFolder);
        }
        if (this.isUsingLog4j()) {
            this.extractLog4jConfigurationFile();
        }
        Path runDirectory = this.repository.getRunDirectory(this.version.getId());
        if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
            ProcessBuilder builder = new ProcessBuilder(StringUtils.tokenize(this.options.getPreLaunchCommand(), this.getEnvVars())).directory(runDirectory.toFile());
            builder.environment().putAll(this.getEnvVars());
            SystemUtils.callExternalProcess(builder);
        }
        try {
            Path appdata;
            ProcessBuilder builder = new ProcessBuilder(rawCommandLine).directory(runDirectory.toFile());
            if (this.listener == null) {
                builder.inheritIO();
            }
            if ((appdata = this.options.getGameDir().toAbsolutePath().getParent()) != null) {
                builder.environment().put("APPDATA", appdata.toString());
            }
            builder.environment().putAll(this.getEnvVars());
            process = builder.start();
        }
        catch (IOException e) {
            throw new ProcessCreationException(e);
        }
        ManagedProcess p = new ManagedProcess(process, rawCommandLine);
        if (this.listener != null) {
            this.startMonitors(p, this.listener, command.encoding, this.daemon);
        }
        return p;
    }

    private Map<String, String> getEnvVars() {
        String versionName = Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId());
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        env.put("INST_NAME", versionName);
        env.put("INST_ID", versionName);
        env.put("INST_DIR", FileUtils.getAbsolutePath(this.repository.getVersionRoot(this.version.getId())));
        env.put("INST_MC_DIR", FileUtils.getAbsolutePath(this.repository.getRunDirectory(this.version.getId())));
        env.put("INST_JAVA", this.options.getJava().getBinary().toString());
        Renderer renderer = this.options.getRenderer();
        if (renderer != Renderer.DEFAULT) {
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                if (renderer != Renderer.LLVMPIPE) {
                    env.put("GALLIUM_DRIVER", renderer.name().toLowerCase(Locale.ROOT));
                }
            } else if (OperatingSystem.CURRENT_OS == OperatingSystem.LINUX) {
                env.put("__GLX_VENDOR_LIBRARY_NAME", "mesa");
                switch (renderer) {
                    case LLVMPIPE: {
                        env.put("LIBGL_ALWAYS_SOFTWARE", "1");
                        break;
                    }
                    case ZINK: {
                        env.put("MESA_LOADER_DRIVER_OVERRIDE", "zink");
                        env.put("LIBGL_KOPPER_DRI2", "1");
                    }
                }
            }
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
            env.put("INST_FORGE", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.CLEANROOM)) {
            env.put("INST_CLEANROOM", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE)) {
            env.put("INST_NEOFORGE", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.LITELOADER)) {
            env.put("INST_LITELOADER", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.FABRIC)) {
            env.put("INST_FABRIC", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
            env.put("INST_OPTIFINE", "1");
        }
        if (this.analyzer.has(LibraryAnalyzer.LibraryType.QUILT)) {
            env.put("INST_QUILT", "1");
        }
        env.putAll(this.options.getEnvironmentVariables());
        return env;
    }

    @Override
    public void makeLaunchScript(Path scriptFile) throws IOException {
        String scriptExtension;
        boolean usePowerShell;
        boolean isWindows = OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS;
        Path nativeFolder = this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER ? this.repository.getNativeDirectory(this.version.getId(), this.options.getJava().getPlatform()) : Path.of(this.options.getNativesDir(), new String[0]);
        if (this.options.getNativesDirType() == NativesDirectoryType.VERSION_FOLDER) {
            this.decompressNatives(nativeFolder);
        }
        if (this.isUsingLog4j()) {
            this.extractLog4jConfigurationFile();
        }
        if (!(usePowerShell = "ps1".equals(scriptExtension = FileUtils.getExtension(scriptFile)))) {
            if (isWindows && !scriptExtension.equals("bat")) {
                throw new IllegalArgumentException("The extension of " + String.valueOf(scriptFile) + " is not 'bat' or 'ps1' in Windows");
            }
            if (!(isWindows || scriptExtension.equals("sh") || scriptExtension.equals("command"))) {
                throw new IllegalArgumentException("The extension of " + String.valueOf(scriptFile) + " is not 'sh', 'ps1' or 'command' in macOS/Linux");
            }
        }
        Command commandLine = this.generateCommandLine(nativeFolder);
        String command = usePowerShell ? null : commandLine.commandLine.toString();
        Map<String, String> envVars = this.getEnvVars();
        if (!usePowerShell && isWindows && command.length() > 8192) {
            throw new CommandTooLongException();
        }
        Files.createDirectories(scriptFile.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(scriptFile, new OpenOption[0]);){
            Charset charset = StandardCharsets.UTF_8;
            if (isWindows) {
                if (usePowerShell) {
                    try {
                        outputStream.write(239);
                        outputStream.write(187);
                        outputStream.write(191);
                    }
                    catch (IOException e) {
                        outputStream.close();
                        throw e;
                    }
                } else {
                    charset = OperatingSystem.NATIVE_CHARSET;
                }
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
                if (usePowerShell) {
                    Iterator<String> appdata;
                    if (isWindows && (appdata = this.options.getGameDir().toAbsolutePath().getParent()) != null) {
                        writer.write("$Env:APPDATA=");
                        writer.write(CommandBuilder.pwshString(appdata.toString()));
                        writer.newLine();
                    }
                    for (Map.Entry entry : envVars.entrySet()) {
                        writer.write("$Env:" + (String)entry.getKey() + "=");
                        writer.write(CommandBuilder.pwshString((String)entry.getValue()));
                        writer.newLine();
                    }
                    writer.write("Set-Location -Path ");
                    writer.write(CommandBuilder.pwshString(FileUtils.getAbsolutePath(this.repository.getRunDirectory(this.version.getId()))));
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
                        writer.write(38);
                        for (String string : StringUtils.tokenize(this.options.getPreLaunchCommand(), envVars)) {
                            writer.write(32);
                            writer.write(CommandBuilder.pwshString(string));
                        }
                        writer.newLine();
                    }
                    writer.write(38);
                    for (String string : commandLine.commandLine.asList()) {
                        writer.write(32);
                        writer.write(CommandBuilder.pwshString(string));
                    }
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                        writer.write(38);
                        for (String string : StringUtils.tokenize(this.options.getPostExitCommand(), envVars)) {
                            writer.write(32);
                            writer.write(CommandBuilder.pwshString(string));
                        }
                        writer.newLine();
                    }
                } else {
                    if (isWindows) {
                        writer.write("@echo off");
                        writer.newLine();
                        Path appdata = this.options.getGameDir().toAbsolutePath().getParent();
                        if (appdata != null) {
                            writer.write("set APPDATA=" + String.valueOf(appdata));
                            writer.newLine();
                        }
                        for (Map.Entry<String, String> entry : envVars.entrySet()) {
                            writer.write("set " + entry.getKey() + "=" + CommandBuilder.toBatchStringLiteral(entry.getValue()));
                            writer.newLine();
                        }
                        writer.newLine();
                        writer.write(new CommandBuilder().add("cd", "/D", FileUtils.getAbsolutePath(this.repository.getRunDirectory(this.version.getId()))).toString());
                    } else {
                        writer.write("#!/usr/bin/env bash");
                        writer.newLine();
                        for (Map.Entry<String, String> entry : envVars.entrySet()) {
                            writer.write("export " + entry.getKey() + "=" + CommandBuilder.toShellStringLiteral(entry.getValue()));
                            writer.newLine();
                        }
                        if (commandLine.tempNativeFolder != null) {
                            writer.write(new CommandBuilder().add("ln", "-s", FileUtils.getAbsolutePath(nativeFolder), commandLine.tempNativeFolder.toString()).toString());
                            writer.newLine();
                        }
                        writer.write(new CommandBuilder().add("cd", FileUtils.getAbsolutePath(this.repository.getRunDirectory(this.version.getId()))).toString());
                    }
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
                        writer.write(new CommandBuilder().addAll(StringUtils.tokenize(this.options.getPreLaunchCommand(), envVars)).toString());
                        writer.newLine();
                    }
                    writer.write(command);
                    writer.newLine();
                    if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                        writer.write(new CommandBuilder().addAll(StringUtils.tokenize(this.options.getPostExitCommand(), envVars)).toString());
                        writer.newLine();
                    }
                    if (isWindows) {
                        writer.write("pause");
                        writer.newLine();
                    }
                    if (commandLine.tempNativeFolder != null) {
                        writer.write(new CommandBuilder().add("rm", commandLine.tempNativeFolder.toString()).toString());
                        writer.newLine();
                    }
                }
            }
        }
        FileUtils.setExecutable(scriptFile);
        if (!Files.isExecutable(scriptFile)) {
            throw new PermissionException();
        }
        if (usePowerShell && !CommandBuilder.hasExecutionPolicy()) {
            throw new ExecutionPolicyLimitException();
        }
    }

    private void startMonitors(ManagedProcess managedProcess, ProcessListener processListener, Charset encoding, boolean isDaemon) {
        processListener.setProcess(managedProcess);
        Thread stdout = Lang.thread(new StreamPump(managedProcess.getProcess().getInputStream(), it -> {
            processListener.onLog((String)it, false);
            managedProcess.addLine((String)it);
        }, encoding), "stdout-pump", isDaemon);
        managedProcess.addRelatedThread(stdout);
        Thread stderr = Lang.thread(new StreamPump(managedProcess.getProcess().getErrorStream(), it -> {
            processListener.onLog((String)it, true);
            managedProcess.addLine((String)it);
        }, encoding), "stderr-pump", isDaemon);
        managedProcess.addRelatedThread(stderr);
        managedProcess.addRelatedThread(Lang.thread(new ExitWaiter(managedProcess, Arrays.asList(stdout, stderr), (exitCode, exitType) -> {
            processListener.onExit((int)exitCode, (ProcessListener.ExitType)((Object)exitType));
            if (StringUtils.isNotBlank(this.options.getPostExitCommand())) {
                try {
                    ProcessBuilder builder = new ProcessBuilder(StringUtils.tokenize(this.options.getPostExitCommand(), this.getEnvVars())).directory(this.options.getGameDir().toFile());
                    builder.environment().putAll(this.getEnvVars());
                    SystemUtils.callExternalProcess(builder);
                }
                catch (Throwable e) {
                    Logger.LOG.warning("An Exception happened while running exit command.", e);
                }
            }
        }), "exit-waiter", isDaemon));
    }

    private /* synthetic */ boolean lambda$generateCommandLine$4(String it) {
        return this.getForbiddens().containsKey(it) && this.getForbiddens().get(it).get() != false;
    }

    private static /* synthetic */ void lambda$generateCommandLine$3(CommandBuilder res, Map configuration, Map features, List arguments) {
        res.addAll(Arguments.parseArguments(arguments, configuration, features));
    }

    private static /* synthetic */ boolean lambda$generateCommandLine$2(String c) {
        return c.contains("2.9.4-nightly-20150209");
    }

    private static /* synthetic */ boolean lambda$generateCommandLine$1(String arg) {
        return "-XX:-UseG1GC".equals(arg) || arg.startsWith("-XX:+Use") && arg.endsWith("GC");
    }

    private static /* synthetic */ void lambda$generateCommandLine$0(CommandBuilder res, Path minecraftIcns) {
        res.addDefault("-Xdock:icon=", FileUtils.getAbsolutePath(minecraftIcns));
    }

    private static final class Command {
        final CommandBuilder commandLine;
        final Path tempNativeFolder;
        final Charset encoding;

        Command(CommandBuilder commandBuilder, Path tempNativeFolder, Charset encoding) {
            this.commandLine = commandBuilder;
            this.tempNativeFolder = tempNativeFolder;
            this.encoding = encoding;
        }
    }
}

