/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXPopup;
import com.jfoenix.effects.JFXDepthManager;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Scale;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;

public class JFXPopupSkin
implements Skin<JFXPopup> {
    protected JFXPopup control;
    protected StackPane container = new StackPane();
    protected Region popupContent;
    protected Node root;
    private Animation animation;
    protected Scale scale;

    public JFXPopupSkin(JFXPopup control) {
        this.control = control;
        this.scale = new Scale(1.0, 0.01, 0.0, 0.0);
        this.popupContent = control.getPopupContent();
        this.container.getStyleClass().add((Object)"jfx-popup-container");
        this.container.getChildren().add((Object)this.popupContent);
        this.container.getTransforms().add((Object)this.scale);
        this.container.setOpacity(0.0);
        this.root = JFXDepthManager.createMaterialNode((Node)this.container, 4);
        this.animation = AnimationUtils.isAnimationEnabled() ? this.getAnimation() : null;
    }

    public void reset(JFXPopup.PopupVPosition vAlign, JFXPopup.PopupHPosition hAlign, double offsetX, double offsetY) {
        this.scale.setPivotX(hAlign == JFXPopup.PopupHPosition.RIGHT ? this.container.getWidth() : 0.0);
        this.scale.setPivotY(vAlign == JFXPopup.PopupVPosition.BOTTOM ? this.container.getHeight() : 0.0);
        this.control.setX(this.control.getX() + (hAlign == JFXPopup.PopupHPosition.RIGHT ? -this.container.getWidth() + offsetX : offsetX));
        this.control.setY(this.control.getY() + (vAlign == JFXPopup.PopupVPosition.BOTTOM ? -this.container.getHeight() + offsetY : offsetY));
    }

    public final void animate() {
        if (this.animation != null) {
            if (this.animation.getStatus() == Animation.Status.STOPPED) {
                this.container.setOpacity(1.0);
                this.animation.playFromStart();
            }
        } else {
            this.container.setOpacity(1.0);
            this.popupContent.setOpacity(1.0);
            this.scale.setX(1.0);
            this.scale.setY(1.0);
        }
    }

    public JFXPopup getSkinnable() {
        return this.control;
    }

    public Node getNode() {
        return this.root;
    }

    public void dispose() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
        this.container = null;
        this.control = null;
        this.popupContent = null;
        this.root = null;
    }

    protected Animation getAnimation() {
        Interpolator interpolator = Motion.EASE;
        return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.popupContent.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.scale.xProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.scale.yProperty(), (Object)0, interpolator)}), new KeyFrame(Motion.SHORT4, new KeyValue[]{new KeyValue((WritableValue)this.popupContent.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)this.scale.xProperty(), (Object)1, interpolator)}), new KeyFrame(Motion.MEDIUM2, new KeyValue[]{new KeyValue((WritableValue)this.popupContent.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)this.scale.yProperty(), (Object)1, interpolator)})});
    }

    public void init() {
        if (this.animation != null) {
            this.animation.stop();
        }
        this.container.setOpacity(0.0);
        this.scale.setX(1.0);
        this.scale.setY(0.01);
    }
}

