/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableDoubleValue;
import kala.compress.archivers.tar.TarArchiveEntry;
import org.jackhuang.hmcl.download.ArtifactMalformedException;
import org.jackhuang.hmcl.task.FetchTask;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.provider.AbstractTerracottaProvider;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.tree.TarFileTree;

public final class TerracottaBundle {
    private final Path root;
    private final List<URI> links;
    private final FileDownloadTask.IntegrityCheck hash;
    private final Map<String, FileDownloadTask.IntegrityCheck> files;

    public TerracottaBundle(Path root, List<URI> links, FileDownloadTask.IntegrityCheck hash, Map<String, FileDownloadTask.IntegrityCheck> files) {
        this.root = root;
        this.links = links;
        this.hash = hash;
        this.files = files;
    }

    public Task<Path> download(final AbstractTerracottaProvider.DownloadContext context) {
        return Task.supplyAsync(() -> Files.createTempFile("terracotta-", ".tar.gz", new FileAttribute[0])).thenComposeAsync(Schedulers.javafx(), pkg -> {
            FileDownloadTask download = new FileDownloadTask(this.links, (Path)pkg, this.hash){

                @Override
                protected FetchTask.Context getContext(HttpResponse<?> response, boolean checkETag, String bmclapiHash) throws IOException {
                    final FetchTask.Context delegate = super.getContext(response, checkETag, bmclapiHash);
                    return new FetchTask.Context(){

                        @Override
                        public void withResult(boolean success) {
                            delegate.withResult(success);
                        }

                        @Override
                        public void write(byte[] buffer, int offset, int len) throws IOException {
                            context.checkCancellation();
                            delegate.write(buffer, offset, len);
                        }

                        @Override
                        public void close() throws IOException {
                            if (this.isSuccess()) {
                                context.checkCancellation();
                            }
                            delegate.close();
                        }
                    };
                }
            };
            context.bindProgress((ObservableDoubleValue)download.progressProperty());
            return download.thenSupplyAsync(() -> pkg);
        });
    }

    public Task<?> install(Path pkg) {
        return Task.runAsync(() -> {
            Files.createDirectories(this.root, new FileAttribute[0]);
            FileUtils.cleanDirectory(this.root);
            try (TarFileTree tree = TarFileTree.open(pkg);){
                for (Map.Entry<String, FileDownloadTask.IntegrityCheck> entry : this.files.entrySet()) {
                    String file = entry.getKey();
                    FileDownloadTask.IntegrityCheck check = entry.getValue();
                    Path path = this.root.resolve(file);
                    TarArchiveEntry archive = (TarArchiveEntry)tree.getEntry("/" + file);
                    if (archive == null) {
                        throw new ArtifactMalformedException(String.format("Expecting %s file in terracotta bundle.", file));
                    }
                    MessageDigest digest = DigestUtils.getDigest(check.getAlgorithm());
                    try (InputStream is = tree.getInputStream(archive);
                         DigestOutputStream os = new DigestOutputStream(Files.newOutputStream(path, new OpenOption[0]), digest);){
                        is.transferTo(os);
                    }
                    String hash = HexFormat.of().formatHex(digest.digest());
                    if (!check.getChecksum().equalsIgnoreCase(hash)) {
                        throw new ChecksumMismatchException(check.getAlgorithm(), check.getChecksum(), hash);
                    }
                    switch (OperatingSystem.CURRENT_OS) {
                        case LINUX: 
                        case MACOS: 
                        case FREEBSD: {
                            Files.setPosixFilePermissions(path, FileUtils.parsePosixFilePermission(archive.getMode()));
                        }
                    }
                }
            }
        }).whenComplete(exception -> {
            if (exception != null) {
                FileUtils.deleteDirectory(this.root);
            }
        });
    }

    public Path locate(String file) {
        FileDownloadTask.IntegrityCheck check = this.files.get(file);
        if (check == null) {
            throw new AssertionError((Object)String.format("Expecting %s file in terracotta bundle.", file));
        }
        return this.root.resolve(file).toAbsolutePath();
    }

    public AbstractTerracottaProvider.Status status() throws IOException {
        if (Files.exists(this.root, new LinkOption[0]) && this.isLocalBundleValid()) {
            return AbstractTerracottaProvider.Status.READY;
        }
        try {
            if (TerracottaMetadata.hasLegacyVersionFiles()) {
                return AbstractTerracottaProvider.Status.LEGACY_VERSION;
            }
        }
        catch (IOException e) {
            Logger.LOG.warning("Cannot determine whether legacy versions exist.", e);
        }
        return AbstractTerracottaProvider.Status.NOT_EXIST;
    }

    private boolean isLocalBundleValid() throws IOException {
        long total = 0L;
        byte[] buffer = new byte[8192];
        for (Map.Entry<String, FileDownloadTask.IntegrityCheck> entry : this.files.entrySet()) {
            Path path = this.root.resolve(entry.getKey());
            FileDownloadTask.IntegrityCheck check = entry.getValue();
            if (!Files.isReadable(path)) {
                return false;
            }
            MessageDigest digest = DigestUtils.getDigest(check.getAlgorithm());
            try (DigestInputStream is = new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), digest);){
                int n;
                while ((n = ((InputStream)is).read(buffer)) >= 0) {
                    if ((total += (long)n) < 0x3200000L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            if (HexFormat.of().formatHex(digest.digest()).equalsIgnoreCase(check.getChecksum())) continue;
            return false;
        }
        return true;
    }
}

