/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.SVGPath;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.Motion;

public final class SVGContainer
extends Parent {
    private static final String DEFAULT_STYLE_CLASS = "svg-container";
    private final SVGPath path = new SVGPath();
    private SVG icon = SVG.NONE;
    private double iconSize = 24.0;
    private SVGPath tempPath;
    private Timeline timeline;

    public SVGContainer() {
        this(SVG.NONE, 24.0);
    }

    public SVGContainer(SVG icon) {
        this(icon, 24.0);
    }

    public SVGContainer(double iconSize) {
        this(SVG.NONE, iconSize);
    }

    public SVGContainer(SVG icon, double iconSize) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.path.getStyleClass().add((Object)"svg");
        this.setIconSizeImpl(iconSize);
        this.setIcon(icon);
    }

    public double getIconSize() {
        return this.iconSize;
    }

    private void setIconSizeImpl(double newSize) {
        this.iconSize = newSize;
        SVG.setSize(this.path, newSize);
        if (this.tempPath != null) {
            SVG.setSize(this.tempPath, newSize);
        }
    }

    public void setIconSize(double newSize) {
        this.setIconSizeImpl(newSize);
        this.requestLayout();
    }

    public SVG getIcon() {
        return this.icon;
    }

    public void setIcon(SVG newIcon) {
        this.setIcon(newIcon, Duration.ZERO);
    }

    public void setIcon(SVG newIcon, Duration animationDuration) {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
        SVG oldIcon = this.icon;
        this.icon = newIcon;
        if (animationDuration.equals((Object)Duration.ZERO)) {
            this.path.setContent(newIcon.getPath());
            this.path.setOpacity(1.0);
            if (this.getChildren().size() != 1) {
                this.getChildren().setAll((Object[])new Node[]{this.path});
            }
        } else {
            if (this.tempPath == null) {
                this.tempPath = new SVGPath();
                this.tempPath.getStyleClass().add((Object)"svg");
                SVG.setSize(this.tempPath, this.iconSize);
            } else {
                this.tempPath.setOpacity(1.0);
            }
            this.tempPath.setContent(oldIcon.getPath());
            this.getChildren().setAll((Object[])new Node[]{this.path, this.tempPath});
            this.path.setOpacity(0.0);
            this.path.setContent(newIcon.getPath());
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.path.opacityProperty(), (Object)0, Motion.LINEAR), new KeyValue((WritableValue)this.tempPath.opacityProperty(), (Object)1, Motion.LINEAR)}), new KeyFrame(animationDuration, new KeyValue[]{new KeyValue((WritableValue)this.path.opacityProperty(), (Object)1, Motion.LINEAR), new KeyValue((WritableValue)this.tempPath.opacityProperty(), (Object)0, Motion.LINEAR)})});
            this.timeline.setOnFinished(e -> {
                this.getChildren().setAll((Object[])new Node[]{this.path});
                this.timeline = null;
            });
            this.timeline.play();
        }
    }

    public double prefWidth(double height) {
        return this.iconSize;
    }

    public double prefHeight(double width) {
        return this.iconSize;
    }

    public double minHeight(double width) {
        return this.iconSize;
    }

    public double minWidth(double height) {
        return this.iconSize;
    }

    protected void layoutChildren() {
    }
}

