/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.LineComponent;

public final class LineTextPane
extends LineComponent {
    private static final String DEFAULT_STYLE_CLASS = "line-text-pane";
    private StringProperty text;

    public LineTextPane() {
        this.getStyleClass().addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(){
                private Label rightLabel;

                public Object getBean() {
                    return LineTextPane.this;
                }

                public String getName() {
                    return "text";
                }

                protected void invalidated() {
                    String text = this.get();
                    if (text != null && !text.isEmpty()) {
                        if (this.rightLabel == null) {
                            this.rightLabel = FXUtils.newSafeTruncatedLabel();
                            FXUtils.copyOnDoubleClick((Labeled)this.rightLabel);
                        }
                        this.rightLabel.setText(text);
                        LineTextPane.this.setNode(2, (Node)this.rightLabel);
                    } else {
                        if (this.rightLabel != null) {
                            this.rightLabel.setText(null);
                        }
                        LineTextPane.this.setNode(2, null);
                    }
                }
            };
        }
        return this.text;
    }

    public String getText() {
        return (String)this.textProperty().get();
    }

    public void setText(String text) {
        this.textProperty().set((Object)text);
    }
}

