/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPopup;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.GameListPopupMenu;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.NativePatcher;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class MainPage
extends StackPane
implements DecoratorPage {
    private static final String ANNOUNCEMENT = "announcement";
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final StringProperty currentGame = new SimpleStringProperty((Object)this, "currentGame");
    private final BooleanProperty showUpdate = new SimpleBooleanProperty((Object)this, "showUpdate");
    private final ObjectProperty<RemoteVersion> latestVersion = new SimpleObjectProperty((Object)this, "latestVersion");
    private final ObservableList<Version> versions = FXCollections.observableArrayList();
    private Profile profile;
    private TransitionPane announcementPane;
    private final StackPane updatePane;
    private final JFXButton menuButton;

    public MainPage() {
        HBox titleNode = new HBox(8.0);
        titleNode.setPadding(new Insets(0.0, 0.0, 0.0, 2.0));
        titleNode.setAlignment(Pos.CENTER_LEFT);
        ImageView titleIcon = new ImageView(FXUtils.newBuiltinImage("/assets/img/icon-title.png"));
        Label titleLabel = new Label(Metadata.FULL_TITLE);
        if (I18n.isUpsideDown()) {
            titleIcon.setRotate(180.0);
            titleLabel.setRotate(180.0);
        }
        titleLabel.getStyleClass().add((Object)"jfx-decorator-title");
        titleLabel.textFillProperty().bind(Themes.titleFillProperty());
        titleNode.getChildren().setAll((Object[])new Node[]{titleIcon, titleLabel});
        this.state.setValue((Object)new DecoratorPage.State(null, (Node)titleNode, false, false, true));
        this.setPadding(new Insets(20.0));
        if (Metadata.isNightly() || Metadata.isDev() && !Objects.equals(Metadata.VERSION, ConfigHolder.config().getShownTips().get((Object)ANNOUNCEMENT))) {
            String content;
            String title;
            if (Metadata.isNightly()) {
                title = I18n.i18n("update.channel.nightly.title");
                content = I18n.i18n("update.channel.nightly.hint");
            } else {
                title = I18n.i18n("update.channel.dev.title");
                content = I18n.i18n("update.channel.dev.hint");
            }
            VBox announcementCard = new VBox();
            BorderPane titleBar = new BorderPane();
            titleBar.getStyleClass().add((Object)"title");
            titleBar.setLeft((Node)new Label(title));
            JFXButton btnHide = new JFXButton();
            btnHide.setOnAction(e -> {
                this.announcementPane.setContent((Node)new StackPane(), ContainerAnimations.FADE);
                if (Metadata.isDev()) {
                    ConfigHolder.config().getShownTips().put((Object)ANNOUNCEMENT, (Object)Metadata.VERSION);
                }
            });
            btnHide.getStyleClass().add((Object)"announcement-close-button");
            btnHide.setGraphic((Node)SVG.CLOSE.createIcon(20.0));
            titleBar.setRight((Node)btnHide);
            TextFlow body = FXUtils.segmentToTextFlow(content, Controllers::onHyperlinkAction);
            body.setLineSpacing(4.0);
            announcementCard.getChildren().setAll((Object[])new Node[]{titleBar, body});
            announcementCard.setSpacing(16.0);
            announcementCard.getStyleClass().addAll((Object[])new String[]{"card", ANNOUNCEMENT});
            VBox announcementBox = new VBox(16.0);
            announcementBox.setPadding(new Insets(15.0));
            announcementBox.getChildren().add((Object)announcementCard);
            this.announcementPane = new TransitionPane();
            this.announcementPane.setContent((Node)announcementBox, ContainerAnimations.NONE);
            StackPane.setMargin((Node)this.announcementPane, (Insets)new Insets(-15.0));
            this.getChildren().add((Object)this.announcementPane);
        }
        this.updatePane = new StackPane();
        this.updatePane.setVisible(false);
        this.updatePane.getStyleClass().add((Object)"bubble");
        FXUtils.setLimitWidth((Region)this.updatePane, 230.0);
        FXUtils.setLimitHeight((Region)this.updatePane, 55.0);
        StackPane.setAlignment((Node)this.updatePane, (Pos)Pos.TOP_RIGHT);
        FXUtils.onClicked((Node)this.updatePane, this::onUpgrade);
        FXUtils.onChange(this.showUpdateProperty(), this::showUpdate);
        HBox hBox = new HBox();
        hBox.setSpacing(12.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)hBox, (Pos)Pos.CENTER_LEFT);
        StackPane.setMargin((Node)hBox, (Insets)new Insets(9.0, 12.0, 9.0, 16.0));
        TwoLineListItem prompt = new TwoLineListItem();
        prompt.setSubtitle(I18n.i18n("update.bubble.subtitle"));
        prompt.setPickOnBounds(false);
        prompt.titleProperty().bind(BindingMapping.of(this.latestVersionProperty()).map(latestVersion -> latestVersion == null ? "" : I18n.i18n("update.bubble.title", latestVersion.getVersion())));
        hBox.getChildren().setAll((Object[])new Node[]{SVG.UPDATE.createIcon(20.0), prompt});
        JFXButton closeUpdateButton = new JFXButton();
        closeUpdateButton.setGraphic((Node)SVG.CLOSE.createIcon(10.0));
        StackPane.setAlignment((Node)closeUpdateButton, (Pos)Pos.TOP_RIGHT);
        closeUpdateButton.getStyleClass().add((Object)"toggle-icon-tiny");
        StackPane.setMargin((Node)closeUpdateButton, (Insets)new Insets(5.0));
        closeUpdateButton.setOnAction(e -> this.closeUpdateBubble());
        this.updatePane.getChildren().setAll((Object[])new Node[]{hBox, closeUpdateButton});
        HBox launchPane = new HBox();
        launchPane.getStyleClass().add((Object)"launch-pane");
        FXUtils.onScroll((Node)launchPane, this.versions, list -> {
            String currentId = this.getCurrentGame();
            return Lang.indexWhere(list, instance -> instance.getId().equals(currentId));
        }, it -> this.profile.setSelectedVersion(it.getId()));
        StackPane.setAlignment((Node)launchPane, (Pos)Pos.BOTTOM_RIGHT);
        final JFXButton launchButton = new JFXButton();
        launchButton.getStyleClass().add((Object)"launch-button");
        launchButton.setDefaultButton(true);
        final VBox graphic = new VBox();
        graphic.setAlignment(Pos.CENTER);
        final Label launchLabel = new Label();
        launchLabel.setStyle("-fx-font-size: 16px;");
        final Label currentLabel = new Label();
        currentLabel.setStyle("-fx-font-size: 12px;");
        FXUtils.onChangeAndOperate(this.currentGameProperty(), new Consumer<String>(){
            private Tooltip tooltip;

            @Override
            public void accept(String currentGame) {
                if (currentGame == null) {
                    launchLabel.setText(I18n.i18n("version.launch.empty"));
                    currentLabel.setText(null);
                    graphic.getChildren().setAll((Object[])new Node[]{launchLabel});
                    launchButton.setOnAction(e -> MainPage.this.launchNoGame());
                    if (this.tooltip == null) {
                        this.tooltip = new Tooltip(I18n.i18n("version.launch.empty.tooltip"));
                    }
                    FXUtils.installFastTooltip((Node)launchButton, this.tooltip);
                } else {
                    launchLabel.setText(I18n.i18n("version.launch"));
                    currentLabel.setText(currentGame);
                    graphic.getChildren().setAll((Object[])new Node[]{launchLabel, currentLabel});
                    launchButton.setOnAction(e -> MainPage.this.launch());
                    if (this.tooltip != null) {
                        Tooltip.uninstall((Node)launchButton, (Tooltip)this.tooltip);
                    }
                }
            }
        });
        launchButton.setGraphic((Node)graphic);
        this.menuButton = new JFXButton();
        this.menuButton.getStyleClass().add((Object)"menu-button");
        this.menuButton.setOnAction(e -> GameListPopupMenu.show((Node)this.menuButton, JFXPopup.PopupVPosition.BOTTOM, JFXPopup.PopupHPosition.RIGHT, 0.0, -this.menuButton.getHeight(), this.profile, this.versions));
        FXUtils.installFastTooltip((Node)this.menuButton, I18n.i18n("version.switch"));
        this.menuButton.setGraphic((Node)SVG.ARROW_DROP_UP.createIcon(30.0));
        EventHandler secondaryClickHandle = event -> {
            if (event.getButton() == MouseButton.SECONDARY && event.getClickCount() == 1) {
                this.menuButton.fire();
                event.consume();
            }
        };
        launchButton.addEventHandler(MouseEvent.MOUSE_CLICKED, secondaryClickHandle);
        this.menuButton.addEventHandler(MouseEvent.MOUSE_CLICKED, secondaryClickHandle);
        launchPane.getChildren().setAll((Object[])new Node[]{launchButton, this.menuButton});
        this.getChildren().addAll((Object[])new Node[]{this.updatePane, launchPane});
    }

    private void showUpdate(boolean show) {
        this.doAnimation(show);
        if (show && this.getLatestVersion() != null && !Objects.equals(ConfigHolder.config().getPromptedVersion(), this.getLatestVersion().getVersion())) {
            Controllers.dialog((Region)new MessageDialogPane.Builder("", I18n.i18n("update.bubble.title", this.getLatestVersion().getVersion()), MessageDialogPane.MessageType.INFO).addAction(I18n.i18n("button.view"), () -> {
                ConfigHolder.config().setPromptedVersion(this.getLatestVersion().getVersion());
                this.onUpgrade();
            }).addCancel(null).build());
        }
    }

    private void doAnimation(boolean show) {
        if (AnimationUtils.isAnimationEnabled()) {
            Duration duration = Duration.millis((double)320.0);
            Timeline nowAnimation = new Timeline();
            nowAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.updatePane.translateXProperty(), (Object)(show ? 260 : 0), FXUtils.SINE)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.updatePane.translateXProperty(), (Object)(show ? 0 : 260), FXUtils.SINE)})});
            if (show) {
                nowAnimation.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, e -> this.updatePane.setVisible(true), new KeyValue[0]));
            } else {
                nowAnimation.getKeyFrames().add((Object)new KeyFrame(duration, e -> this.updatePane.setVisible(false), new KeyValue[0]));
            }
            nowAnimation.play();
        } else {
            this.updatePane.setVisible(show);
        }
    }

    private void launch() {
        Profile profile = Profiles.getSelectedProfile();
        Versions.launch(profile, profile.getSelectedVersion(), new Consumer[0]);
    }

    private void launchNoGame() {
        DownloadProvider downloadProvider = DownloadProviders.getDownloadProvider();
        VersionList<?> versionList = downloadProvider.getVersionListById("game");
        Holder gameVersionHolder = new Holder();
        Task<Void> task = versionList.refreshAsync("").thenSupplyAsync(() -> versionList.getVersions("").stream().filter(it -> it.getVersionType() == RemoteVersion.Type.RELEASE).filter(it -> NativePatcher.checkSupportedStatus(GameVersionNumber.asGameVersion(it.getGameVersion()), Platform.SYSTEM_PLATFORM, OperatingSystem.SYSTEM_VERSION) != NativePatcher.SupportStatus.UNSUPPORTED).sorted().findFirst().orElseThrow(() -> new IOException("No versions found"))).thenComposeAsync(version -> {
            Profile profile = Profiles.getSelectedProfile();
            DefaultDependencyManager dependency = profile.getDependency();
            gameVersionHolder.value = version.getGameVersion();
            String gameVersion = gameVersionHolder.value;
            return dependency.gameBuilder().name(gameVersion).gameVersion(gameVersion).buildAsync();
        }).whenComplete(any -> this.profile.getRepository().refreshVersions()).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.profile.setSelectedVersion((String)gameVersionHolder.value);
                this.launch();
            } else if (exception instanceof CancellationException) {
                Controllers.showToast(I18n.i18n("message.cancelled"));
            } else {
                Logger.LOG.warning("Failed to install game", exception);
                Controllers.dialog(StringUtils.getStackTrace(exception), I18n.i18n("install.failed"), MessageDialogPane.MessageType.WARNING);
            }
        });
        Controllers.taskDialog(task, I18n.i18n("version.launch.empty.installing"), TaskCancellationAction.NORMAL);
    }

    private void onUpgrade() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    private void closeUpdateBubble() {
        this.showUpdate.unbind();
        this.showUpdate.set(false);
    }

    public ReadOnlyObjectWrapper<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getCurrentGame() {
        return (String)this.currentGame.get();
    }

    public StringProperty currentGameProperty() {
        return this.currentGame;
    }

    public void setCurrentGame(String currentGame) {
        this.currentGame.set((Object)currentGame);
    }

    public ObservableList<Version> getVersions() {
        return this.versions;
    }

    public boolean isShowUpdate() {
        return this.showUpdate.get();
    }

    public BooleanProperty showUpdateProperty() {
        return this.showUpdate;
    }

    public void setShowUpdate(boolean showUpdate) {
        this.showUpdate.set(showUpdate);
    }

    public RemoteVersion getLatestVersion() {
        return (RemoteVersion)this.latestVersion.get();
    }

    public ObjectProperty<RemoteVersion> latestVersionProperty() {
        return this.latestVersion;
    }

    public void setLatestVersion(RemoteVersion latestVersion) {
        this.latestVersion.set((Object)latestVersion);
    }

    public void initVersions(Profile profile, List<Version> versions) {
        FXUtils.checkFxUserThread();
        this.profile = profile;
        this.versions.setAll(versions);
    }
}

