/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import io.nayuki.qrcodegen.QrCode;

public final class QrCodeUtils {
    public static String toSVGPath(QrCode qr) {
        return QrCodeUtils.toSVGPath(qr, 0);
    }

    public static String toSVGPath(QrCode qr, int border) {
        int actualSize = qr.size + border * 2;
        StringBuilder builder = new StringBuilder(qr.size * qr.size * 12);
        builder.append('M').append(actualSize).append(' ').append(actualSize).append("ZM0 0Z");
        for (int y = 0; y < qr.size; ++y) {
            for (int x = 0; x < qr.size; ++x) {
                if (!qr.getModule(x, y)) continue;
                if (x != 0 || y != 0) {
                    builder.append(' ');
                }
                builder.append("M").append(x + border).append(',').append(y + border).append("h1v1h-1z");
            }
        }
        return builder.toString();
    }

    private QrCodeUtils() {
    }
}

