/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import org.jetbrains.annotations.NotNull;

public final class MappedObservableList<E, F>
extends TransformationList<E, F> {
    private final Function<? super F, ? extends E> mapper;
    private final List<E> elements;

    public static <T, U> ObservableList<U> create(ObservableList<T> source, Function<T, U> mapper) {
        return new MappedObservableList<U, T>(source, mapper);
    }

    public MappedObservableList(@NotNull ObservableList<? extends F> source, @NotNull Function<? super F, ? extends E> mapper) {
        super(source);
        this.mapper = mapper;
        this.elements = new ArrayList(source.size());
        for (Object f : source) {
            this.elements.add(mapper.apply(f));
        }
    }

    protected void sourceChanged(ListChangeListener.Change<? extends F> change) {
        this.beginChange();
        while (change.next()) {
            int from = change.getFrom();
            int to = change.getTo();
            if (change.wasPermutated()) {
                int i;
                Object[] temp = new Object[to - from];
                int[] permutations = new int[to - from];
                for (i = 0; i < temp.length; ++i) {
                    temp[i] = this.elements.get(from + i);
                }
                for (i = from; i < to; ++i) {
                    int permutation;
                    int n = i - from;
                    permutations[n] = permutation = change.getPermutation(i);
                    this.elements.set(permutation, temp[n]);
                }
                this.nextPermutation(from, to, permutations);
                continue;
            }
            if (change.wasUpdated()) {
                for (int i = from; i < to; ++i) {
                    this.elements.set(i, this.mapper.apply(this.getSource().get(i)));
                    this.nextUpdate(i);
                }
                continue;
            }
            List removed = List.of();
            if (change.wasRemoved()) {
                List<E> subList = this.elements.subList(from, from + change.getRemovedSize());
                removed = new ArrayList<E>(subList);
                subList.clear();
            }
            if (change.wasAdded()) {
                Object[] temp = new Object[to - from];
                List addedSubList = change.getAddedSubList();
                for (int i = 0; i < addedSubList.size(); ++i) {
                    temp[i] = this.mapper.apply(addedSubList.get(i));
                }
                this.elements.addAll(from, Arrays.asList(temp));
            }
            if (change.wasRemoved() && change.wasAdded()) {
                this.nextReplace(from, to, removed);
                continue;
            }
            if (change.wasRemoved()) {
                this.nextRemove(from, removed);
                continue;
            }
            if (!change.wasAdded()) continue;
            this.nextAdd(from, to);
        }
        this.endChange();
    }

    public E get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public int getSourceIndex(int index) {
        Objects.checkIndex(index, this.size());
        return index;
    }

    public int getViewIndex(int index) {
        Objects.checkIndex(index, this.size());
        return index;
    }
}

