/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.Arrays;
import java.util.List;

public interface WinTypes {

    public static final class GROUP_RELATIONSHIP
    extends Structure {
        public short maximumGroupCount;
        public short activeGroupCount;
        public byte[] reserved = new byte[20];
        public PROCESSOR_GROUP_INFO[] groupInfo = new PROCESSOR_GROUP_INFO[1];

        public GROUP_RELATIONSHIP() {
        }

        public GROUP_RELATIONSHIP(Pointer memory) {
            super(memory);
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("maximumGroupCount", "activeGroupCount", "reserved", "groupInfo");
        }

        @Override
        public void read() {
            this.readField("activeGroupCount");
            if (this.activeGroupCount != this.groupInfo.length) {
                this.groupInfo = new PROCESSOR_GROUP_INFO[this.activeGroupCount];
            }
            super.read();
        }
    }

    public static final class PROCESSOR_RELATIONSHIP
    extends Structure {
        public byte flags;
        public byte efficiencyClass;
        public byte[] reserved = new byte[20];
        public short groupCount;
        public GROUP_AFFINITY[] groupMask = new GROUP_AFFINITY[1];

        public PROCESSOR_RELATIONSHIP() {
        }

        public PROCESSOR_RELATIONSHIP(Pointer memory) {
            super(memory);
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("flags", "efficiencyClass", "reserved", "groupCount", "groupMask");
        }

        @Override
        public void read() {
            this.readField("groupCount");
            if (this.groupCount != this.groupMask.length) {
                this.groupMask = new GROUP_AFFINITY[this.groupCount];
            }
            super.read();
        }
    }

    public static final class PROCESSOR_GROUP_INFO
    extends Structure {
        public byte maximumProcessorCount;
        public byte activeProcessorCount;
        public byte[] reserved = new byte[38];
        public LongByReference activeProcessorMask;

        public PROCESSOR_GROUP_INFO(Pointer memory) {
            super(memory);
        }

        public PROCESSOR_GROUP_INFO() {
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("maximumProcessorCount", "activeProcessorCount", "reserved", "activeProcessorMask");
        }
    }

    public static final class GROUP_AFFINITY
    extends Structure {
        public LongByReference mask;
        public short group;
        public short[] reserved = new short[3];

        public GROUP_AFFINITY(Pointer memory) {
            super(memory);
        }

        public GROUP_AFFINITY() {
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("mask", "group", "reserved");
        }
    }

    public static final class MEMORYSTATUSEX
    extends Structure {
        public int dwLength = this.size();
        public int dwMemoryLoad;
        public long ullTotalPhys;
        public long ullAvailPhys;
        public long ullTotalPageFile;
        public long ullAvailPageFile;
        public long ullTotalVirtual;
        public long ullAvailVirtual;
        public long ullAvailExtendedVirtual;

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwLength", "dwMemoryLoad", "ullTotalPhys", "ullAvailPhys", "ullTotalPageFile", "ullAvailPageFile", "ullTotalVirtual", "ullAvailVirtual", "ullAvailExtendedVirtual");
        }
    }

    public static final class OSVERSIONINFOEXW
    extends Structure {
        public int dwOSVersionInfoSize;
        public int dwMajorVersion;
        public int dwMinorVersion;
        public int dwBuildNumber;
        public int dwPlatformId;
        public char[] szCSDVersion = new char[128];
        public short wServicePackMajor;
        public short wServicePackMinor;
        public short wSuiteMask;
        public byte wProductType;
        public byte wReserved;

        public OSVERSIONINFOEXW() {
            this.dwOSVersionInfoSize = this.size();
        }

        @Override
        protected List<String> getFieldOrder() {
            return Arrays.asList("dwOSVersionInfoSize", "dwMajorVersion", "dwMinorVersion", "dwBuildNumber", "dwPlatformId", "szCSDVersion", "wServicePackMajor", "wServicePackMinor", "wSuiteMask", "wProductType", "wReserved");
        }
    }

    public static final class HANDLE
    extends PointerType {
        public static final long INVALID_VALUE = Native.POINTER_SIZE == 8 ? -1L : 0xFFFFFFFFL;
        public static final HANDLE INVALID = new HANDLE(Pointer.createConstant(INVALID_VALUE));
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer p) {
            this.setPointer(p);
            this.immutable = true;
        }

        @Override
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            Object o = super.fromNative(nativeValue, context);
            if (INVALID.equals(o)) {
                return INVALID;
            }
            return o;
        }

        @Override
        public void setPointer(Pointer p) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable reference");
            }
            super.setPointer(p);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getPointer());
        }
    }

    public static final class BOOLByReference
    extends ByReference {
        public BOOLByReference() {
            this(new BOOL(0L));
        }

        public BOOLByReference(BOOL value) {
            super(4);
            this.setValue(value);
        }

        public void setValue(BOOL value) {
            this.getPointer().setInt(0L, value.intValue());
        }

        public BOOL getValue() {
            return new BOOL((long)this.getPointer().getInt(0L));
        }
    }

    public static final class BOOL
    extends IntegerType {
        public static final int SIZE = 4;

        public BOOL() {
            this(0L);
        }

        public BOOL(boolean value) {
            this(value ? 1L : 0L);
        }

        public BOOL(long value) {
            super(4, value, false);
            assert (value == 0L || value == 1L);
        }

        public boolean booleanValue() {
            return this.intValue() > 0;
        }

        @Override
        public String toString() {
            return Boolean.toString(this.booleanValue());
        }
    }
}

