test_ext_dir = input_path = joinpath(@__DIR__,"..","ext","TestExt")
input_path = joinpath(test_ext_dir,"Mutating-ops.jl")
data1 = read(joinpath(test_ext_dir,"Rings-conformance-tests.jl"), String)
data2 = read(joinpath(test_ext_dir,"Mutating-ops.jl"), String)

data = """
###############################################################################
#
# DO NOT EDIT THIS FILE MANUALLY!
#
# Instead, regenerate it by running `dev/regenerate_exercise.jl`
#
###############################################################################

""" * data1 * "\n############\n" * data2

# turn @testsets into ordinary code blocks
data = replace(data, r"""@testset "[^"]+" """ => "")

# replace @test by @assert
data = replace(data, "@test " => "@assert ")

# comment out @test_throws (and hope that they are all in one line)
data = replace(data, "@test_throws " => "#@test_throws ")

# remove 'reps' kwargs
data = replace(data, r"[,;] reps = .+\)\n" => ")\n")

# replace other uses of 'reps' by 1
data = replace(data, r"\breps\b" => "1")

# rename functions from test_FOO to exercise_FOO
data = replace(data, r"\btest_" => "exercise_")

output_path = joinpath(@__DIR__,"..","src","exercise.jl")
write(output_path, data)

