# MIRK Method Tableaus
struct MIRKTableau{sType, cType, vType, bType, xType}
    """Discrete stages of MIRK formula"""
    s::sType
    c::cType
    v::vType
    b::bType
    x::xType

    function MIRKTableau(s, c, v, b, x)
        @assert eltype(c) == eltype(v) == eltype(b) == eltype(x)
        return new{typeof(s), typeof(c), typeof(v), typeof(b), typeof(x)}(s, c, v, b, x)
    end
end

struct MIRKInterpTableau{s, c, v, x, τ, p}
    s_star::s
    c_star::c
    v_star::v
    x_star::x
    τ_star::τ
    p_star::p

    function MIRKInterpTableau(s_star, c_star, v_star, x_star, τ_star, p_star)
        @assert eltype(c_star) == eltype(v_star) == eltype(x_star)
        return new{
            typeof(s_star), typeof(c_star), typeof(v_star),
            typeof(x_star), typeof(τ_star), typeof(p_star),
        }(
            s_star, c_star, v_star, x_star, τ_star, p_star
        )
    end
end
