using SparseBandedMatrices
using Documenter

# Copy manifest files if they exist (they are generated by CI)
# Create assets directory if needed
if isfile("./docs/Manifest.toml") || isfile("./docs/Project.toml")
    mkpath("./docs/src/assets")
end
isfile("./docs/Manifest.toml") && cp("./docs/Manifest.toml", "./docs/src/assets/Manifest.toml", force = true)
isfile("./docs/Project.toml") && cp("./docs/Project.toml", "./docs/src/assets/Project.toml", force = true)

makedocs(;
    modules = [SparseBandedMatrices],
    authors = "Chris Rackauckas <accounts@chrisrackauckas.com> and contributors",
    repo = "https://github.com/SciML/SparseBandedMatrices.jl/blob/{commit}{path}#{line}",
    sitename = "SparseBandedMatrices.jl",
    format = Documenter.HTML(;
        prettyurls = get(ENV, "CI", "false") == "true",
        canonical = "https://docs.sciml.ai/SparseBandedMatrices/stable/",
        edit_link = "main",
        assets = String[],
    ),
    pages = [
        "Home" => "index.md",
    ],
)

deploydocs(;
    repo = "github.com/SciML/SparseBandedMatrices.jl",
    devbranch = "main",
)
