var documenterSearchIndex = {"docs":
[{"location":"api/api_color/#Color","page":"Color","title":"Color","text":"","category":"section"},{"location":"api/api_color/","page":"Color","title":"Color","text":"CurrentModule = Term.color","category":"page"},{"location":"api/api_color/","page":"Color","title":"Color","text":"Pages   = [\"api_color.md\"]","category":"page"},{"location":"api/api_color/","page":"Color","title":"Color","text":"Modules = [color]","category":"page"},{"location":"api/api_color/#Term.color.AbstractColor","page":"Color","title":"Term.color.AbstractColor","text":"AbstractColor\n\nAbstract color type.\n\n\n\n\n\n","category":"type"},{"location":"api/api_color/#Term.color._rgb-Tuple{Any, Any}","page":"Color","title":"Term.color._rgb","text":"_rgb(numbertype, txt)\n\nTries to parse r,g,b out of a string based on number type.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color._rgb-Tuple{Any}","page":"Color","title":"Term.color._rgb","text":"_rgb(numbertype, txt)\n\nTries to parse r,g,b out of a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.get_color-Tuple{AbstractString}","page":"Color","title":"Term.color.get_color","text":"get_color(string::AbstractString; bg=false)::AbstractColor\n\nExtract a color type from a string with color information.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.hex2rgb-Tuple{AbstractString}","page":"Color","title":"Term.color.hex2rgb","text":"hex2rgb(hex::AbstractString)\n\nConverts a string hex color code to a RGB color\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.is_background-Tuple{AbstractString}","page":"Color","title":"Term.color.is_background","text":"is_background(string::AbstractString)::Bool\n\nCheck if a string represents background color information, of any type.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.is_color-Tuple{AbstractString}","page":"Color","title":"Term.color.is_color","text":"is_color(string::AbstractString)::Bool\n\nCheck if a string represents color information, of any type.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.is_hex_color-Tuple{AbstractString}","page":"Color","title":"Term.color.is_hex_color","text":"is_hex_color(string::AbstractString)::Bool\n\nCheck if a string represents a hex color.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.is_named_color-Tuple{AbstractString}","page":"Color","title":"Term.color.is_named_color","text":"is_named_color(string::AbstractString)::Bool\n\nCheck if a string represents a named color.\n\n\n\n\n\n","category":"method"},{"location":"api/api_color/#Term.color.is_rgb_color-Tuple{AbstractString}","page":"Color","title":"Term.color.is_rgb_color","text":"is_rgb_color(string::AbstractString)::Bool\n\nCheck if a string represents a RGB color.\n\n\n\n\n\n","category":"method"},{"location":"adv/introspection/#Introspection","page":"Introspection","title":"Introspection","text":"","category":"section"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"If you often use the (awesome) Julia REPL, you'll be familiar witht he fact that you can type ? to enter the docs section. Then typing a name (e.g., of a Type or function) will bring up the relevant docs. E.g. you might get something like this:","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"help?> cat\nsearch: cat catch catch_backtrace vcat hcat hvcat hvncat CartesianIndex CartesianIndices CapturedException truncate @allocated @deprecate broadcast Broadcast broadcast! IndexCartesian\n\n  cat(A...; dims)\n\n  Concatenate the input arrays along the specified dimensions in the iterable dims. For dimensions not in dims, all input arrays should have the same size, which will also be the\n  size of the output array along that dimension. For dimensions in dims, the size of the output array is the sum of the sizes of the input arrays along that dimension. If dims is a\n  single number, the different arrays are tightly stacked along that dimension. If dims is an iterable containing several dimensions, this allows one to construct block diagonal\n  matrices and their higher-dimensional analogues by simultaneously increasing several dimensions for every new input array and putting zero blocks elsewhere. For example,\n  cat(matrices...; dims=(1,2)) builds a block diagonal matrix, i.e. a block matrix with matrices[1], matrices[2], ... as diagonal blocks and matching zero blocks away from the\n  diagonal.\n\n  See also hcat, vcat, hvcat, repeat.\n\n  Examples\n  ≡≡≡≡≡≡≡≡≡≡\n\n  julia> cat([1 2; 3 4], [pi, pi], fill(10, 2,3,1); dims=2)\n  2×6×1 Array{Float64, 3}:\n  [:, :, 1] =\n   1.0  2.0  3.14159  10.0  10.0  10.0\n   3.0  4.0  3.14159  10.0  10.0  10.0\n  \n  julia> cat(true, trues(2,2), trues(4)', dims=(1,2))\n  4×7 Matrix{Bool}:\n   1  0  0  0  0  0  0\n   0  1  1  0  0  0  0\n   0  1  1  0  0  0  0\n   0  0  0  1  1  1  1","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"This is super useful, you can get access to the docs directly in your console without having to go google stuff. But, if you're on Terms docs you're likely after a more stylish terminal experience. Can we do something like what ? print does in the REPL, but with Term's styling? Of course we can:","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"import Term: inspect\n\ninspect(cat)","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"So given a function name, inspect prints out docstrings as well as methods signature. Just like ? vec but with panels and colors. But it can also work with Types:","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"import Term: inspect\n\nabstract type AbstractType end\n\n\"\"\"\n    MyType\n\nJust a type.\n\"\"\"\nstruct MyType <: AbstractType\n    x::Int\n    y::String\nend\n\n\"\"\"\n    Mytype(x::Int)\n\nConstruct MyType with only an `Int`\n\"\"\"\nMyType(x::Int) = MyType(x, \"no string\")\n\n\"\"\"\n    do_a_thing(a::MyType, x)\n\nFunction doing something with MyType\n\"\"\"\ndo_a_thing(a::MyType, x) = print(a, x)\ndo_a_thing(a::MyType, x::MyType) = println(a, x)\n\n# ! now inspect\ninspect(MyType)","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"warning: Warning\nOoooops. It looks like the layout is a bit funky when rendered in the docs! It will look fine when you use Term in your REPL.","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"As you can see, with a DataType argument, inspect shows you the type's hierarchy for MyType, its docstring and where is defined as well as constructors for our custom type and methods that make use of MyType in their arguments. That's pretty much it, enjoy using inspect!","category":"page"},{"location":"adv/introspection/","page":"Introspection","title":"Introspection","text":"note: Note\ninspect accepts an optional keyword argument to choose how many constructors and methods to show: max_n_methods::Int. If an object has loads of methods, only the first max_n_methods will be shown.","category":"page"},{"location":"api/api_box/#Box","page":"Box","title":"Box","text":"","category":"section"},{"location":"api/api_box/","page":"Box","title":"Box","text":"CurrentModule = Term.box","category":"page"},{"location":"api/api_box/","page":"Box","title":"Box","text":"Pages   = [\"api_box.md\"]","category":"page"},{"location":"api/api_box/","page":"Box","title":"Box","text":"Modules = [box]","category":"page"},{"location":"api/api_box/#Term.box.Box","page":"Box","title":"Term.box.Box","text":"Box\n\nDefines characters to render boxes.\n\nRow names:\n\n┌─┬┐ top │ ││ head ├─┼┤ headrow │ ││ mid ├─┼┤ row ├─┼┤ footrow │ ││ foot └─┴┘ bottom\n\neach row is an instance of BoxLine\n\n\n\n\n\n","category":"type"},{"location":"api/api_box/#Term.box.Box-Tuple{String, String}","page":"Box","title":"Term.box.Box","text":"Box(string)\n\nConstruct a Box objet out of a box string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_box/#Term.box.BoxLine","page":"Box","title":"Term.box.BoxLine","text":"BoxLine\n\nStores the characters for a line of a Box object.\n\n\n\n\n\n","category":"type"},{"location":"api/api_box/#Term.box.fit-Tuple{Term.box.Box, Vector{Int64}}","page":"Box","title":"Term.box.fit","text":"fit(box::Box, widths::Vector{Int})::String\n\nCreates a box.\n\nThe box has one of each level type with columns widths specified by a vector of widhts.\n\n\n\n\n\n","category":"method"},{"location":"api/api_box/#Term.box.get_row-Tuple{Term.box.Box, Vector{Int64}, Symbol}","page":"Box","title":"Term.box.get_row","text":"get_row(box, [1, 2, 3], :row)\n\nGets characters for a row of a Box object.\n\nThe level Symbol can be used to specify the box level (:top, :footer...)\n\n\n\n\n\n","category":"method"},{"location":"api/api_box/#Term.box.get_title_row-Tuple{Symbol, Term.box.Box, Union{Nothing, AbstractString}}","page":"Box","title":"Term.box.get_title_row","text":"gettitlerow(row::Symbol, box::Box, title::Union{Nothing, AbstractString}; <keyword arguments>)\n\nCreate a box row with a title string.\n\nCan create both titles in the top and bottom row to produce subtitles.\n\n#Arguments:\n\nwidth::Int: width of line\nstyle::Union{Nothing:  String}: style of line\ntitle_style::Union{Nothing:  AbstractString}: style of title string\njustify::Symbol=:left: position of title string\n\nSee also get_row.\n\n\n\n\n\n","category":"method"},{"location":"api/api_box/#Term.box.loop_last-Tuple{Vector{T} where T}","page":"Box","title":"Term.box.loop_last","text":"loop_last(v::Vector)\n\nReturns an iterable yielding tuples (is_last, value).\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Errors","page":"Errors","title":"Errors","text":"","category":"section"},{"location":"api/api_errors/","page":"Errors","title":"Errors","text":"CurrentModule = Term.errors","category":"page"},{"location":"api/api_errors/","page":"Errors","title":"Errors","text":"Pages   = [\"api_errors.md\"]","category":"page"},{"location":"api/api_errors/","page":"Errors","title":"Errors","text":"Modules = [errors]","category":"page"},{"location":"api/api_errors/#Term.errors._highlight","page":"Errors","title":"Term.errors._highlight","text":"_highlight(x)\n\nApply style to x based on its type.\n\n\n\n\n\n","category":"function"},{"location":"api/api_errors/#Term.errors._highlight_numbers-Tuple{AbstractString}","page":"Errors","title":"Term.errors._highlight_numbers","text":"_highlight_numbers(x::AbstractString)\n\nAdd style to each number in a string\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Term.errors._highlight_with_type-Tuple{Any}","page":"Errors","title":"Term.errors._highlight_with_type","text":"_highlight_with_type(x)\n\nApply style to x and and mark its type.\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Term.errors.backtrace_subpanel-Tuple{String, Int64, String}","page":"Errors","title":"Term.errors.backtrace_subpanel","text":"backtrace_subpanel(line::String, WIDTH::Int, title::String)\n\nCreate a subpanel for stacktrace, showing source code.\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Term.errors.style_backtrace-Tuple{IO, Vector{T} where T}","page":"Errors","title":"Term.errors.style_backtrace","text":"style_backtrace(io::IO, t::Vector)\n\nCreate a Panel with styled error backtrace information.\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Term.errors.style_error-Tuple{IO, Any}","page":"Errors","title":"Term.errors.style_error","text":"style_error(io::IO, er)\n\nCreate a style error panel.\n\nCreates a Panel with an error message and optional hints.\n\n\n\n\n\n","category":"method"},{"location":"api/api_errors/#Term.errors.style_stacktrace_simple-Tuple{Vector{T} where T}","page":"Errors","title":"Term.errors.style_stacktrace_simple","text":"style_stacktrace_simple(stack::Vector)\n\nSimply style a stacktrace. Just adding a miniumum of color.\n\n\n\n\n\n","category":"method"},{"location":"api/api_measure/#Measure","page":"Measure","title":"Measure","text":"","category":"section"},{"location":"api/api_measure/","page":"Measure","title":"Measure","text":"CurrentModule = Term.measure","category":"page"},{"location":"api/api_measure/","page":"Measure","title":"Measure","text":"Pages   = [\"api_measure.md\"]","category":"page"},{"location":"api/api_measure/","page":"Measure","title":"Measure","text":"Modules = [measure]","category":"page"},{"location":"api/api_measure/#Term.measure.Measure","page":"Measure","title":"Term.measure.Measure","text":"Measure\n\nStores the size of a piece of renderable material\n\n\n\n\n\n","category":"type"},{"location":"api/api_measure/#Term.measure.Measure-Tuple{AbstractString}","page":"Measure","title":"Term.measure.Measure","text":"Measure(str::String)\n\nConstructs a measure object from a string\n\n\n\n\n\n","category":"method"},{"location":"api/api_measure/#Base.:+-Tuple{Term.measure.Measure, Term.measure.Measure}","page":"Measure","title":"Base.:+","text":"The sum of measures returns a measure with the highest value along each dimension\n\n\n\n\n\n","category":"method"},{"location":"basics/styled_text/#Styled-text","page":"Styled text","title":"Styled text","text":"","category":"section"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"The term styled text refers to text printed out to a terminal (or other ::IO) with either color or other style (e.g., bold, italic) information. This is done by adding ANSI escape sequences in a string being printed to the terminal. These escape sequences are not rendered as caracters but add the style information.","category":"page"},{"location":"basics/styled_text/#Style-macros","page":"Styled text","title":"Style macros","text":"","category":"section"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"The easiest way to add style information to a String in Term is using the dedicated macros:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term\nprintln(@green \"this is green\")\nprintln(@blue \"and this is blue\")\nprint(\"\\n\")\nprintln(@bold \"this is bold\")\nprintln(@underline \"and this is underlined\")","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"To color you can use these macros: @black, @red, @green, @yellow, @blue, @magenta, @cyan, @white, @default. While for styling you have: @bold @dim @italic @underline.","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Note that the styling macros return a string, so you can combine the resulting strings as you would normally:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term # hide\nprintln(\n    @green(\"This is green\") * \" and \" * @red(\"this is red\")\n)\nprintln(\n    \"Make your text $(@underline(\"stand out\"))!\"\n)","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"With these style macros you can do some simply styling, but it gets clunky when you want to go beyond adding some color. Let's say you want you text to be blue, bold and underlined; do you really need to use three macros?","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Of course not, you can use the @style macro!","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term # hide\nmytext = @style \"this is my text\" blue bold underline\nprintln(mytext)","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Like the macros you already know, @style returns a string with the desired style, except that now you can specify multiple styles at once! ","category":"page"},{"location":"basics/styled_text/#Markup-text","page":"Styled text","title":"Markup text","text":"","category":"section"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"The basic styling macros are great for handling simple cases where you just want to add a bit of style to a piece of text. More realistically, you might want more control about exactly which parts of your text have what style. ","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"As a way of example, let's say you want every other word of yours string:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"str=\"Every other word has colors!\"","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"to have a color. You could do it with macros:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term # hide\ne = @red \"Every\"\no = \"other\"\nw = @green \"word\"\nh = \"has\"\nc = @blue \"colors!\"\n\nprint(join((e, o, w, h, c), \" \"))","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"but that's awful. String interpolation would also not be of much help here. Instead, it would be great if we could specify styles directly inside a normal string and let Term figure it out.","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Well, that's exactly what we're going to do:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"import Term: tprint\ntprint(\n    \"[red]Every[/red] other [green]word[/green] has [blue]colors![/blue]\"\n)","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Woah! What just happened!! Two things happened: 1) Term styling machinery detects strings segments like \"[red]Every[/red]\" as meaning that the text between \"[...]\" and \"[/...]\" should be colored red and 2) tprint (short for term print) detects this style information and applies it to your text before printing. ","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Not bad huh? Even better, the style information inside a parentheses can be more than just color:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term # hide\ntprint(\n    \"[bold black underline on_red]So much [gold3 bold]STYLE[/gold3 bold] in this text[/bold black underline on_red]\"\n)","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"that's right, Term.jl can also color the background of your text (by adding on_C to your color C you set it as the background, see colors page). As you can see you can pass multiple style information tags as space separated words within the \"[...]\". Also, you might have noticed, Term can also handle nested style tags!","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"If you just want to use Term.jl's style functionality, just make sure to read the admonition below. If you're curious about what's happening under the hood, read on below!","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"warning: A note on style tags\nThe style tags used by Term.jl have an opening \"[style]\" and closing \"[/style]\" syntax. The style is applied to everything inbetween. For \"[/style]\" to close \"[style]\" the text in the parentheses must match exactly (excuding /), up to the number and position of spaces and the words order. So:\"[red] wohoo [/red]\"  # works\n\"[red] wohoo [/red ]\" # doesn't\n\"[bold blue] wohoo [/bold blue]\" # works\n\"[bold blue] wohoo [/blue bold]\" # doesn't","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"tip: Tip\nOccasionally you can do without the closing tag:tprint(\"[red]text\")Term.jl will add the closing tag to the end of the string for you. Generally though, when multiple styles are  applied to the same string, it's better to be explicit in exactly where each style starts and ends.","category":"page"},{"location":"basics/styled_text/#Under-the-hood","page":"Styled text","title":"Under the hood","text":"","category":"section"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"If you're reading here you're curious about what exactly is happening under the hood. So let's get started. Term.jl, like rich in python, defines a simple markup language to specify the style of bits of strings. As we saw, the syntax is very simple with an opening and closing tag specifying the style and marking the start and end of the styled text. ","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"So the first thing that needs to happen is the detection of these markup tags. This is surprisingly hard because there's so many possible combinations. You can have markup tags whose style information varies considerably, you can have nested tags, you can have tags spread across lines and you can have nested tags spread across lines:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"using Term # hide\ntprint(\n    \"\"\"\nAnd [blue] somehow\nit [bold red] all [/bold red]\nhas to [green underline] always\nwork [/green underline] correctly [/blue]\nsomehow.\n    \"\"\"\n)","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"CurrentModule = Term.markup","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"All of this is taken care of by Term.markup.extract_markup which returns a vector of Term.markup.MarkupTag objects. Each of these stores the opening and close tags (as SingleTag objects), the text inbetween them as well as a reference to all MarkupTags nested in it.","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"Normally, you should never use extract_markup directly. Instead you can let Term.style.apply_style handle it. When passed a String, apply_style will use extract_markup to extract style information before applying it to the string. This is done one MarkupTag at the time and recursively (i.e., dealing with nested tags before moving on to the next) until no markup information is found. ","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"After extracting style information, apply_style replaces the MarkupTag information with the appropriate ANSI escape codes. This is done by parsing the markup information (the text bewteen [...]) into a Term.style.MarkupStyle object which stores the style information. Finally, get_style_codes get the ANSI codes corresponding to the required style.  So in summary:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"apply_style(\"[red]text[/red]\")","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"will return a string with style information","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"import Term.style: apply_style  # hide\napply_style(\"[red]text[/red]\") # hide","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"which printed to the console looks like:","category":"page"},{"location":"basics/styled_text/","page":"Styled text","title":"Styled text","text":"import Term.style: apply_style  # hide\nprint(apply_style(\"[red]text[/red]\")) # hide","category":"page"},{"location":"api/api_layout/#Layout","page":"Layout","title":"Layout","text":"","category":"section"},{"location":"api/api_layout/","page":"Layout","title":"Layout","text":"CurrentModule = Term.layout","category":"page"},{"location":"api/api_layout/","page":"Layout","title":"Layout","text":"Pages   = [\"api_layout.md\"]","category":"page"},{"location":"api/api_layout/","page":"Layout","title":"Layout","text":"Modules = [layout]","category":"page"},{"location":"api/api_layout/#Term.layout.Padding","page":"Layout","title":"Term.layout.Padding","text":"Padding\n\nStores empty string to pad a string to the desired with.\n\n\n\n\n\n","category":"type"},{"location":"api/api_layout/#Term.layout.Padding-Tuple{AbstractString, Int64, Symbol}","page":"Layout","title":"Term.layout.Padding","text":"Padding(text::AbstractString, target_width::Int, method::Symbol)::Padding\n\nCreate Padding for a string given a justification method ∈ (:left, :center, :right).\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.Spacer","page":"Layout","title":"Term.layout.Spacer","text":"    Spacer\n\nA box of empty text with given width and height.\n\n\n\n\n\n","category":"type"},{"location":"api/api_layout/#Term.layout.hLine","page":"Layout","title":"Term.layout.hLine","text":"hLine\n\nA 1-line renderable made of repeated character from a Box.\n\n\n\n\n\n","category":"type"},{"location":"api/api_layout/#Term.layout.hLine-Tuple{AbstractString}","page":"Layout","title":"Term.layout.hLine","text":"hLine(text::AbstractString; style::Union{String, Nothing}=nothing, box::Symbol=:ROUNDED)\n\nConstruct an hLine as wide as the stdout with centered text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.hLine-Tuple{Number, String}","page":"Layout","title":"Term.layout.hLine","text":"hLine(width::Number, text::String; style::Union{String, Nothing}=nothing, box::Symbol=:ROUNDED)\n\nCreates an hLine object with texte centered horizontally.\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.hLine-Tuple{Number}","page":"Layout","title":"Term.layout.hLine","text":"hLine(width::Number, style::Union{String, Nothing}; box::Symbol=:ROUNDED)\n\nCreate a styled hLine of given width.\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.hLine-Tuple{}","page":"Layout","title":"Term.layout.hLine","text":"hLine(; style::Union{String, Nothing}=nothing, box::Symbol=:ROUNDED)\n\nConstruct an hLine as wide as the stdout\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.vLine","page":"Layout","title":"Term.layout.vLine","text":"vLine\n\nA multi-line renderable with each line made of a | to create a vertical line\n\n\n\n\n\n","category":"type"},{"location":"api/api_layout/#Term.layout.vLine-Tuple{Number}","page":"Layout","title":"Term.layout.vLine","text":"vLine(height::Number, style::Union{String, Nothing}; box::Symbol=:ROUNDED)\n\nCreate a vLine given a height and, optionally, style information.\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.vLine-Tuple{}","page":"Layout","title":"Term.layout.vLine","text":"vLine(; style::Union{String, Nothing}=nothing, box::Symbol=:ROUNDED)\n\nCreate a vLine as tall as the stdout console\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.hstack-Tuple","page":"Layout","title":"Term.layout.hstack","text":"hstack(renderables...)\n\nHorizonatlly stack a variable number of renderables\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.hstack-Tuple{Union{AbstractString, Term.renderables.AbstractRenderable}, Union{AbstractString, Term.renderables.AbstractRenderable}}","page":"Layout","title":"Term.layout.hstack","text":"hstack(r1::RenderablesUnion, r2::RenderablesUnion)\n\nHorizontally stack two renderables to give a new renderable.\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.vstack-Tuple","page":"Layout","title":"Term.layout.vstack","text":"vstack(renderables...)\n\nVertically stack a variable number of renderables\n\n\n\n\n\n","category":"method"},{"location":"api/api_layout/#Term.layout.vstack-Tuple{Union{AbstractString, Term.renderables.AbstractRenderable}, Union{AbstractString, Term.renderables.AbstractRenderable}}","page":"Layout","title":"Term.layout.vstack","text":"vstack(r1::RenderablesUnion, r2::RenderablesUnion)\n\nVertically stack two renderables to give a new renderable.\n\n\n\n\n\n","category":"method"},{"location":"adv/logging/#Logging","page":"Logging","title":"Logging","text":"","category":"section"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"Julia has a great logging system. If you come from other programming languages like Python you'll likely already love it, but it can be better!","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"AS you know, if you use logging macros like @info with a bunch of arguments after, Julia produces something like this:","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"@info \"My log message\" 1+1 n=\"a string!\" :x","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"It shows your log messages and then the other arguments as key = value display even evaluating expressions like 1 + 1 and showing you the result. Very useful, but visually a bit dull. Also, we might want additional info to be shown: at what time was the log message produced, by which line of code, inside which function, what are the types of the arguments...","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"Well, Term provides logging functionality that gives all that information, plus a ton of styling on top. To do that we need to install Term's own logger (TermLogger, very creative name) as the global logger to handle all error messages:","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"import Term: install_term_logger\ninstall_term_logger()","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"note: Note\nWe could not get Documenter.jl to show the output of Term's logger. So we've added a screenshot at the bottom of this page!","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"Done. Not a lot of work. Now you can just use your logging macros as you would normally, you don't need to change anything. But magic will happen:","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"import Term: install_term_logger # hide\ninstall_term_logger() # hide\n@info \"My log message\" 1+1 n=\"a string!\" :x","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"As you can see, it shows all the information that is normally there, an more!  If your log macro is called from within a function, it will also tell you that:","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"import Term: install_term_logger # hide\ninstall_term_logger()  # hide\n\nfunction my_useful_function()\n    @info \"My log message\" 1+1 n=\"a string!\" :x\nend\n\nmy_useful_function()","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"And of course it works nicely with all logging macros:","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"import Term: install_term_logger # hide\ninstall_term_logger() # hide\n\n\n@info \"just some info\"\n@warn \"careful!\"\n@error \"uh oh, not good!\"","category":"page"},{"location":"adv/logging/","page":"Logging","title":"Logging","text":"(Image: )","category":"page"},{"location":"adv/errors_tracebacks/#Errors","page":"Errors","title":"Errors","text":"","category":"section"},{"location":"adv/errors_tracebacks/","page":"Errors","title":"Errors","text":"In Logging we've seen how Term can replace the default logging system in Julia to produce stylized logging messages. Term can do the same for error messages and stack traces.","category":"page"},{"location":"adv/errors_tracebacks/","page":"Errors","title":"Errors","text":"danger: Danger zone\nThe way the error functionality is currently handled in Term entails re-defining methods from Base, Julia's own code. This is undesirable. It works, but it may lead to problems for some users or some unexpected behaviors, especially if other functions expected the re-defined code to work differently from how it works in Term. While this is fine if you're just writing code for your own comsumption, we strongly discourage using Term's error functionality in production level code - code that needs to be turned into something that many people will use. We can't guarantee that this wouldn't results in a bunch of headaches.  With this warning in place, we do home that in the future Julia will provide hooks for error handling systems as it does for logging. In the meanwhile, you can enjoy Term's stack traces privately in your code.","category":"page"},{"location":"adv/errors_tracebacks/","page":"Errors","title":"Errors","text":"Setting up Term to handle errors for you is very simple:","category":"page"},{"location":"adv/errors_tracebacks/","page":"Errors","title":"Errors","text":"import Term: install_term_stacktrace\n\ninstall_stacktrace()  # entering the danger zone\n\n1 + \"this wont work\"","category":"page"},{"location":"adv/errors_tracebacks/","page":"Errors","title":"Errors","text":"(Image: )","category":"page"},{"location":"api/api_panel/#Panel","page":"Panel","title":"Panel","text":"","category":"section"},{"location":"api/api_panel/","page":"Panel","title":"Panel","text":"CurrentModule = Term.panel","category":"page"},{"location":"api/api_panel/","page":"Panel","title":"Panel","text":"Pages   = [\"api_panel.md\"]","category":"page"},{"location":"api/api_panel/","page":"Panel","title":"Panel","text":"Modules = [panel]","category":"page"},{"location":"api/api_panel/#Term.panel.Panel","page":"Panel","title":"Term.panel.Panel","text":"Panel\n\nRenderable with a panel surrounding some content:         ╭──────────╮         │ my panel │         ╰──────────╯\n\n\n\n\n\n","category":"type"},{"location":"api/api_panel/#Term.panel.Panel-Tuple","page":"Panel","title":"Term.panel.Panel","text":"Panel(renderables; kwargs...)\n\nPanel constructor for creating a panel out of multiple renderables at once.\n\n\n\n\n\n","category":"method"},{"location":"api/api_panel/#Term.panel.Panel-Tuple{Union{AbstractString, Term.renderables.AbstractRenderable}}","page":"Panel","title":"Term.panel.Panel","text":"Panel(\n    content::RenderablesUnion;\n    title::Union{Nothing, String}=nothing,\n    title_style::Union{String, Nothing}=nothing,\n    title_justify::Symbol=:left,\n    subtitle::Union{String, Nothing}=nothing,\n    subtitle_style::Union{String, Nothing}=nothing,\n    subtitle_justify::Symbol=:left,\n    width::Union{Nothing, Symbol, Int}=:fit,\n    height::Union{Nothing, Int}=nothing,\n    style::Union{String, Nothing}=nothing,\n    box::Symbol=:ROUNDED,\n    justify=:left\n)\n\nPanel constructor to fit a panel to a piece of (renderable) content.\n\ntitle can be used to specify a title to be addded to the top row and  title_style and title_justify set its appearance and position. Same for subtitle but for the panel's bottom row. width and height are used to set the Panel's size. If not passed they are computed to fit tot the content's size.\n\n\n\n\n\n","category":"method"},{"location":"api/api_panel/#Term.panel.TextBox","page":"Panel","title":"Term.panel.TextBox","text":"TextBox\n\nCreates a Panel and fits input text to it. The pannel is hidden so that the result is just a text box.\n\n\n\n\n\n","category":"type"},{"location":"api/api_panel/#Term.panel.TextBox-Tuple{Union{AbstractString, Vector{T} where T}}","page":"Panel","title":"Term.panel.TextBox","text":"TextBox(\n    text::Union{Vector, AbstractString};\n    width::Union{Nothing, Int}=nothing,\n    title::Union{Nothing, String}=nothing,\n    title_style::Union{String, Nothing}=\"default\",\n    title_justify::Symbol=:left,\n    subtitle::Union{String, Nothing}=nothing,\n    subtitle_style::Union{String, Nothing}=\"default\",\n    subtitle_justify::Symbol=:left,\n    justify::Symbol=:left,\n    fit::Symbol=:fit,\n    )\n\nCreates an hidden Panel with text in it.\n\nIf a width is passed, the input text is reshaped to have that size, unless fit=:truncate in which case it's cut to size. If no width is passed and fit=true the TextBox's size matches the size of the input text. Other arguments behave like Panel.\n\nSee also Panel.\n\n\n\n\n\n","category":"method"},{"location":"api/api_renderables/#Renderables","page":"Renderables","title":"Renderables","text":"","category":"section"},{"location":"api/api_renderables/","page":"Renderables","title":"Renderables","text":"CurrentModule = Term.renderables","category":"page"},{"location":"api/api_renderables/","page":"Renderables","title":"Renderables","text":"Pages   = [\"api_renderables.md\"]","category":"page"},{"location":"api/api_renderables/","page":"Renderables","title":"Renderables","text":"Modules = [renderables]","category":"page"},{"location":"api/api_renderables/#Term.renderables.AbstractRenderable","page":"Renderables","title":"Term.renderables.AbstractRenderable","text":"AbstractRenderable\n\n\n\n\n\n","category":"type"},{"location":"api/api_renderables/#Term.renderables.Renderable","page":"Renderables","title":"Term.renderables.Renderable","text":"Renderable\n\nGeneric Renderable object.\n\n\n\n\n\n","category":"type"},{"location":"api/api_renderables/#Term.renderables.RenderableText","page":"Renderables","title":"Term.renderables.RenderableText","text":"RenderableText\n\nRenderable represnting a text.\n\nSee also Renderable, TextBox\n\n\n\n\n\n","category":"type"},{"location":"api/api_renderables/#Term.renderables.RenderableText-Tuple{AbstractString}","page":"Renderables","title":"Term.renderables.RenderableText","text":"RenderableText(text::AbstractString; width::Union{Nothing, Int, Symbol}=nothing)\n\nConstruct a RenderableText out of a string.\n\nIf a width is passed the text is resized to match the width.\n\n\n\n\n\n","category":"method"},{"location":"api/api_renderables/#Base.:+-Tuple{Union{AbstractString, Term.renderables.AbstractRenderable}, Union{AbstractString, Term.renderables.AbstractRenderable}}","page":"Renderables","title":"Base.:+","text":"Base.:+(r1::Union{AbstractString, AstractRenderable}, r2::Union{AbstractString, AstractRenderable})\n\nConcatenates two abstract rendereables\n\n\n\n\n\n","category":"method"},{"location":"api/api_renderables/#Base.string-Tuple{Term.renderables.AbstractRenderable}","page":"Renderables","title":"Base.string","text":"Base.string(r::AbstractRenderable)::String\n\nCreates a string representation of a renderable\n\n\n\n\n\n","category":"method"},{"location":"basics/basics/#Intro","page":"Intro","title":"Intro","text":"","category":"section"},{"location":"basics/basics/","page":"Intro","title":"Intro","text":"This section aims to introduce the basic concepts about Term. It will show how to create styled text with color and style information and how to create more complex renderable objects such as Panel and TextBoxes. Finally we'll go over how to 'stack' these renderables to crate complext layouts in your terminal. ","category":"page"},{"location":"basics/basics/","page":"Intro","title":"Intro","text":"The main goal of all of this is to produce bautiful, informative, terminal outputs.  Term can do a lot more than this (e.g., it can replace the standard logging system in Julia), but this kind of advanced functionality is discussed in a separate section.","category":"page"},{"location":"basics/basics/","page":"Intro","title":"Intro","text":"Let's get started!","category":"page"},{"location":"adv/adv/#Intro","page":"Intro","title":"Intro","text":"","category":"section"},{"location":"adv/adv/","page":"Intro","title":"Intro","text":"In the Basics section we've learned how to style text, create renderables and stack them into more complex layouts. You can use all of that to produce great terminal output for your Julia code, but that doesn't exhaust the range of things Term can do. ","category":"page"},{"location":"adv/adv/","page":"Intro","title":"Intro","text":"In this section we'll have a look at Term's additional functionality: logging discusses how to replace the default logging system in Julia to style logging messages with Term, Errors looks at how to replace the standard error messages with better ones made by Term and introspection will discuss Term's inspect function which can be used to peek into objects in your Julia code.","category":"page"},{"location":"adv/adv/","page":"Intro","title":"Intro","text":"Let's get started.","category":"page"},{"location":"api/api_style/#Style","page":"Style","title":"Style","text":"","category":"section"},{"location":"api/api_style/","page":"Style","title":"Style","text":"CurrentModule = Term.style","category":"page"},{"location":"api/api_style/","page":"Style","title":"Style","text":"Pages   = [\"api_style.md\"]","category":"page"},{"location":"api/api_style/","page":"Style","title":"Style","text":"Modules = [style]","category":"page"},{"location":"api/api_style/#Term.style.MarkupStyle","page":"Style","title":"Term.style.MarkupStyle","text":"MarkupStyle\n\nHolds information about the style specification set out by a MarkupTag.\n\n\n\n\n\n","category":"type"},{"location":"api/api_style/#Term.style.MarkupStyle-Tuple{Term.markup.MarkupTag}","page":"Style","title":"Term.style.MarkupStyle","text":"MarkupStyle(tag::MarkupTag)\n\nBuilds a MarkupStyle definition from a MarkupTag.\n\n\n\n\n\n","category":"method"},{"location":"api/api_style/#Term.style.apply_style-Tuple{AbstractString, Term.markup.MarkupTag}","page":"Style","title":"Term.style.apply_style","text":"apply_style(text::AbstractString, tag::MarkupTag)::AbstractString\n\nAppliy the style of a markup tag and it's nested tags\n\n\n\n\n\n","category":"method"},{"location":"api/api_style/#Term.style.apply_style-Tuple{AbstractString, Term.style.MarkupStyle}","page":"Style","title":"Term.style.apply_style","text":"apply_style(text::AbstractString, style::MarkupStyle)::AbstractString\n\nApply a style to a text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_style/#Term.style.apply_style-Tuple{AbstractString}","page":"Style","title":"Term.style.apply_style","text":"apply_style(text::AbstractString)\n\nExtract and apply all markup style in a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_style/#Term.style.extract_style-Tuple{AbstractString}","page":"Style","title":"Term.style.extract_style","text":"extract_style(text::AbstractString)\n\nExtract style information from a text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_style/#Term.style.get_style_codes-Tuple{Term.style.MarkupStyle}","page":"Style","title":"Term.style.get_style_codes","text":"get_style_codes(style::MarkupStyle)\n\nGet ANSICodes corresponding to a MarkupStyle.\n\n\n\n\n\n","category":"method"},{"location":"basics/colors/#Colors","page":"Colors","title":"Colors","text":"","category":"section"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"Okay, so far so good. We can use macros like @red and the tprint function to print colored strings. But so far we've only been using few named colors, but..","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"function rainbow_maker() # hide\n    text = \"there's a whole rainbow\\n of colors out there\" # hide\n    _n = Int(length(text)/2)  # hide\n    R = hcat(range(30, 255, length=_n), range(255, 60, length=_n))  # hide\n    G =hcat(range(255, 60, length=_n), range(60, 120, length=_n))  # hide\n    B = range(50, 255, length=length(text))  # hide\n    out = \"\"  # hide\n    for n in 1:length(text)  # hide\n        r, g, b = R[n], G[n], B[n]  # hide\n        out *= \"[($r, $g, $b)]$(text[n])[/($r, $g, $b)]\"  # hide\n    end # hide\n    return out  # hide\nend # hide\nimport Term: tprint  # hide\ntprint(rainbow_maker()) # hide","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"so how can we use different kinds of colors? It's all done through Term's markup syntax of course. Look:","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"using Term: tprint # hide\ntprint(\"[(255, 50, 100)]colors![/(255, 50, 100)]\")","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"yep, you can pass a set of (r, g, b) values and that'll do it. Personally, I prefer working with hex codes, and so Term can accept them too:","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"using Term: tprint # hide\nindigo = \"#42A5F5\"\n\ntprint(\"Some [$indigo]color![/$indigo]\")","category":"page"},{"location":"basics/colors/#Under-the-hood","page":"Colors","title":"Under the hood","text":"","category":"section"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"What Term is doing here is taking each bit of style information in the markup tag (each word or each (...) within [...]) and constructing style codes with an ANSICode object.","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"If the style informaton represents a color, Term first represents it as a AbstractColor type: NamedColor or BitColor or RGBColor.  ","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"NamedColor objects represent simple colors like red and blue, BitColor represent 16-bit colors like dark_goldenrod and RGBColor, surprisingly, represents rgb-style colors. There's no method to represent hex colors as these are converted into rgb first. ","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"The distinction between NamedColor, BitColor and RGBColor is necessary because the three color styles are represented by a different syntax in the ANSI codes. Naturally, Term users won't normally worry about this and can use whichever color formulation is most convenient.","category":"page"},{"location":"basics/colors/#Colors-2","page":"Colors","title":"Colors","text":"","category":"section"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"Below all named colors, 16bit colors and (many) RGB colors are printed for display.","category":"page"},{"location":"basics/colors/","page":"Colors","title":"Colors","text":"import Term: CODES_16BIT_COLORS\nimport Term: Panel\n\nfunction make_named_colors()\n    sort_idx = sortperm(collect(values(CODES_16BIT_COLORS)))\n    cnames = collect(keys(CODES_16BIT_COLORS))[sort_idx][1:9]\n    colors = \"\"\n    colors = join(map(\n        (c)->\"[on_$c] [/on_$c]\", cnames\n    ))\n    return colors\nend\n\nfunction make_16bit_colors()\n    sort_idx = sortperm(collect(values(CODES_16BIT_COLORS)))\n    cnames = collect(keys(CODES_16BIT_COLORS))[sort_idx][9:end]\n    colors = \"\"\n    colors = join(map(\n        (c)->\"[on_$c] [/on_$c]\", cnames\n    ))\n    return colors\nend\n\nfunction make_rgb_colors()\n    values = 1:25:255\n    colors = \"\"\n    for r in values, b in values, g in values[1:end-1]\n        colors *= \"[on_($r, $g, $b)] [/on_($r, $g, $b)]\"\n    end\n    return colors\nend\n\n\n\nprint(\n    Panel(make_named_colors(), width=20, justify=:center, title=\"Named  colors\", style=\"bold yellow\") / # stacking operator, see layout page\n    Panel(make_16bit_colors(), width=42, title=\"16 bit colors\", style=\"bold yellow\") / \n    Panel(make_rgb_colors(), width=88, title=\"RGB colors\", style=\"bold yellow\")\n)","category":"page"},{"location":"api/api_console/#Consoles","page":"Consoles","title":"Consoles","text":"","category":"section"},{"location":"api/api_console/","page":"Consoles","title":"Consoles","text":"CurrentModule = Term.console","category":"page"},{"location":"api/api_console/","page":"Consoles","title":"Consoles","text":"Pages   = [\"api_console.md\"]","category":"page"},{"location":"api/api_console/","page":"Consoles","title":"Consoles","text":"Modules = [console]","category":"page"},{"location":"api/api_console/#Term.console.Consoles","page":"Consoles","title":"Term.console.Consoles","text":"Consoles\n\nThe Consoles object stores information about the dimensions of the output(::IO) where objects will be printed\n\n\n\n\n\n","category":"type"},{"location":"api/api_console/#Term.console.console_height-Tuple{}","page":"Consoles","title":"Term.console.console_height","text":"console_height()\n\nGet the current console height.\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.console_width-Tuple{}","page":"Consoles","title":"Term.console.console_width","text":"console_width()\n\nGet the current console width.\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint","page":"Consoles","title":"Term.console.tprint","text":"tprint\n\nSimilar to standard lib's print function but with added styling functionality\n\n\n\n\n\n","category":"function"},{"location":"api/api_console/#Term.console.tprint-Tuple{AbstractString}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x::AbstractString)\n\nApply style to a string and print it to a new line\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint-Tuple{Any}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x)\n\nWhen no dedicated method is present, print the string representation\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint-Tuple{Function}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x::Function)\n\nPrint highlighted as a Function\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint-Tuple{Number}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x::Number)\n\nPrint highlighted as a Number\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint-Tuple{Symbol}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x::Symbol)\n\nPrint highlighted as a Symbol\n\n\n\n\n\n","category":"method"},{"location":"api/api_console/#Term.console.tprint-Tuple{Term.renderables.AbstractRenderable}","page":"Consoles","title":"Term.console.tprint","text":"tprint(x::AbstractRenderable)\n\nPrint an AbstractRenderable.\n\nEquivalent to println(x)\n\n\n\n\n\n","category":"method"},{"location":"basics/content_layout/#Content-layout","page":"Content layout","title":"Content layout","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Okay, so we can style text and we can create fancy panels. Cool. Not enough. If we want to get real fancy we need to combine multiple renderable elements. Like this:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term\nprint(Term.make_logo())","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"The example above is composed of panels and textboxes, of course, but also additional lines and spacing elements that can help with the layout. These elements are combined using a very simple syntax to create the whole thing.","category":"page"},{"location":"basics/content_layout/#Nesting","page":"Content layout","title":"Nesting","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"The easiest way to create a layout is to nest things. We've already seen how to do this with Panels and TextBoxes:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"\nimport Term: Panel # hide\n\nprint(\n    Panel(\n        Panel(\n            Panel(\n                \"We need to go deeper...\", height=3, width=28, style=\"green\", box=:ASCII, title=\"ED\", title_style=\"white\"\n            ),\n            style=\"red\", box=:HEAVY, title=\"ST\", title_style=\"white\"\n        ),\n        width=44, justify=:center, style=\"blue\", box=:DOUBLE, title=\"NE\", title_style=\"white\"\n    )\n)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"That's all there is really. Panel can take one or multiple string and AbstractRenderable objects as argument and stacks them inside. You can combine this with the width, height and justify argument to mix things up, but simple nesting will only take you so far. We need better way to compose a layout.","category":"page"},{"location":"basics/content_layout/#Stacking","page":"Content layout","title":"Stacking","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"The idea is simple: horizontally stack two renderables and they will appear side by side, stack them vertically and they will appear one over the other. The syntax is even simpler: * lets you horizontally stack (or concatenate strings) and / lets you stack them vertically.","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"note: Note\nThe choice of * and / as operators for stacking operations was somewhat arbitrary. * was chosen because it's already what Julia uses to concatenate strings, and you can think of that as \"horizontally stacking them\". / was chosen because it reminds me of fractions, and fractions have one number over another. If you don't like to use these operators, you're in luck! They are really just a  shorthand notation for the functions hstack & vstack. You'll find that this notation makes for some pretty nifty code though.","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Let's stack things:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"\nimport Term: Panel # hide\n\nprintln(\n    Panel(\"horizontally\") * Panel(\"stacked\")\n)\nprintln(\"&\\n\")\nprintln(\n    Panel(\"vertically\") / Panel(\"stacked\")\n)\n","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"As simple as that. But you can also go crazy if you like:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"\nimport Term: Panel # hide\n\np = Panel(width=5)\nprintln(\n    (p * p * p) / (p * (p/p)) / (p * p * \"[bold red]supripse![/bold red]\")\n)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"what's that red text doing in there? We didn't use tprint, or apply_style, we didn't put it into a RenderableText or a TextBox... why didn't it print as \"[bold red]supripse![/bold red]\"??","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"The answer is that stacking operators return the generic Renderable type object, and Renderables apply their styles before printing out to console. Okay, not a huge surprise I guess, but I just wanted an excuse to say that regardless of what goes into * and / the output is a generic Renderable (well with the exception of * between two strings which returns a string; also * and / don't work with things like ::Number & co., but you get the idea).","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Previously we briefly mentioned the idea of the Measure or a renderable object. Measure stores information about the width and height of a renderable as it will appear in the terminal. When we stack renderables, the Measure of the resulting Renderable will do the following:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"if we are using * the width will be the sum of widths of the two renderables and the height will be the height  of the tallest renderable\nif we are using / the width will be that of the widest renderable and the height will be the sum of heights. ","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Let's see:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel # hide\np1 = Panel(width=5, height=5)\nprintln(\"p1.measure: \", p1.measure)\n\n\np2 = Panel(width=8, height=5)\nprintln(\"p2.measure: \", p2.measure)\n\nh = p1 * p2\nprintln(\"* stacked measure: \", h.measure)\n\nv = p1 / p2\nprintln(\"/ stacked measure: \", v.measure)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"This is important, because often you want to know a Renderable's size when creating a layout, as we'll see next.","category":"page"},{"location":"basics/content_layout/#Spacer","page":"Content layout","title":"Spacer","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Okay, we can stack two Panels side by side. It looks like this:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"using Term # hide\n\np = Panel(width=5, height=3)\nprint(p * p)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"but what if we want some space between them? We can do something like","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"using Term # hide\np = Panel(width=5, height=3) # hide\nprint(p * \" \"^5 * p)\nprint(p / \"\\n\"^2 / p)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"to create horizontal and vertical spaces. But what if we want to separate two renderables by a space that is 4 characters wide and 3 lines high? We could create a string which does that and stack it with our renderables... Doesn't sound fun. That's why Term has a Spacer renderable object that does it for your:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel # hide\nimport Term: Spacer\np = Panel(width=5, height=3) # hide\n\nspace = Spacer(5, 3; char=',')\nprint(p * space * p)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"here we're using the optional argument char to fill the spacer with a character so that we can see what it looks like. Normally it would be just empty space. The nice thing about spacer is that we can easily do things like this:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel, Spacer # hide\np = Panel(width=5, height=3) # hide\n\ntop = p * Spacer(5, 3; char='t') * p\nmid = Spacer(top.measure.w, 2; char='m') # use top's Measure info !\nbottom = p * Spacer(5, 3; char='b') * p\n\nprint(top / mid / bottom)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"look at that layout! Actually don't, look at it without that clutter:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel, Spacer # hide\np = Panel(width=5, height=3) # hide\n\ntop = p * Spacer(5, 3) * p\nmid = Spacer(top.measure.w, 2) # use top's Measure info !\nbottom = p * Spacer(5, 3) * p\n\nprint(top / mid / bottom)","category":"page"},{"location":"basics/content_layout/#vLine","page":"Content layout","title":"vLine","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"Space is nice. You can separate distinct pieces of content so that the message you're trying to convey is more easily interpreted by the user. But space is not enough. Sometimes you want to add a line to mark out where one section ends and the other starts. Well, that's where vLine and hLine below come in. They're very simple to use, just say how tall/weide the line should be and, optionally, give some markup style information too:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel, Spacer # hide\nimport Term: vLine\np = Panel(width=5, height=3) # hide\n\nl = vLine(p.measure.h; style=\"bold red\")\ns = Spacer(2, p.measure.h)\n\nprint(p * l * s * l * p)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"note: Note\nLike with Panel, vLine and hLine accept a box= keyword argument with the ::Symbol of any of the Box objects supported by Term.","category":"page"},{"location":"basics/content_layout/#hLine","page":"Content layout","title":"hLine","text":"","category":"section"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"I think you can guess where we are going with this. hLine is just like vLine but horizontal:","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"import Term: Panel, Spacer # hide\nimport Term: hLine\n\np = Panel(width=5, height=3) # hide\nl = hLine(20, \"whaaat\"; style=\"bold red\", box=:DOUBLE)\n\n\nprint(p / l / p)","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"surprise! hLine is not just like vLine: it also accepts an optional text argument to create a little title line if you will. But yeah, otherwise it's just the same. ","category":"page"},{"location":"basics/content_layout/","page":"Content layout","title":"Content layout","text":"With this we conclude our overview of the content layout in Term. There's a lot more you can use Term for, but styled text, panels and layout operators will get you far! Enjoy!","category":"page"},{"location":"basics/renderables/#Renderables","page":"Renderables","title":"Renderables","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"In the previous section we...","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"using Term  # hidden\ntprint(\"[green]...have seen how to add some [gold3 bold underline]style[/gold3 bold underline] to our text\")  # hidden","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"and that's great, but it's not enough. If you want to create really beutiful and structured terminal outputs, a bit of color and bold text is not enough. You want to be able to create panels to separate different pieces of content, lines to mark out different sections, you want to be able to control the aspect (e.g.,, line length) of the content you're printing and, most importantly, you want to do all this without too many headaches. Term.jl has got your back.","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"In this section we will look at Renderable objects (subtypes of AbstractRenderable) such as TextBox and Panel. In the next page we will focus on how to compose multiple renderables into a layout and we'll introduce renderables such as hLine and Spacer that are best introduced in that context.","category":"page"},{"location":"basics/renderables/#AbsractRenderable","page":"Renderables","title":"AbsractRenderable","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"This section focuses a bit on how renderables work under the hood. If you just want use Term and you don't care too much for how it works, skip ahead to the next section!","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"When you venture beyond styling simple strings, virtually every object you'll encounter will be a subtype of the AbstractRenderable type. We will call these objects renderables. Renderable types vary, but they all must have two fields: :segments and :measure.","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"note: Segment & Measure\nA Segment is simply a line of text, kinda. The segment type:    struct Segment\n        text::AbstractString   # text with ANSI codes injected\n        plain::AbstractString  # plain text with no style\n        measure::Measure       # measure of plain text\n    endstores a bit of plain text (i.e. without any style information) but also the same text with style information (text). Text is created as described earlier, using apply_style. The other bit of information is the Measure object. Measure keeps track of the size of objects as they will be rendered in the terminal (i.e., wihtout style markup or ANSI codes). It stores a width (w) and height (h) attribute keeping track of text width and number of lines. The Measure of a segment is just that: the textwidth of Segment.plain and the number of lines in it. When creating a renderable. This will generally produce the content that will be ultimately be printed to te terminal by generating a list of Segments. When the renderable is printed out, its Segment.texts are printed to the console in sequence. The Measure of a renderable is a combination of the Measure of the individual segments. It provides information about the renderable's width and number of lines, crucial when creating layouts!","category":"page"},{"location":"basics/renderables/#Renderable","page":"Renderables","title":"Renderable","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"The most generic renderable type is the creatively named Renderable. You'll very rarely create an instance of a Renderable from scratch. More generally Term will create one while performing another operation. For example: in the next page we'll see how to stack multiple renderables to crate a complex layout. Each renderable can be any AbstractRenderable-like object (including string). So if you're stacking a Panel, a TextBox and a String, what type should the resulting renderable object be? Well the generic but useful Renderable of course. ","category":"page"},{"location":"basics/renderables/#RenderableText","page":"Renderables","title":"RenderableText","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Now we get to more interesting stuff: RenderableText. What is it? Exactly what the name says, a renderable that stores a bit of text:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"using Term # hide\nrend = RenderableText(\"\"\"\n    [bold red]Woah, my first [yellow italic]`Renderable`!\n\"\"\")\nprint(rend)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Nothing special here. You'll notice that RenderableText automatically applies style information though. Also, when we were just styling strings before we had to use tprint instead of the normal print function to get our styled output. Well no more! Renderable objects work well with print so you can drop that t. ","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Now, do we really need a whole new type just to print a bit of text? Of course not, but RenderableText does more than that!","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"import Term: RenderableText\n\nrend = RenderableText(\".\"^100; width=25)\nprint(rend)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"magic! When we pass a width argument RenderableText reshapes our input text to the desired width! As you can imagine, when you're creating a layout made up of multiple elements, you want to be able to control the width of each element, so here you go!","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Now, as a reward for getting this far into the docs, a little sneak preview at renderables stacking:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"import Term: RenderableText # hide\n\nlorem = \"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\" # hide\n\nt1 = RenderableText(lorem; width=25)\nt2 = RenderableText(lorem; width=42)\nrend = t1 / \"\\n [bold green]second paragraph[/bold green] \\n\" / t2  # stacking syntax!!! - the result is typeof `Renderable`\nprint(rend)","category":"page"},{"location":"basics/renderables/#Panel","page":"Renderables","title":"Panel","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Okay, time to move beyond simple text. It's time for:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"import Term: Panel # hide\nprint(# hide\n    Panel(# hide\n        \"[red]awesome[/red]\", # hide\n        title=\"Term's\", # hide\n        title_style=\"bold green\", # hide\n        style=\"gold1 bold\", # hide\n        subtitle=\"Panels\", # hide\n        subtitle_style=\"bold blue\", # hide\n        subtitle_justify=:right, # hide\n        width=18, # hide\n        justify=:center # hide\n    ) # hide\n) # hide","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Simply put, a Panel showing a piece of content (generally a styled string, but it can be any Renderable really) surrounded by a box. Simple but effective.","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Well not that simple actually because Panel is the first renderable that allows you lots of options to personalize its appearance. For instance the panel printed above is given by:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"    Panel(\n        \"[red]awesome[/red]\",\n        title=\"Term's\",\n        title_style=\"bold green\",\n        style=\"gold1 bold\",\n        subtitle=\"Panels\",\n        subtitle_style=\"bold blue\",\n        subtitle_justify=:right,\n        width=18,\n        justify=:center\n    )","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"The first argument is the content, the rest is styling options. As you can see you can specify the titles and subtitles (or leave them out if you prefer, do your thing!), their appearance (via markup style information) and their position (:left, :center or :right). The style argument sets the style of the box itself (and title/subtitle if they don't have dedicated style information).","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"The box is created using Term's own Box type! It's not worth going too much into exactly how it works, but it's worth pointing out that there's loads of types of boxes:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"ASCII,\nASCII2,\nASCII_DOUBLE_HEAD,\nSQUARE,\nSQUARE_DOUBLE_HEAD,\nMINIMAL,\nMINIMAL_HEAVY_HEAD\nMINIMAL_DOUBLE_HEAD,\nSIMPLE,\nSIMPLE_HEAD,\nSIMPLE_HEAVY,\nHORIZONTALS,\nROUNDED,\nHEAVY\nHEAVY_EDGE,\nHEAVY_HEAD,\nDOUBLE,\nDOUBLE_EDGE","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"And you can use any of these with your panels:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"\nimport Term: Panel # hide\n\nprint(\n    Panel(width=8, box=:DOUBLE, style=\"green\") *\n    Panel(width=8, box=:HEAVY, style=\"white\") *\n    Panel(width=8, box=:ROUNDED, style=\"red\"),\n)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"By the way, Panels are not limited to having strings as content, they can have other renderables too (multiple ones in fact)!","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"\nimport Term: Panel # hide\n\nprint(\n    Panel(\n        Panel(width=18, style=\"green\"),\n        Panel(width=18, style=\"white\"),\n        Panel(width=18, style=\"red\"),\n        title=\"so many panels!\",\n        width=:fit,\n        title_justify=:left,\n        title_style=\"bold red\"\n    )\n)","category":"page"},{"location":"basics/renderables/#TextBox","page":"Renderables","title":"TextBox","text":"","category":"section"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"TextBoxes are a very simple but very useful renderable. They bring together RenderableText with Panel. In fact they're just a panel with a RenderableText inside and with its box hidden.  Why do we need them, you say? Well because now you can have a piece of text, with a nice title and sub title.","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"import Term: TextBox\n\nprint(\n    TextBox(\n        \",\"^100 * \"\\n\",\n        title=\"title!\",\n        subtitle=\"sub title!\",\n        width=30,\n        title_style=\"bold red\",\n        subtitle_style=\"dim\",\n        title_justify=:center,\n    )\n)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Okay, admittedly that's not huge. But it still nice to have. It also helps with keeping layout consistent when mixing panels and text, have a look:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"import Term: RenderableText, Panel\n\nt = \",\"^100\n\ntext = RenderableText(t; width=22)\npanel = Panel(t, width=22)\n\n\nprint(\n    text, panel\n)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"you see? The panel and the text have the same width, BUT, the panel must fit its box, some padding and its content within the same width. So the size of the text inside will need to change compared to RenderableText(t; width=22). If we use a TextBox on the other hand:","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"\nimport Term: TextBox, Panel # hide\n\nt = \",\"^100 # hide\n\ntbox = TextBox(t, width=22)\npanel = Panel(t, width=22)\n\nprint(\n    tbox, panel\n)","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Now the two pieces of text look the same and the final layout is a lot more homogeneous, success!","category":"page"},{"location":"basics/renderables/","page":"Renderables","title":"Renderables","text":"Let's move on to talk about layout more!","category":"page"},{"location":"api/api_introspection/#Introspection","page":"Introspection","title":"Introspection","text":"","category":"section"},{"location":"api/api_introspection/","page":"Introspection","title":"Introspection","text":"CurrentModule = Term.introspection","category":"page"},{"location":"api/api_introspection/","page":"Introspection","title":"Introspection","text":"Pages   = [\"api_introspection.md\"]","category":"page"},{"location":"api/api_introspection/","page":"Introspection","title":"Introspection","text":"Modules = [introspection]","category":"page"},{"location":"api/api_introspection/#Term.introspection.TypeInfo","page":"Introspection","title":"Term.introspection.TypeInfo","text":"TypeInfo\n\nStores metadata about a DataType\n\n\n\n\n\n","category":"type"},{"location":"api/api_introspection/#Term.introspection.TypeInfo-Tuple{DataType}","page":"Introspection","title":"Term.introspection.TypeInfo","text":"TypeInfo(type::DataType)\n\nExtract information from a DataType and store it as a TypeInfo object.\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.TypeInfo-Tuple{Function}","page":"Introspection","title":"Term.introspection.TypeInfo","text":"TypeInfo(fun::Function)\n\nExctract information from a function object\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.get_docstring-Tuple{Any}","page":"Introspection","title":"Term.introspection.get_docstring","text":"get_docstring(obj)\n\nExtract and style an object's docstring.\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.inspect-Tuple{Any}","page":"Introspection","title":"Term.introspection.inspect","text":"generic inspect method, dispatches to type-specific methods when they can be found\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.inspect-Tuple{DataType}","page":"Introspection","title":"Term.introspection.inspect","text":"inspect(type::DataType; width::Int=120)\n\nIntrospect a  type.\n\nExtract  info like docstring, fields, types etc. and show it in a structured terminal output.\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.inspect-Tuple{Function}","page":"Introspection","title":"Term.introspection.inspect","text":"inspect(fun::Function; width::Int=88, max_n_methods::Int = 7)\n\nInspects Function objects providing docstrings, and methods signatures.\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.style_method_line-Tuple{AbstractString}","page":"Introspection","title":"Term.introspection.style_method_line","text":"style_method_line(method::AbstractString; trim::Bool=false)::String\n\nStyle a string with method info (name, args, path...)\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.style_sub_types-Tuple{Any}","page":"Introspection","title":"Term.introspection.style_sub_types","text":"style_sub_types(info)::String\n\nStyle a vector of sub types.\n\n\n\n\n\n","category":"method"},{"location":"api/api_introspection/#Term.introspection.style_super_types-Tuple{Any}","page":"Introspection","title":"Term.introspection.style_super_types","text":"style_super_types(info)::String\n\nStyle a vector of super types \n\n\n\n\n\n","category":"method"},{"location":"api/api_logging/#Logging","page":"Logging","title":"Logging","text":"","category":"section"},{"location":"api/api_logging/","page":"Logging","title":"Logging","text":"CurrentModule = Term.logging","category":"page"},{"location":"api/api_logging/","page":"Logging","title":"Logging","text":"Pages   = [\"api_logging.md\"]","category":"page"},{"location":"api/api_logging/","page":"Logging","title":"Logging","text":"Modules = [logging]","category":"page"},{"location":"api/api_logging/#Term.logging.TermLogger","page":"Logging","title":"Term.logging.TermLogger","text":"TermLogger\n\nCustom logger type.\n\n\n\n\n\n","category":"type"},{"location":"api/api_logging/#Logging.handle_message-Tuple{Term.logging.TermLogger, Any, Any, Any, Any, Any, Any, Any}","page":"Logging","title":"Logging.handle_message","text":"Logging.handle_message(logger::TermLogger,\n\nHandle printing of log messages, with style!.\n\nIn addition to the log message and info such as file/line and time of log,  it prints kwargs styled by their type.\n\n\n\n\n\n","category":"method"},{"location":"api/api_logging/#Term.logging.install_term_logger","page":"Logging","title":"Term.logging.install_term_logger","text":"install_term_logger(theme::Theme=theme)\n\nInstall TermLogger as the global logging system.\n\ntheme::Theme can be passed to specify the theme to use for styling objects.\n\n\n\n\n\n","category":"function"},{"location":"api/api_logging/#Term.logging.print_closing_line","page":"Logging","title":"Term.logging.print_closing_line","text":"print_closing_line(color::String, width::Int)\n\nPrint the final line of a log message with style and date info\n\n\n\n\n\n","category":"function"},{"location":"api/api_markup/#Markup","page":"Markup","title":"Markup","text":"","category":"section"},{"location":"api/api_markup/","page":"Markup","title":"Markup","text":"CurrentModule = Term.markup","category":"page"},{"location":"api/api_markup/","page":"Markup","title":"Markup","text":"Pages   = [\"api_markup.md\"]","category":"page"},{"location":"api/api_markup/","page":"Markup","title":"Markup","text":"Modules = [markup]","category":"page"},{"location":"api/api_markup/#Term.markup.MarkupTag","page":"Markup","title":"Term.markup.MarkupTag","text":"MarkupTag\n\nRepresents a complete markup tag.\n\nIt stores two SingleTag, the text inbetween and any other MarkupTag that was detected in that text.\n\n\n\n\n\n","category":"type"},{"location":"api/api_markup/#Term.markup.SingleTag","page":"Markup","title":"Term.markup.SingleTag","text":"SingleTag\n\nRepresents a single tag [style] or [/style]\n\n\n\n\n\n","category":"type"},{"location":"api/api_markup/#Term.markup.SingleTag-Tuple{RegexMatch}","page":"Markup","title":"Term.markup.SingleTag","text":"SingleTag(match::RegexMatch)\n\nConstruct a SingleTag out of a RegexMatch\n\n\n\n\n\n","category":"method"},{"location":"api/api_markup/#Term.markup.clean_nested_tags-Tuple{AbstractString}","page":"Markup","title":"Term.markup.clean_nested_tags","text":"clean_nested_tags(text::AbstractString)::AbstractString\n\nGiven a text with nested string like: [red]aaaa [green]bbbb[/green] cccc [blue] ddddd [/blue]eeee[/red]\n\nit adds extra tags to ensure that text within inner tags is handled properly, giving: [red]aaaa [green]bbbb[/green][red] cccc [/red][blue] ddddd [/blue][red]eeee[/red]\n\n\n\n\n\n","category":"method"},{"location":"api/api_markup/#Term.markup.clean_nested_tags-Tuple{Term.markup.MarkupTag, AbstractString}","page":"Markup","title":"Term.markup.clean_nested_tags","text":"clean_nested_tags(tag, text::AbstractString)\n\nrecursively applies to inner tags\n\n\n\n\n\n","category":"method"},{"location":"api/api_markup/#Term.markup.extract_markup-Tuple{AbstractString}","page":"Markup","title":"Term.markup.extract_markup","text":"extract_markup(input_text::AbstractString; firstonly=false)\n\nExtracts MarkupTags from a piece of text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_markup/#Term.markup.has_markup-Tuple{AbstractString}","page":"Markup","title":"Term.markup.has_markup","text":"has_markup(text::AbstractString)\n\nReturns true if text includes a MarkupTag\n\n\n\n\n\n","category":"method"},{"location":"api/api_markup/#Term.markup.pairup_tags-Tuple{Vector{AbstractString}}","page":"Markup","title":"Term.markup.pairup_tags","text":"pairup_tags(text::Vector{AbstractString})\n\nGiven a vector of string with markup tags not properly closed/opened across lines,  it fixes things up.\n\n\n\n\n\n","category":"method"},{"location":"api/api_segment/#Segment","page":"Segment","title":"Segment","text":"","category":"section"},{"location":"api/api_segment/","page":"Segment","title":"Segment","text":"CurrentModule = Term.segment","category":"page"},{"location":"api/api_segment/","page":"Segment","title":"Segment","text":"Pages   = [\"api_segment.md\"]","category":"page"},{"location":"api/api_segment/","page":"Segment","title":"Segment","text":"Modules = [segment]","category":"page"},{"location":"api/api_segment/#Term.segment.Segment","page":"Segment","title":"Term.segment.Segment","text":"Segment\n\nstores one piece of text with all the styles applied to it.\n\n\n\n\n\n","category":"type"},{"location":"api/api_segment/#Term.segment.Segment-Tuple{Union{AbstractString, Term.segment.Segment}, Union{Nothing, AbstractString}}","page":"Segment","title":"Term.segment.Segment","text":"Segment(text::Union{Segment, AbstractString}, markup::AbstractString)\n\nConstruct a Segment out of a plain string and a markup string with style info\n\n\n\n\n\n","category":"method"},{"location":"api/api_segment/#Term.segment.Segment-Tuple{Union{AbstractString, Term.segment.Segment}, Union{Nothing, Term.style.MarkupStyle}}","page":"Segment","title":"Term.segment.Segment","text":"Segment(text::Union{Segment, AbstractString}, style::MarkupStyle)\n\nConstruct a Segment out of a plain string and a MarkupStyle object.\n\n\n\n\n\n","category":"method"},{"location":"api/api_segment/#Term.segment.Segment-Tuple{Union{AbstractString, Term.segment.Segment}}","page":"Segment","title":"Term.segment.Segment","text":"Segment(text::AbstractString)\n\nConstruct a Segment out of a string with markup.\n\n\n\n\n\n","category":"method"},{"location":"api/api_segment/#Base.:*-Tuple{Term.segment.Segment, AbstractString}","page":"Segment","title":"Base.:*","text":"concatenate strings and segments\n\n\n\n\n\n","category":"method"},{"location":"api/api_segment/#Base.show-Tuple{IO, Term.segment.Segment}","page":"Segment","title":"Base.show","text":"print styled in stdout, info otherwise\n\n\n\n\n\n","category":"method"},{"location":"","page":"Home","title":"Home","text":"CurrentModule = Term","category":"page"},{"location":"#Term","page":"Home","title":"Term","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"Term.jl is a Julia library for producing styled, beautiful terminal output, like this:","category":"page"},{"location":"","page":"Home","title":"Home","text":"import Term\nprint(Term.make_logo())","category":"page"},{"location":"","page":"Home","title":"Home","text":"Term.jl uses a simple markup syntax to add style information to standard Julia strings. It also provides Renderable objects such as the Panel and TextBox as you can see in the example below. These too can be styled,  include styled text, and they can benested and stacked to produce structured visual displays in your terminal. ","category":"page"},{"location":"","page":"Home","title":"Home","text":"warning: Code under development\nWhile we're happy enough with Term to have people start using it, Term is a very young package under active development. This means that:     - there are likely several bugs that need to be discovered and fixed     - as we expand and improve Term there's likely going to be frequent breaking changes If you're curious about Term and you'd like to start playing around with it, you're more than welcome to join the fun. Infact, you can join on us on GitHub and help us make Term even better! If, however, you're thinking of using Term in production-level code that others will need to rely upon, we ask you to be  patient for a bit longer as we continue to work on Term.","category":"page"},{"location":"","page":"Home","title":"Home","text":"info: `Term` and `rich`\nWhile Term was written from scratch in Julia, it's based upon a pre-existing python library called rich. If you have never used rich, jsut know that it's absolutely awesome. And its crator, Will McGugan, made it open source for anyone to use. That also meant people like us could took inspiration from rich to create related packages in other languages. We are very grateful to Will, and we hope that Term will end up beign a fraction as cool as rich.","category":"page"},{"location":"#Installation","page":"Home","title":"Installation","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"In a Julia script:","category":"page"},{"location":"","page":"Home","title":"Home","text":"using Pkg\n\nPkg.add(\"Term\")","category":"page"},{"location":"","page":"Home","title":"Home","text":"or in the Julia REPL","category":"page"},{"location":"","page":"Home","title":"Home","text":"julia> ]  # enters the pkg interface\npkg> add Term","category":"page"},{"location":"","page":"Home","title":"Home","text":"done!","category":"page"},{"location":"","page":"Home","title":"Home","text":"","category":"page"},{"location":"","page":"Home","title":"Home","text":"The rest of the documentation is dedicated to explaining the basic concepts behavind Term.jl and how to use Term to produce styled terminal text.  Head to the GitHub repository to find several detailed examples or jump in the Discussions to start chatting with us. ","category":"page"},{"location":"#Getting-in-touch","page":"Home","title":"Getting in touch","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"If you want to get in touch with us, the easiest way is on GitHub. You can open an issue to report a bug or ask for a new feature or join the discussions for more general chats about Term. The discussion section is also a good place to go for general questions about Term and how to use it. ","category":"page"},{"location":"","page":"Home","title":"Home","text":"Term is written to be a useful piece of software for anyone using Julia, from beginners to more advanced users. If you're comfortable writing and testing code, you can jump in right now and start actively working on Term with us. If you're not, that's totally fine. There's a lot of ways in which you can help: open an issue to report problems with Term, ask questions on GitHub, help expand the docs and examples for other users too. Or just tell us what you're experience using Term was like, any feedback can help us imporove!.","category":"page"},{"location":"#Related-packages","page":"Home","title":"Related packages","text":"","category":"section"},{"location":"","page":"Home","title":"Home","text":"As mentioned, Term is inspired on rich in python. There's also a project called Spectre console which is a .NET Standard 2.0 version of rich.","category":"page"},{"location":"","page":"Home","title":"Home","text":"In Julia there's several pre-existing packages aimed at producing styling terminal output, we note in particular:","category":"page"},{"location":"","page":"Home","title":"Home","text":"Crayons\nAnsiColor","category":"page"},{"location":"api/api_term/#Term","page":"Term","title":"Term","text":"","category":"section"},{"location":"api/api_term/","page":"Term","title":"Term","text":"CurrentModule = Term","category":"page"},{"location":"api/api_term/","page":"Term","title":"Term","text":"Pages   = [\"api_term.md\"]","category":"page"},{"location":"api/api_term/","page":"Term","title":"Term","text":"Modules = [Term]","category":"page"},{"location":"api/api_term/#Term.ANSICode-Tuple{Any}","page":"Term","title":"Term.ANSICode","text":"ANSICode(color; bg::Bool=false)\n\nCreate ANSI tags for colors.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.CodeTheme","page":"Term","title":"Term.CodeTheme","text":"Custom hilighting theme for Highlighters.jl https://juliadocs.github.io/Highlights.jl/stable/man/theme/\n\n\n\n\n\n","category":"type"},{"location":"api/api_term/#Term.Theme","page":"Term","title":"Term.Theme","text":"Theme\n\nStores colors for different semantically relevant items, used to  style outputs to terminal.\n\n\n\n\n\n","category":"type"},{"location":"api/api_term/#Term.measure.Measure-Tuple{Term.segment.Segment}","page":"Term","title":"Term.measure.Measure","text":"Measure(seg::Segment)\n\ngives the measure of a segment\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.measure.Measure-Tuple{Vector{Term.segment.Segment}}","page":"Term","title":"Term.measure.Measure","text":"Measure(segments::Vector{Segment})\n\ngives the measure of a vector of segments\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Highlights.Format.render-Tuple{IO, MIME{Symbol(\"text/ansi\")}, Highlights.Format.TokenIterator}","page":"Term","title":"Highlights.Format.render","text":"Format.render(io::IO, ::MIME\"text/ansi\", tokens::Format.TokenIterator)\n\ncustom ANSI lexer for Highlighters.jl\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.chars-Tuple{AbstractString}","page":"Term","title":"Term.chars","text":"Split a string into a vector of Chars.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.cleantext-Tuple{AbstractString}","page":"Term","title":"Term.cleantext","text":"cleantext(str::AbstractString)\n\nRemove all style information from a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.do_by_line-Tuple{Function, AbstractString}","page":"Term","title":"Term.do_by_line","text":"do_by_line(fn::Function, text::AbstractString)\n\nApply fn to each line in the text.\n\nThe function fn should accept a single ::AbstractString argument.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.escape_brackets-Tuple{AbstractString}","page":"Term","title":"Term.escape_brackets","text":"remove_ansi(str::AbstractString)::AbstractString\n\nReplace each squared bracket with a double copy of itself\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.get_last_valid_str_idx-Tuple{AbstractString, Int64}","page":"Term","title":"Term.get_last_valid_str_idx","text":"get_last_valid_str_idx(str::AbstractString, idx::Int)\n\nGet valid index to cut a string at.\n\nWhen indexing a string, the number of indices is given by the the sum of the ncodeunits of each Char, but some indices will not be valid. This function ensures that given a (potentially) not valid index, the last valid one is elected.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.get_next_valid_str_idx-Tuple{AbstractString, Int64}","page":"Term","title":"Term.get_next_valid_str_idx","text":"getnextvalidstridx(str::AbstractString, idx::Int)\n\nGet valid index to cut a string at.\n\nWhen indexing a string, the number of indices is given by the the sum of the ncodeunits of each Char, but some indices will not be valid. This function ensures that given a (potentially) not valid index, the next valid one is elected.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.get_valid_chars!-Tuple{Vector{Int64}, Any, Int64}","page":"Term","title":"Term.get_valid_chars!","text":"get_valid_chars!(valid_chars::Vector{Int}, tag, δ::Int)\n\nRecursively extract valid characters (i.e. not in markup tags) from a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.highlight-Tuple{AbstractString, Term.Theme, Symbol}","page":"Term","title":"Term.highlight","text":"highlight(text::AbstractString, theme::Theme, like::Symbol)\n\nHilights an entire text as if it was a type of semantically relevant text of type :like.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.highlight-Tuple{AbstractString, Term.Theme}","page":"Term","title":"Term.highlight","text":"highlight(text::AbstractString, theme::Theme)\n\nHighlighs a text introducing markup to style semantically relevant segments, colors specified by a theme object\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.highlight_syntax-Tuple{AbstractString}","page":"Term","title":"Term.highlight_syntax","text":"highlight_syntax(code::AbstractString; style::Bool=true)\n\nHighlight Julia code syntax in a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.join_lines-Tuple{Any}","page":"Term","title":"Term.join_lines","text":"join_lines(lines)\n\nMerge a vector of strings in a single string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.load_code_and_highlight-Tuple{AbstractString, Int64}","page":"Term","title":"Term.load_code_and_highlight","text":"load_code_and_highlight(path::AbstractString, lineno::Int; δ::Int=3, width::INt=120)\n\nLoad a file, get the code and format it. Return styled text\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.nospaces-Tuple{AbstractString}","page":"Term","title":"Term.nospaces","text":"nospaces(text::AbstractString)\n\nRemove all spaces from a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.read_file_lines-Tuple{AbstractString, Int64, Int64}","page":"Term","title":"Term.read_file_lines","text":"read_file_lines(path::String, start::Int, stop::Int)\n\nRead a file and select only lines in range start -> stop.\n\nReturns a vector of tuples with the line number and line content.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.reinsert_double_brackets-Tuple{AbstractString}","page":"Term","title":"Term.reinsert_double_brackets","text":"reinsert_double_brackets(text::AbstractString)::AbstractString\n\nInsert previously replaced double brackets\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.remove_ansi-Tuple{AbstractString}","page":"Term","title":"Term.remove_ansi","text":"remove_ansi(str::AbstractString)::AbstractString\n\nRemove all ANSI tags from a string of text\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.remove_brackets-Tuple{AbstractString}","page":"Term","title":"Term.remove_brackets","text":"remove_brackets(text::AbstractString)\n\nRemove all () brackets from a string.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.remove_markup-Tuple{AbstractString}","page":"Term","title":"Term.remove_markup","text":"remove_markup(input_text::AbstractString)::AbstractString\n\nRemove all markup tags from a string of text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.remove_markup_open-Tuple{AbstractString}","page":"Term","title":"Term.remove_markup_open","text":"remove_markup_open(text::AbstractString)\n\nRemove all opening markup tags from a string of text\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.replace_double_brackets-Tuple{AbstractString}","page":"Term","title":"Term.replace_double_brackets","text":"replace_double_brackets(text::AbstractString)::AbstractString\n\nReplace double brackets with %% and ±± to avoid them being picked up by markup extraction\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.replace_text","page":"Term","title":"Term.replace_text","text":"replace_text(text::AbstractString, start::Int, stop::Int, char::Char='_')\n\nReplace a section of a text  between start and stop with another string composed of repeats of a given character char.\n\n\n\n\n\n","category":"function"},{"location":"api/api_term/#Term.replace_text-Tuple{AbstractString, Int64, Int64, AbstractString}","page":"Term","title":"Term.replace_text","text":"replace_text(text::AbstractString, start::Int, stop::Int, replace::AbstractString)\n\nReplace a section of a text between start and stop with replace.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.reshape_text-Tuple{AbstractString, Int64}","page":"Term","title":"Term.reshape_text","text":"reshape_text(text::AbstractString, width::Int)\n\nReshape text to have a given width.\n\nWhen text is longer than width, it gets cut into multiple lines. This is done carefully to preserve style information by: avoiding  cutting inside style markup and copying markup tags over to new lines so that the style is correctly applied.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.split_lines-Tuple{AbstractString}","page":"Term","title":"Term.split_lines","text":"split_lines(text::AbstractString)\n\nSplit a string into its composing lines.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.split_lines-Tuple{Any}","page":"Term","title":"Term.split_lines","text":"split_lines(renderable)\n\nSplit a renderable's text.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.square_to_round_brackets-Tuple{AbstractString}","page":"Term","title":"Term.square_to_round_brackets","text":"square_to_round_brackets(text::AbstractString)\n\nReplace square brackets with round ones.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.textlen-Tuple{AbstractString}","page":"Term","title":"Term.textlen","text":"textlen(x::AbstractString)\n\nGet length of text after all style information is removed.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.truncate-Tuple{AbstractString, Int64}","page":"Term","title":"Term.truncate","text":"truncate(text::AbstractString, width::Int)\n\nShorten a string of text to a target width\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.unescape_brackets-Tuple{AbstractString}","page":"Term","title":"Term.unescape_brackets","text":"unescape_brackets(text::AbstractString)::AbstractString\n\nReplece every double squared parenthesis with a single copy of itself\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.unspace_commas-Tuple{AbstractString}","page":"Term","title":"Term.unspace_commas","text":"unspace_commas(text::AbstractString)\n\nRemove spaces after commas.\n\n\n\n\n\n","category":"method"},{"location":"api/api_term/#Term.@make_color_macro-Tuple{Any}","page":"Term","title":"Term.@make_color_macro","text":"Macro to create macros such as @green which colors text accordingly\n\n\n\n\n\n","category":"macro"},{"location":"api/api_term/#Term.@make_mode_macro-Tuple{Any}","page":"Term","title":"Term.@make_mode_macro","text":"Macro to create macros such as @underline which styles text accordingly.\n\n\n\n\n\n","category":"macro"},{"location":"api/api_term/#Term.@style-Tuple{Any, Vararg{Any, N} where N}","page":"Term","title":"Term.@style","text":"@style \"text\" style1 style2...\n\nApplies a sequence of styles to a piece of text, such that\n\nprintln(@style \"my text\" bold green underline)\n\nwill print my text as bold, green and underlined\n\n\n\n\n\n","category":"macro"}]
}
