/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.compose.core.ComposeKtConfig;
import io.nlopez.compose.core.ComposeKtVisitor;
import io.nlopez.compose.core.Emitter;
import io.nlopez.compose.core.EmitterKt;
import io.nlopez.compose.core.util.PreviewsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lio/nlopez/compose/rules/PreviewAnnotationNaming;", "Lio/nlopez/compose/core/ComposeKtVisitor;", "<init>", "()V", "visitClass", "", "clazz", "Lorg/jetbrains/kotlin/psi/KtClass;", "emitter", "Lio/nlopez/compose/core/Emitter;", "config", "Lio/nlopez/compose/core/ComposeKtConfig;", "Companion", "common-ktlint"})
public final class PreviewAnnotationNaming
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PreviewAnnotationDoesNotStartWithPreview = "MultiPreview annotations should start with `Preview` as prefix.\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-multipreview-annotations-properly for more information.";

    @Override
    public void visitClass(@NotNull KtClass clazz, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        Intrinsics.checkNotNullParameter(config, "config");
        if (!clazz.isAnnotation()) {
            return;
        }
        if (!PreviewsKt.isPreview(clazz)) {
            return;
        }
        String string = clazz.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String name2 = string;
        if (!StringsKt.startsWith$default(name2, "Preview", false, 2, null)) {
            EmitterKt.report(emitter, clazz, PreviewAnnotationDoesNotStartWithPreview);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/nlopez/compose/rules/PreviewAnnotationNaming$Companion;", "", "<init>", "()V", "PreviewAnnotationDoesNotStartWithPreview", "", "getPreviewAnnotationDoesNotStartWithPreview", "()Ljava/lang/String;", "common-ktlint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPreviewAnnotationDoesNotStartWithPreview() {
            return PreviewAnnotationDoesNotStartWithPreview;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

