/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.io.IOException;
import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.Resource;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Version;
import org.ec4j.core.parser.EditorConfigModelHandler;
import org.ec4j.core.parser.EditorConfigParser;
import org.ec4j.core.parser.ErrorHandler;

public class EditorConfigLoader {
    private final ErrorHandler errorHandler;
    private final EditorConfigModelHandler handler;
    private final EditorConfigParser parser = EditorConfigParser.default_();

    public static EditorConfigLoader default_() {
        return new EditorConfigLoader(new EditorConfigModelHandler(PropertyTypeRegistry.default_(), Version.CURRENT), ErrorHandler.THROW_SYNTAX_ERRORS_IGNORE_OTHERS);
    }

    public static EditorConfigLoader of(Version version2) {
        return EditorConfigLoader.of(version2, PropertyTypeRegistry.default_());
    }

    public static EditorConfigLoader of(Version version2, PropertyTypeRegistry registry) {
        return EditorConfigLoader.of(version2, registry, ErrorHandler.THROW_SYNTAX_ERRORS_IGNORE_OTHERS);
    }

    public static EditorConfigLoader of(Version version2, PropertyTypeRegistry registry, ErrorHandler errorHandler) {
        return new EditorConfigLoader(new EditorConfigModelHandler(registry, version2), errorHandler);
    }

    public EditorConfigLoader(EditorConfigModelHandler handler2, ErrorHandler errorHandler) {
        this.handler = handler2;
        this.errorHandler = errorHandler;
    }

    public EditorConfig load(Resource configFile2) throws IOException {
        try {
            this.parser.parse(configFile2, this.handler, this.errorHandler);
            EditorConfig result2 = this.handler.getEditorConfig();
            return result2;
        }
        catch (IOException e2) {
            throw new IOException("Could not load " + configFile2.getPath(), e2);
        }
    }
}

