/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ec4j.core.model.Ec4jPath;

public class Glob {
    private final PatternSyntaxException error;
    private final List<int[]> ranges;
    private final Pattern regex;
    private final String source;
    private final boolean matchLastSegmentOnly;
    static final Pattern ESCAPED_COMMENT_SIGNS = Pattern.compile("\\\\([#;])");

    public Glob(String source) {
        this.source = source;
        this.ranges = new ArrayList<int[]>();
        source = ESCAPED_COMMENT_SIGNS.matcher(source).replaceAll("$1");
        int slashPos = source.indexOf(47);
        int doubleAsteriskPos = source.indexOf("**");
        if (slashPos >= 0) {
            source = slashPos == 0 ? source.substring(1) : source;
        }
        this.matchLastSegmentOnly = slashPos < 0 && doubleAsteriskPos < 0;
        StringBuilder regex = new StringBuilder(source.length());
        Glob.convertGlobToRegEx(source, this.ranges, regex);
        PatternSyntaxException err = null;
        Pattern pat = null;
        try {
            pat = Pattern.compile(regex.toString());
        }
        catch (PatternSyntaxException e2) {
            err = e2;
        }
        this.error = err;
        this.regex = pat;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Glob other = (Glob)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public PatternSyntaxException getError() {
        return this.error;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.source == null ? 0 : this.source.hashCode());
        return result2;
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public boolean isValid() {
        return this.error == null;
    }

    public boolean match(Ec4jPath filePath) {
        if (!this.isValid()) {
            return false;
        }
        Matcher matcher = this.regex.matcher(this.matchLastSegmentOnly ? filePath.getLastSegment() : filePath.toString());
        if (matcher.matches()) {
            for (int i2 = 0; i2 < matcher.groupCount(); ++i2) {
                int[] range = this.ranges.get(i2);
                String numberString = matcher.group(i2 + 1);
                if (numberString == null || numberString.startsWith("0")) {
                    return false;
                }
                int number = Integer.parseInt(numberString);
                if (number >= range[0] && number <= range[1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.source;
    }

    static void convertGlobToRegEx(String globString, List<int[]> ranges, StringBuilder result2) {
        int length = globString.length();
        int i2 = 0;
        int braceLevel = 0;
        boolean matchingBraces = Glob.matchingBraces(globString);
        boolean escaped = false;
        boolean inBrackets = false;
        while (i2 < length) {
            char current = globString.charAt(i2);
            ++i2;
            if ('*' == current) {
                if (i2 < length && globString.charAt(i2) == '*') {
                    result2.append(".*");
                    ++i2;
                } else {
                    result2.append("[^/]*");
                }
            } else if ('?' == current) {
                result2.append(".");
            } else if ('[' == current) {
                boolean seenSlash;
                boolean bl = seenSlash = Glob.findChar('/', ']', globString, length, i2) >= 0;
                if (seenSlash || escaped) {
                    result2.append("\\[");
                } else if (i2 < length && "!^".indexOf(globString.charAt(i2)) >= 0) {
                    ++i2;
                    result2.append("[^");
                } else {
                    result2.append("[");
                }
                inBrackets = true;
            } else if (']' == current || '-' == current && inBrackets) {
                if (escaped) {
                    result2.append("\\");
                }
                result2.append(current);
                inBrackets = current != ']' || escaped;
            } else if ('{' == current) {
                int j2 = Glob.findChar(',', '}', globString, length, i2);
                if (j2 < 0 && -j2 < length) {
                    String choice = globString.substring(i2, -j2);
                    int[] range = Glob.getNumericRange(choice);
                    if (range != null) {
                        result2.append("(\\d+)");
                        ranges.add(range);
                    } else {
                        result2.append("\\{");
                        Glob.convertGlobToRegEx(choice, ranges, result2);
                        result2.append("\\}");
                    }
                    i2 = -j2 + 1;
                } else if (matchingBraces) {
                    result2.append("(?:");
                    ++braceLevel;
                } else {
                    result2.append("\\{");
                }
            } else if (',' == current) {
                result2.append(braceLevel > 0 && !escaped ? "|" : ",");
            } else if ('/' == current) {
                if (i2 < length && globString.charAt(i2) == '*') {
                    if (i2 + 1 < length && globString.charAt(i2 + 1) == '*' && i2 + 2 < length && globString.charAt(i2 + 2) == '/') {
                        result2.append("(?:/|/.*/)");
                        i2 += 3;
                    } else {
                        result2.append(current);
                    }
                } else {
                    result2.append(current);
                }
            } else if ('}' == current) {
                if (braceLevel > 0 && !escaped) {
                    result2.append(")");
                    --braceLevel;
                } else {
                    result2.append("}");
                }
            } else if ('\\' != current) {
                Glob.escapeToRegex(current, result2);
            }
            if ('\\' == current) {
                if (escaped) {
                    result2.append("\\\\");
                }
                escaped = !escaped;
                continue;
            }
            escaped = false;
        }
    }

    static boolean matchingBraces(String globString) {
        int i2 = 0;
        int len = globString.length();
        int openedCount = 0;
        block5: while (i2 < len) {
            switch (globString.charAt(i2++)) {
                case '\\': {
                    ++i2;
                    continue block5;
                }
                case '{': {
                    ++openedCount;
                    continue block5;
                }
                case '}': {
                    --openedCount;
                    continue block5;
                }
            }
        }
        return openedCount == 0;
    }

    static int[] getNumericRange(String choice) {
        int separator = choice.indexOf("..");
        if (separator < 0) {
            return null;
        }
        try {
            int start = Integer.parseInt(choice.substring(0, separator));
            int end = Integer.parseInt(choice.substring(separator + 2));
            return new int[]{start, end};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static int findChar(char c2, char stopAt, String pattern, int length, int start) {
        int j2;
        boolean escapedChar = false;
        for (j2 = start; j2 < length && (pattern.charAt(j2) != stopAt || escapedChar); ++j2) {
            if (pattern.charAt(j2) == c2 && !escapedChar) {
                return j2;
            }
            escapedChar = pattern.charAt(j2) == '\\' && !escapedChar;
        }
        return -j2;
    }

    static void escapeToRegex(char c2, StringBuilder result2) {
        if (c2 == ' ' || Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_' || c2 == '-') {
            result2.append(c2);
        } else if (c2 == '\n') {
            result2.append("\\n");
        } else {
            result2.append('\\').append(c2);
        }
    }
}

