/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public abstract class ClsRepositoryPsiElement<T extends StubElement>
extends ClsElementImpl
implements StubBasedPsiElement<T> {
    private final T myStub;

    protected ClsRepositoryPsiElement(T stub) {
        this.myStub = stub;
    }

    @Override
    public IStubElementType getElementType() {
        return this.myStub.getStubType();
    }

    @Override
    public PsiElement getParent() {
        return this.myStub.getParentStub().getPsi();
    }

    @Override
    public PsiManager getManager() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return file.getManager();
    }

    @Override
    public PsiFile getContainingFile() {
        Object p2 = this.myStub;
        while (!(p2 instanceof PsiFileStub)) {
            p2 = p2.getParentStub();
        }
        return (PsiFile)p2.getPsi();
    }

    @Override
    public T getStub() {
        return this.myStub;
    }

    @Override
    public boolean isPhysical() {
        PsiFile file = this.getContainingFile();
        return file != null && file.isPhysical();
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        List<StubElement> stubs = this.getStub().getChildrenStubs();
        if (stubs.size() == 0) {
            if (EMPTY_ARRAY == null) {
                ClsRepositoryPsiElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        PsiElement[] children2 = new PsiElement[stubs.size()];
        for (int i2 = 0; i2 < stubs.size(); ++i2) {
            children2[i2] = stubs.get(i2).getPsi();
        }
        if (children2 == null) {
            ClsRepositoryPsiElement.$$$reportNull$$$0(1);
        }
        return children2;
    }

    @Override
    public PsiElement getFirstChild() {
        List<StubElement> children2 = this.getStub().getChildrenStubs();
        return children2.isEmpty() ? null : (PsiElement)children2.get(0).getPsi();
    }

    @Override
    public PsiElement getLastChild() {
        List<StubElement> children2 = this.getStub().getChildrenStubs();
        return children2.isEmpty() ? null : (PsiElement)children2.get(children2.size() - 1).getPsi();
    }

    @Override
    public PsiElement getNextSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i2 = ArrayUtil.indexOf(psiElements, this);
        if (i2 < 0 || i2 >= psiElements.length - 1) {
            return null;
        }
        return psiElements[i2 + 1];
    }

    @Override
    public PsiElement getPrevSibling() {
        Object[] psiElements = this.getParent().getChildren();
        int i2 = ArrayUtil.indexOf(psiElements, this);
        if (i2 < 1) {
            return null;
        }
        return psiElements[i2 - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsRepositoryPsiElement", "getChildren"));
    }
}

