/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.util.Function;

public final class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name2, @NotNull Function<? super H, ? extends T> function2) {
        if (name2 == null) {
            PsiCacheKey.$$$reportNull$$$0(0);
        }
        if (function2 == null) {
            PsiCacheKey.$$$reportNull$$$0(1);
        }
        super(name2);
        this.myFunction = function2;
    }

    public T getValue(@NotNull H h2) {
        T result2;
        if (h2 == null) {
            PsiCacheKey.$$$reportNull$$$0(2);
        }
        if ((result2 = this.getCachedValueOrNull(h2)) != null) {
            return result2;
        }
        result2 = this.myFunction.fun(h2);
        long count2 = PsiCacheKey.getModificationCount(h2);
        h2.putUserData(this, new SoftReference<Pair<Long, T>>(new Pair<Long, T>(count2, result2)));
        return result2;
    }

    @Nullable
    public T getCachedValueOrNull(@NotNull H h2) {
        SoftReference ref;
        Pair data2;
        if (h2 == null) {
            PsiCacheKey.$$$reportNull$$$0(3);
        }
        if ((data2 = (Pair)org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ref = (SoftReference)h2.getUserData(this))) == null || (Long)data2.getFirst() != PsiCacheKey.getModificationCount(h2)) {
            return null;
        }
        return (T)data2.getSecond();
    }

    private static long getModificationCount(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PsiCacheKey.$$$reportNull$$$0(4);
        }
        long nonPhysicalStamp = (file = element.getContainingFile()) == null || file.isPhysical() ? 0L : file.getModificationStamp();
        PsiElement root = file != null ? file : element;
        return nonPhysicalStamp + root.getManager().getModificationTracker().getModificationCount();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name2, @NotNull Function<? super H, ? extends T> function2) {
        if (name2 == null) {
            PsiCacheKey.$$$reportNull$$$0(5);
        }
        if (function2 == null) {
            PsiCacheKey.$$$reportNull$$$0(6);
        }
        return new PsiCacheKey<T, H>(name2, function2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiCacheKey";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedValueOrNull";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getModificationCount";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

