/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u001a\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0003\u001a\\\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00160\u00152\u001a\b\u0002\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0015\u001a-\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00012\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0015H\u0082\b\u001a\u001c\u0010\u001d\u001a\u00020\u00102\b\b\u0002\u0010\u001e\u001a\u00020\u00032\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"MAX_PORT_NUMBER", "", "makeRunFilenameString", "", "timestamp", "digest", "port", "escapeSequence", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "Ljava/io/File;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "Lkotlin/Function2;", "", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "keyword", "baseDir", "LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nClientUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientUtils.kt\norg/jetbrains/kotlin/daemon/common/ClientUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n100#1,16:153\n434#2:147\n507#2,5:148\n1#3:169\n*S KotlinDebug\n*F\n+ 1 ClientUtils.kt\norg/jetbrains/kotlin/daemon/common/ClientUtilsKt\n*L\n69#1:153,16\n121#1:147\n121#1:148,5\n*E\n"})
public final class ClientUtilsKt {
    public static final int MAX_PORT_NUMBER = 65535;
    private static final long ORPHANED_RUN_FILE_AGE_THRESHOLD_MS = 1000000L;
    @NotNull
    private static final String validFlagFileKeywordChars = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkNotNullParameter(timestamp, "timestamp");
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(port, "port");
        Intrinsics.checkNotNullParameter(escapeSequence, "escapeSequence");
        return "kotlin-daemon" + escapeSequence + '.' + timestamp + escapeSequence + '.' + digest + escapeSequence + '.' + port + escapeSequence + ".run";
    }

    public static /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Regex regex = new Regex(ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\"));
        return arg_0 -> ClientUtilsKt.makePortFromRunFilenameExtractor$lambda$0(regex, arg_0);
    }

    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter2, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        Intrinsics.checkNotNullParameter(registryDir, "registryDir");
        Intrinsics.checkNotNullParameter(compilerId, "compilerId");
        Intrinsics.checkNotNullParameter(fileToCompareTimestamp, "fileToCompareTimestamp");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(report2, "report");
        String classPathDigest = compilerId.digest();
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull(SequencesKt.filter(SequencesKt.map(FilesKt.walk$default(registryDir, null, 1, null), arg_0 -> ClientUtilsKt.walkDaemons$lambda$2(portExtractor, arg_0)), arg_0 -> ClientUtilsKt.walkDaemons$lambda$3(filter2, arg_0)), arg_0 -> ClientUtilsKt.walkDaemons$lambda$4(fileToCompareTimestamp, report2, arg_0));
    }

    public static /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, File file2, Function2 function2, Function2 function22, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function2 = ClientUtilsKt::walkDaemons$lambda$0;
        }
        if ((n2 & 0x10) != 0) {
            function22 = ClientUtilsKt::walkDaemons$lambda$1;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, file2, function2, function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        boolean $i$f$tryConnectToDaemon = false;
        try {
            Remote remote = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote daemon = remote != null ? remote.lookup("KotlinJvmCompilerService") : null;
            remote = daemon;
            if (remote == null) {
                report2.invoke(DaemonReportCategory.INFO, "daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon;
                }
                report2.invoke(DaemonReportCategory.INFO, "Unable to cast compiler service, actual class received: " + daemon.getClass().getName());
            }
        }
        catch (Throwable e2) {
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object = e2.getCause();
            if ((object == null || (object = ((Throwable)object).getMessage()) == null) && (object = e2.getMessage()) == null) {
                object = "unknown error";
            }
            report2.invoke(DaemonReportCategory.INFO, stringBuilder.append((String)object).toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(keyword, "keyword");
        String string = keyword;
        StringBuilder stringBuilder = new StringBuilder().append("kotlin-");
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n2 = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)validFlagFileKeywordChars, Character.toLowerCase(it), false, 2, null)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String prefix = stringBuilder.append(((StringBuilder)destination$iv$iv).toString()).append('-').toString();
        File file = baseDir;
        File flagFile = (file != null ? file.isDirectory() : false) ? Files.createTempFile(baseDir.toPath(), prefix, "-is-running", new FileAttribute[0]).toFile() : Files.createTempFile(prefix, "-is-running", new FileAttribute[0]).toFile();
        flagFile.deleteOnExit();
        Intrinsics.checkNotNull(flagFile);
        return flagFile;
    }

    public static /* synthetic */ File makeAutodeletingFlagFile$default(String string, File file, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "compiler-client";
        }
        if ((n2 & 2) != 0) {
            file = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string, file);
    }

    private static final Integer makePortFromRunFilenameExtractor$lambda$0(Regex $regex, String it) {
        String string;
        MatchGroup matchGroup;
        MatchGroupCollection matchGroupCollection;
        Intrinsics.checkNotNullParameter(it, "it");
        MatchResult matchResult = Regex.find$default($regex, it, 0, 2, null);
        return matchResult != null && (matchGroupCollection = matchResult.getGroups()) != null && (matchGroup = matchGroupCollection.get(1)) != null && (string = matchGroup.getValue()) != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    private static final boolean walkDaemons$lambda$0(File file, int n2) {
        Intrinsics.checkNotNullParameter(file, "<unused var>");
        return true;
    }

    private static final Unit walkDaemons$lambda$1(DaemonReportCategory daemonReportCategory, String string) {
        Intrinsics.checkNotNullParameter((Object)daemonReportCategory, "<unused var>");
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        return Unit.INSTANCE;
    }

    private static final Pair walkDaemons$lambda$2(Function1 $portExtractor, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return new Pair(it, $portExtractor.invoke(string));
    }

    private static final boolean walkDaemons$lambda$3(Function2 $filter, Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        File file = (File)pair.component1();
        Integer port = (Integer)pair.component2();
        return port != null && (Boolean)$filter.invoke(file, port) != false;
    }

    private static final DaemonWithMetadata walkDaemons$lambda$4(File $fileToCompareTimestamp, Function2 $report, Pair pair) {
        DaemonWithMetadata daemonWithMetadata;
        CompileService daemon;
        long relativeAge;
        File file;
        block15: {
            CompileService compileService;
            block14: {
                Integer port;
                Intrinsics.checkNotNullParameter(pair, "<destruct>");
                file = (File)pair.component1();
                Integer n2 = port = (Integer)pair.component2();
                Intrinsics.checkNotNull(n2);
                int n3 = n2;
                int n4 = 17001 <= n3 ? (n3 < 18000 ? 1 : 0) : (n3 = 0);
                if (_Assertions.ENABLED && n3 == 0) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                relativeAge = $fileToCompareTimestamp.lastModified() - file.lastModified();
                $report.invoke(DaemonReportCategory.DEBUG, "found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect");
                int port$iv = port;
                boolean $i$f$tryConnectToDaemon = false;
                try {
                    Remote remote = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                    Remote daemon$iv = remote != null ? remote.lookup("KotlinJvmCompilerService") : null;
                    remote = daemon$iv;
                    if (remote == null) {
                        $report.invoke(DaemonReportCategory.INFO, "daemon not found");
                        break block14;
                    }
                    if (remote instanceof CompileService) {
                        compileService = (CompileService)daemon$iv;
                        break block15;
                    }
                    $report.invoke(DaemonReportCategory.INFO, "Unable to cast compiler service, actual class received: " + daemon$iv.getClass().getName());
                }
                catch (Throwable e$iv) {
                    StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
                    Object object = e$iv.getCause();
                    if ((object == null || (object = ((Throwable)object).getMessage()) == null) && (object = e$iv.getMessage()) == null) {
                        object = "unknown error";
                    }
                    $report.invoke(DaemonReportCategory.INFO, stringBuilder.append((String)object).toString());
                }
            }
            compileService = daemon = null;
        }
        if (daemon == null) {
            if (relativeAge - 1000000L <= 0L) {
                $report.invoke(DaemonReportCategory.DEBUG, "found fresh run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it");
            } else {
                $report.invoke(DaemonReportCategory.DEBUG, "found seemingly orphaned run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it");
                if (!file.delete()) {
                    $report.invoke(DaemonReportCategory.INFO, "WARNING: unable to delete seemingly orphaned file '" + file.getAbsolutePath() + "', cleanup recommended");
                }
            }
        }
        try {
            DaemonWithMetadata daemonWithMetadata2;
            CompileService compileService = daemon;
            if (compileService != null) {
                CompileService it = compileService;
                boolean bl = false;
                daemonWithMetadata2 = new DaemonWithMetadata(it, file, it.getDaemonJVMOptions().get());
            } else {
                daemonWithMetadata2 = null;
            }
            daemonWithMetadata = daemonWithMetadata2;
        }
        catch (Exception e2) {
            $report.invoke(DaemonReportCategory.INFO, "ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: " + e2.getMessage());
            daemonWithMetadata = null;
        }
        return daemonWithMetadata;
    }
}

