/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001*B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001c\u001a\u00020\u0013H\u0014J\u001a\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!2\u0006\u0010#\u001a\u00020\u001fH\u0014J\u0014\u0010$\u001a\u00020\u00192\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020'H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteScopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "designationMapForLocalClasses", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Ljava/util/Map;)V", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getUseSiteScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getDesignationMapForLocalClasses", "()Ljava/util/Map;", "statusMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "get", "klass", "startComputing", "endComputing", "", "computeOnlyClassStatus", "forceResolveStatusesOfSupertypes", "regularClass", "additionalSuperTypes", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "superTypeToSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "typeRef", "forceResolveStatusOfCorrespondingClass", "superClassSymbol", "forceResolveStatusesOfClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "resolveClassForSuperType", "", "StatusComputationStatus", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,510:1\n382#2,7:511\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession\n*L\n140#1:511,7\n*E\n"})
public class StatusComputationSession {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final ScopeSession useSiteScopeSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @NotNull
    private final Map<FirClass, StatusComputationStatus> statusMap;

    public StatusComputationSession(@NotNull FirSession useSiteSession, @NotNull ScopeSession useSiteScopeSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses) {
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(useSiteScopeSession, "useSiteScopeSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        this.useSiteSession = useSiteSession;
        this.useSiteScopeSession = useSiteScopeSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.statusMap = MapsKt.withDefaultMutable(new HashMap(), StatusComputationSession::statusMap$lambda$0);
    }

    public /* synthetic */ StatusComputationSession(FirSession firSession, ScopeSession scopeSession, Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(firSession, scopeSession, map2);
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @NotNull
    public final ScopeSession getUseSiteScopeSession() {
        return this.useSiteScopeSession;
    }

    @NotNull
    public final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> getDesignationMapForLocalClasses() {
        return this.designationMapForLocalClasses;
    }

    @NotNull
    public final StatusComputationStatus get(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return MapsKt.getValue(this.statusMap, klass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StatusComputationStatus startComputing(@NotNull FirClass klass) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Map<FirClass, StatusComputationStatus> map2 = this.statusMap;
        FirClass key$iv = klass;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            StatusComputationStatus answer$iv = StatusComputationStatus.Computing;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (StatusComputationStatus)((Object)object);
    }

    public final void endComputing(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        this.statusMap.put(klass, StatusComputationStatus.Computed);
    }

    public final void computeOnlyClassStatus(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        StatusComputationStatus existedStatus = MapsKt.getValue(this.statusMap, klass);
        if (existedStatus.compareTo((Enum)StatusComputationStatus.ComputedOnlyClassStatus) < 0) {
            this.statusMap.put(klass, StatusComputationStatus.ComputedOnlyClassStatus);
        }
    }

    public void forceResolveStatusesOfSupertypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        for (FirTypeRef superTypeRef : CollectionsKt.plus((Collection)regularClass.getSuperTypeRefs(), (Iterable)this.additionalSuperTypes(regularClass))) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(superTypeRef)) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        }
    }

    @NotNull
    protected List<FirTypeRef> additionalSuperTypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected Collection<FirClassifierSymbol<?>> superTypeToSymbols(@NotNull FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        return CollectionsKt.listOfNotNull(ToSymbolUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.useSiteSession));
    }

    private final void forceResolveStatusOfCorrespondingClass(FirClassifierSymbol<?> superClassSymbol) {
        FirClassifierSymbol<?> firClassifierSymbol = superClassSymbol;
        if (firClassifierSymbol instanceof FirRegularClassSymbol) {
            this.forceResolveStatusesOfClass((FirRegularClass)((FirRegularClassSymbol)superClassSymbol).getFir());
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(((FirTypeAlias)((FirTypeAliasSymbol)superClassSymbol).getFir()).getExpandedTypeRef())) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        } else if (!(firClassifierSymbol instanceof FirTypeParameterSymbol) && !(firClassifierSymbol instanceof FirAnonymousObjectSymbol)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        if (!Intrinsics.areEqual(regularClass.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            StatusComputationStatus statusComputationStatus = this.get(regularClass);
            if (!statusComputationStatus.getRequiresComputation()) {
                return;
            }
            this.startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            this.endComputing(regularClass);
            return;
        }
        StatusComputationStatus statusComputationStatus = this.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (!this.resolveClassForSuperType(regularClass)) {
            return;
        }
        this.endComputing(regularClass);
    }

    protected boolean resolveClassForSuperType(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        DesignationState designationState = DesignationState.Companion.create(regularClass.getSymbol(), this.designationMapForLocalClasses, false);
        if (designationState == null) {
            return false;
        }
        DesignationState designation = designationState;
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(designation, this);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
        return true;
    }

    private static final StatusComputationStatus statusMap$lambda$0(FirClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StatusComputationStatus.NotComputed;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession$StatusComputationStatus;", "", "requiresComputation", "", "<init>", "(Ljava/lang/String;IZ)V", "getRequiresComputation", "()Z", "NotComputed", "Computing", "ComputedOnlyClassStatus", "Computed", "resolve"})
    public static final class StatusComputationStatus
    extends Enum<StatusComputationStatus> {
        private final boolean requiresComputation;
        public static final /* enum */ StatusComputationStatus NotComputed = new StatusComputationStatus(true);
        public static final /* enum */ StatusComputationStatus Computing = new StatusComputationStatus(false);
        public static final /* enum */ StatusComputationStatus ComputedOnlyClassStatus = new StatusComputationStatus(true);
        public static final /* enum */ StatusComputationStatus Computed = new StatusComputationStatus(false);
        private static final /* synthetic */ StatusComputationStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StatusComputationStatus(boolean requiresComputation) {
            this.requiresComputation = requiresComputation;
        }

        public final boolean getRequiresComputation() {
            return this.requiresComputation;
        }

        public static StatusComputationStatus[] values() {
            return (StatusComputationStatus[])$VALUES.clone();
        }

        public static StatusComputationStatus valueOf(String value2) {
            return Enum.valueOf(StatusComputationStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<StatusComputationStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusComputationStatusArray = new StatusComputationStatus[]{StatusComputationStatus.NotComputed, StatusComputationStatus.Computing, StatusComputationStatus.ComputedOnlyClassStatus, StatusComputationStatus.Computed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

