/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsLoweringUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.EqualityAndComparisonCallsTransformer$findEqualsMethod$;
import org.jetbrains.kotlin.ir.backend.js.utils.JsInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\f\u0010\u001c\u001a\u00020\r*\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020%H\u0002J\f\u0010&\u001a\u00020'*\u00020%H\u0002J\f\u0010(\u001a\u00020\r*\u00020)H\u0002J\f\u0010*\u001a\u00020\r*\u00020)H\u0002J\f\u0010+\u001a\u00020\r*\u00020'H\u0002J\f\u0010,\u001a\u00020\r*\u00020'H\u0002J\f\u0010-\u001a\u00020\r*\u00020%H\u0002J\f\u0010.\u001a\u00020\r*\u00020\u0013H\u0002J\u001a\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010100*\u00020\u0013H\u0002J \u00102\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0013H\u0002J\f\u00105\u001a\u00020%*\u00020%H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u000fj\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "icUtils", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "longAsBigInt", "", "symbolToTransformer", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/SymbolToTransformer;", "transformLongComparison", "comparator", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "transformFunctionAccess", "call", "doNotIntrinsify", "transformEqeqeqOperator", "isCharBoxing", "transformEqeqOperator", "chooseEqualityOperatorForPrimitiveTypes", "allValueArgumentsAreNullable", "transformCompareToMethodCall", "transformEqualsMethodCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getPrimitiveType", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer$PrimitiveType;", "isMethodOfPrimitiveJSType", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isMethodOfPotentiallyPrimitiveJSType", "isBuiltin", "canBeUsedWithJsEq", "isDefaultEqualsMethod", "isBoxIntrinsic", "unboxParamWithInlinedClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "optimizeInlineClassEquality", "lhs", "rhs", "getLowestUnderlyingType", "PrimitiveType", "backend.js"})
@SourceDebugExtension(value={"SMAP\nEqualityAndComparisonCallsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EqualityAndComparisonCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n488#2,7:275\n488#2,7:282\n488#2,7:289\n488#2,7:296\n1740#3,3:303\n1740#3,3:310\n477#4:306\n28#5:307\n29#5:309\n1#6:308\n*S KotlinDebug\n*F\n+ 1 EqualityAndComparisonCallsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer\n*L\n41#1:275,7\n42#1:282,7\n43#1:289,7\n44#1:296,7\n145#1:303,3\n155#1:310,3\n195#1:306\n243#1:307\n243#1:309\n243#1:308\n*E\n"})
public final class EqualityAndComparisonCallsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIntrinsics intrinsics;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JsInlineClassesUtils icUtils;
    private final boolean longAsBigInt;
    @NotNull
    private final Map<IrFunctionSymbol, Function1<IrFunctionAccessExpression, IrExpression>> symbolToTransformer;

    public EqualityAndComparisonCallsTransformer(@NotNull JsIrBackendContext context2) {
        IrClassifierSymbol it;
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        this.intrinsics = context2.getIntrinsics();
        this.irBuiltIns = context2.getIrBuiltIns();
        this.icUtils = context2.getInlineClassesUtils();
        this.longAsBigInt = JSConfigurationKeysKt.getCompileLongAsBigint(context2.getConfiguration());
        this.symbolToTransformer = new HashMap();
        Map<IrFunctionSymbol, Function1<IrFunctionAccessExpression, IrExpression>> $this$_init__u24lambda_u240 = this.symbolToTransformer;
        boolean bl = false;
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)this.irBuiltIns.getEqeqeqSymbol(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

            public final IrExpression invoke(IrFunctionAccessExpression p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return EqualityAndComparisonCallsTransformer.access$transformEqeqeqOperator((EqualityAndComparisonCallsTransformer)this.receiver, p0);
            }
        });
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)this.irBuiltIns.getEqeqSymbol(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

            public final IrExpression invoke(IrFunctionAccessExpression p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return EqualityAndComparisonCallsTransformer.access$transformEqeqOperator((EqualityAndComparisonCallsTransformer)this.receiver, p0);
            }
        });
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, this.irBuiltIns.getIeee754equalsFunByOperandType(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

            public final IrExpression invoke(IrFunctionAccessExpression p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return EqualityAndComparisonCallsTransformer.access$chooseEqualityOperatorForPrimitiveTypes((EqualityAndComparisonCallsTransformer)this.receiver, p0);
            }
        });
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)this.irBuiltIns.getBooleanNotSymbol(), this.intrinsics.getJsNot());
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map2 = this.irBuiltIns.getLessFunByOperandType();
        Map<IrFunctionSymbol, Function1<IrFunctionAccessExpression, IrExpression>> map3 = $this$_init__u24lambda_u240;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Object, Object> result$iv = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            it = (IrClassifierSymbol)entry.getKey();
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual(it, this.irBuiltIns.getLongClass()))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        CallsLoweringUtilsKt.add(map3, (Map<IrClassifierSymbol, ? extends IrFunctionSymbol>)result$iv, this.intrinsics.getJsLt());
        $this$filterKeys$iv = this.irBuiltIns.getLessOrEqualFunByOperandType();
        map3 = $this$_init__u24lambda_u240;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : $this$filterKeys$iv.entrySet()) {
            it = (IrClassifierSymbol)entry.getKey();
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual(it, this.irBuiltIns.getLongClass()))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        CallsLoweringUtilsKt.add(map3, (Map<IrClassifierSymbol, ? extends IrFunctionSymbol>)result$iv, this.intrinsics.getJsLtEq());
        $this$filterKeys$iv = this.irBuiltIns.getGreaterFunByOperandType();
        map3 = $this$_init__u24lambda_u240;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : $this$filterKeys$iv.entrySet()) {
            it = (IrClassifierSymbol)entry.getKey();
            boolean bl4 = false;
            if (!(!Intrinsics.areEqual(it, this.irBuiltIns.getLongClass()))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        CallsLoweringUtilsKt.add(map3, (Map<IrClassifierSymbol, ? extends IrFunctionSymbol>)result$iv, this.intrinsics.getJsGt());
        $this$filterKeys$iv = this.irBuiltIns.getGreaterOrEqualFunByOperandType();
        map3 = $this$_init__u24lambda_u240;
        $i$f$filterKeys = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : $this$filterKeys$iv.entrySet()) {
            it = (IrClassifierSymbol)entry.getKey();
            boolean bl5 = false;
            if (!(!Intrinsics.areEqual(it, this.irBuiltIns.getLongClass()))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        CallsLoweringUtilsKt.add(map3, (Map<IrClassifierSymbol, ? extends IrFunctionSymbol>)result$iv, this.intrinsics.getJsGtEq());
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.irBuiltIns.getLessFunByOperandType().get(this.irBuiltIns.getLongClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)irSimpleFunctionSymbol, this.transformLongComparison(this.intrinsics.getJsLt()));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.irBuiltIns.getLessOrEqualFunByOperandType().get(this.irBuiltIns.getLongClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol2);
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)irSimpleFunctionSymbol2, this.transformLongComparison(this.intrinsics.getJsLtEq()));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = this.irBuiltIns.getGreaterFunByOperandType().get(this.irBuiltIns.getLongClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol3);
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)irSimpleFunctionSymbol3, this.transformLongComparison(this.intrinsics.getJsGt()));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = this.irBuiltIns.getGreaterOrEqualFunByOperandType().get(this.irBuiltIns.getLongClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol4);
        CallsLoweringUtilsKt.add($this$_init__u24lambda_u240, (IrFunctionSymbol)irSimpleFunctionSymbol4, this.transformLongComparison(this.intrinsics.getJsGtEq()));
    }

    private final Function1<IrFunctionAccessExpression, IrExpression> transformLongComparison(IrSimpleFunctionSymbol comparator) {
        return arg_0 -> EqualityAndComparisonCallsTransformer.transformLongComparison$lambda$0(this, comparator, arg_0);
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter(call2, "call");
        IrFunctionSymbol symbol = (IrFunctionSymbol)call2.getSymbol();
        Object object = this.symbolToTransformer.get(symbol);
        if (object != null) {
            Function1<IrFunctionAccessExpression, IrExpression> it = object;
            boolean bl = false;
            return it.invoke(call2);
        }
        object = symbol.getOwner().getName();
        return Intrinsics.areEqual(object, Name.identifier("compareTo")) ? (doNotIntrinsify ? (IrExpression)call2 : this.transformCompareToMethodCall(call2)) : (Intrinsics.areEqual(object, Name.identifier("equals")) ? this.transformEqualsMethodCall((IrCall)call2) : (IrExpression)call2);
    }

    private final IrExpression transformEqeqeqOperator(IrFunctionAccessExpression call2) {
        Object e2 = call2.getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        IrExpression lhs = (IrExpression)e2;
        Object e3 = call2.getArguments().get(1);
        Intrinsics.checkNotNull(e3);
        IrExpression rhs = (IrExpression)e3;
        return this.isCharBoxing(lhs) && this.isCharBoxing(rhs) ? this.optimizeInlineClassEquality(call2, lhs, rhs) : (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEqeqeq(), null, null, 12, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCharBoxing(IrExpression $this$isCharBoxing) {
        if (!($this$isCharBoxing instanceof IrCall)) return false;
        if (!Intrinsics.areEqual(((IrCall)$this$isCharBoxing).getSymbol(), this.intrinsics.getJsBoxIntrinsic())) return false;
        Object e2 = ((IrCall)$this$isCharBoxing).getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        if (!IrTypePredicatesKt.isChar(((IrExpression)e2).getType())) return false;
        return true;
    }

    private final IrExpression transformEqeqOperator(IrFunctionAccessExpression call2) {
        IrExpression irExpression;
        Object e2 = call2.getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        IrExpression lhs = (IrExpression)e2;
        Object e3 = call2.getArguments().get(1);
        Intrinsics.checkNotNull(e3);
        IrExpression rhs = (IrExpression)e3;
        PrimitiveType lhsJsType = this.getPrimitiveType(lhs.getType());
        PrimitiveType rhsJsType = this.getPrimitiveType(rhs.getType());
        IrSimpleFunction equalsMethod = this.findEqualsMethod(lhs.getType());
        if (lhs.getType() instanceof IrDynamicType) {
            irExpression = IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEqeq(), null, null, 12, null);
        } else if (IrUtilsKt.isNullConst(lhs) || IrUtilsKt.isNullConst(rhs)) {
            irExpression = IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEqeq(), null, null, 12, null);
        } else if (lhsJsType == rhsJsType && this.canBeUsedWithJsEq(lhsJsType)) {
            irExpression = this.chooseEqualityOperatorForPrimitiveTypes(call2);
        } else if (IrTypePredicatesKt.isLong(lhs.getType()) && IrTypePredicatesKt.isLong(rhs.getType())) {
            if (this.longAsBigInt) {
                irExpression = this.chooseEqualityOperatorForPrimitiveTypes(call2);
            } else {
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.intrinsics.getLongEquals();
                Intrinsics.checkNotNull(irSimpleFunctionSymbol);
                irExpression = IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null);
            }
        } else {
            irExpression = !this.isBuiltin(lhsJsType) && !IrTypeUtilsKt.isNullable(lhs.getType()) && equalsMethod != null ? (IrExpression)IrUtilsKt.irCall$default(call2, equalsMethod.getSymbol(), null, null, 12, null) : (this.isBoxIntrinsic(lhs) && this.isBoxIntrinsic(rhs) ? this.optimizeInlineClassEquality(call2, lhs, rhs) : (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEquals(), null, null, 12, null));
        }
        return irExpression;
    }

    private final IrExpression chooseEqualityOperatorForPrimitiveTypes(IrFunctionAccessExpression call2) {
        return this.allValueArgumentsAreNullable(call2) ? (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEqeq(), null, null, 12, null) : (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEqeqeq(), null, null, 12, null);
    }

    private final boolean allValueArgumentsAreNullable(IrFunctionAccessExpression $this$allValueArgumentsAreNullable) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = IrUtilsKt.getNonDispatchArguments($this$allValueArgumentsAreNullable);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IrExpression it = (IrExpression)element$iv;
                    boolean bl2 = false;
                    IrExpression irExpression = it;
                    Intrinsics.checkNotNull(irExpression);
                    if (IrTypeUtilsKt.isNullable(irExpression.getType())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final IrExpression transformCompareToMethodCall(IrFunctionAccessExpression call2) {
        IrFunction irFunction = ((IrFunctionSymbol)call2.getSymbol()).getOwner();
        Intrinsics.checkNotNull(irFunction, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        IrSimpleFunction function2 = (IrSimpleFunction)irFunction;
        if (!(function2.getParent() instanceof IrClass)) {
            return call2;
        }
        return this.isMethodOfPrimitiveJSType(function2) || EqualityAndComparisonCallsTransformer.transformCompareToMethodCall$isFakeOverriddenFromComparable(function2) ? (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsCompareTo(), null, null, 12, null) : (IrExpression)call2;
    }

    private final IrExpression transformEqualsMethodCall(IrCall call2) {
        IrSimpleFunction function2 = (IrSimpleFunction)call2.getSymbol().getOwner();
        return !MiscKt.isEqualsInheritedFromAny(function2) ? (IrExpression)call2 : (IrUtilsKt.isSuperToAny(call2) ? (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.intrinsics.getJsEqeqeq(), null, null, 12, null) : (this.isMethodOfPotentiallyPrimitiveJSType(function2) ? (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)call2, this.intrinsics.getJsEquals(), null, null, 12, null) : (IrExpression)call2));
    }

    private final IrSimpleFunction findEqualsMethod(IrType $this$findEqualsMethod) {
        IrClass irClass = IrTypesKt.getClass($this$findEqualsMethod);
        if (irClass == null) {
            return null;
        }
        IrClass klass = irClass;
        if (IrUtilsKt.isEnumClass(klass) && klass.isExternal()) {
            return null;
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)klass.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, findEqualsMethod$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return MemoryOptimizedCollectionUtilKt.atMostOne(SequencesKt.filter(sequence2, EqualityAndComparisonCallsTransformer::findEqualsMethod$lambda$0));
    }

    private final PrimitiveType getPrimitiveType(IrType $this$getPrimitiveType) {
        IrType $this$getPrimitiveType_u24lambda_u240 = IrTypesKt.makeNotNull($this$getPrimitiveType);
        boolean bl = false;
        return IrTypePredicatesKt.isBoolean($this$getPrimitiveType_u24lambda_u240) ? PrimitiveType.BOOLEAN : (IrTypePredicatesKt.isByte($this$getPrimitiveType_u24lambda_u240) || IrTypePredicatesKt.isShort($this$getPrimitiveType_u24lambda_u240) || IrTypePredicatesKt.isInt($this$getPrimitiveType_u24lambda_u240) ? PrimitiveType.INTEGER_NUMBER : (IrTypePredicatesKt.isFloat($this$getPrimitiveType_u24lambda_u240) || IrTypePredicatesKt.isDouble($this$getPrimitiveType_u24lambda_u240) ? PrimitiveType.FLOATING_POINT_NUMBER : (IrTypePredicatesKt.isString($this$getPrimitiveType_u24lambda_u240) ? PrimitiveType.STRING : (IrTypePredicatesKt.isLong($this$getPrimitiveType_u24lambda_u240) && this.longAsBigInt ? PrimitiveType.BIGINT_NUMBER : PrimitiveType.OTHER))));
    }

    private final boolean isMethodOfPrimitiveJSType(IrFunction $this$isMethodOfPrimitiveJSType) {
        boolean bl;
        IrValueParameter irValueParameter = $this$isMethodOfPrimitiveJSType.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl2 = false;
            bl = this.getPrimitiveType(it.getType()) != PrimitiveType.OTHER;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isMethodOfPotentiallyPrimitiveJSType(IrFunction $this$isMethodOfPotentiallyPrimitiveJSType) {
        return this.isMethodOfPrimitiveJSType($this$isMethodOfPotentiallyPrimitiveJSType) || IrUtilsKt.isFakeOverriddenFromAny($this$isMethodOfPotentiallyPrimitiveJSType);
    }

    private final boolean isBuiltin(PrimitiveType $this$isBuiltin) {
        return $this$isBuiltin != PrimitiveType.OTHER;
    }

    private final boolean canBeUsedWithJsEq(PrimitiveType $this$canBeUsedWithJsEq) {
        return this.isBuiltin($this$canBeUsedWithJsEq) && $this$canBeUsedWithJsEq != PrimitiveType.FLOATING_POINT_NUMBER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultEqualsMethod(IrType $this$isDefaultEqualsMethod) {
        if (IrTypePredicatesKt.isChar($this$isDefaultEqualsMethod)) return true;
        IrSimpleFunction irSimpleFunction = this.findEqualsMethod($this$isDefaultEqualsMethod);
        if ((irSimpleFunction != null ? irSimpleFunction.getOrigin() : null) != IrDeclarationOrigin.Companion.getGENERATED_SINGLE_FIELD_VALUE_CLASS_MEMBER()) return false;
        return true;
    }

    private final boolean isBoxIntrinsic(IrExpression $this$isBoxIntrinsic) {
        return $this$isBoxIntrinsic instanceof IrCall && Intrinsics.areEqual(((IrCall)$this$isBoxIntrinsic).getSymbol(), this.icUtils.getBoxIntrinsic());
    }

    private final Pair<IrExpression, IrClass> unboxParamWithInlinedClass(IrExpression $this$unboxParamWithInlinedClass) {
        Intrinsics.checkNotNull($this$unboxParamWithInlinedClass, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
        IrExpression irExpression = (IrExpression)((IrFunctionAccessExpression)$this$unboxParamWithInlinedClass).getArguments().get(0);
        if (irExpression == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Boxed expression is expected";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$unboxParamWithInlinedClass_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$unboxParamWithInlinedClass_u24lambda_u240.withIrEntry("this", $this$unboxParamWithInlinedClass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        IrExpression unboxed = irExpression;
        return new Pair<IrExpression, IrClass>(unboxed, this.icUtils.getInlinedClass(unboxed.getType()));
    }

    private final IrExpression optimizeInlineClassEquality(IrFunctionAccessExpression call2, IrExpression lhs, IrExpression rhs) {
        Pair<IrExpression, IrClass> pair = this.unboxParamWithInlinedClass(lhs);
        IrExpression lhsUnboxed = pair.component1();
        IrClass lhsClassType = pair.component2();
        Pair<IrExpression, IrClass> pair2 = this.unboxParamWithInlinedClass(rhs);
        IrExpression rhsUnboxed = pair2.component1();
        IrClass rhsClassType = pair2.component2();
        if (lhsClassType != null && lhsClassType == rhsClassType && this.isDefaultEqualsMethod(lhsUnboxed.getType())) {
            call2.getArguments().set(0, lhsUnboxed);
            call2.getArguments().set(1, rhsUnboxed);
            if (IrTypePredicatesKt.isChar(lhsUnboxed.getType()) || this.canBeUsedWithJsEq(this.getPrimitiveType(this.getLowestUnderlyingType(lhsUnboxed.getType())))) {
                return this.chooseEqualityOperatorForPrimitiveTypes(call2);
            }
        }
        return IrUtilsKt.irCall$default(call2, this.intrinsics.getJsEquals(), null, null, 12, null);
    }

    private final IrType getLowestUnderlyingType(IrType $this$getLowestUnderlyingType) {
        if (this.isDefaultEqualsMethod($this$getLowestUnderlyingType)) {
            IrSimpleType underlyingType;
            Object object = this.icUtils.getInlinedClass($this$getLowestUnderlyingType);
            IrSimpleType irSimpleType = object != null && (object = IrDeclarationsKt.getInlineClassRepresentation((IrClass)object)) != null ? (IrSimpleType)((InlineClassRepresentation)object).getUnderlyingType() : (underlyingType = null);
            if (underlyingType != null) {
                return this.getLowestUnderlyingType(underlyingType);
            }
        }
        return $this$getLowestUnderlyingType;
    }

    private static final IrExpression transformLongComparison$lambda$0(EqualityAndComparisonCallsTransformer this$0, IrSimpleFunctionSymbol $comparator, IrFunctionAccessExpression call2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(call2, "call");
        if (this$0.longAsBigInt) {
            irExpression = IrUtilsKt.irCall$default(call2, $comparator, null, null, 12, null);
        } else {
            IrCallImpl irCallImpl;
            IrCallImpl $this$transformLongComparison_u24lambda_u240_u240 = irCallImpl = BuildersKt.IrCallImpl$default(call2.getStartOffset(), call2.getEndOffset(), ((IrSimpleFunction)$comparator.getOwner()).getReturnType(), $comparator, 0, null, null, 96, null);
            boolean bl = false;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$transformLongComparison_u24lambda_u240_u240.getArguments();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this$0.intrinsics.getLongCompareToLong();
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            valueArgumentsList.set(0, IrUtilsKt.irCall$default(call2, irSimpleFunctionSymbol, null, null, 12, null));
            $this$transformLongComparison_u24lambda_u240_u240.getArguments().set(1, JsIrBuilder.INSTANCE.buildInt(this$0.irBuiltIns.getIntType(), 0));
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean transformCompareToMethodCall$isFakeOverriddenFromComparable(IrSimpleFunction $this$transformCompareToMethodCall_u24isFakeOverriddenFromComparable) {
        IrSimpleFunctionSymbol it;
        if (!$this$transformCompareToMethodCall_u24isFakeOverriddenFromComparable.isFakeOverride()) {
            if (IrDeclarationsKt.isStaticMethodOfClass($this$transformCompareToMethodCall_u24isFakeOverriddenFromComparable)) return false;
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass($this$transformCompareToMethodCall_u24isFakeOverriddenFromComparable).getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            if (!IrTypePredicatesKt.isComparable(irValueParameter.getType())) return false;
            return true;
        }
        Iterable $this$all$iv = $this$transformCompareToMethodCall_u24isFakeOverriddenFromComparable.getOverriddenSymbols();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
        } while (EqualityAndComparisonCallsTransformer.transformCompareToMethodCall$isFakeOverriddenFromComparable((IrSimpleFunction)it.getOwner()));
        return false;
    }

    private static final boolean findEqualsMethod$lambda$0(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MiscKt.isEqualsInheritedFromAny(it) && !IrUtilsKt.isFakeOverriddenFromAny(it);
    }

    public static final /* synthetic */ IrExpression access$transformEqeqeqOperator(EqualityAndComparisonCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformEqeqeqOperator(call2);
    }

    public static final /* synthetic */ IrExpression access$transformEqeqOperator(EqualityAndComparisonCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformEqeqOperator(call2);
    }

    public static final /* synthetic */ IrExpression access$chooseEqualityOperatorForPrimitiveTypes(EqualityAndComparisonCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.chooseEqualityOperatorForPrimitiveTypes(call2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer$PrimitiveType;", "", "<init>", "(Ljava/lang/String;I)V", "FLOATING_POINT_NUMBER", "INTEGER_NUMBER", "BIGINT_NUMBER", "STRING", "BOOLEAN", "OTHER", "backend.js"})
    private static final class PrimitiveType
    extends Enum<PrimitiveType> {
        public static final /* enum */ PrimitiveType FLOATING_POINT_NUMBER = new PrimitiveType();
        public static final /* enum */ PrimitiveType INTEGER_NUMBER = new PrimitiveType();
        public static final /* enum */ PrimitiveType BIGINT_NUMBER = new PrimitiveType();
        public static final /* enum */ PrimitiveType STRING = new PrimitiveType();
        public static final /* enum */ PrimitiveType BOOLEAN = new PrimitiveType();
        public static final /* enum */ PrimitiveType OTHER = new PrimitiveType();
        private static final /* synthetic */ PrimitiveType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PrimitiveType[] values() {
            return (PrimitiveType[])$VALUES.clone();
        }

        public static PrimitiveType valueOf(String value2) {
            return Enum.valueOf(PrimitiveType.class, value2);
        }

        @NotNull
        public static EnumEntries<PrimitiveType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = primitiveTypeArray = new PrimitiveType[]{PrimitiveType.FLOATING_POINT_NUMBER, PrimitiveType.INTEGER_NUMBER, PrimitiveType.BIGINT_NUMBER, PrimitiveType.STRING, PrimitiveType.BOOLEAN, PrimitiveType.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

