/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.LazyExplicitImportScope;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.lazy.ImportForceResolver;
import org.jetbrains.kotlin.resolve.lazy.ImportResolutionComponents;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolver;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolverForKtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolver;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/ImportForceResolver;", "components", "Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;", "indexedImports", "Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "traceForImportResolve", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;)V", "forceResolveImportDirective", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "", "forceResolveNonDefaultImportsTask", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "forceResolveNonDefaultImports", "checkResolvedImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportInfo;", "forceResolveImport", "frontend"})
@SourceDebugExtension(value={"SMAP\nLazyImportScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyImportScope.kt\norg/jetbrains/kotlin/resolve/lazy/LazyImportResolverForKtImportDirective\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,400:1\n1069#2,2:401\n1869#3,2:403\n*S KotlinDebug\n*F\n+ 1 LazyImportScope.kt\norg/jetbrains/kotlin/resolve/lazy/LazyImportResolverForKtImportDirective\n*L\n199#1:401,2\n206#1:403,2\n*E\n"})
public final class LazyImportResolverForKtImportDirective
extends LazyImportResolver<KtImportDirective>
implements ImportForceResolver {
    @NotNull
    private final MemoizedFunctionToNotNull<KtImportDirective, Unit> forceResolveImportDirective;
    @NotNull
    private final NotNullLazyValue<Unit> forceResolveNonDefaultImportsTask;

    public LazyImportResolverForKtImportDirective(@NotNull ImportResolutionComponents components, @NotNull IndexedImports<KtImportDirective> indexedImports, @NotNull Collection<FqName> excludedImportNames, @NotNull BindingTrace traceForImportResolve, @Nullable PackageFragmentDescriptor packageFragment) {
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(indexedImports, "indexedImports");
        Intrinsics.checkNotNullParameter(excludedImportNames, "excludedImportNames");
        Intrinsics.checkNotNullParameter(traceForImportResolve, "traceForImportResolve");
        super(components, indexedImports, excludedImportNames, traceForImportResolve, packageFragment);
        this.forceResolveImportDirective = components.getStorageManager().createMemoizedFunction(arg_0 -> LazyImportResolverForKtImportDirective.forceResolveImportDirective$lambda$0(this, components, traceForImportResolve, arg_0));
        this.forceResolveNonDefaultImportsTask = components.getStorageManager().createLazyValue(() -> LazyImportResolverForKtImportDirective.forceResolveNonDefaultImportsTask$lambda$0(indexedImports, this, traceForImportResolve));
    }

    @Override
    public void forceResolveNonDefaultImports() {
        this.forceResolveNonDefaultImportsTask.invoke();
    }

    private final void checkResolvedImportDirective(KtImportInfo importDirective) {
        if (!(importDirective instanceof KtImportDirective)) {
            return;
        }
        KtExpression ktExpression = ((KtImportDirective)importDirective).getImportedReference();
        if (ktExpression == null) {
            return;
        }
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtil.getLastReference(ktExpression);
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression importedReference = ktSimpleNameExpression;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getTraceForImportResolve().getBindingContext().get(BindingContext.REFERENCE_TARGET, importedReference);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor importedDescriptor = declarationDescriptor;
        String aliasName = ((KtImportDirective)importDirective).getAliasName();
        if (importedDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)importedDescriptor).isOperator() && aliasName != null && OperatorConventions.isConventionName(Name.identifier(aliasName))) {
            this.getTraceForImportResolve().report(Errors.OPERATOR_RENAMED_ON_IMPORT.on((KtSimpleNameExpression)((PsiElement)importedReference)));
        }
    }

    @Override
    public void forceResolveImport(@NotNull KtImportDirective importDirective) {
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        this.forceResolveImportDirective.invoke(importDirective);
    }

    private static final Unit forceResolveImportDirective$lambda$0(LazyImportResolverForKtImportDirective this$0, ImportResolutionComponents $components, BindingTrace $traceForImportResolve, KtImportDirective directive) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        ImportingScope scope2 = this$0.getImportScope(directive);
        if (scope2 instanceof LazyExplicitImportScope) {
            Collection<DeclarationDescriptor> allDescriptors2 = ((LazyExplicitImportScope)scope2).storeReferencesToDescriptors$frontend();
            PlatformClassesMappedToKotlinChecker.checkPlatformClassesMappedToKotlin($components.getPlatformToKotlinClassMapper(), $traceForImportResolve, directive, allDescriptors2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit forceResolveNonDefaultImportsTask$lambda$0(IndexedImports $indexedImports, LazyImportResolverForKtImportDirective this$0, BindingTrace $traceForImportResolve) {
        HashMultimap explicitClassImports = HashMultimap.create();
        for (KtImportDirective importInfo : (KtImportDirective[])$indexedImports.getImports()) {
            KotlinLookupLocation lookupLocation;
            this$0.forceResolveImport(importInfo);
            ImportingScope scope2 = this$0.getImportScope(importInfo);
            Name alias = importInfo.getImportedName();
            if (alias != null && scope2.getContributedClassifier(alias, lookupLocation = new KotlinLookupLocation(importInfo)) != null) {
                explicitClassImports.put(alias.asString(), importInfo);
            }
            this$0.checkResolvedImportDirective(importInfo);
        }
        for (Map.Entry entry : explicitClassImports.entries()) {
            boolean bl;
            KtImportDirective ktImportDirective;
            block6: {
                Intrinsics.checkNotNull(entry);
                String alias = (String)entry.getKey();
                ktImportDirective = (KtImportDirective)entry.getValue();
                Intrinsics.checkNotNull(alias);
                CharSequence $this$all$iv = alias;
                boolean $i$f$all = false;
                for (int lookupLocation = 0; lookupLocation < $this$all$iv.length(); ++lookupLocation) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(lookupLocation);
                    boolean bl2 = false;
                    if (it == '_') continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            if (!bl) continue;
            $traceForImportResolve.report(Errors.UNDERSCORE_IS_RESERVED.on(ktImportDirective));
        }
        for (String alias : explicitClassImports.keySet()) {
            Set imports = explicitClassImports.get(alias);
            if (imports.size() <= 1) continue;
            Intrinsics.checkNotNull(imports);
            Iterable $this$forEach$iv = imports;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtImportDirective it = (KtImportDirective)element$iv;
                boolean bl = false;
                $traceForImportResolve.report(Errors.CONFLICTING_IMPORT.on((KtImportDirective)((PsiElement)it), alias));
            }
        }
        return Unit.INSTANCE;
    }
}

