/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ResolverForModule;
import org.jetbrains.kotlin.analyzer.ResolverForProject;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analyzer/EmptyResolverForProject;", "M", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/ResolverForProject;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "tryGetResolverForModule", "Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "moduleInfo", "(Lorg/jetbrains/kotlin/analyzer/ModuleInfo;)Lorg/jetbrains/kotlin/analyzer/ResolverForModule;", "resolverForModuleDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "descriptorForModule", "", "(Lorg/jetbrains/kotlin/analyzer/ModuleInfo;)Ljava/lang/Void;", "allModules", "", "getAllModules", "()Ljava/util/Collection;", "diagnoseUnknownModuleInfo", "infos", "", "moduleInfoForModuleDescriptor", "moduleDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "frontend"})
public final class EmptyResolverForProject<M extends ModuleInfo>
extends ResolverForProject<M> {
    @NotNull
    private final Collection<M> allModules = CollectionsKt.emptyList();

    @Override
    @NotNull
    public String getName() {
        return "Empty resolver";
    }

    @Override
    @Nullable
    public ResolverForModule tryGetResolverForModule(@NotNull M moduleInfo) {
        Intrinsics.checkNotNullParameter(moduleInfo, "moduleInfo");
        return null;
    }

    @Override
    @NotNull
    public ResolverForModule resolverForModuleDescriptor(@NotNull ModuleDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        throw new IllegalStateException(descriptor2 + " is not contained in this resolver");
    }

    @NotNull
    public Void descriptorForModule(@NotNull M moduleInfo) {
        Intrinsics.checkNotNullParameter(moduleInfo, "moduleInfo");
        this.diagnoseUnknownModuleInfo(CollectionsKt.listOf(moduleInfo));
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public Collection<M> getAllModules() {
        return this.allModules;
    }

    @Override
    @NotNull
    public Void diagnoseUnknownModuleInfo(@NotNull List<? extends ModuleInfo> infos) {
        Intrinsics.checkNotNullParameter(infos, "infos");
        throw new IllegalStateException("Should not be called for " + infos);
    }

    @Override
    @NotNull
    public M moduleInfoForModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        throw new IllegalStateException(moduleDescriptor + " is not contained in this resolver");
    }
}

