/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideProvider;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrDeserializationSettings;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.jvm.serialization.IrLibraryFileFromAnnotation;
import org.jetbrains.kotlin.backend.jvm.serialization.PrePopulatedDeclarationTable;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrProvider;
import org.jetbrains.kotlin.ir.backend.jvm.serialization.JvmIrMangler;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a\u001a(\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"deserializeFromByteArray", "", "byteArray", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/IrProvider;", "toplevelParent", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "safelyInitializeAllLazyDescendants", "Lorg/jetbrains/kotlin/ir/IrElement;", "referencePublicSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "makeSimpleFakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "buildFakeOverridesForLocalClasses", "toplevel", "ir.serialization.jvm"})
public final class DeserializeLazyDeclarationsKt {
    public static final void deserializeFromByteArray(@NotNull byte[] byteArray, @NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders, @NotNull IrClass toplevelParent, @NotNull IrTypeSystemContext typeSystemContext2) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, "irProviders");
        Intrinsics.checkNotNullParameter(toplevelParent, "toplevelParent");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        IrInterningService irInterner = new IrInterningService();
        JvmIr.ClassOrFile irProto = JvmIr.ClassOrFile.parseFrom(BasicIrModuleDeserializerKt.getCodedInputStream(byteArray));
        List<IrType> list = irProto.getTypeList();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeList(...)");
        List<org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature> list2 = irProto.getSignatureList();
        Intrinsics.checkNotNullExpressionValue(list2, "getSignatureList(...)");
        ProtocolStringList protocolStringList = irProto.getStringList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "getStringList(...)");
        List list3 = protocolStringList;
        List<JvmIr.XStatementOrExpression> list4 = irProto.getBodyList();
        Intrinsics.checkNotNullExpressionValue(list4, "getBodyList(...)");
        ProtocolStringList protocolStringList2 = irProto.getDebugInfoList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList2, "getDebugInfoList(...)");
        List list5 = protocolStringList2;
        List<FileEntry> list6 = irProto.getFileEntryList();
        Intrinsics.checkNotNullExpressionValue(list6, "getFileEntryList(...)");
        IrLibraryFileFromAnnotation irLibraryFile = new IrLibraryFileFromAnnotation(list, list2, list3, list4, list5, list6);
        IrFileEntry irFileEntry = new NaiveSourceBasedFileEntryImpl("<unknown>", null, 0, 0, 14, null);
        IrFileSymbol irFileSymbol = new IrFileSymbolImpl(null, 1, null);
        FqName fqName2 = AdditionalIrUtilsKt.getPackageFqName(toplevelParent);
        Intrinsics.checkNotNull(fqName2);
        IrFileImpl dummyIrFile = new IrFileImpl(irFileEntry, irFileSymbol, fqName2);
        String string = irProto.getFileFacadeFqName();
        Intrinsics.checkNotNullExpressionValue(string, "getFileFacadeFqName(...)");
        FqName fqName3 = AdditionalIrUtilsKt.getPackageFqName(toplevelParent);
        Intrinsics.checkNotNull(fqName3);
        IdSignature.FileSignature dummyFileSignature = new IdSignature.FileSignature(string, fqName3, "<unknown>");
        IrFileSymbol irFileSymbol2 = dummyIrFile.getSymbol();
        IrSymbolDeserializer symbolDeserializer2 = new IrSymbolDeserializer(symbolTable, irLibraryFile, irFileSymbol2, DeserializeLazyDeclarationsKt::deserializeFromByteArray$lambda$0, irInterner, null, dummyFileSignature, (arg_0, arg_1) -> DeserializeLazyDeclarationsKt.deserializeFromByteArray$lambda$1(symbolTable, arg_0, arg_1), 32, null);
        IrDeclarationDeserializer deserializer2 = new IrDeclarationDeserializer(irBuiltIns, symbolTable, irBuiltIns.getIrFactory(), irLibraryFile, toplevelParent, new IrDeserializationSettings(false, true, null, false, 13, null), symbolDeserializer2, DeserializeLazyDeclarationsKt::deserializeFromByteArray$lambda$2, DeserializeLazyDeclarationsKt::deserializeFromByteArray$lambda$3, null, irInterner);
        for (IrDeclaration declarationProto : irProto.getDeclarationList()) {
            Intrinsics.checkNotNull(declarationProto);
            deserializer2.deserializeDeclaration(declarationProto, false);
        }
        IdSignatureComposer signaturer = symbolTable.getSignaturer();
        if (signaturer == null) {
            new ExternalDependenciesGenerator(symbolTable, irProviders).generateUnboundSymbolsAsDependencies();
        } else {
            signaturer.withFileSignature(dummyFileSignature, () -> DeserializeLazyDeclarationsKt.deserializeFromByteArray$lambda$4(symbolTable, irProviders));
        }
        DeserializeLazyDeclarationsKt.safelyInitializeAllLazyDescendants(toplevelParent);
        PatchDeclarationParentsKt.patchDeclarationParents$default(toplevelParent, null, 1, null);
        DeserializeLazyDeclarationsKt.buildFakeOverridesForLocalClasses(symbolTable, typeSystemContext2, symbolDeserializer2, toplevelParent);
    }

    private static final void safelyInitializeAllLazyDescendants(IrElement $this$safelyInitializeAllLazyDescendants) {
        IrVisitorsKt.acceptVoid($this$safelyInitializeAllLazyDescendants, new IrVisitorVoid(){

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                List directChildrenSnapshot = new ArrayList<E>();
                IrVisitorsKt.acceptChildrenVoid(element, new IrVisitorVoid(directChildrenSnapshot){
                    final /* synthetic */ List<IrElement> $directChildrenSnapshot;
                    {
                        this.$directChildrenSnapshot = $directChildrenSnapshot;
                    }

                    public void visitElement(IrElement element) {
                        Intrinsics.checkNotNullParameter(element, "element");
                        ((Collection)this.$directChildrenSnapshot).add(element);
                    }
                });
                for (IrElement child : directChildrenSnapshot) {
                    IrVisitorsKt.acceptChildrenVoid(child, this);
                }
            }
        });
    }

    private static final IrSymbol referencePublicSymbol(SymbolTable symbolTable, IdSignature idSig, BinarySymbolData.SymbolKind symbolKind) {
        IrSymbol irSymbol;
        SymbolTable $this$referencePublicSymbol_u24lambda_u240 = symbolTable;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[symbolKind.ordinal()]) {
            case 1: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceClass(idSig);
                break;
            }
            case 2: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceConstructor(idSig);
                break;
            }
            case 3: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceEnumEntry(idSig);
                break;
            }
            case 4: 
            case 5: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceField(idSig);
                break;
            }
            case 6: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceSimpleFunction(idSig);
                break;
            }
            case 7: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceTypeAlias(idSig);
                break;
            }
            case 8: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceProperty(idSig);
                break;
            }
            case 9: {
                irSymbol = $this$referencePublicSymbol_u24lambda_u240.referenceTypeParameter(idSig);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected classifier symbol kind: " + (Object)((Object)symbolKind) + " for signature " + idSig).toString());
            }
        }
        return irSymbol;
    }

    @NotNull
    public static final IrLinkerFakeOverrideProvider makeSimpleFakeOverrideBuilder(@NotNull SymbolTable symbolTable, @NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrSymbolDeserializer symbolDeserializer2) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        Intrinsics.checkNotNullParameter(symbolDeserializer2, "symbolDeserializer");
        FileLocalAwareLinker fileLocalAwareLinker = new FileLocalAwareLinker(symbolDeserializer2){
            final /* synthetic */ IrSymbolDeserializer $symbolDeserializer;
            {
                this.$symbolDeserializer = $symbolDeserializer;
            }

            public IrPropertySymbol tryReferencingPropertyByLocalSignature(org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, IdSignature idSignature) {
                Intrinsics.checkNotNullParameter(parent2, "parent");
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                return this.$symbolDeserializer.referencePropertyByLocalSignature(idSignature);
            }

            public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(org.jetbrains.kotlin.ir.declarations.IrDeclaration parent2, IdSignature idSignature) {
                Intrinsics.checkNotNullParameter(parent2, "parent");
                Intrinsics.checkNotNullParameter(idSignature, "idSignature");
                return this.$symbolDeserializer.referenceSimpleFunctionByLocalSignature(idSignature);
            }
        };
        JvmIrMangler jvmIrMangler = JvmIrMangler.INSTANCE;
        PrePopulatedDeclarationTable prePopulatedDeclarationTable = new PrePopulatedDeclarationTable(symbolDeserializer2.getDeserializedSymbolsWithOwnersInCurrentFile());
        Map map2 = MapsKt.emptyMap();
        PartialLinkageSupportForLinker partialLinkageSupportForLinker = PartialLinkageSupportForLinker.Companion.getDISABLED();
        return new IrLinkerFakeOverrideProvider(fileLocalAwareLinker, symbolTable, jvmIrMangler, typeSystemContext2, map2, partialLinkageSupportForLinker, null, prePopulatedDeclarationTable, null, 320, null);
    }

    private static final void buildFakeOverridesForLocalClasses(SymbolTable symbolTable, IrTypeSystemContext typeSystemContext2, IrSymbolDeserializer symbolDeserializer2, IrClass toplevel) {
        IrLinkerFakeOverrideProvider builder = DeserializeLazyDeclarationsKt.makeSimpleFakeOverrideBuilder(symbolTable, typeSystemContext2, symbolDeserializer2);
        IrVisitorsKt.acceptChildrenVoid((IrElement)toplevel, new IrVisitorVoid(builder){
            final /* synthetic */ IrLinkerFakeOverrideProvider $builder;
            {
                this.$builder = $builder;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                if (Intrinsics.areEqual(declaration.getVisibility(), DescriptorVisibilities.LOCAL)) {
                    this.$builder.provideFakeOverrides(declaration, CompatibilityMode.Companion.getCURRENT());
                }
                super.visitClass(declaration);
            }
        });
    }

    private static final Unit deserializeFromByteArray$lambda$0(IdSignature it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final IrSymbol deserializeFromByteArray$lambda$1(SymbolTable $symbolTable, IdSignature idSignature, BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        return DeserializeLazyDeclarationsKt.referencePublicSymbol($symbolTable, idSignature, symbolKind);
    }

    private static final Unit deserializeFromByteArray$lambda$2(IrClass irClass, IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(irClass, "<unused var>");
        Intrinsics.checkNotNullParameter(idSignature, "<unused var>");
        return Unit.INSTANCE;
    }

    private static final boolean deserializeFromByteArray$lambda$3(IrClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return false;
    }

    private static final Unit deserializeFromByteArray$lambda$4(SymbolTable $symbolTable, List $irProviders) {
        new ExternalDependenciesGenerator($symbolTable, $irProviders).generateUnboundSymbolsAsDependencies();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BinarySymbolData.SymbolKind.values().length];
            try {
                nArray[BinarySymbolData.SymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.CONSTRUCTOR_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.ENUM_ENTRY_SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.STANDALONE_FIELD_SYMBOL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.FIELD_SYMBOL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.FUNCTION_SYMBOL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.PROPERTY_SYMBOL.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BinarySymbolData.SymbolKind.TYPE_PARAMETER_SYMBOL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

