/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public final class FileAttributes {
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(1, 0L, 0L);
    private final byte flags;
    public final long length;
    public final long lastModified;

    /*
     * WARNING - void declaration
     */
    public FileAttributes(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, long length, long lastModified, boolean bl, @NotNull CaseSensitivity caseSensitivity) {
        void caseSensitivity2;
        void isWritable;
        if (caseSensitivity == null) {
            FileAttributes.$$$reportNull$$$0(0);
        }
        this(FileAttributes.flags(isDirectory, isSpecial, isSymlink, isHidden, (boolean)isWritable, (CaseSensitivity)caseSensitivity2), length, lastModified);
    }

    private FileAttributes(byte flags, long length, long lastModified) {
        if (flags != -1 && (flags & 0x80) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + Integer.toBinaryString(flags));
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        this.flags = flags;
        this.length = length;
        this.lastModified = lastModified;
    }

    private static byte flags(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, boolean isWritable, CaseSensitivity sensitivity) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (!isWritable) {
            flags = (byte)(flags | 4);
        }
        int type_flags = (isSpecial ? 3 : (isDirectory ? 2 : 1)) << 3;
        flags = (byte)(flags | type_flags);
        flags = FileAttributes.packSensitivityIntoFlags(isDirectory ? sensitivity : CaseSensitivity.UNKNOWN, flags);
        return flags;
    }

    private static byte packSensitivityIntoFlags(CaseSensitivity sensitivity, byte flags) {
        int sensitivity_flags = sensitivity == CaseSensitivity.UNKNOWN ? 0 : (sensitivity == CaseSensitivity.SENSITIVE ? 1 : 2);
        flags = (byte)(flags | sensitivity_flags << 5);
        return flags;
    }

    public boolean isDirectory() {
        return (this.flags >> 3 & 3) == 2;
    }

    @Nullable(value="`null` means an unknown type, typically a broken symlink")
    public @Nullable(value="`null` means an unknown type, typically a broken symlink") Type getType() {
        int type2 = this.flags >> 3 & 3;
        switch (type2) {
            case 0: {
                return null;
            }
            case 1: {
                return Type.FILE;
            }
            case 2: {
                return Type.DIRECTORY;
            }
            case 3: {
                return Type.SPECIAL;
            }
        }
        throw new IllegalStateException("Invalid type flags: " + Integer.toBinaryString(this.flags));
    }

    @NotNull
    public CaseSensitivity areChildrenCaseSensitive() {
        if (!this.isDirectory()) {
            CaseSensitivity caseSensitivity = CaseSensitivity.UNKNOWN;
            if (caseSensitivity == null) {
                FileAttributes.$$$reportNull$$$0(1);
            }
            return caseSensitivity;
        }
        int sensitivity_flags = this.flags >> 5 & 3;
        switch (sensitivity_flags) {
            case 0: {
                CaseSensitivity caseSensitivity = CaseSensitivity.UNKNOWN;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(2);
                }
                return caseSensitivity;
            }
            case 1: {
                CaseSensitivity caseSensitivity = CaseSensitivity.SENSITIVE;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(3);
                }
                return caseSensitivity;
            }
            case 2: {
                CaseSensitivity caseSensitivity = CaseSensitivity.INSENSITIVE;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(4);
                }
                return caseSensitivity;
            }
        }
        throw new IllegalStateException("Invalid sensitivity flags: " + Integer.toBinaryString(sensitivity_flags));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FileAttributes that = (FileAttributes)o2;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result2 = this.flags;
        result2 = 31 * result2 + Long.hashCode(this.length);
        result2 = 31 * result2 + Long.hashCode(this.lastModified);
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type:").append((Object)this.getType());
        if (BitUtil.isSet(this.flags, (byte)1)) {
            sb.append(" l");
        }
        if (BitUtil.isSet(this.flags, (byte)2)) {
            sb.append(" .");
        }
        if (BitUtil.isSet(this.flags, (byte)4)) {
            sb.append(" ro");
        }
        sb.append(" length:").append(this.length);
        sb.append(" modified:").append(this.lastModified);
        sb.append(" case-sensitive: ").append((Object)this.areChildrenCaseSensitive());
        sb.append(']');
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSensitivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileAttributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sensitivity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "areChildrenCaseSensitive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNio";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withCaseSensitivity";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromNio";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CaseSensitivity {
        SENSITIVE,
        INSENSITIVE,
        UNKNOWN;

    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }
}

