/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.AnnotationTargetUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirPropertyBodyResolveStateKt;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J=\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001bJ5\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001dJ5\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001dJK\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010&J\\\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0001(\u0000\u00a2\u0006\u0002\u0010,J7\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u00010\u0016H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u00100J-\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\u0012H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J-\u00103\u001a\u00020\n2\u0006\u00104\u001a\u000205H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u00106J-\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020+H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u00109J-\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020<H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u00020(*\u00020\u00162\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020C0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020+\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "deprecatedClassId", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;)V", "reportIfMfvc", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "hint", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Ljava/lang/String;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "checkMultiFieldValueClassAnnotationRestrictions", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "checkAnnotationTarget", "checkAnnotationUseSiteTarget", "annotated", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "applicableTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;Ljava/util/Set;)V", "checkPropertyGetter", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;)Z", "checkDeprecatedCalls", "deprecatedSinceKotlin", "deprecated", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "checkDeclaredRepeatedAnnotations", "annotationContainer", "checkAllRepeatedAnnotations", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkRepeatedAnnotationsInProperty", "property", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkPossibleMigrationToPropertyOrField", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "requiresMigrationToPropertyOrFieldWarning", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "JAVA_LANG_PACKAGE", "STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n+ 2 TypeExpansionUtils.kt\norg/jetbrains/kotlin/fir/resolve/TypeExpansionUtilsKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,488:1\n286#2:489\n287#2:510\n75#3,17:490\n94#3:509\n13805#4,2:507\n1761#5,3:511\n1761#5,3:514\n1563#5:517\n1634#5,3:518\n*S KotlinDebug\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n*L\n398#1:489\n398#1:510\n398#1:490,17\n398#1:509\n398#1:507,2\n166#1:511,3\n174#1:514,3\n406#1:517\n406#1:518,3\n*E\n"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");
    @NotNull
    private static final FqName JAVA_LANG_PACKAGE = new FqName("java.lang");
    @NotNull
    private static final Set<ClassId> STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION;

    private FirAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        block2: {
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (declaration instanceof FirDanglingModifierList) {
                return;
            }
            this.checkAnnotationContainer(context2, reporter, declaration);
            if (!(declaration instanceof FirCallableDeclaration)) break block2;
            FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it = firReceiverParameter;
                boolean bl = false;
                INSTANCE.checkAnnotationContainer(context2, reporter, it);
            }
        }
    }

    private final void checkAnnotationContainer(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer declaration) {
        FirReceiverParameter receiverParameter;
        FirAnnotation deprecated = null;
        FirAnnotation deprecatedSinceKotlin = null;
        for (FirAnnotation annotation : declaration.getAnnotations()) {
            FqName fqName2;
            if (CallableIdUtilsKt.fqName(annotation, context2.getSession()) == null) continue;
            if (Intrinsics.areEqual(fqName2, deprecatedClassId)) {
                deprecated = annotation;
            } else if (Intrinsics.areEqual(fqName2, deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlin = annotation;
            }
            this.checkAnnotationTarget(context2, reporter, declaration, annotation);
        }
        if (declaration instanceof FirCallableDeclaration && (receiverParameter = ((FirCallableDeclaration)declaration).getReceiverParameter()) != null) {
            for (FirAnnotation receiverAnnotation : receiverParameter.getAnnotations()) {
                this.reportIfMfvc(context2, reporter, receiverAnnotation, "receivers", FirTypeUtilsKt.getConeType(receiverParameter.getTypeRef()));
            }
        }
        if (deprecatedSinceKotlin != null) {
            this.checkDeprecatedCalls(context2, reporter, deprecatedSinceKotlin, deprecated);
        }
        this.checkDeclaredRepeatedAnnotations(context2, reporter, declaration);
        if (declaration instanceof FirCallableDeclaration) {
            if (declaration instanceof FirProperty) {
                this.checkRepeatedAnnotationsInProperty(context2, reporter, (FirProperty)declaration);
            }
            if (declaration instanceof FirValueParameter) {
                this.checkPossibleMigrationToPropertyOrField(context2, reporter, (FirValueParameter)declaration);
            }
            KtSourceElement ktSourceElement = ((FirCallableDeclaration)declaration).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
                KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)declaration).getReturnTypeRef().getSource();
                if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtRealSourceElementKind) {
                    this.checkAllRepeatedAnnotations(context2, reporter, ((FirCallableDeclaration)declaration).getReturnTypeRef());
                }
            }
        } else if (declaration instanceof FirTypeAlias) {
            this.checkAllRepeatedAnnotations(context2, reporter, ((FirTypeAlias)declaration).getExpandedTypeRef());
        }
    }

    private final void reportIfMfvc(CheckerContext context2, DiagnosticReporter reporter, FirAnnotation annotation, String hint, ConeKotlinType type2) {
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(type2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET(), (Object)hint, null, 16, null);
        }
    }

    private final void checkMultiFieldValueClassAnnotationRestrictions(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer declaration, FirAnnotation annotation) {
        Pair<String, Object> pair;
        AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
        switch (annotationUseSiteTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget.ordinal()]) {
            case 1: {
                Object object = declaration instanceof FirBackingField ? (FirBackingField)declaration : null;
                if (object == null || (object = ((FirBackingField)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    return;
                }
                pair = TuplesKt.to("fields", object);
                break;
            }
            case 2: {
                Object object = declaration instanceof FirBackingField ? (FirBackingField)declaration : null;
                if (object == null || (object = ((FirBackingField)object).getPropertySymbol()) == null || (object = ((FirPropertySymbol)object).getDelegate()) == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                    return;
                }
                pair = TuplesKt.to("delegate fields", object);
                break;
            }
            case 3: {
                Object object = declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null;
                if (object == null || (object = ((FirCallableDeclaration)object).getReceiverParameter()) == null || (object = ((FirReceiverParameter)object).getTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    return;
                }
                pair = TuplesKt.to("receivers", object);
                break;
            }
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (declaration instanceof FirProperty && !FirPropertyBodyResolveStateKt.isLocal((FirProperty)declaration)) {
                    Set<KotlinTarget> allowedAnnotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession());
                    if (Intrinsics.areEqual(DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration), true) && allowedAnnotationTargets.contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.PROPERTY)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.FIELD)) {
                        pair = TuplesKt.to("fields", FirTypeUtilsKt.getConeType(((FirProperty)declaration).getReturnTypeRef()));
                        break;
                    }
                    return;
                }
                if (declaration instanceof FirField) {
                    pair = TuplesKt.to("fields", FirTypeUtilsKt.getConeType(((FirField)declaration).getReturnTypeRef()));
                    break;
                }
                if (declaration instanceof FirValueParameter) {
                    pair = TuplesKt.to("parameters", FirTypeUtilsKt.getConeType(((FirValueParameter)declaration).getReturnTypeRef()));
                    break;
                }
                if (declaration instanceof FirVariable) {
                    pair = TuplesKt.to("variables", FirTypeUtilsKt.getConeType(((FirVariable)declaration).getReturnTypeRef()));
                    break;
                }
                if (declaration instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration).isGetter() && FirAnnotationChecker.checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers((FirPropertyAccessor)declaration)) {
                    pair = TuplesKt.to("getters", FirTypeUtilsKt.getConeType(((FirPropertyAccessor)declaration).getReturnTypeRef()));
                    break;
                }
                return;
            }
            case 10: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair<String, Object> pair2 = pair;
        String hint = pair2.component1();
        ConeKotlinType type2 = (ConeKotlinType)pair2.component2();
        this.reportIfMfvc(context2, reporter, annotation, hint, type2);
    }

    private final void checkAnnotationTarget(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer declaration, FirAnnotation annotation) {
        Object targetDescription;
        AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession());
        AnnotationUseSiteTarget useSiteTarget = annotation.getUseSiteTarget();
        if (useSiteTarget != null) {
            this.checkAnnotationUseSiteTarget(context2, reporter, declaration, annotation, useSiteTarget, applicableTargets);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget, actualTargets, applicableTargets)) {
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ValueClasses)) {
                this.checkMultiFieldValueClassAnnotationRestrictions(context2, reporter, declaration, annotation);
            }
            return;
        }
        Object object = kotlin.collections.CollectionsKt.firstOrNull(actualTargets.getDefaultTargets());
        if (object == null || (object = object.getDescription()) == null) {
            object = targetDescription = "unidentified target";
        }
        if (declaration instanceof FirBackingField && actualTargets == AnnotationTargetLists.INSTANCE.getT_MEMBER_PROPERTY_IN_ANNOTATION() && !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ForbidFieldAnnotationsOnAnnotationParameters)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WARNING(), targetDescription, applicableTargets, null, 32, null);
        } else if (useSiteTarget != null) {
            if (useSiteTarget != AnnotationUseSiteTarget.ALL) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, (Object)useSiteTarget.getRenderName(), applicableTargets, null, 64, null);
            }
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, applicableTargets, null, 32, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, Set<? extends KotlinTarget> applicableTargets) {
        KtSourceElement ktSourceElement = annotation.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 5: 
            case 6: {
                KtDiagnosticFactory1<String> ktDiagnosticFactory1;
                boolean bl = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                if (bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY();
                } else if (!bl) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY_WARNING();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.checkPropertyGetter(context2, reporter, annotated, annotation, target, ktDiagnosticFactory1);
                break;
            }
            case 1: {
                FirPropertySymbol propertySymbol;
                if (!(annotated instanceof FirBackingField) || (propertySymbol = ((FirBackingField)annotated).getPropertySymbol()).getDelegateFieldSymbol() == null || DeclarationAttributesKt.getHasBackingField(propertySymbol)) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), null, 8, null);
                break;
            }
            case 2: {
                if (!(annotated instanceof FirBackingField) || ((FirBackingField)annotated).getPropertySymbol().getDelegateFieldSymbol() != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), null, 8, null);
                break;
            }
            case 7: 
            case 9: {
                if (this.checkPropertyGetter(context2, reporter, annotated, annotation, target, FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY()) || ((FirProperty)annotated).isVar()) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), (Object)target.getRenderName(), null, 16, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirValueParameter) {
                    FirBasedSymbol<?> container = kotlin.collections.CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                    if (FirHelpersKt.isPrimaryConstructor(container)) {
                        KtSourceElement ktSourceElement2 = ((FirValueParameter)annotated).getSource();
                        if (ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement2) : false) break;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), (Object)target.getRenderName(), null, 16, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), null, 8, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), null, 8, null);
                break;
            }
            case 4: {
                if (annotated instanceof FirFile) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), null, 8, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"declaration", (Object)target.getRenderName(), applicableTargets, null, 64, null);
                break;
            }
            case 10: {
                if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AnnotationAllUseSiteTarget)) {
                    FirAnnotationContainer firAnnotationContainer = annotated;
                    if (firAnnotationContainer instanceof FirValueParameter) {
                        if (ClassMembersKt.getCorrespondingProperty((FirValueParameter)annotated) != null) break;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), null, 8, null);
                        break;
                    }
                    if (firAnnotationContainer instanceof FirProperty) {
                        if (FirPropertyBodyResolveStateKt.isLocal((FirProperty)annotated)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), null, 8, null);
                            break;
                        }
                        if (((FirProperty)annotated).getDelegate() != null) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), null, 8, null);
                            break;
                        }
                        if (applicableTargets.contains((Object)KotlinTarget.PROPERTY)) break;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"property", (Object)target.getRenderName(), applicableTargets, null, 64, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), null, 8, null);
                    break;
                }
                if (annotated instanceof FirValueParameter && ClassMembersKt.getCorrespondingProperty((FirValueParameter)annotated) != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), TuplesKt.to(LanguageFeature.AnnotationAllUseSiteTarget, context2.getLanguageVersionSettings()), null, 16, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean checkPropertyGetter(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, KtDiagnosticFactory1<String> diagnostic) {
        boolean isReport;
        boolean bl = isReport = !(annotated instanceof FirProperty) || FirPropertyBodyResolveStateKt.isLocal((FirProperty)annotated);
        if (isReport) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), diagnostic, (Object)target.getRenderName(), null, 16, null);
        }
        return isReport;
    }

    private final void checkDeprecatedCalls(CheckerContext context2, DiagnosticReporter reporter, FirAnnotation deprecatedSinceKotlin, FirAnnotation deprecated) {
        FirFileSymbol closestFirFile = context2.getContainingFileSymbol();
        if (closestFirFile != null && !UtilsKt.getPackageFqName(closestFirFile).startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), null, 8, null);
        }
        if (deprecated == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), null, 8, null);
        } else {
            Map<Name, FirExpression> argumentMapping2 = deprecated.getArgumentMapping().getMapping();
            for (Name name2 : argumentMapping2.keySet()) {
                if (!Intrinsics.areEqual(name2.getIdentifier(), "level")) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), null, 8, null);
                break;
            }
        }
    }

    private final void checkDeclaredRepeatedAnnotations(CheckerContext context2, DiagnosticReporter reporter, FirAnnotationContainer annotationContainer) {
        Map<FirAnnotation, KtSourceElement> annotationSources = CollectionsKt.keysToMap((Iterable)annotationContainer.getAnnotations(), FirAnnotationChecker::checkDeclaredRepeatedAnnotations$lambda$0);
        FirAnnotationHelpersKt.checkRepeatedAnnotation(context2, reporter, annotationContainer, annotationContainer.getAnnotations(), annotationSources, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAllRepeatedAnnotations(CheckerContext context2, DiagnosticReporter reporter, FirTypeRef typeRef) {
        void $this$forEachExpandedType$iv;
        Map<FirAnnotation, KtSourceElement> annotationSources = CollectionsKt.keysToMap((Iterable)typeRef.getAnnotations(), FirAnnotationChecker::checkAllRepeatedAnnotations$lambda$0);
        KtSourceElement useSiteSource = typeRef.getSource();
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(typeRef);
        FirSession session$iv = context2.getSession();
        boolean $i$f$forEachExpandedType = false;
        void $this$forEachType$iv$iv = $this$forEachExpandedType$iv;
        boolean $i$f$forEachType = false;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{$this$forEachType$iv$iv};
        List<ConeKotlinType> stack$iv$iv = kotlin.collections.CollectionsKt.mutableListOf(coneKotlinTypeArray);
        while (!((Collection)stack$iv$iv).isEmpty()) {
            ConeKotlinType next$iv$iv;
            ConeKotlinType it$iv = AddToStdlibKt.popLast(stack$iv$iv);
            boolean bl = false;
            ConeKotlinType type2 = next$iv$iv = TypeExpansionUtilsKt.fullyExpandedType$default(it$iv, session$iv, null, 2, null);
            boolean bl2 = false;
            FirAnnotationHelpersKt.checkRepeatedAnnotation(context2, reporter, null, CustomAnnotationTypeAttributeKt.getTypeAnnotations(type2), annotationSources, useSiteSource);
            ConeKotlinType coneKotlinType2 = next$iv$iv;
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getLowerBound());
                if (((ConeFlexibleType)next$iv$iv).isTrivial()) continue;
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getUpperBound());
                continue;
            }
            if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                stack$iv$iv.add(((ConeDefinitelyNotNullType)next$iv$iv).getOriginal());
                continue;
            }
            if (coneKotlinType2 instanceof ConeIntersectionType) {
                stack$iv$iv.addAll(((ConeIntersectionType)next$iv$iv).getIntersectedTypes());
                continue;
            }
            ConeTypeProjection[] $this$forEach$iv$iv$iv = next$iv$iv.getTypeArguments();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConeTypeProjection element$iv$iv$iv;
                ConeTypeProjection it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i2];
                boolean bl3 = false;
                if (!(it$iv$iv instanceof ConeKotlinTypeProjection)) continue;
                stack$iv$iv.add(((ConeKotlinTypeProjection)it$iv$iv).getType());
            }
        }
    }

    private final void checkRepeatedAnnotationsInProperty(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        Pair[] pairArray = new Pair[3];
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to(AnnotationUseSiteTarget.PROPERTY_GETTER, firPropertyAccessor != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor) : null);
        FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
        pairArray[1] = TuplesKt.to(AnnotationUseSiteTarget.PROPERTY_SETTER, firPropertyAccessor2 != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor2) : null);
        Object object = property2.getSetter();
        pairArray[2] = TuplesKt.to(AnnotationUseSiteTarget.SETTER_PARAMETER, FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null ? (FirValueParameter)kotlin.collections.CollectionsKt.single(object) : null));
        Map propertyAnnotations = MapsKt.mapOf(pairArray);
        for (FirAnnotation annotation : property2.getAnnotations()) {
            List existingAnnotations;
            AnnotationUseSiteTarget useSiteTarget;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(context2, property2, annotation);
            }
            if ((List)propertyAnnotations.get((Object)(useSiteTarget = annotationUseSiteTarget)) == null || !existingAnnotations.contains(FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef())) || FirAnnotationHelpersKt.isRepeatable(annotation, context2.getSession())) continue;
            KtSourceElement ktSourceElement = annotation.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getREPEATED_ANNOTATION(), null, 8, null);
        }
    }

    private final void checkPossibleMigrationToPropertyOrField(CheckerContext context2, DiagnosticReporter reporter, FirValueParameter parameter) {
        FirSession session = context2.getSession();
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AnnotationDefaultTargetMigrationWarning) || LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.PropertyParamAnnotationDefaultTargetMode)) {
            return;
        }
        FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter);
        if (firProperty == null) {
            return;
        }
        FirProperty correspondingProperty = firProperty;
        for (FirAnnotation annotation : parameter.getAnnotations()) {
            FirClassSymbol containingClass;
            if (annotation.getUseSiteTarget() != null || !this.requiresMigrationToPropertyOrFieldWarning(annotation, session)) continue;
            Set<AnnotationUseSiteTarget> allowedTargets = AnnotationTargetUtilsKt.useSiteTargetsFromMetaAnnotation(annotation, session);
            boolean propertyAllowed = allowedTargets.contains((Object)AnnotationUseSiteTarget.PROPERTY);
            boolean fieldAllowed = allowedTargets.contains((Object)AnnotationUseSiteTarget.FIELD);
            if (!propertyAllowed && !fieldAllowed) continue;
            if (propertyAllowed) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_WILL_BE_APPLIED_ALSO_TO_PROPERTY_OR_FIELD(), (Object)AnnotationUseSiteTarget.PROPERTY.getRenderName(), null, 16, null);
                continue;
            }
            if (correspondingProperty.getBackingField() == null) continue;
            FirBasedSymbol<?> firBasedSymbol = kotlin.collections.CollectionsKt.getOrNull(context2.getContainingDeclarations(), context2.getContainingDeclarations().size() - 2);
            FirClassSymbol firClassSymbol = containingClass = firBasedSymbol instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol : null;
            if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_WILL_BE_APPLIED_ALSO_TO_PROPERTY_OR_FIELD(), (Object)AnnotationUseSiteTarget.FIELD.getRenderName(), null, 16, null);
        }
    }

    private final boolean requiresMigrationToPropertyOrFieldWarning(FirAnnotation $this$requiresMigrationToPropertyOrFieldWarning, FirSession session) {
        ClassId classId;
        FirClassLikeSymbol<?> symbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = symbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol($this$requiresMigrationToPropertyOrFieldWarning, session);
        ClassId classId2 = classId = firClassLikeSymbol != null ? firClassLikeSymbol.getClassId() : null;
        if (kotlin.collections.CollectionsKt.contains((Iterable)STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION, classId)) {
            return false;
        }
        FirOptInUsageBaseChecker $this$requiresMigrationToPropertyOrFieldWarning_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = symbol;
        return !(firClassLikeSymbol2 != null ? $this$requiresMigrationToPropertyOrFieldWarning_u24lambda_u240.isExperimentalMarker(firClassLikeSymbol2, session) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers(FirPropertyAccessor $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers) {
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getContextParameters().isEmpty()) return false;
        FirReceiverParameter firReceiverParameter = $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getReceiverParameter();
        if ((firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null) != null) return false;
        if (FirDeclarationUtilKt.isExtension($this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol())) return false;
        if (FirCallableSymbolKt.getHasContextParameters($this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol())) return false;
        return true;
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget, List<? extends KotlinTarget> targets) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget) == it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl;
        block4: {
            if (useSiteTarget == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final KtSourceElement checkDeclaredRepeatedAnnotations$lambda$0(FirAnnotation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getSource();
    }

    private static final KtSourceElement checkAllRepeatedAnnotations$lambda$0(FirAnnotation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getSource();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> checkRepeatedAnnotationsInProperty$getAnnotationTypes(FirAnnotationContainer $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes) {
        List list;
        Object object = $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes;
        if (object != null && (object = object.getAnnotations()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    static {
        ClassId[] classIdArray = new ClassId[6];
        classIdArray[0] = OptInNames.INSTANCE.getOPT_IN_CLASS_ID();
        classIdArray[1] = StandardClassIds.Annotations.INSTANCE.getDeprecated();
        classIdArray[2] = StandardClassIds.Annotations.INSTANCE.getDeprecatedSinceKotlin();
        classIdArray[3] = StandardClassIds.Annotations.INSTANCE.getSuppress();
        Name name2 = Name.identifier("Deprecated");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        classIdArray[4] = new ClassId(JAVA_LANG_PACKAGE, name2);
        Name name3 = Name.identifier("SuppressWarnings");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        classIdArray[5] = new ClassId(JAVA_LANG_PACKAGE, name3);
        STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION = SetsKt.hashSetOf(classIdArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.ALL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

