/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression.FirJavaValueBasedClassUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "synchronizedCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "lockParameterName", "Lorg/jetbrains/kotlin/name/Name;", "operationsToCheckFirstArgCallableIds", "", "operationsToCheckFirstTypeArgCallableIds", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkSynchronizedCall", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,99:1\n56#2:100\n58#2:101\n70#2,4:102\n*S KotlinDebug\n*F\n+ 1 FirJvmIdentitySensitiveCallWithValueTypeObjectChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmIdentitySensitiveCallWithValueTypeObjectChecker\n*L\n58#1:100\n61#1:101\n82#1:102,4\n*E\n"})
public final class FirJvmIdentitySensitiveCallWithValueTypeObjectChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmIdentitySensitiveCallWithValueTypeObjectChecker INSTANCE = new FirJvmIdentitySensitiveCallWithValueTypeObjectChecker();
    @NotNull
    private static final CallableId synchronizedCallableId;
    @NotNull
    private static final Name lockParameterName;
    @NotNull
    private static final Set<CallableId> operationsToCheckFirstArgCallableIds;
    @NotNull
    private static final Set<CallableId> operationsToCheckFirstTypeArgCallableIds;

    private FirJvmIdentitySensitiveCallWithValueTypeObjectChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol function2 = firCallableSymbol;
        CallableId callableId = function2.getCallableId();
        if (Intrinsics.areEqual(callableId, synchronizedCallableId)) {
            this.checkSynchronizedCall(context2, reporter, expression2);
        } else if (CollectionsKt.contains((Iterable)operationsToCheckFirstArgCallableIds, callableId)) {
            FirCall $this$arguments$iv = expression2;
            boolean $i$f$getArguments = false;
            Object object = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                return;
            }
            Object type2 = object;
            if (FirJavaValueBasedClassUtilsKt.isValueTypeAndWarningsEnabled((ConeKotlinType)type2, context2.getSession())) {
                FirCall $this$argument$iv = expression2;
                boolean $i$f$getArgument = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()).getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), type2, null, 16, null);
            }
        } else if (CollectionsKt.contains((Iterable)operationsToCheckFirstTypeArgCallableIds, callableId)) {
            FirTypeProjection firTypeProjection = CollectionsKt.firstOrNull(expression2.getTypeArguments());
            FirTypeProjectionWithVariance firTypeProjectionWithVariance = firTypeProjection instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)firTypeProjection : null;
            if (firTypeProjectionWithVariance == null) {
                return;
            }
            FirTypeProjectionWithVariance typeArgument = firTypeProjectionWithVariance;
            ConeRigidType type3 = ConeTypeUtilsKt.upperBoundIfFlexible(FirTypeUtilsKt.getConeType(typeArgument.getTypeRef()));
            if (FirJavaValueBasedClassUtilsKt.isValueTypeAndWarningsEnabled(type3, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)typeArgument.getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), (Object)type3, null, 16, null);
            }
        }
    }

    private final void checkSynchronizedCall(CheckerContext context2, DiagnosticReporter reporter, FirFunctionCall expression2) {
        FirCall $this$resolvedArgumentMapping$iv = expression2;
        boolean $i$f$getResolvedArgumentMapping = false;
        FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
        Object object = linkedHashMap;
        if (linkedHashMap == null || (object = ((LinkedHashMap)object).entrySet()) == null) {
            return;
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            FirExpression argument = (FirExpression)entry.getKey();
            FirValueParameter parameter = (FirValueParameter)entry.getValue();
            if (!Intrinsics.areEqual(parameter.getName(), lockParameterName)) continue;
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(argument);
            if (ConeBuiltinTypeUtilsKt.isPrimitive(type2) || FirHelpersKt.isValueClass(type2, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_BLOCK_ON_VALUE_CLASS_OR_PRIMITIVE(), (Object)type2, null, 16, null);
            }
            if (FirJavaValueBasedClassUtilsKt.isJavaValueBasedClassAndWarningsEnabled(type2, context2.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getSYNCHRONIZED_BLOCK_ON_JAVA_VALUE_BASED_CLASS(), (Object)type2, null, 16, null);
            }
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DisableWarningsForIdentitySensitiveOperationsOnValueClassesAndPrimitives) || !FirJavaValueBasedClassUtilsKt.isFlexiblePrimitive(type2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)argument.getSource(), FirJvmErrors.INSTANCE.getIDENTITY_SENSITIVE_OPERATIONS_WITH_VALUE_TYPE(), (Object)type2, null, 16, null);
        }
    }

    static {
        FqName fqName2 = new FqName("kotlin");
        Name name2 = Name.identifier("synchronized");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        synchronizedCallableId = new CallableId(fqName2, name2);
        Name name3 = Name.identifier("lock");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        lockParameterName = name3;
        CallableId[] callableIdArray = new CallableId[5];
        FqName fqName3 = new FqName("java.lang");
        FqName fqName4 = new FqName("System");
        Name name4 = Name.identifier("identityHashCode");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        callableIdArray[0] = new CallableId(fqName3, fqName4, name4);
        FqName fqName5 = new FqName("java.lang.ref");
        FqName fqName6 = new FqName("Cleaner");
        Name name5 = Name.identifier("register");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        callableIdArray[1] = new CallableId(fqName5, fqName6, name5);
        FqName fqName7 = new FqName("java.lang.ref");
        FqName fqName8 = new FqName("PhantomReference");
        Name name6 = Name.identifier("PhantomReference");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        callableIdArray[2] = new CallableId(fqName7, fqName8, name6);
        FqName fqName9 = new FqName("java.lang.ref");
        FqName fqName10 = new FqName("SoftReference");
        Name name7 = Name.identifier("SoftReference");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
        callableIdArray[3] = new CallableId(fqName9, fqName10, name7);
        FqName fqName11 = new FqName("java.lang.ref");
        FqName fqName12 = new FqName("WeakReference");
        Name name8 = Name.identifier("WeakReference");
        Intrinsics.checkNotNullExpressionValue(name8, "identifier(...)");
        callableIdArray[4] = new CallableId(fqName11, fqName12, name8);
        operationsToCheckFirstArgCallableIds = SetsKt.setOf(callableIdArray);
        callableIdArray = new CallableId[2];
        FqName fqName13 = new FqName("java.util");
        FqName fqName14 = new FqName("IdentityHashMap");
        Name name9 = Name.identifier("IdentityHashMap");
        Intrinsics.checkNotNullExpressionValue(name9, "identifier(...)");
        callableIdArray[0] = new CallableId(fqName13, fqName14, name9);
        FqName fqName15 = new FqName("java.util");
        FqName fqName16 = new FqName("WeakHashMap");
        Name name10 = Name.identifier("WeakHashMap");
        Intrinsics.checkNotNullExpressionValue(name10, "identifier(...)");
        callableIdArray[1] = new CallableId(fqName15, fqName16, name10);
        operationsToCheckFirstTypeArgCallableIds = SetsKt.setOf(callableIdArray);
    }
}

