/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0011j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "", "sourceRoots", "", "Ljava/io/File;", "outputDir", "includeUnavailableSourcesIntoSourceMap", "", "<init>", "(Ljava/util/List;Ljava/io/File;Z)V", "", "outputDirPathResolver", "Lorg/jetbrains/kotlin/js/sourceMap/RelativePathCalculator;", "cache", "", "", "filesInDirExistCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getPathRelativeToSourceRoots", "file", "getPathRelativeToSourceRootsIfExists", "calculatePathRelativeToSourceRoots", "calculatePathRelativeToOutput", "Companion", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,81:1\n1634#2,3:82\n1#3:85\n382#4,7:86\n233#5:93\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver\n*L\n16#1:82,3\n36#1:86,7\n37#1:93\n*E\n"})
public final class SourceFilePathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean includeUnavailableSourcesIntoSourceMap;
    @NotNull
    private final Set<File> sourceRoots;
    @Nullable
    private final RelativePathCalculator outputDirPathResolver;
    @NotNull
    private final Map<File, String> cache;
    @NotNull
    private final HashMap<File, Boolean> filesInDirExistCache;

    /*
     * WARNING - void declaration
     */
    public SourceFilePathResolver(@NotNull List<? extends File> sourceRoots, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
        RelativePathCalculator relativePathCalculator;
        File destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        this.includeUnavailableSourcesIntoSourceMap = includeUnavailableSourcesIntoSourceMap;
        Iterable iterable = sourceRoots;
        Collection collection = new LinkedHashSet();
        SourceFilePathResolver sourceFilePathResolver = this;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file = (File)item$iv;
            void var12_12 = destination$iv;
            boolean bl = false;
            var12_12.add(it.getAbsoluteFile());
        }
        sourceFilePathResolver.sourceRoots = (Set)((Object)destination$iv);
        SourceFilePathResolver sourceFilePathResolver2 = this;
        File file = outputDir;
        if (file != null) {
            void p0;
            destination$iv = file;
            sourceFilePathResolver = sourceFilePathResolver2;
            boolean bl = false;
            relativePathCalculator = new RelativePathCalculator((File)p0);
            sourceFilePathResolver2 = sourceFilePathResolver;
        } else {
            relativePathCalculator = null;
        }
        sourceFilePathResolver2.outputDirPathResolver = relativePathCalculator;
        this.cache = new LinkedHashMap();
        this.filesInDirExistCache = new HashMap();
    }

    public /* synthetic */ SourceFilePathResolver(List list, File file, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            file = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(list, file, bl);
    }

    @NotNull
    public final String getPathRelativeToSourceRoots(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        String path = this.cache.get(file);
        if (path == null) {
            path = this.calculatePathRelativeToSourceRoots(file);
            this.cache.put(file, path);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getPathRelativeToSourceRootsIfExists(@NotNull File file) throws IOException {
        boolean moduleSourcesShouldBeAdded;
        Intrinsics.checkNotNullParameter(file, "file");
        if (!this.includeUnavailableSourcesIntoSourceMap) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = this.filesInDirExistCache;
            File file2 = file.getParentFile();
            if (file2 == null) {
                file2 = file;
            }
            File key$iv = file2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Boolean answer$iv = file.exists();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if ((Boolean)object == false) return null;
        }
        boolean bl = true;
        boolean condition$iv = moduleSourcesShouldBeAdded = bl;
        boolean $i$f$runIf = false;
        if (!condition$iv) return null;
        boolean bl2 = false;
        String string = this.getPathRelativeToSourceRoots(file);
        return string;
    }

    private final String calculatePathRelativeToSourceRoots(File file) throws IOException {
        String pathRelativeToOutput;
        String string = pathRelativeToOutput = this.calculatePathRelativeToOutput(file);
        if (string != null) {
            return string;
        }
        List parts = new ArrayList();
        Intrinsics.checkNotNullExpressionValue(file.getAbsoluteFile(), "getAbsoluteFile(...)");
        for (File currentFile = FilesKt.normalize(v3882666); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts.isEmpty()) break;
                CollectionsKt.reverse(parts);
                Iterable iterable = parts;
                String string2 = File.separator;
                Intrinsics.checkNotNullExpressionValue(string2, "separator");
                return CollectionsKt.joinToString$default(iterable, string2, null, null, 0, null, null, 62, null);
            }
            String string3 = currentFile.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            parts.add(string3);
        }
        String string4 = file.getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        return string4;
    }

    private final String calculatePathRelativeToOutput(File file) {
        RelativePathCalculator relativePathCalculator = this.outputDirPathResolver;
        return relativePathCalculator != null ? relativePathCalculator.calculateRelativePathTo(file) : null;
    }

    @JvmStatic
    @NotNull
    public static final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
        return Companion.create(sourceRoots, sourceMapPrefix, outputDir, includeUnavailableSourcesIntoSourceMap);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver;", "sourceRoots", "", "", "sourceMapPrefix", "outputDir", "Ljava/io/File;", "includeUnavailableSourcesIntoSourceMap", "", "js.sourcemap"})
    @SourceDebugExtension(value={"SMAP\nSourceFilePathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1563#2:82\n1634#2,3:83\n1#3:86\n*S KotlinDebug\n*F\n+ 1 SourceFilePathResolver.kt\norg/jetbrains/kotlin/js/sourceMap/SourceFilePathResolver$Companion\n*L\n74#1:82\n74#1:83,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SourceFilePathResolver create(@NotNull List<String> sourceRoots, @NotNull String sourceMapPrefix, @Nullable File outputDir, boolean includeUnavailableSourcesIntoSourceMap) {
            File file;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
            Intrinsics.checkNotNullParameter(sourceMapPrefix, "sourceMapPrefix");
            boolean generateRelativePathsInSourceMap = ((CharSequence)sourceMapPrefix).length() == 0 && sourceRoots.isEmpty();
            Iterable $this$map$iv = sourceRoots;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            File $i$f$map22 = file = outputDir;
            collection = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = generateRelativePathsInSourceMap;
            File file2 = bl2 ? file : null;
            boolean bl3 = includeUnavailableSourcesIntoSourceMap;
            File file3 = file2;
            Collection collection2 = collection;
            return new SourceFilePathResolver((List<? extends File>)collection2, file3, bl3);
        }

        public static /* synthetic */ SourceFilePathResolver create$default(Companion companion, List list, String string, File file, boolean bl, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return companion.create(list, string, file, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

