/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.org.objectweb.asm;

import shadow.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import shadow.org.jetbrains.org.objectweb.asm.Attribute;
import shadow.org.jetbrains.org.objectweb.asm.Constants;
import shadow.org.jetbrains.org.objectweb.asm.TypePath;

public abstract class RecordComponentVisitor {
    protected final int api;
    protected RecordComponentVisitor delegate;

    protected RecordComponentVisitor(int api) {
        this(api, null);
    }

    protected RecordComponentVisitor(int api, RecordComponentVisitor recordComponentVisitor) {
        if (api != 589824 && api != 524288 && api != 458752 && api != 393216 && api != 327680 && api != 262144 && api != 0x10A0000) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == 0x10A0000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = api;
        this.delegate = recordComponentVisitor;
    }

    public RecordComponentVisitor getDelegate() {
        return this.delegate;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        if (this.delegate != null) {
            return this.delegate.visitAnnotation(descriptor2, visible);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        if (this.delegate != null) {
            return this.delegate.visitTypeAnnotation(typeRef, typePath, descriptor2, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.delegate != null) {
            this.delegate.visitAttribute(attribute);
        }
    }

    public void visitEnd() {
        if (this.delegate != null) {
            this.delegate.visitEnd();
        }
    }
}

