/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.org.objectweb.asm;

import shadow.org.jetbrains.org.objectweb.asm.ByteVector;

public class TypeReference {
    private final int targetTypeAndInfo;

    public TypeReference(int typeRef) {
        this.targetTypeAndInfo = typeRef;
    }

    public static TypeReference newTypeReference(int sort) {
        return new TypeReference(sort << 24);
    }

    public static TypeReference newTypeParameterReference(int sort, int paramIndex) {
        return new TypeReference(sort << 24 | paramIndex << 16);
    }

    public static TypeReference newTypeParameterBoundReference(int sort, int paramIndex, int boundIndex) {
        return new TypeReference(sort << 24 | paramIndex << 16 | boundIndex << 8);
    }

    public static TypeReference newSuperTypeReference(int itfIndex) {
        return new TypeReference(0x10000000 | (itfIndex & 0xFFFF) << 8);
    }

    public static TypeReference newFormalParameterReference(int paramIndex) {
        return new TypeReference(0x16000000 | paramIndex << 16);
    }

    public int getSort() {
        return this.targetTypeAndInfo >>> 24;
    }

    public int getTypeParameterIndex() {
        return (this.targetTypeAndInfo & 0xFF0000) >> 16;
    }

    public int getTypeParameterBoundIndex() {
        return (this.targetTypeAndInfo & 0xFF00) >> 8;
    }

    public int getSuperTypeIndex() {
        return (short)((this.targetTypeAndInfo & 0xFFFF00) >> 8);
    }

    public int getFormalParameterIndex() {
        return (this.targetTypeAndInfo & 0xFF0000) >> 16;
    }

    public int getExceptionIndex() {
        return (this.targetTypeAndInfo & 0xFFFF00) >> 8;
    }

    public int getTryCatchBlockIndex() {
        return (this.targetTypeAndInfo & 0xFFFF00) >> 8;
    }

    public int getTypeArgumentIndex() {
        return this.targetTypeAndInfo & 0xFF;
    }

    public int getValue() {
        return this.targetTypeAndInfo;
    }

    static void putTarget(int targetTypeAndInfo, ByteVector output2) {
        switch (targetTypeAndInfo >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                output2.putShort(targetTypeAndInfo >>> 16);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                output2.putByte(targetTypeAndInfo >>> 24);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                output2.putInt(targetTypeAndInfo);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                output2.put12(targetTypeAndInfo >>> 24, (targetTypeAndInfo & 0xFFFF00) >> 8);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

