exports.__esModule = true;
var ATTRIBUTE_NAMES = exports.ATTRIBUTE_NAMES = {
    BODY: "bodyAttributes",
    HTML: "htmlAttributes",
    TITLE: "titleAttributes"
};

var TAG_NAMES = exports.TAG_NAMES = {
    BASE: "base",
    BODY: "body",
    HEAD: "head",
    HTML: "html",
    LINK: "link",
    META: "meta",
    NOSCRIPT: "noscript",
    SCRIPT: "script",
    STYLE: "style",
    TITLE: "title"
};

var VALID_TAG_NAMES = exports.VALID_TAG_NAMES = Object.keys(TAG_NAMES).map(function (name) {
    return TAG_NAMES[name];
});

var TAG_PROPERTIES = exports.TAG_PROPERTIES = {
    CHARSET: "charset",
    CSS_TEXT: "cssText",
    HREF: "href",
    HTTPEQUIV: "http-equiv",
    INNER_HTML: "innerHTML",
    ITEM_PROP: "itemprop",
    NAME: "name",
    PROPERTY: "property",
    REL: "rel",
    SRC: "src"
};

// No `charset` and `itemprop` in DOM, so Inferno hasn't them either.
// What about httpEquiv though?
var INFERNO_TAG_MAP = exports.INFERNO_TAG_MAP = {
    accesskey: "accessKey",
    class: "className",
    contenteditable: "contentEditable",
    contextmenu: "contextMenu",
    tabindex: "tabIndex"
};

var HELMET_PROPS = exports.HELMET_PROPS = {
    DEFAULT_TITLE: "defaultTitle",
    DEFER: "defer",
    ENCODE_SPECIAL_CHARACTERS: "encodeSpecialCharacters",
    ON_CHANGE_CLIENT_STATE: "onChangeClientState",
    TITLE_TEMPLATE: "titleTemplate"
};

var HTML_TAG_MAP = exports.HTML_TAG_MAP = Object.keys(INFERNO_TAG_MAP).reduce(function (obj, key) {
    obj[INFERNO_TAG_MAP[key]] = key;
    return obj;
}, {});

var VOID_TAGS = exports.VOID_TAGS = [TAG_NAMES.BASE, TAG_NAMES.LINK, TAG_NAMES.META];

var HELMET_ATTRIBUTE = exports.HELMET_ATTRIBUTE = "data-inferno-helmet";