/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_ARMV9SME;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_ARMV9SME.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_ARMV9SME, shgemm_beta_ARMV9SME,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_ARMV9SME, shgemm_itcopy_ARMV9SME,
#else
  shgemm_oncopy_ARMV9SME, shgemm_otcopy_ARMV9SME,
#endif
  shgemm_oncopy_ARMV9SME, shgemm_otcopy_ARMV9SME,
  shgemv_n_ARMV9SME, shgemv_t_ARMV9SME,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_ARMV9SME, sbdtobf16_k_ARMV9SME, sbf16tos_k_ARMV9SME, dbf16tod_k_ARMV9SME,

  samax_k_ARMV9SME,  samin_k_ARMV9SME,  smax_k_ARMV9SME,  smin_k_ARMV9SME,
  isamax_k_ARMV9SME, isamin_k_ARMV9SME, ismax_k_ARMV9SME, ismin_k_ARMV9SME,
  snrm2_k_ARMV9SME,  sasum_k_ARMV9SME,  ssum_k_ARMV9SME, scopy_k_ARMV9SME, sbdot_k_ARMV9SME,
  dsdot_k_ARMV9SME,
  srot_k_ARMV9SME,   srotm_k_ARMV9SME, bscal_k_ARMV9SME, saxpy_k_ARMV9SME,  sscal_k_ARMV9SME, sswap_k_ARMV9SME,
  bgemv_n_ARMV9SME, bgemv_t_ARMV9SME, sbgemv_n_ARMV9SME, sbgemv_t_ARMV9SME, sger_k_ARMV9SME,
  ssymv_L_ARMV9SME, ssymv_U_ARMV9SME,

  bgemm_kernel_ARMV9SME, bgemm_beta_ARMV9SME,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_ARMV9SME, bgemm_itcopy_ARMV9SME,
#else
  bgemm_oncopy_ARMV9SME, bgemm_otcopy_ARMV9SME,
#endif
  bgemm_oncopy_ARMV9SME, bgemm_otcopy_ARMV9SME,

  sbgemm_kernel_ARMV9SME, sbgemm_beta_ARMV9SME,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_ARMV9SME, sbgemm_itcopy_ARMV9SME,
#else
  sbgemm_oncopy_ARMV9SME, sbgemm_otcopy_ARMV9SME,
#endif
  sbgemm_oncopy_ARMV9SME, sbgemm_otcopy_ARMV9SME,

  strsm_kernel_LN_ARMV9SME, strsm_kernel_LT_ARMV9SME, strsm_kernel_RN_ARMV9SME, strsm_kernel_RT_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ARMV9SME, strsm_iunncopy_ARMV9SME, strsm_iutucopy_ARMV9SME, strsm_iutncopy_ARMV9SME,
  strsm_ilnucopy_ARMV9SME, strsm_ilnncopy_ARMV9SME, strsm_iltucopy_ARMV9SME, strsm_iltncopy_ARMV9SME,
#else
  strsm_ounucopy_ARMV9SME, strsm_ounncopy_ARMV9SME, strsm_outucopy_ARMV9SME, strsm_outncopy_ARMV9SME,
  strsm_olnucopy_ARMV9SME, strsm_olnncopy_ARMV9SME, strsm_oltucopy_ARMV9SME, strsm_oltncopy_ARMV9SME,
#endif
  strsm_ounucopy_ARMV9SME, strsm_ounncopy_ARMV9SME, strsm_outucopy_ARMV9SME, strsm_outncopy_ARMV9SME,
  strsm_olnucopy_ARMV9SME, strsm_olnncopy_ARMV9SME, strsm_oltucopy_ARMV9SME, strsm_oltncopy_ARMV9SME,
  strmm_kernel_RN_ARMV9SME, strmm_kernel_RT_ARMV9SME, strmm_kernel_LN_ARMV9SME, strmm_kernel_LT_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ARMV9SME, strmm_iunncopy_ARMV9SME, strmm_iutucopy_ARMV9SME, strmm_iutncopy_ARMV9SME,
  strmm_ilnucopy_ARMV9SME, strmm_ilnncopy_ARMV9SME, strmm_iltucopy_ARMV9SME, strmm_iltncopy_ARMV9SME,
#else
  strmm_ounucopy_ARMV9SME, strmm_ounncopy_ARMV9SME, strmm_outucopy_ARMV9SME, strmm_outncopy_ARMV9SME,
  strmm_olnucopy_ARMV9SME, strmm_olnncopy_ARMV9SME, strmm_oltucopy_ARMV9SME, strmm_oltncopy_ARMV9SME,
#endif
  strmm_ounucopy_ARMV9SME, strmm_ounncopy_ARMV9SME, strmm_outucopy_ARMV9SME, strmm_outncopy_ARMV9SME,
  strmm_olnucopy_ARMV9SME, strmm_olnncopy_ARMV9SME, strmm_oltucopy_ARMV9SME, strmm_oltncopy_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ARMV9SME, ssymm_iltcopy_ARMV9SME,
#else
  ssymm_outcopy_ARMV9SME, ssymm_oltcopy_ARMV9SME,
#endif
  ssymm_outcopy_ARMV9SME, ssymm_oltcopy_ARMV9SME,

#ifndef NO_LAPACK
  sneg_tcopy_ARMV9SME, slaswp_ncopy_ARMV9SME,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_ARMV9SME,
  sbgemm_small_kernel_nn_ARMV9SME, sbgemm_small_kernel_nt_ARMV9SME, sbgemm_small_kernel_tn_ARMV9SME, sbgemm_small_kernel_tt_ARMV9SME,
  sbgemm_small_kernel_b0_nn_ARMV9SME, sbgemm_small_kernel_b0_nt_ARMV9SME, sbgemm_small_kernel_b0_tn_ARMV9SME, sbgemm_small_kernel_b0_tt_ARMV9SME,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_ARMV9SME,  samin_k_ARMV9SME,  smax_k_ARMV9SME,  smin_k_ARMV9SME,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_ARMV9SME,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_ARMV9SME, ismax_k_ARMV9SME, ismin_k_ARMV9SME,
  snrm2_k_ARMV9SME,  sasum_k_ARMV9SME,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_ARMV9SME,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_ARMV9SME, sdot_k_ARMV9SME,
//  dsdot_k_ARMV9SME,
  srot_k_ARMV9SME,  srotm_k_ARMV9SME,  saxpy_k_ARMV9SME,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_ARMV9SME,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_ARMV9SME,
  sgemv_n_ARMV9SME,  sgemv_t_ARMV9SME,
#endif
#if BUILD_SINGLE == 1
  sger_k_ARMV9SME,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_ARMV9SME, ssymv_U_ARMV9SME,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_ARMV9SME,
  sgemm_direct_performant_ARMV9SME,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_ARMV9SME,
  sgemm_direct_alpha_beta_ARMV9SME,
  ssymm_direct_alpha_betaLU_ARMV9SME,
  ssymm_direct_alpha_betaLL_ARMV9SME,
#endif

  sgemm_kernel_ARMV9SME, sgemm_beta_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_ARMV9SME, sgemm_itcopy_ARMV9SME,
#else
  sgemm_oncopy_ARMV9SME, sgemm_otcopy_ARMV9SME,
#endif
  sgemm_oncopy_ARMV9SME, sgemm_otcopy_ARMV9SME,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_ARMV9SME,
  sgemm_small_kernel_nn_ARMV9SME, sgemm_small_kernel_nt_ARMV9SME, sgemm_small_kernel_tn_ARMV9SME, sgemm_small_kernel_tt_ARMV9SME,
  sgemm_small_kernel_b0_nn_ARMV9SME, sgemm_small_kernel_b0_nt_ARMV9SME, sgemm_small_kernel_b0_tn_ARMV9SME, sgemm_small_kernel_b0_tt_ARMV9SME,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_ARMV9SME, strsm_kernel_LT_ARMV9SME, strsm_kernel_RN_ARMV9SME, strsm_kernel_RT_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ARMV9SME, strsm_iunncopy_ARMV9SME, strsm_iutucopy_ARMV9SME, strsm_iutncopy_ARMV9SME,
  strsm_ilnucopy_ARMV9SME, strsm_ilnncopy_ARMV9SME, strsm_iltucopy_ARMV9SME, strsm_iltncopy_ARMV9SME,
#else
  strsm_ounucopy_ARMV9SME, strsm_ounncopy_ARMV9SME, strsm_outucopy_ARMV9SME, strsm_outncopy_ARMV9SME,
  strsm_olnucopy_ARMV9SME, strsm_olnncopy_ARMV9SME, strsm_oltucopy_ARMV9SME, strsm_oltncopy_ARMV9SME,
#endif
  strsm_ounucopy_ARMV9SME, strsm_ounncopy_ARMV9SME, strsm_outucopy_ARMV9SME, strsm_outncopy_ARMV9SME,
  strsm_olnucopy_ARMV9SME, strsm_olnncopy_ARMV9SME, strsm_oltucopy_ARMV9SME, strsm_oltncopy_ARMV9SME,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_ARMV9SME, strmm_kernel_RT_ARMV9SME, strmm_kernel_LN_ARMV9SME, strmm_kernel_LT_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ARMV9SME, strmm_iunncopy_ARMV9SME, strmm_iutucopy_ARMV9SME, strmm_iutncopy_ARMV9SME,
  strmm_ilnucopy_ARMV9SME, strmm_ilnncopy_ARMV9SME, strmm_iltucopy_ARMV9SME, strmm_iltncopy_ARMV9SME,
#else
  strmm_ounucopy_ARMV9SME, strmm_ounncopy_ARMV9SME, strmm_outucopy_ARMV9SME, strmm_outncopy_ARMV9SME,
  strmm_olnucopy_ARMV9SME, strmm_olnncopy_ARMV9SME, strmm_oltucopy_ARMV9SME, strmm_oltncopy_ARMV9SME,
#endif
  strmm_ounucopy_ARMV9SME, strmm_ounncopy_ARMV9SME, strmm_outucopy_ARMV9SME, strmm_outncopy_ARMV9SME,
  strmm_olnucopy_ARMV9SME, strmm_olnncopy_ARMV9SME, strmm_oltucopy_ARMV9SME, strmm_oltncopy_ARMV9SME,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ARMV9SME, ssymm_iltcopy_ARMV9SME,
#else
  ssymm_outcopy_ARMV9SME, ssymm_oltcopy_ARMV9SME,
#endif
  ssymm_outcopy_ARMV9SME, ssymm_oltcopy_ARMV9SME,
#ifndef NO_LAPACK
  sneg_tcopy_ARMV9SME, slaswp_ncopy_ARMV9SME,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_ARMV9SME,  damin_k_ARMV9SME,  dmax_k_ARMV9SME,  dmin_k_ARMV9SME,
  idamax_k_ARMV9SME, idamin_k_ARMV9SME, idmax_k_ARMV9SME, idmin_k_ARMV9SME,
  dnrm2_k_ARMV9SME, dasum_k_ARMV9SME,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_ARMV9SME,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_ARMV9SME, ddot_k_ARMV9SME,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_ARMV9SME,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_ARMV9SME,
  drotm_k_ARMV9SME,
  daxpy_k_ARMV9SME,
  dscal_k_ARMV9SME, 
  dswap_k_ARMV9SME,
  dgemv_n_ARMV9SME,  dgemv_t_ARMV9SME,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_ARMV9SME,
  dsymv_L_ARMV9SME,  dsymv_U_ARMV9SME,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_ARMV9SME, dgemm_beta_ARMV9SME,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_ARMV9SME, dgemm_itcopy_ARMV9SME,
#else
  dgemm_oncopy_ARMV9SME, dgemm_otcopy_ARMV9SME,
#endif
  dgemm_oncopy_ARMV9SME, dgemm_otcopy_ARMV9SME,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_ARMV9SME,
  dgemm_small_kernel_nn_ARMV9SME, dgemm_small_kernel_nt_ARMV9SME, dgemm_small_kernel_tn_ARMV9SME, dgemm_small_kernel_tt_ARMV9SME,
  dgemm_small_kernel_b0_nn_ARMV9SME, dgemm_small_kernel_b0_nt_ARMV9SME, dgemm_small_kernel_b0_tn_ARMV9SME, dgemm_small_kernel_b0_tt_ARMV9SME,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_ARMV9SME, dtrsm_kernel_LT_ARMV9SME, dtrsm_kernel_RN_ARMV9SME, dtrsm_kernel_RT_ARMV9SME,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_ARMV9SME, dtrsm_iunncopy_ARMV9SME, dtrsm_iutucopy_ARMV9SME, dtrsm_iutncopy_ARMV9SME,
  dtrsm_ilnucopy_ARMV9SME, dtrsm_ilnncopy_ARMV9SME, dtrsm_iltucopy_ARMV9SME, dtrsm_iltncopy_ARMV9SME,
#else
  dtrsm_ounucopy_ARMV9SME, dtrsm_ounncopy_ARMV9SME, dtrsm_outucopy_ARMV9SME, dtrsm_outncopy_ARMV9SME,
  dtrsm_olnucopy_ARMV9SME, dtrsm_olnncopy_ARMV9SME, dtrsm_oltucopy_ARMV9SME, dtrsm_oltncopy_ARMV9SME,
#endif
  dtrsm_ounucopy_ARMV9SME, dtrsm_ounncopy_ARMV9SME, dtrsm_outucopy_ARMV9SME, dtrsm_outncopy_ARMV9SME,
  dtrsm_olnucopy_ARMV9SME, dtrsm_olnncopy_ARMV9SME, dtrsm_oltucopy_ARMV9SME, dtrsm_oltncopy_ARMV9SME,
  dtrmm_kernel_RN_ARMV9SME, dtrmm_kernel_RT_ARMV9SME, dtrmm_kernel_LN_ARMV9SME, dtrmm_kernel_LT_ARMV9SME,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_ARMV9SME, dtrmm_iunncopy_ARMV9SME, dtrmm_iutucopy_ARMV9SME, dtrmm_iutncopy_ARMV9SME,
  dtrmm_ilnucopy_ARMV9SME, dtrmm_ilnncopy_ARMV9SME, dtrmm_iltucopy_ARMV9SME, dtrmm_iltncopy_ARMV9SME,
#else
  dtrmm_ounucopy_ARMV9SME, dtrmm_ounncopy_ARMV9SME, dtrmm_outucopy_ARMV9SME, dtrmm_outncopy_ARMV9SME,
  dtrmm_olnucopy_ARMV9SME, dtrmm_olnncopy_ARMV9SME, dtrmm_oltucopy_ARMV9SME, dtrmm_oltncopy_ARMV9SME,
#endif
  dtrmm_ounucopy_ARMV9SME, dtrmm_ounncopy_ARMV9SME, dtrmm_outucopy_ARMV9SME, dtrmm_outncopy_ARMV9SME,
  dtrmm_olnucopy_ARMV9SME, dtrmm_olnncopy_ARMV9SME, dtrmm_oltucopy_ARMV9SME, dtrmm_oltncopy_ARMV9SME,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_ARMV9SME, dsymm_iltcopy_ARMV9SME,
#else
  dsymm_outcopy_ARMV9SME, dsymm_oltcopy_ARMV9SME,
#endif
  dsymm_outcopy_ARMV9SME, dsymm_oltcopy_ARMV9SME,

#ifndef NO_LAPACK
  dneg_tcopy_ARMV9SME, dlaswp_ncopy_ARMV9SME,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_ARMV9SME,  qamin_k_ARMV9SME,  qmax_k_ARMV9SME,  qmin_k_ARMV9SME,
  iqamax_k_ARMV9SME, iqamin_k_ARMV9SME, iqmax_k_ARMV9SME, iqmin_k_ARMV9SME,
  qnrm2_k_ARMV9SME,  qasum_k_ARMV9SME,  qsum_k_ARMV9SME, qcopy_k_ARMV9SME, qdot_k_ARMV9SME,
  qrot_k_ARMV9SME,   qrotm_k_ARMV9SME,  qaxpy_k_ARMV9SME,  qscal_k_ARMV9SME, qswap_k_ARMV9SME,
  qgemv_n_ARMV9SME,  qgemv_t_ARMV9SME,  qger_k_ARMV9SME,
  qsymv_L_ARMV9SME,  qsymv_U_ARMV9SME,
  qgemm_kernel_ARMV9SME, qgemm_beta_ARMV9SME,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_ARMV9SME, qgemm_itcopy_ARMV9SME,
#else
  qgemm_oncopy_ARMV9SME, qgemm_otcopy_ARMV9SME,
#endif
  qgemm_oncopy_ARMV9SME, qgemm_otcopy_ARMV9SME,
  qtrsm_kernel_LN_ARMV9SME, qtrsm_kernel_LT_ARMV9SME, qtrsm_kernel_RN_ARMV9SME, qtrsm_kernel_RT_ARMV9SME,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_ARMV9SME, qtrsm_iunncopy_ARMV9SME, qtrsm_iutucopy_ARMV9SME, qtrsm_iutncopy_ARMV9SME,
  qtrsm_ilnucopy_ARMV9SME, qtrsm_ilnncopy_ARMV9SME, qtrsm_iltucopy_ARMV9SME, qtrsm_iltncopy_ARMV9SME,
#else
  qtrsm_ounucopy_ARMV9SME, qtrsm_ounncopy_ARMV9SME, qtrsm_outucopy_ARMV9SME, qtrsm_outncopy_ARMV9SME,
  qtrsm_olnucopy_ARMV9SME, qtrsm_olnncopy_ARMV9SME, qtrsm_oltucopy_ARMV9SME, qtrsm_oltncopy_ARMV9SME,
#endif
  qtrsm_ounucopy_ARMV9SME, qtrsm_ounncopy_ARMV9SME, qtrsm_outucopy_ARMV9SME, qtrsm_outncopy_ARMV9SME,
  qtrsm_olnucopy_ARMV9SME, qtrsm_olnncopy_ARMV9SME, qtrsm_oltucopy_ARMV9SME, qtrsm_oltncopy_ARMV9SME,
  qtrmm_kernel_RN_ARMV9SME, qtrmm_kernel_RT_ARMV9SME, qtrmm_kernel_LN_ARMV9SME, qtrmm_kernel_LT_ARMV9SME,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_ARMV9SME, qtrmm_iunncopy_ARMV9SME, qtrmm_iutucopy_ARMV9SME, qtrmm_iutncopy_ARMV9SME,
  qtrmm_ilnucopy_ARMV9SME, qtrmm_ilnncopy_ARMV9SME, qtrmm_iltucopy_ARMV9SME, qtrmm_iltncopy_ARMV9SME,
#else
  qtrmm_ounucopy_ARMV9SME, qtrmm_ounncopy_ARMV9SME, qtrmm_outucopy_ARMV9SME, qtrmm_outncopy_ARMV9SME,
  qtrmm_olnucopy_ARMV9SME, qtrmm_olnncopy_ARMV9SME, qtrmm_oltucopy_ARMV9SME, qtrmm_oltncopy_ARMV9SME,
#endif
  qtrmm_ounucopy_ARMV9SME, qtrmm_ounncopy_ARMV9SME, qtrmm_outucopy_ARMV9SME, qtrmm_outncopy_ARMV9SME,
  qtrmm_olnucopy_ARMV9SME, qtrmm_olnncopy_ARMV9SME, qtrmm_oltucopy_ARMV9SME, qtrmm_oltncopy_ARMV9SME,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_ARMV9SME, qsymm_iltcopy_ARMV9SME,
#else
  qsymm_outcopy_ARMV9SME, qsymm_oltcopy_ARMV9SME,
#endif
  qsymm_outcopy_ARMV9SME, qsymm_oltcopy_ARMV9SME,

#ifndef NO_LAPACK
  qneg_tcopy_ARMV9SME, qlaswp_ncopy_ARMV9SME,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_ARMV9SME, camin_k_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
  icamax_k_ARMV9SME, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_ARMV9SME,
  cnrm2_k_ARMV9SME, casum_k_ARMV9SME, csum_k_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_ARMV9SME, cdotu_k_ARMV9SME, cdotc_k_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
 csrot_k_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_ARMV9SME,
  caxpyc_k_ARMV9SME, 
  cscal_k_ARMV9SME, 
  cswap_k_ARMV9SME,

  cgemv_n_ARMV9SME, cgemv_t_ARMV9SME, cgemv_r_ARMV9SME, cgemv_c_ARMV9SME,
  cgemv_o_ARMV9SME, cgemv_u_ARMV9SME, cgemv_s_ARMV9SME, cgemv_d_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_ARMV9SME, cgerc_k_ARMV9SME, cgerv_k_ARMV9SME, cgerd_k_ARMV9SME,
  csymv_L_ARMV9SME, csymv_U_ARMV9SME,
  chemv_L_ARMV9SME, chemv_U_ARMV9SME, chemv_M_ARMV9SME, chemv_V_ARMV9SME,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_ARMV9SME, cgemm_kernel_l_ARMV9SME, cgemm_kernel_r_ARMV9SME, cgemm_kernel_b_ARMV9SME,
  cgemm_beta_ARMV9SME,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_ARMV9SME, cgemm_itcopy_ARMV9SME,
#else
  cgemm_oncopy_ARMV9SME, cgemm_otcopy_ARMV9SME,
#endif
  cgemm_oncopy_ARMV9SME, cgemm_otcopy_ARMV9SME,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_ARMV9SME,
  cgemm_small_kernel_nn_ARMV9SME, cgemm_small_kernel_nt_ARMV9SME, cgemm_small_kernel_nr_ARMV9SME, cgemm_small_kernel_nc_ARMV9SME,
  cgemm_small_kernel_tn_ARMV9SME, cgemm_small_kernel_tt_ARMV9SME, cgemm_small_kernel_tr_ARMV9SME, cgemm_small_kernel_tc_ARMV9SME,
  cgemm_small_kernel_rn_ARMV9SME, cgemm_small_kernel_rt_ARMV9SME, cgemm_small_kernel_rr_ARMV9SME, cgemm_small_kernel_rc_ARMV9SME,
  cgemm_small_kernel_cn_ARMV9SME, cgemm_small_kernel_ct_ARMV9SME, cgemm_small_kernel_cr_ARMV9SME, cgemm_small_kernel_cc_ARMV9SME,
  cgemm_small_kernel_b0_nn_ARMV9SME, cgemm_small_kernel_b0_nt_ARMV9SME, cgemm_small_kernel_b0_nr_ARMV9SME, cgemm_small_kernel_b0_nc_ARMV9SME,
  cgemm_small_kernel_b0_tn_ARMV9SME, cgemm_small_kernel_b0_tt_ARMV9SME, cgemm_small_kernel_b0_tr_ARMV9SME, cgemm_small_kernel_b0_tc_ARMV9SME,
  cgemm_small_kernel_b0_rn_ARMV9SME, cgemm_small_kernel_b0_rt_ARMV9SME, cgemm_small_kernel_b0_rr_ARMV9SME, cgemm_small_kernel_b0_rc_ARMV9SME,
  cgemm_small_kernel_b0_cn_ARMV9SME, cgemm_small_kernel_b0_ct_ARMV9SME, cgemm_small_kernel_b0_cr_ARMV9SME, cgemm_small_kernel_b0_cc_ARMV9SME,
#endif

  ctrsm_kernel_LN_ARMV9SME, ctrsm_kernel_LT_ARMV9SME, ctrsm_kernel_LR_ARMV9SME, ctrsm_kernel_LC_ARMV9SME,
  ctrsm_kernel_RN_ARMV9SME, ctrsm_kernel_RT_ARMV9SME, ctrsm_kernel_RR_ARMV9SME, ctrsm_kernel_RC_ARMV9SME,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_ARMV9SME,  ctrsm_iunncopy_ARMV9SME,  ctrsm_iutucopy_ARMV9SME,  ctrsm_iutncopy_ARMV9SME,
  ctrsm_ilnucopy_ARMV9SME,  ctrsm_ilnncopy_ARMV9SME,  ctrsm_iltucopy_ARMV9SME,  ctrsm_iltncopy_ARMV9SME,
#else
  ctrsm_ounucopy_ARMV9SME,  ctrsm_ounncopy_ARMV9SME,  ctrsm_outucopy_ARMV9SME,  ctrsm_outncopy_ARMV9SME,
  ctrsm_olnucopy_ARMV9SME,  ctrsm_olnncopy_ARMV9SME,  ctrsm_oltucopy_ARMV9SME,  ctrsm_oltncopy_ARMV9SME,
#endif
  ctrsm_ounucopy_ARMV9SME,  ctrsm_ounncopy_ARMV9SME,  ctrsm_outucopy_ARMV9SME,  ctrsm_outncopy_ARMV9SME,
  ctrsm_olnucopy_ARMV9SME,  ctrsm_olnncopy_ARMV9SME,  ctrsm_oltucopy_ARMV9SME,  ctrsm_oltncopy_ARMV9SME,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_ARMV9SME,  ctrmm_kernel_RT_ARMV9SME,  ctrmm_kernel_RR_ARMV9SME,  ctrmm_kernel_RC_ARMV9SME,
  ctrmm_kernel_LN_ARMV9SME,  ctrmm_kernel_LT_ARMV9SME,  ctrmm_kernel_LR_ARMV9SME,  ctrmm_kernel_LC_ARMV9SME,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_ARMV9SME,  ctrmm_iunncopy_ARMV9SME,  ctrmm_iutucopy_ARMV9SME,  ctrmm_iutncopy_ARMV9SME,
  ctrmm_ilnucopy_ARMV9SME,  ctrmm_ilnncopy_ARMV9SME,  ctrmm_iltucopy_ARMV9SME,  ctrmm_iltncopy_ARMV9SME,
#else
  ctrmm_ounucopy_ARMV9SME,  ctrmm_ounncopy_ARMV9SME,  ctrmm_outucopy_ARMV9SME,  ctrmm_outncopy_ARMV9SME,
  ctrmm_olnucopy_ARMV9SME,  ctrmm_olnncopy_ARMV9SME,  ctrmm_oltucopy_ARMV9SME,  ctrmm_oltncopy_ARMV9SME,
#endif
  ctrmm_ounucopy_ARMV9SME,  ctrmm_ounncopy_ARMV9SME,  ctrmm_outucopy_ARMV9SME,  ctrmm_outncopy_ARMV9SME,
  ctrmm_olnucopy_ARMV9SME,  ctrmm_olnncopy_ARMV9SME,  ctrmm_oltucopy_ARMV9SME,  ctrmm_oltncopy_ARMV9SME,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_ARMV9SME,  csymm_iltcopy_ARMV9SME,
#else
  csymm_outcopy_ARMV9SME,  csymm_oltcopy_ARMV9SME,
#endif
  csymm_outcopy_ARMV9SME,  csymm_oltcopy_ARMV9SME,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_ARMV9SME,  chemm_iltcopy_ARMV9SME,
#else
  chemm_outcopy_ARMV9SME,  chemm_oltcopy_ARMV9SME,
#endif
  chemm_outcopy_ARMV9SME,  chemm_oltcopy_ARMV9SME,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_ARMV9SME,

  cgemm3m_incopyb_ARMV9SME,  cgemm3m_incopyr_ARMV9SME,
  cgemm3m_incopyi_ARMV9SME,  cgemm3m_itcopyb_ARMV9SME,
  cgemm3m_itcopyr_ARMV9SME,  cgemm3m_itcopyi_ARMV9SME,
  cgemm3m_oncopyb_ARMV9SME,  cgemm3m_oncopyr_ARMV9SME,
  cgemm3m_oncopyi_ARMV9SME,  cgemm3m_otcopyb_ARMV9SME,
  cgemm3m_otcopyr_ARMV9SME,  cgemm3m_otcopyi_ARMV9SME,

  csymm3m_iucopyb_ARMV9SME,  csymm3m_ilcopyb_ARMV9SME,
  csymm3m_iucopyr_ARMV9SME,  csymm3m_ilcopyr_ARMV9SME,
  csymm3m_iucopyi_ARMV9SME,  csymm3m_ilcopyi_ARMV9SME,
  csymm3m_oucopyb_ARMV9SME,  csymm3m_olcopyb_ARMV9SME,
  csymm3m_oucopyr_ARMV9SME,  csymm3m_olcopyr_ARMV9SME,
  csymm3m_oucopyi_ARMV9SME,  csymm3m_olcopyi_ARMV9SME,

  chemm3m_iucopyb_ARMV9SME,  chemm3m_ilcopyb_ARMV9SME,
  chemm3m_iucopyr_ARMV9SME,  chemm3m_ilcopyr_ARMV9SME,
  chemm3m_iucopyi_ARMV9SME,  chemm3m_ilcopyi_ARMV9SME,

  chemm3m_oucopyb_ARMV9SME,  chemm3m_olcopyb_ARMV9SME,
  chemm3m_oucopyr_ARMV9SME,  chemm3m_olcopyr_ARMV9SME,
  chemm3m_oucopyi_ARMV9SME,  chemm3m_olcopyi_ARMV9SME,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_ARMV9SME,
  
   claswp_ncopy_ARMV9SME,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_ARMV9SME, zamin_k_ARMV9SME, izamax_k_ARMV9SME, izamin_k_ARMV9SME,
  znrm2_k_ARMV9SME, zasum_k_ARMV9SME, zsum_k_ARMV9SME, zcopy_k_ARMV9SME,
  zdotu_k_ARMV9SME, zdotc_k_ARMV9SME, zdrot_k_ARMV9SME,
  zaxpy_k_ARMV9SME, zaxpyc_k_ARMV9SME, zscal_k_ARMV9SME, zswap_k_ARMV9SME,

  zgemv_n_ARMV9SME, zgemv_t_ARMV9SME, zgemv_r_ARMV9SME, zgemv_c_ARMV9SME,
  zgemv_o_ARMV9SME, zgemv_u_ARMV9SME, zgemv_s_ARMV9SME, zgemv_d_ARMV9SME,
  zgeru_k_ARMV9SME, zgerc_k_ARMV9SME, zgerv_k_ARMV9SME, zgerd_k_ARMV9SME,
  zsymv_L_ARMV9SME, zsymv_U_ARMV9SME,
  zhemv_L_ARMV9SME, zhemv_U_ARMV9SME, zhemv_M_ARMV9SME, zhemv_V_ARMV9SME,

  zgemm_kernel_n_ARMV9SME, zgemm_kernel_l_ARMV9SME, zgemm_kernel_r_ARMV9SME, zgemm_kernel_b_ARMV9SME,
  zgemm_beta_ARMV9SME,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_ARMV9SME, zgemm_itcopy_ARMV9SME,
#else
  zgemm_oncopy_ARMV9SME, zgemm_otcopy_ARMV9SME,
#endif
  zgemm_oncopy_ARMV9SME, zgemm_otcopy_ARMV9SME,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_ARMV9SME,
  zgemm_small_kernel_nn_ARMV9SME, zgemm_small_kernel_nt_ARMV9SME, zgemm_small_kernel_nr_ARMV9SME, zgemm_small_kernel_nc_ARMV9SME,
  zgemm_small_kernel_tn_ARMV9SME, zgemm_small_kernel_tt_ARMV9SME, zgemm_small_kernel_tr_ARMV9SME, zgemm_small_kernel_tc_ARMV9SME,
  zgemm_small_kernel_rn_ARMV9SME, zgemm_small_kernel_rt_ARMV9SME, zgemm_small_kernel_rr_ARMV9SME, zgemm_small_kernel_rc_ARMV9SME,
  zgemm_small_kernel_cn_ARMV9SME, zgemm_small_kernel_ct_ARMV9SME, zgemm_small_kernel_cr_ARMV9SME, zgemm_small_kernel_cc_ARMV9SME,
  zgemm_small_kernel_b0_nn_ARMV9SME, zgemm_small_kernel_b0_nt_ARMV9SME, zgemm_small_kernel_b0_nr_ARMV9SME, zgemm_small_kernel_b0_nc_ARMV9SME,
  zgemm_small_kernel_b0_tn_ARMV9SME, zgemm_small_kernel_b0_tt_ARMV9SME, zgemm_small_kernel_b0_tr_ARMV9SME, zgemm_small_kernel_b0_tc_ARMV9SME,
  zgemm_small_kernel_b0_rn_ARMV9SME, zgemm_small_kernel_b0_rt_ARMV9SME, zgemm_small_kernel_b0_rr_ARMV9SME, zgemm_small_kernel_b0_rc_ARMV9SME,
  zgemm_small_kernel_b0_cn_ARMV9SME, zgemm_small_kernel_b0_ct_ARMV9SME, zgemm_small_kernel_b0_cr_ARMV9SME, zgemm_small_kernel_b0_cc_ARMV9SME,
#endif

  ztrsm_kernel_LN_ARMV9SME, ztrsm_kernel_LT_ARMV9SME, ztrsm_kernel_LR_ARMV9SME, ztrsm_kernel_LC_ARMV9SME,
  ztrsm_kernel_RN_ARMV9SME, ztrsm_kernel_RT_ARMV9SME, ztrsm_kernel_RR_ARMV9SME, ztrsm_kernel_RC_ARMV9SME,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_ARMV9SME,  ztrsm_iunncopy_ARMV9SME,  ztrsm_iutucopy_ARMV9SME,  ztrsm_iutncopy_ARMV9SME,
  ztrsm_ilnucopy_ARMV9SME,  ztrsm_ilnncopy_ARMV9SME,  ztrsm_iltucopy_ARMV9SME,  ztrsm_iltncopy_ARMV9SME,
#else
  ztrsm_ounucopy_ARMV9SME,  ztrsm_ounncopy_ARMV9SME,  ztrsm_outucopy_ARMV9SME,  ztrsm_outncopy_ARMV9SME,
  ztrsm_olnucopy_ARMV9SME,  ztrsm_olnncopy_ARMV9SME,  ztrsm_oltucopy_ARMV9SME,  ztrsm_oltncopy_ARMV9SME,
#endif
  ztrsm_ounucopy_ARMV9SME,  ztrsm_ounncopy_ARMV9SME,  ztrsm_outucopy_ARMV9SME,  ztrsm_outncopy_ARMV9SME,
  ztrsm_olnucopy_ARMV9SME,  ztrsm_olnncopy_ARMV9SME,  ztrsm_oltucopy_ARMV9SME,  ztrsm_oltncopy_ARMV9SME,

  ztrmm_kernel_RN_ARMV9SME,  ztrmm_kernel_RT_ARMV9SME,  ztrmm_kernel_RR_ARMV9SME,  ztrmm_kernel_RC_ARMV9SME,
  ztrmm_kernel_LN_ARMV9SME,  ztrmm_kernel_LT_ARMV9SME,  ztrmm_kernel_LR_ARMV9SME,  ztrmm_kernel_LC_ARMV9SME,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_ARMV9SME,  ztrmm_iunncopy_ARMV9SME,  ztrmm_iutucopy_ARMV9SME,  ztrmm_iutncopy_ARMV9SME,
  ztrmm_ilnucopy_ARMV9SME,  ztrmm_ilnncopy_ARMV9SME,  ztrmm_iltucopy_ARMV9SME,  ztrmm_iltncopy_ARMV9SME,
#else
  ztrmm_ounucopy_ARMV9SME,  ztrmm_ounncopy_ARMV9SME,  ztrmm_outucopy_ARMV9SME,  ztrmm_outncopy_ARMV9SME,
  ztrmm_olnucopy_ARMV9SME,  ztrmm_olnncopy_ARMV9SME,  ztrmm_oltucopy_ARMV9SME,  ztrmm_oltncopy_ARMV9SME,
#endif
  ztrmm_ounucopy_ARMV9SME,  ztrmm_ounncopy_ARMV9SME,  ztrmm_outucopy_ARMV9SME,  ztrmm_outncopy_ARMV9SME,
  ztrmm_olnucopy_ARMV9SME,  ztrmm_olnncopy_ARMV9SME,  ztrmm_oltucopy_ARMV9SME,  ztrmm_oltncopy_ARMV9SME,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_ARMV9SME,  zsymm_iltcopy_ARMV9SME,
#else
  zsymm_outcopy_ARMV9SME,  zsymm_oltcopy_ARMV9SME,
#endif
  zsymm_outcopy_ARMV9SME,  zsymm_oltcopy_ARMV9SME,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_ARMV9SME,  zhemm_iltcopy_ARMV9SME,
#else
  zhemm_outcopy_ARMV9SME,  zhemm_oltcopy_ARMV9SME,
#endif
  zhemm_outcopy_ARMV9SME,  zhemm_oltcopy_ARMV9SME,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_ARMV9SME,

  zgemm3m_incopyb_ARMV9SME,  zgemm3m_incopyr_ARMV9SME,
  zgemm3m_incopyi_ARMV9SME,  zgemm3m_itcopyb_ARMV9SME,
  zgemm3m_itcopyr_ARMV9SME,  zgemm3m_itcopyi_ARMV9SME,
  zgemm3m_oncopyb_ARMV9SME,  zgemm3m_oncopyr_ARMV9SME,
  zgemm3m_oncopyi_ARMV9SME,  zgemm3m_otcopyb_ARMV9SME,
  zgemm3m_otcopyr_ARMV9SME,  zgemm3m_otcopyi_ARMV9SME,

  zsymm3m_iucopyb_ARMV9SME,  zsymm3m_ilcopyb_ARMV9SME,
  zsymm3m_iucopyr_ARMV9SME,  zsymm3m_ilcopyr_ARMV9SME,
  zsymm3m_iucopyi_ARMV9SME,  zsymm3m_ilcopyi_ARMV9SME,
  zsymm3m_oucopyb_ARMV9SME,  zsymm3m_olcopyb_ARMV9SME,
  zsymm3m_oucopyr_ARMV9SME,  zsymm3m_olcopyr_ARMV9SME,
  zsymm3m_oucopyi_ARMV9SME,  zsymm3m_olcopyi_ARMV9SME,

  zhemm3m_iucopyb_ARMV9SME,  zhemm3m_ilcopyb_ARMV9SME,
  zhemm3m_iucopyr_ARMV9SME,  zhemm3m_ilcopyr_ARMV9SME,
  zhemm3m_iucopyi_ARMV9SME,  zhemm3m_ilcopyi_ARMV9SME,

  zhemm3m_oucopyb_ARMV9SME,  zhemm3m_olcopyb_ARMV9SME,
  zhemm3m_oucopyr_ARMV9SME,  zhemm3m_olcopyr_ARMV9SME,
  zhemm3m_oucopyi_ARMV9SME,  zhemm3m_olcopyi_ARMV9SME,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_ARMV9SME, zlaswp_ncopy_ARMV9SME,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_ARMV9SME, xamin_k_ARMV9SME, ixamax_k_ARMV9SME, ixamin_k_ARMV9SME,
  xnrm2_k_ARMV9SME, xasum_k_ARMV9SME, xsum_k_ARMV9SME, xcopy_k_ARMV9SME,
  xdotu_k_ARMV9SME, xdotc_k_ARMV9SME, xqrot_k_ARMV9SME,
  xaxpy_k_ARMV9SME, xaxpyc_k_ARMV9SME, xscal_k_ARMV9SME, xswap_k_ARMV9SME,

  xgemv_n_ARMV9SME, xgemv_t_ARMV9SME, xgemv_r_ARMV9SME, xgemv_c_ARMV9SME,
  xgemv_o_ARMV9SME, xgemv_u_ARMV9SME, xgemv_s_ARMV9SME, xgemv_d_ARMV9SME,
  xgeru_k_ARMV9SME, xgerc_k_ARMV9SME, xgerv_k_ARMV9SME, xgerd_k_ARMV9SME,
  xsymv_L_ARMV9SME, xsymv_U_ARMV9SME,
  xhemv_L_ARMV9SME, xhemv_U_ARMV9SME, xhemv_M_ARMV9SME, xhemv_V_ARMV9SME,

  xgemm_kernel_n_ARMV9SME, xgemm_kernel_l_ARMV9SME, xgemm_kernel_r_ARMV9SME, xgemm_kernel_b_ARMV9SME,
  xgemm_beta_ARMV9SME,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_ARMV9SME, xgemm_itcopy_ARMV9SME,
#else
  xgemm_oncopy_ARMV9SME, xgemm_otcopy_ARMV9SME,
#endif
  xgemm_oncopy_ARMV9SME, xgemm_otcopy_ARMV9SME,

  xtrsm_kernel_LN_ARMV9SME, xtrsm_kernel_LT_ARMV9SME, xtrsm_kernel_LR_ARMV9SME, xtrsm_kernel_LC_ARMV9SME,
  xtrsm_kernel_RN_ARMV9SME, xtrsm_kernel_RT_ARMV9SME, xtrsm_kernel_RR_ARMV9SME, xtrsm_kernel_RC_ARMV9SME,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_ARMV9SME,  xtrsm_iunncopy_ARMV9SME,  xtrsm_iutucopy_ARMV9SME,  xtrsm_iutncopy_ARMV9SME,
  xtrsm_ilnucopy_ARMV9SME,  xtrsm_ilnncopy_ARMV9SME,  xtrsm_iltucopy_ARMV9SME,  xtrsm_iltncopy_ARMV9SME,
#else
  xtrsm_ounucopy_ARMV9SME,  xtrsm_ounncopy_ARMV9SME,  xtrsm_outucopy_ARMV9SME,  xtrsm_outncopy_ARMV9SME,
  xtrsm_olnucopy_ARMV9SME,  xtrsm_olnncopy_ARMV9SME,  xtrsm_oltucopy_ARMV9SME,  xtrsm_oltncopy_ARMV9SME,
#endif
  xtrsm_ounucopy_ARMV9SME,  xtrsm_ounncopy_ARMV9SME,  xtrsm_outucopy_ARMV9SME,  xtrsm_outncopy_ARMV9SME,
  xtrsm_olnucopy_ARMV9SME,  xtrsm_olnncopy_ARMV9SME,  xtrsm_oltucopy_ARMV9SME,  xtrsm_oltncopy_ARMV9SME,

  xtrmm_kernel_RN_ARMV9SME,  xtrmm_kernel_RT_ARMV9SME,  xtrmm_kernel_RR_ARMV9SME,  xtrmm_kernel_RC_ARMV9SME,
  xtrmm_kernel_LN_ARMV9SME,  xtrmm_kernel_LT_ARMV9SME,  xtrmm_kernel_LR_ARMV9SME,  xtrmm_kernel_LC_ARMV9SME,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_ARMV9SME,  xtrmm_iunncopy_ARMV9SME,  xtrmm_iutucopy_ARMV9SME,  xtrmm_iutncopy_ARMV9SME,
  xtrmm_ilnucopy_ARMV9SME,  xtrmm_ilnncopy_ARMV9SME,  xtrmm_iltucopy_ARMV9SME,  xtrmm_iltncopy_ARMV9SME,
#else
  xtrmm_ounucopy_ARMV9SME,  xtrmm_ounncopy_ARMV9SME,  xtrmm_outucopy_ARMV9SME,  xtrmm_outncopy_ARMV9SME,
  xtrmm_olnucopy_ARMV9SME,  xtrmm_olnncopy_ARMV9SME,  xtrmm_oltucopy_ARMV9SME,  xtrmm_oltncopy_ARMV9SME,
#endif
  xtrmm_ounucopy_ARMV9SME,  xtrmm_ounncopy_ARMV9SME,  xtrmm_outucopy_ARMV9SME,  xtrmm_outncopy_ARMV9SME,
  xtrmm_olnucopy_ARMV9SME,  xtrmm_olnncopy_ARMV9SME,  xtrmm_oltucopy_ARMV9SME,  xtrmm_oltncopy_ARMV9SME,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_ARMV9SME,  xsymm_iltcopy_ARMV9SME,
#else
  xsymm_outcopy_ARMV9SME,  xsymm_oltcopy_ARMV9SME,
#endif
  xsymm_outcopy_ARMV9SME,  xsymm_oltcopy_ARMV9SME,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_ARMV9SME,  xhemm_iltcopy_ARMV9SME,
#else
  xhemm_outcopy_ARMV9SME,  xhemm_oltcopy_ARMV9SME,
#endif
  xhemm_outcopy_ARMV9SME,  xhemm_oltcopy_ARMV9SME,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_ARMV9SME,

  xgemm3m_incopyb_ARMV9SME,  xgemm3m_incopyr_ARMV9SME,
  xgemm3m_incopyi_ARMV9SME,  xgemm3m_itcopyb_ARMV9SME,
  xgemm3m_itcopyr_ARMV9SME,  xgemm3m_itcopyi_ARMV9SME,
  xgemm3m_oncopyb_ARMV9SME,  xgemm3m_oncopyr_ARMV9SME,
  xgemm3m_oncopyi_ARMV9SME,  xgemm3m_otcopyb_ARMV9SME,
  xgemm3m_otcopyr_ARMV9SME,  xgemm3m_otcopyi_ARMV9SME,

  xsymm3m_iucopyb_ARMV9SME,  xsymm3m_ilcopyb_ARMV9SME,
  xsymm3m_iucopyr_ARMV9SME,  xsymm3m_ilcopyr_ARMV9SME,
  xsymm3m_iucopyi_ARMV9SME,  xsymm3m_ilcopyi_ARMV9SME,
  xsymm3m_oucopyb_ARMV9SME,  xsymm3m_olcopyb_ARMV9SME,
  xsymm3m_oucopyr_ARMV9SME,  xsymm3m_olcopyr_ARMV9SME,
  xsymm3m_oucopyi_ARMV9SME,  xsymm3m_olcopyi_ARMV9SME,

  xhemm3m_iucopyb_ARMV9SME,  xhemm3m_ilcopyb_ARMV9SME,
  xhemm3m_iucopyr_ARMV9SME,  xhemm3m_ilcopyr_ARMV9SME,
  xhemm3m_iucopyi_ARMV9SME,  xhemm3m_ilcopyi_ARMV9SME,

  xhemm3m_oucopyb_ARMV9SME,  xhemm3m_olcopyb_ARMV9SME,
  xhemm3m_oucopyr_ARMV9SME,  xhemm3m_olcopyr_ARMV9SME,
  xhemm3m_oucopyi_ARMV9SME,  xhemm3m_olcopyi_ARMV9SME,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_ARMV9SME, xlaswp_ncopy_ARMV9SME,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_ARMV9SME,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_ARMV9SME,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_ARMV9SME,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_ARMV9SME,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_ARMV9SME, somatcopy_k_ct_ARMV9SME, somatcopy_k_rn_ARMV9SME, somatcopy_k_rt_ARMV9SME,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_ARMV9SME, domatcopy_k_ct_ARMV9SME, domatcopy_k_rn_ARMV9SME, domatcopy_k_rt_ARMV9SME,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_ARMV9SME, comatcopy_k_ct_ARMV9SME, comatcopy_k_rn_ARMV9SME, comatcopy_k_rt_ARMV9SME,
  comatcopy_k_cnc_ARMV9SME, comatcopy_k_ctc_ARMV9SME, comatcopy_k_rnc_ARMV9SME, comatcopy_k_rtc_ARMV9SME,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_ARMV9SME, zomatcopy_k_ct_ARMV9SME, zomatcopy_k_rn_ARMV9SME, zomatcopy_k_rt_ARMV9SME,
  zomatcopy_k_cnc_ARMV9SME, zomatcopy_k_ctc_ARMV9SME, zomatcopy_k_rnc_ARMV9SME, zomatcopy_k_rtc_ARMV9SME,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_ARMV9SME, simatcopy_k_ct_ARMV9SME, simatcopy_k_rn_ARMV9SME, simatcopy_k_rt_ARMV9SME,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_ARMV9SME, dimatcopy_k_ct_ARMV9SME, dimatcopy_k_rn_ARMV9SME, dimatcopy_k_rt_ARMV9SME,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_ARMV9SME, cimatcopy_k_ct_ARMV9SME, cimatcopy_k_rn_ARMV9SME, cimatcopy_k_rt_ARMV9SME,
  cimatcopy_k_cnc_ARMV9SME, cimatcopy_k_ctc_ARMV9SME, cimatcopy_k_rnc_ARMV9SME, cimatcopy_k_rtc_ARMV9SME,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_ARMV9SME, zimatcopy_k_ct_ARMV9SME, zimatcopy_k_rn_ARMV9SME, zimatcopy_k_rt_ARMV9SME,
  zimatcopy_k_cnc_ARMV9SME, zimatcopy_k_ctc_ARMV9SME, zimatcopy_k_rnc_ARMV9SME, zimatcopy_k_rtc_ARMV9SME,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_ARMV9SME,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_ARMV9SME,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_ARMV9SME,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_ARMV9SME,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
