/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_CORTEXA57;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_CORTEXA57.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_CORTEXA57, shgemm_beta_CORTEXA57,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_CORTEXA57, shgemm_itcopy_CORTEXA57,
#else
  shgemm_oncopy_CORTEXA57, shgemm_otcopy_CORTEXA57,
#endif
  shgemm_oncopy_CORTEXA57, shgemm_otcopy_CORTEXA57,
  shgemv_n_CORTEXA57, shgemv_t_CORTEXA57,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_CORTEXA57, sbdtobf16_k_CORTEXA57, sbf16tos_k_CORTEXA57, dbf16tod_k_CORTEXA57,

  samax_k_CORTEXA57,  samin_k_CORTEXA57,  smax_k_CORTEXA57,  smin_k_CORTEXA57,
  isamax_k_CORTEXA57, isamin_k_CORTEXA57, ismax_k_CORTEXA57, ismin_k_CORTEXA57,
  snrm2_k_CORTEXA57,  sasum_k_CORTEXA57,  ssum_k_CORTEXA57, scopy_k_CORTEXA57, sbdot_k_CORTEXA57,
  dsdot_k_CORTEXA57,
  srot_k_CORTEXA57,   srotm_k_CORTEXA57, bscal_k_CORTEXA57, saxpy_k_CORTEXA57,  sscal_k_CORTEXA57, sswap_k_CORTEXA57,
  bgemv_n_CORTEXA57, bgemv_t_CORTEXA57, sbgemv_n_CORTEXA57, sbgemv_t_CORTEXA57, sger_k_CORTEXA57,
  ssymv_L_CORTEXA57, ssymv_U_CORTEXA57,

  bgemm_kernel_CORTEXA57, bgemm_beta_CORTEXA57,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_CORTEXA57, bgemm_itcopy_CORTEXA57,
#else
  bgemm_oncopy_CORTEXA57, bgemm_otcopy_CORTEXA57,
#endif
  bgemm_oncopy_CORTEXA57, bgemm_otcopy_CORTEXA57,

  sbgemm_kernel_CORTEXA57, sbgemm_beta_CORTEXA57,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_CORTEXA57, sbgemm_itcopy_CORTEXA57,
#else
  sbgemm_oncopy_CORTEXA57, sbgemm_otcopy_CORTEXA57,
#endif
  sbgemm_oncopy_CORTEXA57, sbgemm_otcopy_CORTEXA57,

  strsm_kernel_LN_CORTEXA57, strsm_kernel_LT_CORTEXA57, strsm_kernel_RN_CORTEXA57, strsm_kernel_RT_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_CORTEXA57, strsm_iunncopy_CORTEXA57, strsm_iutucopy_CORTEXA57, strsm_iutncopy_CORTEXA57,
  strsm_ilnucopy_CORTEXA57, strsm_ilnncopy_CORTEXA57, strsm_iltucopy_CORTEXA57, strsm_iltncopy_CORTEXA57,
#else
  strsm_ounucopy_CORTEXA57, strsm_ounncopy_CORTEXA57, strsm_outucopy_CORTEXA57, strsm_outncopy_CORTEXA57,
  strsm_olnucopy_CORTEXA57, strsm_olnncopy_CORTEXA57, strsm_oltucopy_CORTEXA57, strsm_oltncopy_CORTEXA57,
#endif
  strsm_ounucopy_CORTEXA57, strsm_ounncopy_CORTEXA57, strsm_outucopy_CORTEXA57, strsm_outncopy_CORTEXA57,
  strsm_olnucopy_CORTEXA57, strsm_olnncopy_CORTEXA57, strsm_oltucopy_CORTEXA57, strsm_oltncopy_CORTEXA57,
  strmm_kernel_RN_CORTEXA57, strmm_kernel_RT_CORTEXA57, strmm_kernel_LN_CORTEXA57, strmm_kernel_LT_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_CORTEXA57, strmm_iunncopy_CORTEXA57, strmm_iutucopy_CORTEXA57, strmm_iutncopy_CORTEXA57,
  strmm_ilnucopy_CORTEXA57, strmm_ilnncopy_CORTEXA57, strmm_iltucopy_CORTEXA57, strmm_iltncopy_CORTEXA57,
#else
  strmm_ounucopy_CORTEXA57, strmm_ounncopy_CORTEXA57, strmm_outucopy_CORTEXA57, strmm_outncopy_CORTEXA57,
  strmm_olnucopy_CORTEXA57, strmm_olnncopy_CORTEXA57, strmm_oltucopy_CORTEXA57, strmm_oltncopy_CORTEXA57,
#endif
  strmm_ounucopy_CORTEXA57, strmm_ounncopy_CORTEXA57, strmm_outucopy_CORTEXA57, strmm_outncopy_CORTEXA57,
  strmm_olnucopy_CORTEXA57, strmm_olnncopy_CORTEXA57, strmm_oltucopy_CORTEXA57, strmm_oltncopy_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_CORTEXA57, ssymm_iltcopy_CORTEXA57,
#else
  ssymm_outcopy_CORTEXA57, ssymm_oltcopy_CORTEXA57,
#endif
  ssymm_outcopy_CORTEXA57, ssymm_oltcopy_CORTEXA57,

#ifndef NO_LAPACK
  sneg_tcopy_CORTEXA57, slaswp_ncopy_CORTEXA57,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_CORTEXA57,
  sbgemm_small_kernel_nn_CORTEXA57, sbgemm_small_kernel_nt_CORTEXA57, sbgemm_small_kernel_tn_CORTEXA57, sbgemm_small_kernel_tt_CORTEXA57,
  sbgemm_small_kernel_b0_nn_CORTEXA57, sbgemm_small_kernel_b0_nt_CORTEXA57, sbgemm_small_kernel_b0_tn_CORTEXA57, sbgemm_small_kernel_b0_tt_CORTEXA57,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_CORTEXA57,  samin_k_CORTEXA57,  smax_k_CORTEXA57,  smin_k_CORTEXA57,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_CORTEXA57,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_CORTEXA57, ismax_k_CORTEXA57, ismin_k_CORTEXA57,
  snrm2_k_CORTEXA57,  sasum_k_CORTEXA57,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_CORTEXA57,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_CORTEXA57, sdot_k_CORTEXA57,
//  dsdot_k_CORTEXA57,
  srot_k_CORTEXA57,  srotm_k_CORTEXA57,  saxpy_k_CORTEXA57,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_CORTEXA57,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_CORTEXA57,
  sgemv_n_CORTEXA57,  sgemv_t_CORTEXA57,
#endif
#if BUILD_SINGLE == 1
  sger_k_CORTEXA57,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_CORTEXA57, ssymv_U_CORTEXA57,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_CORTEXA57,
  sgemm_direct_performant_CORTEXA57,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_CORTEXA57,
  sgemm_direct_alpha_beta_CORTEXA57,
  ssymm_direct_alpha_betaLU_CORTEXA57,
  ssymm_direct_alpha_betaLL_CORTEXA57,
#endif

  sgemm_kernel_CORTEXA57, sgemm_beta_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_CORTEXA57, sgemm_itcopy_CORTEXA57,
#else
  sgemm_oncopy_CORTEXA57, sgemm_otcopy_CORTEXA57,
#endif
  sgemm_oncopy_CORTEXA57, sgemm_otcopy_CORTEXA57,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_CORTEXA57,
  sgemm_small_kernel_nn_CORTEXA57, sgemm_small_kernel_nt_CORTEXA57, sgemm_small_kernel_tn_CORTEXA57, sgemm_small_kernel_tt_CORTEXA57,
  sgemm_small_kernel_b0_nn_CORTEXA57, sgemm_small_kernel_b0_nt_CORTEXA57, sgemm_small_kernel_b0_tn_CORTEXA57, sgemm_small_kernel_b0_tt_CORTEXA57,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_CORTEXA57, strsm_kernel_LT_CORTEXA57, strsm_kernel_RN_CORTEXA57, strsm_kernel_RT_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_CORTEXA57, strsm_iunncopy_CORTEXA57, strsm_iutucopy_CORTEXA57, strsm_iutncopy_CORTEXA57,
  strsm_ilnucopy_CORTEXA57, strsm_ilnncopy_CORTEXA57, strsm_iltucopy_CORTEXA57, strsm_iltncopy_CORTEXA57,
#else
  strsm_ounucopy_CORTEXA57, strsm_ounncopy_CORTEXA57, strsm_outucopy_CORTEXA57, strsm_outncopy_CORTEXA57,
  strsm_olnucopy_CORTEXA57, strsm_olnncopy_CORTEXA57, strsm_oltucopy_CORTEXA57, strsm_oltncopy_CORTEXA57,
#endif
  strsm_ounucopy_CORTEXA57, strsm_ounncopy_CORTEXA57, strsm_outucopy_CORTEXA57, strsm_outncopy_CORTEXA57,
  strsm_olnucopy_CORTEXA57, strsm_olnncopy_CORTEXA57, strsm_oltucopy_CORTEXA57, strsm_oltncopy_CORTEXA57,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_CORTEXA57, strmm_kernel_RT_CORTEXA57, strmm_kernel_LN_CORTEXA57, strmm_kernel_LT_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_CORTEXA57, strmm_iunncopy_CORTEXA57, strmm_iutucopy_CORTEXA57, strmm_iutncopy_CORTEXA57,
  strmm_ilnucopy_CORTEXA57, strmm_ilnncopy_CORTEXA57, strmm_iltucopy_CORTEXA57, strmm_iltncopy_CORTEXA57,
#else
  strmm_ounucopy_CORTEXA57, strmm_ounncopy_CORTEXA57, strmm_outucopy_CORTEXA57, strmm_outncopy_CORTEXA57,
  strmm_olnucopy_CORTEXA57, strmm_olnncopy_CORTEXA57, strmm_oltucopy_CORTEXA57, strmm_oltncopy_CORTEXA57,
#endif
  strmm_ounucopy_CORTEXA57, strmm_ounncopy_CORTEXA57, strmm_outucopy_CORTEXA57, strmm_outncopy_CORTEXA57,
  strmm_olnucopy_CORTEXA57, strmm_olnncopy_CORTEXA57, strmm_oltucopy_CORTEXA57, strmm_oltncopy_CORTEXA57,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_CORTEXA57, ssymm_iltcopy_CORTEXA57,
#else
  ssymm_outcopy_CORTEXA57, ssymm_oltcopy_CORTEXA57,
#endif
  ssymm_outcopy_CORTEXA57, ssymm_oltcopy_CORTEXA57,
#ifndef NO_LAPACK
  sneg_tcopy_CORTEXA57, slaswp_ncopy_CORTEXA57,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_CORTEXA57,  damin_k_CORTEXA57,  dmax_k_CORTEXA57,  dmin_k_CORTEXA57,
  idamax_k_CORTEXA57, idamin_k_CORTEXA57, idmax_k_CORTEXA57, idmin_k_CORTEXA57,
  dnrm2_k_CORTEXA57, dasum_k_CORTEXA57,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_CORTEXA57,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_CORTEXA57, ddot_k_CORTEXA57,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_CORTEXA57,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_CORTEXA57,
  drotm_k_CORTEXA57,
  daxpy_k_CORTEXA57,
  dscal_k_CORTEXA57, 
  dswap_k_CORTEXA57,
  dgemv_n_CORTEXA57,  dgemv_t_CORTEXA57,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_CORTEXA57,
  dsymv_L_CORTEXA57,  dsymv_U_CORTEXA57,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_CORTEXA57, dgemm_beta_CORTEXA57,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_CORTEXA57, dgemm_itcopy_CORTEXA57,
#else
  dgemm_oncopy_CORTEXA57, dgemm_otcopy_CORTEXA57,
#endif
  dgemm_oncopy_CORTEXA57, dgemm_otcopy_CORTEXA57,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_CORTEXA57,
  dgemm_small_kernel_nn_CORTEXA57, dgemm_small_kernel_nt_CORTEXA57, dgemm_small_kernel_tn_CORTEXA57, dgemm_small_kernel_tt_CORTEXA57,
  dgemm_small_kernel_b0_nn_CORTEXA57, dgemm_small_kernel_b0_nt_CORTEXA57, dgemm_small_kernel_b0_tn_CORTEXA57, dgemm_small_kernel_b0_tt_CORTEXA57,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_CORTEXA57, dtrsm_kernel_LT_CORTEXA57, dtrsm_kernel_RN_CORTEXA57, dtrsm_kernel_RT_CORTEXA57,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_CORTEXA57, dtrsm_iunncopy_CORTEXA57, dtrsm_iutucopy_CORTEXA57, dtrsm_iutncopy_CORTEXA57,
  dtrsm_ilnucopy_CORTEXA57, dtrsm_ilnncopy_CORTEXA57, dtrsm_iltucopy_CORTEXA57, dtrsm_iltncopy_CORTEXA57,
#else
  dtrsm_ounucopy_CORTEXA57, dtrsm_ounncopy_CORTEXA57, dtrsm_outucopy_CORTEXA57, dtrsm_outncopy_CORTEXA57,
  dtrsm_olnucopy_CORTEXA57, dtrsm_olnncopy_CORTEXA57, dtrsm_oltucopy_CORTEXA57, dtrsm_oltncopy_CORTEXA57,
#endif
  dtrsm_ounucopy_CORTEXA57, dtrsm_ounncopy_CORTEXA57, dtrsm_outucopy_CORTEXA57, dtrsm_outncopy_CORTEXA57,
  dtrsm_olnucopy_CORTEXA57, dtrsm_olnncopy_CORTEXA57, dtrsm_oltucopy_CORTEXA57, dtrsm_oltncopy_CORTEXA57,
  dtrmm_kernel_RN_CORTEXA57, dtrmm_kernel_RT_CORTEXA57, dtrmm_kernel_LN_CORTEXA57, dtrmm_kernel_LT_CORTEXA57,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_CORTEXA57, dtrmm_iunncopy_CORTEXA57, dtrmm_iutucopy_CORTEXA57, dtrmm_iutncopy_CORTEXA57,
  dtrmm_ilnucopy_CORTEXA57, dtrmm_ilnncopy_CORTEXA57, dtrmm_iltucopy_CORTEXA57, dtrmm_iltncopy_CORTEXA57,
#else
  dtrmm_ounucopy_CORTEXA57, dtrmm_ounncopy_CORTEXA57, dtrmm_outucopy_CORTEXA57, dtrmm_outncopy_CORTEXA57,
  dtrmm_olnucopy_CORTEXA57, dtrmm_olnncopy_CORTEXA57, dtrmm_oltucopy_CORTEXA57, dtrmm_oltncopy_CORTEXA57,
#endif
  dtrmm_ounucopy_CORTEXA57, dtrmm_ounncopy_CORTEXA57, dtrmm_outucopy_CORTEXA57, dtrmm_outncopy_CORTEXA57,
  dtrmm_olnucopy_CORTEXA57, dtrmm_olnncopy_CORTEXA57, dtrmm_oltucopy_CORTEXA57, dtrmm_oltncopy_CORTEXA57,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_CORTEXA57, dsymm_iltcopy_CORTEXA57,
#else
  dsymm_outcopy_CORTEXA57, dsymm_oltcopy_CORTEXA57,
#endif
  dsymm_outcopy_CORTEXA57, dsymm_oltcopy_CORTEXA57,

#ifndef NO_LAPACK
  dneg_tcopy_CORTEXA57, dlaswp_ncopy_CORTEXA57,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_CORTEXA57,  qamin_k_CORTEXA57,  qmax_k_CORTEXA57,  qmin_k_CORTEXA57,
  iqamax_k_CORTEXA57, iqamin_k_CORTEXA57, iqmax_k_CORTEXA57, iqmin_k_CORTEXA57,
  qnrm2_k_CORTEXA57,  qasum_k_CORTEXA57,  qsum_k_CORTEXA57, qcopy_k_CORTEXA57, qdot_k_CORTEXA57,
  qrot_k_CORTEXA57,   qrotm_k_CORTEXA57,  qaxpy_k_CORTEXA57,  qscal_k_CORTEXA57, qswap_k_CORTEXA57,
  qgemv_n_CORTEXA57,  qgemv_t_CORTEXA57,  qger_k_CORTEXA57,
  qsymv_L_CORTEXA57,  qsymv_U_CORTEXA57,
  qgemm_kernel_CORTEXA57, qgemm_beta_CORTEXA57,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_CORTEXA57, qgemm_itcopy_CORTEXA57,
#else
  qgemm_oncopy_CORTEXA57, qgemm_otcopy_CORTEXA57,
#endif
  qgemm_oncopy_CORTEXA57, qgemm_otcopy_CORTEXA57,
  qtrsm_kernel_LN_CORTEXA57, qtrsm_kernel_LT_CORTEXA57, qtrsm_kernel_RN_CORTEXA57, qtrsm_kernel_RT_CORTEXA57,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_CORTEXA57, qtrsm_iunncopy_CORTEXA57, qtrsm_iutucopy_CORTEXA57, qtrsm_iutncopy_CORTEXA57,
  qtrsm_ilnucopy_CORTEXA57, qtrsm_ilnncopy_CORTEXA57, qtrsm_iltucopy_CORTEXA57, qtrsm_iltncopy_CORTEXA57,
#else
  qtrsm_ounucopy_CORTEXA57, qtrsm_ounncopy_CORTEXA57, qtrsm_outucopy_CORTEXA57, qtrsm_outncopy_CORTEXA57,
  qtrsm_olnucopy_CORTEXA57, qtrsm_olnncopy_CORTEXA57, qtrsm_oltucopy_CORTEXA57, qtrsm_oltncopy_CORTEXA57,
#endif
  qtrsm_ounucopy_CORTEXA57, qtrsm_ounncopy_CORTEXA57, qtrsm_outucopy_CORTEXA57, qtrsm_outncopy_CORTEXA57,
  qtrsm_olnucopy_CORTEXA57, qtrsm_olnncopy_CORTEXA57, qtrsm_oltucopy_CORTEXA57, qtrsm_oltncopy_CORTEXA57,
  qtrmm_kernel_RN_CORTEXA57, qtrmm_kernel_RT_CORTEXA57, qtrmm_kernel_LN_CORTEXA57, qtrmm_kernel_LT_CORTEXA57,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_CORTEXA57, qtrmm_iunncopy_CORTEXA57, qtrmm_iutucopy_CORTEXA57, qtrmm_iutncopy_CORTEXA57,
  qtrmm_ilnucopy_CORTEXA57, qtrmm_ilnncopy_CORTEXA57, qtrmm_iltucopy_CORTEXA57, qtrmm_iltncopy_CORTEXA57,
#else
  qtrmm_ounucopy_CORTEXA57, qtrmm_ounncopy_CORTEXA57, qtrmm_outucopy_CORTEXA57, qtrmm_outncopy_CORTEXA57,
  qtrmm_olnucopy_CORTEXA57, qtrmm_olnncopy_CORTEXA57, qtrmm_oltucopy_CORTEXA57, qtrmm_oltncopy_CORTEXA57,
#endif
  qtrmm_ounucopy_CORTEXA57, qtrmm_ounncopy_CORTEXA57, qtrmm_outucopy_CORTEXA57, qtrmm_outncopy_CORTEXA57,
  qtrmm_olnucopy_CORTEXA57, qtrmm_olnncopy_CORTEXA57, qtrmm_oltucopy_CORTEXA57, qtrmm_oltncopy_CORTEXA57,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_CORTEXA57, qsymm_iltcopy_CORTEXA57,
#else
  qsymm_outcopy_CORTEXA57, qsymm_oltcopy_CORTEXA57,
#endif
  qsymm_outcopy_CORTEXA57, qsymm_oltcopy_CORTEXA57,

#ifndef NO_LAPACK
  qneg_tcopy_CORTEXA57, qlaswp_ncopy_CORTEXA57,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_CORTEXA57, camin_k_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
  icamax_k_CORTEXA57, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_CORTEXA57,
  cnrm2_k_CORTEXA57, casum_k_CORTEXA57, csum_k_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_CORTEXA57, cdotu_k_CORTEXA57, cdotc_k_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
 csrot_k_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_CORTEXA57,
  caxpyc_k_CORTEXA57, 
  cscal_k_CORTEXA57, 
  cswap_k_CORTEXA57,

  cgemv_n_CORTEXA57, cgemv_t_CORTEXA57, cgemv_r_CORTEXA57, cgemv_c_CORTEXA57,
  cgemv_o_CORTEXA57, cgemv_u_CORTEXA57, cgemv_s_CORTEXA57, cgemv_d_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_CORTEXA57, cgerc_k_CORTEXA57, cgerv_k_CORTEXA57, cgerd_k_CORTEXA57,
  csymv_L_CORTEXA57, csymv_U_CORTEXA57,
  chemv_L_CORTEXA57, chemv_U_CORTEXA57, chemv_M_CORTEXA57, chemv_V_CORTEXA57,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_CORTEXA57, cgemm_kernel_l_CORTEXA57, cgemm_kernel_r_CORTEXA57, cgemm_kernel_b_CORTEXA57,
  cgemm_beta_CORTEXA57,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_CORTEXA57, cgemm_itcopy_CORTEXA57,
#else
  cgemm_oncopy_CORTEXA57, cgemm_otcopy_CORTEXA57,
#endif
  cgemm_oncopy_CORTEXA57, cgemm_otcopy_CORTEXA57,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_CORTEXA57,
  cgemm_small_kernel_nn_CORTEXA57, cgemm_small_kernel_nt_CORTEXA57, cgemm_small_kernel_nr_CORTEXA57, cgemm_small_kernel_nc_CORTEXA57,
  cgemm_small_kernel_tn_CORTEXA57, cgemm_small_kernel_tt_CORTEXA57, cgemm_small_kernel_tr_CORTEXA57, cgemm_small_kernel_tc_CORTEXA57,
  cgemm_small_kernel_rn_CORTEXA57, cgemm_small_kernel_rt_CORTEXA57, cgemm_small_kernel_rr_CORTEXA57, cgemm_small_kernel_rc_CORTEXA57,
  cgemm_small_kernel_cn_CORTEXA57, cgemm_small_kernel_ct_CORTEXA57, cgemm_small_kernel_cr_CORTEXA57, cgemm_small_kernel_cc_CORTEXA57,
  cgemm_small_kernel_b0_nn_CORTEXA57, cgemm_small_kernel_b0_nt_CORTEXA57, cgemm_small_kernel_b0_nr_CORTEXA57, cgemm_small_kernel_b0_nc_CORTEXA57,
  cgemm_small_kernel_b0_tn_CORTEXA57, cgemm_small_kernel_b0_tt_CORTEXA57, cgemm_small_kernel_b0_tr_CORTEXA57, cgemm_small_kernel_b0_tc_CORTEXA57,
  cgemm_small_kernel_b0_rn_CORTEXA57, cgemm_small_kernel_b0_rt_CORTEXA57, cgemm_small_kernel_b0_rr_CORTEXA57, cgemm_small_kernel_b0_rc_CORTEXA57,
  cgemm_small_kernel_b0_cn_CORTEXA57, cgemm_small_kernel_b0_ct_CORTEXA57, cgemm_small_kernel_b0_cr_CORTEXA57, cgemm_small_kernel_b0_cc_CORTEXA57,
#endif

  ctrsm_kernel_LN_CORTEXA57, ctrsm_kernel_LT_CORTEXA57, ctrsm_kernel_LR_CORTEXA57, ctrsm_kernel_LC_CORTEXA57,
  ctrsm_kernel_RN_CORTEXA57, ctrsm_kernel_RT_CORTEXA57, ctrsm_kernel_RR_CORTEXA57, ctrsm_kernel_RC_CORTEXA57,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_CORTEXA57,  ctrsm_iunncopy_CORTEXA57,  ctrsm_iutucopy_CORTEXA57,  ctrsm_iutncopy_CORTEXA57,
  ctrsm_ilnucopy_CORTEXA57,  ctrsm_ilnncopy_CORTEXA57,  ctrsm_iltucopy_CORTEXA57,  ctrsm_iltncopy_CORTEXA57,
#else
  ctrsm_ounucopy_CORTEXA57,  ctrsm_ounncopy_CORTEXA57,  ctrsm_outucopy_CORTEXA57,  ctrsm_outncopy_CORTEXA57,
  ctrsm_olnucopy_CORTEXA57,  ctrsm_olnncopy_CORTEXA57,  ctrsm_oltucopy_CORTEXA57,  ctrsm_oltncopy_CORTEXA57,
#endif
  ctrsm_ounucopy_CORTEXA57,  ctrsm_ounncopy_CORTEXA57,  ctrsm_outucopy_CORTEXA57,  ctrsm_outncopy_CORTEXA57,
  ctrsm_olnucopy_CORTEXA57,  ctrsm_olnncopy_CORTEXA57,  ctrsm_oltucopy_CORTEXA57,  ctrsm_oltncopy_CORTEXA57,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_CORTEXA57,  ctrmm_kernel_RT_CORTEXA57,  ctrmm_kernel_RR_CORTEXA57,  ctrmm_kernel_RC_CORTEXA57,
  ctrmm_kernel_LN_CORTEXA57,  ctrmm_kernel_LT_CORTEXA57,  ctrmm_kernel_LR_CORTEXA57,  ctrmm_kernel_LC_CORTEXA57,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_CORTEXA57,  ctrmm_iunncopy_CORTEXA57,  ctrmm_iutucopy_CORTEXA57,  ctrmm_iutncopy_CORTEXA57,
  ctrmm_ilnucopy_CORTEXA57,  ctrmm_ilnncopy_CORTEXA57,  ctrmm_iltucopy_CORTEXA57,  ctrmm_iltncopy_CORTEXA57,
#else
  ctrmm_ounucopy_CORTEXA57,  ctrmm_ounncopy_CORTEXA57,  ctrmm_outucopy_CORTEXA57,  ctrmm_outncopy_CORTEXA57,
  ctrmm_olnucopy_CORTEXA57,  ctrmm_olnncopy_CORTEXA57,  ctrmm_oltucopy_CORTEXA57,  ctrmm_oltncopy_CORTEXA57,
#endif
  ctrmm_ounucopy_CORTEXA57,  ctrmm_ounncopy_CORTEXA57,  ctrmm_outucopy_CORTEXA57,  ctrmm_outncopy_CORTEXA57,
  ctrmm_olnucopy_CORTEXA57,  ctrmm_olnncopy_CORTEXA57,  ctrmm_oltucopy_CORTEXA57,  ctrmm_oltncopy_CORTEXA57,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_CORTEXA57,  csymm_iltcopy_CORTEXA57,
#else
  csymm_outcopy_CORTEXA57,  csymm_oltcopy_CORTEXA57,
#endif
  csymm_outcopy_CORTEXA57,  csymm_oltcopy_CORTEXA57,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_CORTEXA57,  chemm_iltcopy_CORTEXA57,
#else
  chemm_outcopy_CORTEXA57,  chemm_oltcopy_CORTEXA57,
#endif
  chemm_outcopy_CORTEXA57,  chemm_oltcopy_CORTEXA57,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_CORTEXA57,

  cgemm3m_incopyb_CORTEXA57,  cgemm3m_incopyr_CORTEXA57,
  cgemm3m_incopyi_CORTEXA57,  cgemm3m_itcopyb_CORTEXA57,
  cgemm3m_itcopyr_CORTEXA57,  cgemm3m_itcopyi_CORTEXA57,
  cgemm3m_oncopyb_CORTEXA57,  cgemm3m_oncopyr_CORTEXA57,
  cgemm3m_oncopyi_CORTEXA57,  cgemm3m_otcopyb_CORTEXA57,
  cgemm3m_otcopyr_CORTEXA57,  cgemm3m_otcopyi_CORTEXA57,

  csymm3m_iucopyb_CORTEXA57,  csymm3m_ilcopyb_CORTEXA57,
  csymm3m_iucopyr_CORTEXA57,  csymm3m_ilcopyr_CORTEXA57,
  csymm3m_iucopyi_CORTEXA57,  csymm3m_ilcopyi_CORTEXA57,
  csymm3m_oucopyb_CORTEXA57,  csymm3m_olcopyb_CORTEXA57,
  csymm3m_oucopyr_CORTEXA57,  csymm3m_olcopyr_CORTEXA57,
  csymm3m_oucopyi_CORTEXA57,  csymm3m_olcopyi_CORTEXA57,

  chemm3m_iucopyb_CORTEXA57,  chemm3m_ilcopyb_CORTEXA57,
  chemm3m_iucopyr_CORTEXA57,  chemm3m_ilcopyr_CORTEXA57,
  chemm3m_iucopyi_CORTEXA57,  chemm3m_ilcopyi_CORTEXA57,

  chemm3m_oucopyb_CORTEXA57,  chemm3m_olcopyb_CORTEXA57,
  chemm3m_oucopyr_CORTEXA57,  chemm3m_olcopyr_CORTEXA57,
  chemm3m_oucopyi_CORTEXA57,  chemm3m_olcopyi_CORTEXA57,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_CORTEXA57,
  
   claswp_ncopy_CORTEXA57,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_CORTEXA57, zamin_k_CORTEXA57, izamax_k_CORTEXA57, izamin_k_CORTEXA57,
  znrm2_k_CORTEXA57, zasum_k_CORTEXA57, zsum_k_CORTEXA57, zcopy_k_CORTEXA57,
  zdotu_k_CORTEXA57, zdotc_k_CORTEXA57, zdrot_k_CORTEXA57,
  zaxpy_k_CORTEXA57, zaxpyc_k_CORTEXA57, zscal_k_CORTEXA57, zswap_k_CORTEXA57,

  zgemv_n_CORTEXA57, zgemv_t_CORTEXA57, zgemv_r_CORTEXA57, zgemv_c_CORTEXA57,
  zgemv_o_CORTEXA57, zgemv_u_CORTEXA57, zgemv_s_CORTEXA57, zgemv_d_CORTEXA57,
  zgeru_k_CORTEXA57, zgerc_k_CORTEXA57, zgerv_k_CORTEXA57, zgerd_k_CORTEXA57,
  zsymv_L_CORTEXA57, zsymv_U_CORTEXA57,
  zhemv_L_CORTEXA57, zhemv_U_CORTEXA57, zhemv_M_CORTEXA57, zhemv_V_CORTEXA57,

  zgemm_kernel_n_CORTEXA57, zgemm_kernel_l_CORTEXA57, zgemm_kernel_r_CORTEXA57, zgemm_kernel_b_CORTEXA57,
  zgemm_beta_CORTEXA57,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_CORTEXA57, zgemm_itcopy_CORTEXA57,
#else
  zgemm_oncopy_CORTEXA57, zgemm_otcopy_CORTEXA57,
#endif
  zgemm_oncopy_CORTEXA57, zgemm_otcopy_CORTEXA57,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_CORTEXA57,
  zgemm_small_kernel_nn_CORTEXA57, zgemm_small_kernel_nt_CORTEXA57, zgemm_small_kernel_nr_CORTEXA57, zgemm_small_kernel_nc_CORTEXA57,
  zgemm_small_kernel_tn_CORTEXA57, zgemm_small_kernel_tt_CORTEXA57, zgemm_small_kernel_tr_CORTEXA57, zgemm_small_kernel_tc_CORTEXA57,
  zgemm_small_kernel_rn_CORTEXA57, zgemm_small_kernel_rt_CORTEXA57, zgemm_small_kernel_rr_CORTEXA57, zgemm_small_kernel_rc_CORTEXA57,
  zgemm_small_kernel_cn_CORTEXA57, zgemm_small_kernel_ct_CORTEXA57, zgemm_small_kernel_cr_CORTEXA57, zgemm_small_kernel_cc_CORTEXA57,
  zgemm_small_kernel_b0_nn_CORTEXA57, zgemm_small_kernel_b0_nt_CORTEXA57, zgemm_small_kernel_b0_nr_CORTEXA57, zgemm_small_kernel_b0_nc_CORTEXA57,
  zgemm_small_kernel_b0_tn_CORTEXA57, zgemm_small_kernel_b0_tt_CORTEXA57, zgemm_small_kernel_b0_tr_CORTEXA57, zgemm_small_kernel_b0_tc_CORTEXA57,
  zgemm_small_kernel_b0_rn_CORTEXA57, zgemm_small_kernel_b0_rt_CORTEXA57, zgemm_small_kernel_b0_rr_CORTEXA57, zgemm_small_kernel_b0_rc_CORTEXA57,
  zgemm_small_kernel_b0_cn_CORTEXA57, zgemm_small_kernel_b0_ct_CORTEXA57, zgemm_small_kernel_b0_cr_CORTEXA57, zgemm_small_kernel_b0_cc_CORTEXA57,
#endif

  ztrsm_kernel_LN_CORTEXA57, ztrsm_kernel_LT_CORTEXA57, ztrsm_kernel_LR_CORTEXA57, ztrsm_kernel_LC_CORTEXA57,
  ztrsm_kernel_RN_CORTEXA57, ztrsm_kernel_RT_CORTEXA57, ztrsm_kernel_RR_CORTEXA57, ztrsm_kernel_RC_CORTEXA57,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_CORTEXA57,  ztrsm_iunncopy_CORTEXA57,  ztrsm_iutucopy_CORTEXA57,  ztrsm_iutncopy_CORTEXA57,
  ztrsm_ilnucopy_CORTEXA57,  ztrsm_ilnncopy_CORTEXA57,  ztrsm_iltucopy_CORTEXA57,  ztrsm_iltncopy_CORTEXA57,
#else
  ztrsm_ounucopy_CORTEXA57,  ztrsm_ounncopy_CORTEXA57,  ztrsm_outucopy_CORTEXA57,  ztrsm_outncopy_CORTEXA57,
  ztrsm_olnucopy_CORTEXA57,  ztrsm_olnncopy_CORTEXA57,  ztrsm_oltucopy_CORTEXA57,  ztrsm_oltncopy_CORTEXA57,
#endif
  ztrsm_ounucopy_CORTEXA57,  ztrsm_ounncopy_CORTEXA57,  ztrsm_outucopy_CORTEXA57,  ztrsm_outncopy_CORTEXA57,
  ztrsm_olnucopy_CORTEXA57,  ztrsm_olnncopy_CORTEXA57,  ztrsm_oltucopy_CORTEXA57,  ztrsm_oltncopy_CORTEXA57,

  ztrmm_kernel_RN_CORTEXA57,  ztrmm_kernel_RT_CORTEXA57,  ztrmm_kernel_RR_CORTEXA57,  ztrmm_kernel_RC_CORTEXA57,
  ztrmm_kernel_LN_CORTEXA57,  ztrmm_kernel_LT_CORTEXA57,  ztrmm_kernel_LR_CORTEXA57,  ztrmm_kernel_LC_CORTEXA57,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_CORTEXA57,  ztrmm_iunncopy_CORTEXA57,  ztrmm_iutucopy_CORTEXA57,  ztrmm_iutncopy_CORTEXA57,
  ztrmm_ilnucopy_CORTEXA57,  ztrmm_ilnncopy_CORTEXA57,  ztrmm_iltucopy_CORTEXA57,  ztrmm_iltncopy_CORTEXA57,
#else
  ztrmm_ounucopy_CORTEXA57,  ztrmm_ounncopy_CORTEXA57,  ztrmm_outucopy_CORTEXA57,  ztrmm_outncopy_CORTEXA57,
  ztrmm_olnucopy_CORTEXA57,  ztrmm_olnncopy_CORTEXA57,  ztrmm_oltucopy_CORTEXA57,  ztrmm_oltncopy_CORTEXA57,
#endif
  ztrmm_ounucopy_CORTEXA57,  ztrmm_ounncopy_CORTEXA57,  ztrmm_outucopy_CORTEXA57,  ztrmm_outncopy_CORTEXA57,
  ztrmm_olnucopy_CORTEXA57,  ztrmm_olnncopy_CORTEXA57,  ztrmm_oltucopy_CORTEXA57,  ztrmm_oltncopy_CORTEXA57,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_CORTEXA57,  zsymm_iltcopy_CORTEXA57,
#else
  zsymm_outcopy_CORTEXA57,  zsymm_oltcopy_CORTEXA57,
#endif
  zsymm_outcopy_CORTEXA57,  zsymm_oltcopy_CORTEXA57,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_CORTEXA57,  zhemm_iltcopy_CORTEXA57,
#else
  zhemm_outcopy_CORTEXA57,  zhemm_oltcopy_CORTEXA57,
#endif
  zhemm_outcopy_CORTEXA57,  zhemm_oltcopy_CORTEXA57,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_CORTEXA57,

  zgemm3m_incopyb_CORTEXA57,  zgemm3m_incopyr_CORTEXA57,
  zgemm3m_incopyi_CORTEXA57,  zgemm3m_itcopyb_CORTEXA57,
  zgemm3m_itcopyr_CORTEXA57,  zgemm3m_itcopyi_CORTEXA57,
  zgemm3m_oncopyb_CORTEXA57,  zgemm3m_oncopyr_CORTEXA57,
  zgemm3m_oncopyi_CORTEXA57,  zgemm3m_otcopyb_CORTEXA57,
  zgemm3m_otcopyr_CORTEXA57,  zgemm3m_otcopyi_CORTEXA57,

  zsymm3m_iucopyb_CORTEXA57,  zsymm3m_ilcopyb_CORTEXA57,
  zsymm3m_iucopyr_CORTEXA57,  zsymm3m_ilcopyr_CORTEXA57,
  zsymm3m_iucopyi_CORTEXA57,  zsymm3m_ilcopyi_CORTEXA57,
  zsymm3m_oucopyb_CORTEXA57,  zsymm3m_olcopyb_CORTEXA57,
  zsymm3m_oucopyr_CORTEXA57,  zsymm3m_olcopyr_CORTEXA57,
  zsymm3m_oucopyi_CORTEXA57,  zsymm3m_olcopyi_CORTEXA57,

  zhemm3m_iucopyb_CORTEXA57,  zhemm3m_ilcopyb_CORTEXA57,
  zhemm3m_iucopyr_CORTEXA57,  zhemm3m_ilcopyr_CORTEXA57,
  zhemm3m_iucopyi_CORTEXA57,  zhemm3m_ilcopyi_CORTEXA57,

  zhemm3m_oucopyb_CORTEXA57,  zhemm3m_olcopyb_CORTEXA57,
  zhemm3m_oucopyr_CORTEXA57,  zhemm3m_olcopyr_CORTEXA57,
  zhemm3m_oucopyi_CORTEXA57,  zhemm3m_olcopyi_CORTEXA57,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_CORTEXA57, zlaswp_ncopy_CORTEXA57,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_CORTEXA57, xamin_k_CORTEXA57, ixamax_k_CORTEXA57, ixamin_k_CORTEXA57,
  xnrm2_k_CORTEXA57, xasum_k_CORTEXA57, xsum_k_CORTEXA57, xcopy_k_CORTEXA57,
  xdotu_k_CORTEXA57, xdotc_k_CORTEXA57, xqrot_k_CORTEXA57,
  xaxpy_k_CORTEXA57, xaxpyc_k_CORTEXA57, xscal_k_CORTEXA57, xswap_k_CORTEXA57,

  xgemv_n_CORTEXA57, xgemv_t_CORTEXA57, xgemv_r_CORTEXA57, xgemv_c_CORTEXA57,
  xgemv_o_CORTEXA57, xgemv_u_CORTEXA57, xgemv_s_CORTEXA57, xgemv_d_CORTEXA57,
  xgeru_k_CORTEXA57, xgerc_k_CORTEXA57, xgerv_k_CORTEXA57, xgerd_k_CORTEXA57,
  xsymv_L_CORTEXA57, xsymv_U_CORTEXA57,
  xhemv_L_CORTEXA57, xhemv_U_CORTEXA57, xhemv_M_CORTEXA57, xhemv_V_CORTEXA57,

  xgemm_kernel_n_CORTEXA57, xgemm_kernel_l_CORTEXA57, xgemm_kernel_r_CORTEXA57, xgemm_kernel_b_CORTEXA57,
  xgemm_beta_CORTEXA57,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_CORTEXA57, xgemm_itcopy_CORTEXA57,
#else
  xgemm_oncopy_CORTEXA57, xgemm_otcopy_CORTEXA57,
#endif
  xgemm_oncopy_CORTEXA57, xgemm_otcopy_CORTEXA57,

  xtrsm_kernel_LN_CORTEXA57, xtrsm_kernel_LT_CORTEXA57, xtrsm_kernel_LR_CORTEXA57, xtrsm_kernel_LC_CORTEXA57,
  xtrsm_kernel_RN_CORTEXA57, xtrsm_kernel_RT_CORTEXA57, xtrsm_kernel_RR_CORTEXA57, xtrsm_kernel_RC_CORTEXA57,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_CORTEXA57,  xtrsm_iunncopy_CORTEXA57,  xtrsm_iutucopy_CORTEXA57,  xtrsm_iutncopy_CORTEXA57,
  xtrsm_ilnucopy_CORTEXA57,  xtrsm_ilnncopy_CORTEXA57,  xtrsm_iltucopy_CORTEXA57,  xtrsm_iltncopy_CORTEXA57,
#else
  xtrsm_ounucopy_CORTEXA57,  xtrsm_ounncopy_CORTEXA57,  xtrsm_outucopy_CORTEXA57,  xtrsm_outncopy_CORTEXA57,
  xtrsm_olnucopy_CORTEXA57,  xtrsm_olnncopy_CORTEXA57,  xtrsm_oltucopy_CORTEXA57,  xtrsm_oltncopy_CORTEXA57,
#endif
  xtrsm_ounucopy_CORTEXA57,  xtrsm_ounncopy_CORTEXA57,  xtrsm_outucopy_CORTEXA57,  xtrsm_outncopy_CORTEXA57,
  xtrsm_olnucopy_CORTEXA57,  xtrsm_olnncopy_CORTEXA57,  xtrsm_oltucopy_CORTEXA57,  xtrsm_oltncopy_CORTEXA57,

  xtrmm_kernel_RN_CORTEXA57,  xtrmm_kernel_RT_CORTEXA57,  xtrmm_kernel_RR_CORTEXA57,  xtrmm_kernel_RC_CORTEXA57,
  xtrmm_kernel_LN_CORTEXA57,  xtrmm_kernel_LT_CORTEXA57,  xtrmm_kernel_LR_CORTEXA57,  xtrmm_kernel_LC_CORTEXA57,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_CORTEXA57,  xtrmm_iunncopy_CORTEXA57,  xtrmm_iutucopy_CORTEXA57,  xtrmm_iutncopy_CORTEXA57,
  xtrmm_ilnucopy_CORTEXA57,  xtrmm_ilnncopy_CORTEXA57,  xtrmm_iltucopy_CORTEXA57,  xtrmm_iltncopy_CORTEXA57,
#else
  xtrmm_ounucopy_CORTEXA57,  xtrmm_ounncopy_CORTEXA57,  xtrmm_outucopy_CORTEXA57,  xtrmm_outncopy_CORTEXA57,
  xtrmm_olnucopy_CORTEXA57,  xtrmm_olnncopy_CORTEXA57,  xtrmm_oltucopy_CORTEXA57,  xtrmm_oltncopy_CORTEXA57,
#endif
  xtrmm_ounucopy_CORTEXA57,  xtrmm_ounncopy_CORTEXA57,  xtrmm_outucopy_CORTEXA57,  xtrmm_outncopy_CORTEXA57,
  xtrmm_olnucopy_CORTEXA57,  xtrmm_olnncopy_CORTEXA57,  xtrmm_oltucopy_CORTEXA57,  xtrmm_oltncopy_CORTEXA57,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_CORTEXA57,  xsymm_iltcopy_CORTEXA57,
#else
  xsymm_outcopy_CORTEXA57,  xsymm_oltcopy_CORTEXA57,
#endif
  xsymm_outcopy_CORTEXA57,  xsymm_oltcopy_CORTEXA57,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_CORTEXA57,  xhemm_iltcopy_CORTEXA57,
#else
  xhemm_outcopy_CORTEXA57,  xhemm_oltcopy_CORTEXA57,
#endif
  xhemm_outcopy_CORTEXA57,  xhemm_oltcopy_CORTEXA57,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_CORTEXA57,

  xgemm3m_incopyb_CORTEXA57,  xgemm3m_incopyr_CORTEXA57,
  xgemm3m_incopyi_CORTEXA57,  xgemm3m_itcopyb_CORTEXA57,
  xgemm3m_itcopyr_CORTEXA57,  xgemm3m_itcopyi_CORTEXA57,
  xgemm3m_oncopyb_CORTEXA57,  xgemm3m_oncopyr_CORTEXA57,
  xgemm3m_oncopyi_CORTEXA57,  xgemm3m_otcopyb_CORTEXA57,
  xgemm3m_otcopyr_CORTEXA57,  xgemm3m_otcopyi_CORTEXA57,

  xsymm3m_iucopyb_CORTEXA57,  xsymm3m_ilcopyb_CORTEXA57,
  xsymm3m_iucopyr_CORTEXA57,  xsymm3m_ilcopyr_CORTEXA57,
  xsymm3m_iucopyi_CORTEXA57,  xsymm3m_ilcopyi_CORTEXA57,
  xsymm3m_oucopyb_CORTEXA57,  xsymm3m_olcopyb_CORTEXA57,
  xsymm3m_oucopyr_CORTEXA57,  xsymm3m_olcopyr_CORTEXA57,
  xsymm3m_oucopyi_CORTEXA57,  xsymm3m_olcopyi_CORTEXA57,

  xhemm3m_iucopyb_CORTEXA57,  xhemm3m_ilcopyb_CORTEXA57,
  xhemm3m_iucopyr_CORTEXA57,  xhemm3m_ilcopyr_CORTEXA57,
  xhemm3m_iucopyi_CORTEXA57,  xhemm3m_ilcopyi_CORTEXA57,

  xhemm3m_oucopyb_CORTEXA57,  xhemm3m_olcopyb_CORTEXA57,
  xhemm3m_oucopyr_CORTEXA57,  xhemm3m_olcopyr_CORTEXA57,
  xhemm3m_oucopyi_CORTEXA57,  xhemm3m_olcopyi_CORTEXA57,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_CORTEXA57, xlaswp_ncopy_CORTEXA57,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_CORTEXA57,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_CORTEXA57,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_CORTEXA57,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_CORTEXA57,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_CORTEXA57, somatcopy_k_ct_CORTEXA57, somatcopy_k_rn_CORTEXA57, somatcopy_k_rt_CORTEXA57,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_CORTEXA57, domatcopy_k_ct_CORTEXA57, domatcopy_k_rn_CORTEXA57, domatcopy_k_rt_CORTEXA57,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_CORTEXA57, comatcopy_k_ct_CORTEXA57, comatcopy_k_rn_CORTEXA57, comatcopy_k_rt_CORTEXA57,
  comatcopy_k_cnc_CORTEXA57, comatcopy_k_ctc_CORTEXA57, comatcopy_k_rnc_CORTEXA57, comatcopy_k_rtc_CORTEXA57,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_CORTEXA57, zomatcopy_k_ct_CORTEXA57, zomatcopy_k_rn_CORTEXA57, zomatcopy_k_rt_CORTEXA57,
  zomatcopy_k_cnc_CORTEXA57, zomatcopy_k_ctc_CORTEXA57, zomatcopy_k_rnc_CORTEXA57, zomatcopy_k_rtc_CORTEXA57,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_CORTEXA57, simatcopy_k_ct_CORTEXA57, simatcopy_k_rn_CORTEXA57, simatcopy_k_rt_CORTEXA57,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_CORTEXA57, dimatcopy_k_ct_CORTEXA57, dimatcopy_k_rn_CORTEXA57, dimatcopy_k_rt_CORTEXA57,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_CORTEXA57, cimatcopy_k_ct_CORTEXA57, cimatcopy_k_rn_CORTEXA57, cimatcopy_k_rt_CORTEXA57,
  cimatcopy_k_cnc_CORTEXA57, cimatcopy_k_ctc_CORTEXA57, cimatcopy_k_rnc_CORTEXA57, cimatcopy_k_rtc_CORTEXA57,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_CORTEXA57, zimatcopy_k_ct_CORTEXA57, zimatcopy_k_rn_CORTEXA57, zimatcopy_k_rt_CORTEXA57,
  zimatcopy_k_cnc_CORTEXA57, zimatcopy_k_ctc_CORTEXA57, zimatcopy_k_rnc_CORTEXA57, zimatcopy_k_rtc_CORTEXA57,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_CORTEXA57,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_CORTEXA57,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_CORTEXA57,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_CORTEXA57,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
