/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_EMAG8180;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_EMAG8180.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_EMAG8180, shgemm_beta_EMAG8180,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_EMAG8180, shgemm_itcopy_EMAG8180,
#else
  shgemm_oncopy_EMAG8180, shgemm_otcopy_EMAG8180,
#endif
  shgemm_oncopy_EMAG8180, shgemm_otcopy_EMAG8180,
  shgemv_n_EMAG8180, shgemv_t_EMAG8180,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_EMAG8180, sbdtobf16_k_EMAG8180, sbf16tos_k_EMAG8180, dbf16tod_k_EMAG8180,

  samax_k_EMAG8180,  samin_k_EMAG8180,  smax_k_EMAG8180,  smin_k_EMAG8180,
  isamax_k_EMAG8180, isamin_k_EMAG8180, ismax_k_EMAG8180, ismin_k_EMAG8180,
  snrm2_k_EMAG8180,  sasum_k_EMAG8180,  ssum_k_EMAG8180, scopy_k_EMAG8180, sbdot_k_EMAG8180,
  dsdot_k_EMAG8180,
  srot_k_EMAG8180,   srotm_k_EMAG8180, bscal_k_EMAG8180, saxpy_k_EMAG8180,  sscal_k_EMAG8180, sswap_k_EMAG8180,
  bgemv_n_EMAG8180, bgemv_t_EMAG8180, sbgemv_n_EMAG8180, sbgemv_t_EMAG8180, sger_k_EMAG8180,
  ssymv_L_EMAG8180, ssymv_U_EMAG8180,

  bgemm_kernel_EMAG8180, bgemm_beta_EMAG8180,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_EMAG8180, bgemm_itcopy_EMAG8180,
#else
  bgemm_oncopy_EMAG8180, bgemm_otcopy_EMAG8180,
#endif
  bgemm_oncopy_EMAG8180, bgemm_otcopy_EMAG8180,

  sbgemm_kernel_EMAG8180, sbgemm_beta_EMAG8180,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_EMAG8180, sbgemm_itcopy_EMAG8180,
#else
  sbgemm_oncopy_EMAG8180, sbgemm_otcopy_EMAG8180,
#endif
  sbgemm_oncopy_EMAG8180, sbgemm_otcopy_EMAG8180,

  strsm_kernel_LN_EMAG8180, strsm_kernel_LT_EMAG8180, strsm_kernel_RN_EMAG8180, strsm_kernel_RT_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_EMAG8180, strsm_iunncopy_EMAG8180, strsm_iutucopy_EMAG8180, strsm_iutncopy_EMAG8180,
  strsm_ilnucopy_EMAG8180, strsm_ilnncopy_EMAG8180, strsm_iltucopy_EMAG8180, strsm_iltncopy_EMAG8180,
#else
  strsm_ounucopy_EMAG8180, strsm_ounncopy_EMAG8180, strsm_outucopy_EMAG8180, strsm_outncopy_EMAG8180,
  strsm_olnucopy_EMAG8180, strsm_olnncopy_EMAG8180, strsm_oltucopy_EMAG8180, strsm_oltncopy_EMAG8180,
#endif
  strsm_ounucopy_EMAG8180, strsm_ounncopy_EMAG8180, strsm_outucopy_EMAG8180, strsm_outncopy_EMAG8180,
  strsm_olnucopy_EMAG8180, strsm_olnncopy_EMAG8180, strsm_oltucopy_EMAG8180, strsm_oltncopy_EMAG8180,
  strmm_kernel_RN_EMAG8180, strmm_kernel_RT_EMAG8180, strmm_kernel_LN_EMAG8180, strmm_kernel_LT_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_EMAG8180, strmm_iunncopy_EMAG8180, strmm_iutucopy_EMAG8180, strmm_iutncopy_EMAG8180,
  strmm_ilnucopy_EMAG8180, strmm_ilnncopy_EMAG8180, strmm_iltucopy_EMAG8180, strmm_iltncopy_EMAG8180,
#else
  strmm_ounucopy_EMAG8180, strmm_ounncopy_EMAG8180, strmm_outucopy_EMAG8180, strmm_outncopy_EMAG8180,
  strmm_olnucopy_EMAG8180, strmm_olnncopy_EMAG8180, strmm_oltucopy_EMAG8180, strmm_oltncopy_EMAG8180,
#endif
  strmm_ounucopy_EMAG8180, strmm_ounncopy_EMAG8180, strmm_outucopy_EMAG8180, strmm_outncopy_EMAG8180,
  strmm_olnucopy_EMAG8180, strmm_olnncopy_EMAG8180, strmm_oltucopy_EMAG8180, strmm_oltncopy_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_EMAG8180, ssymm_iltcopy_EMAG8180,
#else
  ssymm_outcopy_EMAG8180, ssymm_oltcopy_EMAG8180,
#endif
  ssymm_outcopy_EMAG8180, ssymm_oltcopy_EMAG8180,

#ifndef NO_LAPACK
  sneg_tcopy_EMAG8180, slaswp_ncopy_EMAG8180,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_EMAG8180,
  sbgemm_small_kernel_nn_EMAG8180, sbgemm_small_kernel_nt_EMAG8180, sbgemm_small_kernel_tn_EMAG8180, sbgemm_small_kernel_tt_EMAG8180,
  sbgemm_small_kernel_b0_nn_EMAG8180, sbgemm_small_kernel_b0_nt_EMAG8180, sbgemm_small_kernel_b0_tn_EMAG8180, sbgemm_small_kernel_b0_tt_EMAG8180,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_EMAG8180,  samin_k_EMAG8180,  smax_k_EMAG8180,  smin_k_EMAG8180,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_EMAG8180,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_EMAG8180, ismax_k_EMAG8180, ismin_k_EMAG8180,
  snrm2_k_EMAG8180,  sasum_k_EMAG8180,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_EMAG8180,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_EMAG8180, sdot_k_EMAG8180,
//  dsdot_k_EMAG8180,
  srot_k_EMAG8180,  srotm_k_EMAG8180,  saxpy_k_EMAG8180,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_EMAG8180,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_EMAG8180,
  sgemv_n_EMAG8180,  sgemv_t_EMAG8180,
#endif
#if BUILD_SINGLE == 1
  sger_k_EMAG8180,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_EMAG8180, ssymv_U_EMAG8180,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_EMAG8180,
  sgemm_direct_performant_EMAG8180,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_EMAG8180,
  sgemm_direct_alpha_beta_EMAG8180,
  ssymm_direct_alpha_betaLU_EMAG8180,
  ssymm_direct_alpha_betaLL_EMAG8180,
  strmm_direct_LNUN_EMAG8180,
  strmm_direct_LNLN_EMAG8180,
  strmm_direct_LTUN_EMAG8180,
  strmm_direct_LTLN_EMAG8180,
  ssyrk_direct_alpha_betaUN_EMAG8180,
  ssyrk_direct_alpha_betaUT_EMAG8180,
  ssyrk_direct_alpha_betaLN_EMAG8180,
  ssyrk_direct_alpha_betaLT_EMAG8180,
  ssyr2k_direct_alpha_betaUN_EMAG8180,
  ssyr2k_direct_alpha_betaUT_EMAG8180,
  ssyr2k_direct_alpha_betaLN_EMAG8180,
  ssyr2k_direct_alpha_betaLT_EMAG8180,
#endif

  sgemm_kernel_EMAG8180, sgemm_beta_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_EMAG8180, sgemm_itcopy_EMAG8180,
#else
  sgemm_oncopy_EMAG8180, sgemm_otcopy_EMAG8180,
#endif
  sgemm_oncopy_EMAG8180, sgemm_otcopy_EMAG8180,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_EMAG8180,
  sgemm_small_kernel_nn_EMAG8180, sgemm_small_kernel_nt_EMAG8180, sgemm_small_kernel_tn_EMAG8180, sgemm_small_kernel_tt_EMAG8180,
  sgemm_small_kernel_b0_nn_EMAG8180, sgemm_small_kernel_b0_nt_EMAG8180, sgemm_small_kernel_b0_tn_EMAG8180, sgemm_small_kernel_b0_tt_EMAG8180,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_EMAG8180, strsm_kernel_LT_EMAG8180, strsm_kernel_RN_EMAG8180, strsm_kernel_RT_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_EMAG8180, strsm_iunncopy_EMAG8180, strsm_iutucopy_EMAG8180, strsm_iutncopy_EMAG8180,
  strsm_ilnucopy_EMAG8180, strsm_ilnncopy_EMAG8180, strsm_iltucopy_EMAG8180, strsm_iltncopy_EMAG8180,
#else
  strsm_ounucopy_EMAG8180, strsm_ounncopy_EMAG8180, strsm_outucopy_EMAG8180, strsm_outncopy_EMAG8180,
  strsm_olnucopy_EMAG8180, strsm_olnncopy_EMAG8180, strsm_oltucopy_EMAG8180, strsm_oltncopy_EMAG8180,
#endif
  strsm_ounucopy_EMAG8180, strsm_ounncopy_EMAG8180, strsm_outucopy_EMAG8180, strsm_outncopy_EMAG8180,
  strsm_olnucopy_EMAG8180, strsm_olnncopy_EMAG8180, strsm_oltucopy_EMAG8180, strsm_oltncopy_EMAG8180,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_EMAG8180, strmm_kernel_RT_EMAG8180, strmm_kernel_LN_EMAG8180, strmm_kernel_LT_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_EMAG8180, strmm_iunncopy_EMAG8180, strmm_iutucopy_EMAG8180, strmm_iutncopy_EMAG8180,
  strmm_ilnucopy_EMAG8180, strmm_ilnncopy_EMAG8180, strmm_iltucopy_EMAG8180, strmm_iltncopy_EMAG8180,
#else
  strmm_ounucopy_EMAG8180, strmm_ounncopy_EMAG8180, strmm_outucopy_EMAG8180, strmm_outncopy_EMAG8180,
  strmm_olnucopy_EMAG8180, strmm_olnncopy_EMAG8180, strmm_oltucopy_EMAG8180, strmm_oltncopy_EMAG8180,
#endif
  strmm_ounucopy_EMAG8180, strmm_ounncopy_EMAG8180, strmm_outucopy_EMAG8180, strmm_outncopy_EMAG8180,
  strmm_olnucopy_EMAG8180, strmm_olnncopy_EMAG8180, strmm_oltucopy_EMAG8180, strmm_oltncopy_EMAG8180,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_EMAG8180, ssymm_iltcopy_EMAG8180,
#else
  ssymm_outcopy_EMAG8180, ssymm_oltcopy_EMAG8180,
#endif
  ssymm_outcopy_EMAG8180, ssymm_oltcopy_EMAG8180,
#ifndef NO_LAPACK
  sneg_tcopy_EMAG8180, slaswp_ncopy_EMAG8180,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_EMAG8180,  damin_k_EMAG8180,  dmax_k_EMAG8180,  dmin_k_EMAG8180,
  idamax_k_EMAG8180, idamin_k_EMAG8180, idmax_k_EMAG8180, idmin_k_EMAG8180,
  dnrm2_k_EMAG8180, dasum_k_EMAG8180,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_EMAG8180,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_EMAG8180, ddot_k_EMAG8180,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_EMAG8180,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_EMAG8180,
  drotm_k_EMAG8180,
  daxpy_k_EMAG8180,
  dscal_k_EMAG8180, 
  dswap_k_EMAG8180,
  dgemv_n_EMAG8180,  dgemv_t_EMAG8180,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_EMAG8180,
  dsymv_L_EMAG8180,  dsymv_U_EMAG8180,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_EMAG8180, dgemm_beta_EMAG8180,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_EMAG8180, dgemm_itcopy_EMAG8180,
#else
  dgemm_oncopy_EMAG8180, dgemm_otcopy_EMAG8180,
#endif
  dgemm_oncopy_EMAG8180, dgemm_otcopy_EMAG8180,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_EMAG8180,
  dgemm_small_kernel_nn_EMAG8180, dgemm_small_kernel_nt_EMAG8180, dgemm_small_kernel_tn_EMAG8180, dgemm_small_kernel_tt_EMAG8180,
  dgemm_small_kernel_b0_nn_EMAG8180, dgemm_small_kernel_b0_nt_EMAG8180, dgemm_small_kernel_b0_tn_EMAG8180, dgemm_small_kernel_b0_tt_EMAG8180,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_EMAG8180, dtrsm_kernel_LT_EMAG8180, dtrsm_kernel_RN_EMAG8180, dtrsm_kernel_RT_EMAG8180,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_EMAG8180, dtrsm_iunncopy_EMAG8180, dtrsm_iutucopy_EMAG8180, dtrsm_iutncopy_EMAG8180,
  dtrsm_ilnucopy_EMAG8180, dtrsm_ilnncopy_EMAG8180, dtrsm_iltucopy_EMAG8180, dtrsm_iltncopy_EMAG8180,
#else
  dtrsm_ounucopy_EMAG8180, dtrsm_ounncopy_EMAG8180, dtrsm_outucopy_EMAG8180, dtrsm_outncopy_EMAG8180,
  dtrsm_olnucopy_EMAG8180, dtrsm_olnncopy_EMAG8180, dtrsm_oltucopy_EMAG8180, dtrsm_oltncopy_EMAG8180,
#endif
  dtrsm_ounucopy_EMAG8180, dtrsm_ounncopy_EMAG8180, dtrsm_outucopy_EMAG8180, dtrsm_outncopy_EMAG8180,
  dtrsm_olnucopy_EMAG8180, dtrsm_olnncopy_EMAG8180, dtrsm_oltucopy_EMAG8180, dtrsm_oltncopy_EMAG8180,
  dtrmm_kernel_RN_EMAG8180, dtrmm_kernel_RT_EMAG8180, dtrmm_kernel_LN_EMAG8180, dtrmm_kernel_LT_EMAG8180,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_EMAG8180, dtrmm_iunncopy_EMAG8180, dtrmm_iutucopy_EMAG8180, dtrmm_iutncopy_EMAG8180,
  dtrmm_ilnucopy_EMAG8180, dtrmm_ilnncopy_EMAG8180, dtrmm_iltucopy_EMAG8180, dtrmm_iltncopy_EMAG8180,
#else
  dtrmm_ounucopy_EMAG8180, dtrmm_ounncopy_EMAG8180, dtrmm_outucopy_EMAG8180, dtrmm_outncopy_EMAG8180,
  dtrmm_olnucopy_EMAG8180, dtrmm_olnncopy_EMAG8180, dtrmm_oltucopy_EMAG8180, dtrmm_oltncopy_EMAG8180,
#endif
  dtrmm_ounucopy_EMAG8180, dtrmm_ounncopy_EMAG8180, dtrmm_outucopy_EMAG8180, dtrmm_outncopy_EMAG8180,
  dtrmm_olnucopy_EMAG8180, dtrmm_olnncopy_EMAG8180, dtrmm_oltucopy_EMAG8180, dtrmm_oltncopy_EMAG8180,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_EMAG8180, dsymm_iltcopy_EMAG8180,
#else
  dsymm_outcopy_EMAG8180, dsymm_oltcopy_EMAG8180,
#endif
  dsymm_outcopy_EMAG8180, dsymm_oltcopy_EMAG8180,

#ifndef NO_LAPACK
  dneg_tcopy_EMAG8180, dlaswp_ncopy_EMAG8180,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_EMAG8180,  qamin_k_EMAG8180,  qmax_k_EMAG8180,  qmin_k_EMAG8180,
  iqamax_k_EMAG8180, iqamin_k_EMAG8180, iqmax_k_EMAG8180, iqmin_k_EMAG8180,
  qnrm2_k_EMAG8180,  qasum_k_EMAG8180,  qsum_k_EMAG8180, qcopy_k_EMAG8180, qdot_k_EMAG8180,
  qrot_k_EMAG8180,   qrotm_k_EMAG8180,  qaxpy_k_EMAG8180,  qscal_k_EMAG8180, qswap_k_EMAG8180,
  qgemv_n_EMAG8180,  qgemv_t_EMAG8180,  qger_k_EMAG8180,
  qsymv_L_EMAG8180,  qsymv_U_EMAG8180,
  qgemm_kernel_EMAG8180, qgemm_beta_EMAG8180,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_EMAG8180, qgemm_itcopy_EMAG8180,
#else
  qgemm_oncopy_EMAG8180, qgemm_otcopy_EMAG8180,
#endif
  qgemm_oncopy_EMAG8180, qgemm_otcopy_EMAG8180,
  qtrsm_kernel_LN_EMAG8180, qtrsm_kernel_LT_EMAG8180, qtrsm_kernel_RN_EMAG8180, qtrsm_kernel_RT_EMAG8180,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_EMAG8180, qtrsm_iunncopy_EMAG8180, qtrsm_iutucopy_EMAG8180, qtrsm_iutncopy_EMAG8180,
  qtrsm_ilnucopy_EMAG8180, qtrsm_ilnncopy_EMAG8180, qtrsm_iltucopy_EMAG8180, qtrsm_iltncopy_EMAG8180,
#else
  qtrsm_ounucopy_EMAG8180, qtrsm_ounncopy_EMAG8180, qtrsm_outucopy_EMAG8180, qtrsm_outncopy_EMAG8180,
  qtrsm_olnucopy_EMAG8180, qtrsm_olnncopy_EMAG8180, qtrsm_oltucopy_EMAG8180, qtrsm_oltncopy_EMAG8180,
#endif
  qtrsm_ounucopy_EMAG8180, qtrsm_ounncopy_EMAG8180, qtrsm_outucopy_EMAG8180, qtrsm_outncopy_EMAG8180,
  qtrsm_olnucopy_EMAG8180, qtrsm_olnncopy_EMAG8180, qtrsm_oltucopy_EMAG8180, qtrsm_oltncopy_EMAG8180,
  qtrmm_kernel_RN_EMAG8180, qtrmm_kernel_RT_EMAG8180, qtrmm_kernel_LN_EMAG8180, qtrmm_kernel_LT_EMAG8180,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_EMAG8180, qtrmm_iunncopy_EMAG8180, qtrmm_iutucopy_EMAG8180, qtrmm_iutncopy_EMAG8180,
  qtrmm_ilnucopy_EMAG8180, qtrmm_ilnncopy_EMAG8180, qtrmm_iltucopy_EMAG8180, qtrmm_iltncopy_EMAG8180,
#else
  qtrmm_ounucopy_EMAG8180, qtrmm_ounncopy_EMAG8180, qtrmm_outucopy_EMAG8180, qtrmm_outncopy_EMAG8180,
  qtrmm_olnucopy_EMAG8180, qtrmm_olnncopy_EMAG8180, qtrmm_oltucopy_EMAG8180, qtrmm_oltncopy_EMAG8180,
#endif
  qtrmm_ounucopy_EMAG8180, qtrmm_ounncopy_EMAG8180, qtrmm_outucopy_EMAG8180, qtrmm_outncopy_EMAG8180,
  qtrmm_olnucopy_EMAG8180, qtrmm_olnncopy_EMAG8180, qtrmm_oltucopy_EMAG8180, qtrmm_oltncopy_EMAG8180,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_EMAG8180, qsymm_iltcopy_EMAG8180,
#else
  qsymm_outcopy_EMAG8180, qsymm_oltcopy_EMAG8180,
#endif
  qsymm_outcopy_EMAG8180, qsymm_oltcopy_EMAG8180,

#ifndef NO_LAPACK
  qneg_tcopy_EMAG8180, qlaswp_ncopy_EMAG8180,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_EMAG8180, camin_k_EMAG8180,
#endif
#if (BUILD_COMPLEX)
  icamax_k_EMAG8180, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_EMAG8180,
  cnrm2_k_EMAG8180, casum_k_EMAG8180, csum_k_EMAG8180,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_EMAG8180, cdotu_k_EMAG8180, cdotc_k_EMAG8180,
#endif
#if (BUILD_COMPLEX)
 csrot_k_EMAG8180,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_EMAG8180,
  caxpyc_k_EMAG8180, 
  cscal_k_EMAG8180, 
  cswap_k_EMAG8180,

  cgemv_n_EMAG8180, cgemv_t_EMAG8180, cgemv_r_EMAG8180, cgemv_c_EMAG8180,
  cgemv_o_EMAG8180, cgemv_u_EMAG8180, cgemv_s_EMAG8180, cgemv_d_EMAG8180,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_EMAG8180, cgerc_k_EMAG8180, cgerv_k_EMAG8180, cgerd_k_EMAG8180,
  csymv_L_EMAG8180, csymv_U_EMAG8180,
  chemv_L_EMAG8180, chemv_U_EMAG8180, chemv_M_EMAG8180, chemv_V_EMAG8180,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_EMAG8180, cgemm_kernel_l_EMAG8180, cgemm_kernel_r_EMAG8180, cgemm_kernel_b_EMAG8180,
  cgemm_beta_EMAG8180,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_EMAG8180, cgemm_itcopy_EMAG8180,
#else
  cgemm_oncopy_EMAG8180, cgemm_otcopy_EMAG8180,
#endif
  cgemm_oncopy_EMAG8180, cgemm_otcopy_EMAG8180,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_EMAG8180,
  cgemm_small_kernel_nn_EMAG8180, cgemm_small_kernel_nt_EMAG8180, cgemm_small_kernel_nr_EMAG8180, cgemm_small_kernel_nc_EMAG8180,
  cgemm_small_kernel_tn_EMAG8180, cgemm_small_kernel_tt_EMAG8180, cgemm_small_kernel_tr_EMAG8180, cgemm_small_kernel_tc_EMAG8180,
  cgemm_small_kernel_rn_EMAG8180, cgemm_small_kernel_rt_EMAG8180, cgemm_small_kernel_rr_EMAG8180, cgemm_small_kernel_rc_EMAG8180,
  cgemm_small_kernel_cn_EMAG8180, cgemm_small_kernel_ct_EMAG8180, cgemm_small_kernel_cr_EMAG8180, cgemm_small_kernel_cc_EMAG8180,
  cgemm_small_kernel_b0_nn_EMAG8180, cgemm_small_kernel_b0_nt_EMAG8180, cgemm_small_kernel_b0_nr_EMAG8180, cgemm_small_kernel_b0_nc_EMAG8180,
  cgemm_small_kernel_b0_tn_EMAG8180, cgemm_small_kernel_b0_tt_EMAG8180, cgemm_small_kernel_b0_tr_EMAG8180, cgemm_small_kernel_b0_tc_EMAG8180,
  cgemm_small_kernel_b0_rn_EMAG8180, cgemm_small_kernel_b0_rt_EMAG8180, cgemm_small_kernel_b0_rr_EMAG8180, cgemm_small_kernel_b0_rc_EMAG8180,
  cgemm_small_kernel_b0_cn_EMAG8180, cgemm_small_kernel_b0_ct_EMAG8180, cgemm_small_kernel_b0_cr_EMAG8180, cgemm_small_kernel_b0_cc_EMAG8180,
#endif

  ctrsm_kernel_LN_EMAG8180, ctrsm_kernel_LT_EMAG8180, ctrsm_kernel_LR_EMAG8180, ctrsm_kernel_LC_EMAG8180,
  ctrsm_kernel_RN_EMAG8180, ctrsm_kernel_RT_EMAG8180, ctrsm_kernel_RR_EMAG8180, ctrsm_kernel_RC_EMAG8180,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_EMAG8180,  ctrsm_iunncopy_EMAG8180,  ctrsm_iutucopy_EMAG8180,  ctrsm_iutncopy_EMAG8180,
  ctrsm_ilnucopy_EMAG8180,  ctrsm_ilnncopy_EMAG8180,  ctrsm_iltucopy_EMAG8180,  ctrsm_iltncopy_EMAG8180,
#else
  ctrsm_ounucopy_EMAG8180,  ctrsm_ounncopy_EMAG8180,  ctrsm_outucopy_EMAG8180,  ctrsm_outncopy_EMAG8180,
  ctrsm_olnucopy_EMAG8180,  ctrsm_olnncopy_EMAG8180,  ctrsm_oltucopy_EMAG8180,  ctrsm_oltncopy_EMAG8180,
#endif
  ctrsm_ounucopy_EMAG8180,  ctrsm_ounncopy_EMAG8180,  ctrsm_outucopy_EMAG8180,  ctrsm_outncopy_EMAG8180,
  ctrsm_olnucopy_EMAG8180,  ctrsm_olnncopy_EMAG8180,  ctrsm_oltucopy_EMAG8180,  ctrsm_oltncopy_EMAG8180,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_EMAG8180,  ctrmm_kernel_RT_EMAG8180,  ctrmm_kernel_RR_EMAG8180,  ctrmm_kernel_RC_EMAG8180,
  ctrmm_kernel_LN_EMAG8180,  ctrmm_kernel_LT_EMAG8180,  ctrmm_kernel_LR_EMAG8180,  ctrmm_kernel_LC_EMAG8180,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_EMAG8180,  ctrmm_iunncopy_EMAG8180,  ctrmm_iutucopy_EMAG8180,  ctrmm_iutncopy_EMAG8180,
  ctrmm_ilnucopy_EMAG8180,  ctrmm_ilnncopy_EMAG8180,  ctrmm_iltucopy_EMAG8180,  ctrmm_iltncopy_EMAG8180,
#else
  ctrmm_ounucopy_EMAG8180,  ctrmm_ounncopy_EMAG8180,  ctrmm_outucopy_EMAG8180,  ctrmm_outncopy_EMAG8180,
  ctrmm_olnucopy_EMAG8180,  ctrmm_olnncopy_EMAG8180,  ctrmm_oltucopy_EMAG8180,  ctrmm_oltncopy_EMAG8180,
#endif
  ctrmm_ounucopy_EMAG8180,  ctrmm_ounncopy_EMAG8180,  ctrmm_outucopy_EMAG8180,  ctrmm_outncopy_EMAG8180,
  ctrmm_olnucopy_EMAG8180,  ctrmm_olnncopy_EMAG8180,  ctrmm_oltucopy_EMAG8180,  ctrmm_oltncopy_EMAG8180,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_EMAG8180,  csymm_iltcopy_EMAG8180,
#else
  csymm_outcopy_EMAG8180,  csymm_oltcopy_EMAG8180,
#endif
  csymm_outcopy_EMAG8180,  csymm_oltcopy_EMAG8180,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_EMAG8180,  chemm_iltcopy_EMAG8180,
#else
  chemm_outcopy_EMAG8180,  chemm_oltcopy_EMAG8180,
#endif
  chemm_outcopy_EMAG8180,  chemm_oltcopy_EMAG8180,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_EMAG8180,

  cgemm3m_incopyb_EMAG8180,  cgemm3m_incopyr_EMAG8180,
  cgemm3m_incopyi_EMAG8180,  cgemm3m_itcopyb_EMAG8180,
  cgemm3m_itcopyr_EMAG8180,  cgemm3m_itcopyi_EMAG8180,
  cgemm3m_oncopyb_EMAG8180,  cgemm3m_oncopyr_EMAG8180,
  cgemm3m_oncopyi_EMAG8180,  cgemm3m_otcopyb_EMAG8180,
  cgemm3m_otcopyr_EMAG8180,  cgemm3m_otcopyi_EMAG8180,

  csymm3m_iucopyb_EMAG8180,  csymm3m_ilcopyb_EMAG8180,
  csymm3m_iucopyr_EMAG8180,  csymm3m_ilcopyr_EMAG8180,
  csymm3m_iucopyi_EMAG8180,  csymm3m_ilcopyi_EMAG8180,
  csymm3m_oucopyb_EMAG8180,  csymm3m_olcopyb_EMAG8180,
  csymm3m_oucopyr_EMAG8180,  csymm3m_olcopyr_EMAG8180,
  csymm3m_oucopyi_EMAG8180,  csymm3m_olcopyi_EMAG8180,

  chemm3m_iucopyb_EMAG8180,  chemm3m_ilcopyb_EMAG8180,
  chemm3m_iucopyr_EMAG8180,  chemm3m_ilcopyr_EMAG8180,
  chemm3m_iucopyi_EMAG8180,  chemm3m_ilcopyi_EMAG8180,

  chemm3m_oucopyb_EMAG8180,  chemm3m_olcopyb_EMAG8180,
  chemm3m_oucopyr_EMAG8180,  chemm3m_olcopyr_EMAG8180,
  chemm3m_oucopyi_EMAG8180,  chemm3m_olcopyi_EMAG8180,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_EMAG8180,
  
   claswp_ncopy_EMAG8180,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_EMAG8180, zamin_k_EMAG8180, izamax_k_EMAG8180, izamin_k_EMAG8180,
  znrm2_k_EMAG8180, zasum_k_EMAG8180, zsum_k_EMAG8180, zcopy_k_EMAG8180,
  zdotu_k_EMAG8180, zdotc_k_EMAG8180, zdrot_k_EMAG8180,
  zaxpy_k_EMAG8180, zaxpyc_k_EMAG8180, zscal_k_EMAG8180, zswap_k_EMAG8180,

  zgemv_n_EMAG8180, zgemv_t_EMAG8180, zgemv_r_EMAG8180, zgemv_c_EMAG8180,
  zgemv_o_EMAG8180, zgemv_u_EMAG8180, zgemv_s_EMAG8180, zgemv_d_EMAG8180,
  zgeru_k_EMAG8180, zgerc_k_EMAG8180, zgerv_k_EMAG8180, zgerd_k_EMAG8180,
  zsymv_L_EMAG8180, zsymv_U_EMAG8180,
  zhemv_L_EMAG8180, zhemv_U_EMAG8180, zhemv_M_EMAG8180, zhemv_V_EMAG8180,

  zgemm_kernel_n_EMAG8180, zgemm_kernel_l_EMAG8180, zgemm_kernel_r_EMAG8180, zgemm_kernel_b_EMAG8180,
  zgemm_beta_EMAG8180,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_EMAG8180, zgemm_itcopy_EMAG8180,
#else
  zgemm_oncopy_EMAG8180, zgemm_otcopy_EMAG8180,
#endif
  zgemm_oncopy_EMAG8180, zgemm_otcopy_EMAG8180,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_EMAG8180,
  zgemm_small_kernel_nn_EMAG8180, zgemm_small_kernel_nt_EMAG8180, zgemm_small_kernel_nr_EMAG8180, zgemm_small_kernel_nc_EMAG8180,
  zgemm_small_kernel_tn_EMAG8180, zgemm_small_kernel_tt_EMAG8180, zgemm_small_kernel_tr_EMAG8180, zgemm_small_kernel_tc_EMAG8180,
  zgemm_small_kernel_rn_EMAG8180, zgemm_small_kernel_rt_EMAG8180, zgemm_small_kernel_rr_EMAG8180, zgemm_small_kernel_rc_EMAG8180,
  zgemm_small_kernel_cn_EMAG8180, zgemm_small_kernel_ct_EMAG8180, zgemm_small_kernel_cr_EMAG8180, zgemm_small_kernel_cc_EMAG8180,
  zgemm_small_kernel_b0_nn_EMAG8180, zgemm_small_kernel_b0_nt_EMAG8180, zgemm_small_kernel_b0_nr_EMAG8180, zgemm_small_kernel_b0_nc_EMAG8180,
  zgemm_small_kernel_b0_tn_EMAG8180, zgemm_small_kernel_b0_tt_EMAG8180, zgemm_small_kernel_b0_tr_EMAG8180, zgemm_small_kernel_b0_tc_EMAG8180,
  zgemm_small_kernel_b0_rn_EMAG8180, zgemm_small_kernel_b0_rt_EMAG8180, zgemm_small_kernel_b0_rr_EMAG8180, zgemm_small_kernel_b0_rc_EMAG8180,
  zgemm_small_kernel_b0_cn_EMAG8180, zgemm_small_kernel_b0_ct_EMAG8180, zgemm_small_kernel_b0_cr_EMAG8180, zgemm_small_kernel_b0_cc_EMAG8180,
#endif

  ztrsm_kernel_LN_EMAG8180, ztrsm_kernel_LT_EMAG8180, ztrsm_kernel_LR_EMAG8180, ztrsm_kernel_LC_EMAG8180,
  ztrsm_kernel_RN_EMAG8180, ztrsm_kernel_RT_EMAG8180, ztrsm_kernel_RR_EMAG8180, ztrsm_kernel_RC_EMAG8180,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_EMAG8180,  ztrsm_iunncopy_EMAG8180,  ztrsm_iutucopy_EMAG8180,  ztrsm_iutncopy_EMAG8180,
  ztrsm_ilnucopy_EMAG8180,  ztrsm_ilnncopy_EMAG8180,  ztrsm_iltucopy_EMAG8180,  ztrsm_iltncopy_EMAG8180,
#else
  ztrsm_ounucopy_EMAG8180,  ztrsm_ounncopy_EMAG8180,  ztrsm_outucopy_EMAG8180,  ztrsm_outncopy_EMAG8180,
  ztrsm_olnucopy_EMAG8180,  ztrsm_olnncopy_EMAG8180,  ztrsm_oltucopy_EMAG8180,  ztrsm_oltncopy_EMAG8180,
#endif
  ztrsm_ounucopy_EMAG8180,  ztrsm_ounncopy_EMAG8180,  ztrsm_outucopy_EMAG8180,  ztrsm_outncopy_EMAG8180,
  ztrsm_olnucopy_EMAG8180,  ztrsm_olnncopy_EMAG8180,  ztrsm_oltucopy_EMAG8180,  ztrsm_oltncopy_EMAG8180,

  ztrmm_kernel_RN_EMAG8180,  ztrmm_kernel_RT_EMAG8180,  ztrmm_kernel_RR_EMAG8180,  ztrmm_kernel_RC_EMAG8180,
  ztrmm_kernel_LN_EMAG8180,  ztrmm_kernel_LT_EMAG8180,  ztrmm_kernel_LR_EMAG8180,  ztrmm_kernel_LC_EMAG8180,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_EMAG8180,  ztrmm_iunncopy_EMAG8180,  ztrmm_iutucopy_EMAG8180,  ztrmm_iutncopy_EMAG8180,
  ztrmm_ilnucopy_EMAG8180,  ztrmm_ilnncopy_EMAG8180,  ztrmm_iltucopy_EMAG8180,  ztrmm_iltncopy_EMAG8180,
#else
  ztrmm_ounucopy_EMAG8180,  ztrmm_ounncopy_EMAG8180,  ztrmm_outucopy_EMAG8180,  ztrmm_outncopy_EMAG8180,
  ztrmm_olnucopy_EMAG8180,  ztrmm_olnncopy_EMAG8180,  ztrmm_oltucopy_EMAG8180,  ztrmm_oltncopy_EMAG8180,
#endif
  ztrmm_ounucopy_EMAG8180,  ztrmm_ounncopy_EMAG8180,  ztrmm_outucopy_EMAG8180,  ztrmm_outncopy_EMAG8180,
  ztrmm_olnucopy_EMAG8180,  ztrmm_olnncopy_EMAG8180,  ztrmm_oltucopy_EMAG8180,  ztrmm_oltncopy_EMAG8180,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_EMAG8180,  zsymm_iltcopy_EMAG8180,
#else
  zsymm_outcopy_EMAG8180,  zsymm_oltcopy_EMAG8180,
#endif
  zsymm_outcopy_EMAG8180,  zsymm_oltcopy_EMAG8180,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_EMAG8180,  zhemm_iltcopy_EMAG8180,
#else
  zhemm_outcopy_EMAG8180,  zhemm_oltcopy_EMAG8180,
#endif
  zhemm_outcopy_EMAG8180,  zhemm_oltcopy_EMAG8180,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_EMAG8180,

  zgemm3m_incopyb_EMAG8180,  zgemm3m_incopyr_EMAG8180,
  zgemm3m_incopyi_EMAG8180,  zgemm3m_itcopyb_EMAG8180,
  zgemm3m_itcopyr_EMAG8180,  zgemm3m_itcopyi_EMAG8180,
  zgemm3m_oncopyb_EMAG8180,  zgemm3m_oncopyr_EMAG8180,
  zgemm3m_oncopyi_EMAG8180,  zgemm3m_otcopyb_EMAG8180,
  zgemm3m_otcopyr_EMAG8180,  zgemm3m_otcopyi_EMAG8180,

  zsymm3m_iucopyb_EMAG8180,  zsymm3m_ilcopyb_EMAG8180,
  zsymm3m_iucopyr_EMAG8180,  zsymm3m_ilcopyr_EMAG8180,
  zsymm3m_iucopyi_EMAG8180,  zsymm3m_ilcopyi_EMAG8180,
  zsymm3m_oucopyb_EMAG8180,  zsymm3m_olcopyb_EMAG8180,
  zsymm3m_oucopyr_EMAG8180,  zsymm3m_olcopyr_EMAG8180,
  zsymm3m_oucopyi_EMAG8180,  zsymm3m_olcopyi_EMAG8180,

  zhemm3m_iucopyb_EMAG8180,  zhemm3m_ilcopyb_EMAG8180,
  zhemm3m_iucopyr_EMAG8180,  zhemm3m_ilcopyr_EMAG8180,
  zhemm3m_iucopyi_EMAG8180,  zhemm3m_ilcopyi_EMAG8180,

  zhemm3m_oucopyb_EMAG8180,  zhemm3m_olcopyb_EMAG8180,
  zhemm3m_oucopyr_EMAG8180,  zhemm3m_olcopyr_EMAG8180,
  zhemm3m_oucopyi_EMAG8180,  zhemm3m_olcopyi_EMAG8180,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_EMAG8180, zlaswp_ncopy_EMAG8180,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_EMAG8180, xamin_k_EMAG8180, ixamax_k_EMAG8180, ixamin_k_EMAG8180,
  xnrm2_k_EMAG8180, xasum_k_EMAG8180, xsum_k_EMAG8180, xcopy_k_EMAG8180,
  xdotu_k_EMAG8180, xdotc_k_EMAG8180, xqrot_k_EMAG8180,
  xaxpy_k_EMAG8180, xaxpyc_k_EMAG8180, xscal_k_EMAG8180, xswap_k_EMAG8180,

  xgemv_n_EMAG8180, xgemv_t_EMAG8180, xgemv_r_EMAG8180, xgemv_c_EMAG8180,
  xgemv_o_EMAG8180, xgemv_u_EMAG8180, xgemv_s_EMAG8180, xgemv_d_EMAG8180,
  xgeru_k_EMAG8180, xgerc_k_EMAG8180, xgerv_k_EMAG8180, xgerd_k_EMAG8180,
  xsymv_L_EMAG8180, xsymv_U_EMAG8180,
  xhemv_L_EMAG8180, xhemv_U_EMAG8180, xhemv_M_EMAG8180, xhemv_V_EMAG8180,

  xgemm_kernel_n_EMAG8180, xgemm_kernel_l_EMAG8180, xgemm_kernel_r_EMAG8180, xgemm_kernel_b_EMAG8180,
  xgemm_beta_EMAG8180,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_EMAG8180, xgemm_itcopy_EMAG8180,
#else
  xgemm_oncopy_EMAG8180, xgemm_otcopy_EMAG8180,
#endif
  xgemm_oncopy_EMAG8180, xgemm_otcopy_EMAG8180,

  xtrsm_kernel_LN_EMAG8180, xtrsm_kernel_LT_EMAG8180, xtrsm_kernel_LR_EMAG8180, xtrsm_kernel_LC_EMAG8180,
  xtrsm_kernel_RN_EMAG8180, xtrsm_kernel_RT_EMAG8180, xtrsm_kernel_RR_EMAG8180, xtrsm_kernel_RC_EMAG8180,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_EMAG8180,  xtrsm_iunncopy_EMAG8180,  xtrsm_iutucopy_EMAG8180,  xtrsm_iutncopy_EMAG8180,
  xtrsm_ilnucopy_EMAG8180,  xtrsm_ilnncopy_EMAG8180,  xtrsm_iltucopy_EMAG8180,  xtrsm_iltncopy_EMAG8180,
#else
  xtrsm_ounucopy_EMAG8180,  xtrsm_ounncopy_EMAG8180,  xtrsm_outucopy_EMAG8180,  xtrsm_outncopy_EMAG8180,
  xtrsm_olnucopy_EMAG8180,  xtrsm_olnncopy_EMAG8180,  xtrsm_oltucopy_EMAG8180,  xtrsm_oltncopy_EMAG8180,
#endif
  xtrsm_ounucopy_EMAG8180,  xtrsm_ounncopy_EMAG8180,  xtrsm_outucopy_EMAG8180,  xtrsm_outncopy_EMAG8180,
  xtrsm_olnucopy_EMAG8180,  xtrsm_olnncopy_EMAG8180,  xtrsm_oltucopy_EMAG8180,  xtrsm_oltncopy_EMAG8180,

  xtrmm_kernel_RN_EMAG8180,  xtrmm_kernel_RT_EMAG8180,  xtrmm_kernel_RR_EMAG8180,  xtrmm_kernel_RC_EMAG8180,
  xtrmm_kernel_LN_EMAG8180,  xtrmm_kernel_LT_EMAG8180,  xtrmm_kernel_LR_EMAG8180,  xtrmm_kernel_LC_EMAG8180,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_EMAG8180,  xtrmm_iunncopy_EMAG8180,  xtrmm_iutucopy_EMAG8180,  xtrmm_iutncopy_EMAG8180,
  xtrmm_ilnucopy_EMAG8180,  xtrmm_ilnncopy_EMAG8180,  xtrmm_iltucopy_EMAG8180,  xtrmm_iltncopy_EMAG8180,
#else
  xtrmm_ounucopy_EMAG8180,  xtrmm_ounncopy_EMAG8180,  xtrmm_outucopy_EMAG8180,  xtrmm_outncopy_EMAG8180,
  xtrmm_olnucopy_EMAG8180,  xtrmm_olnncopy_EMAG8180,  xtrmm_oltucopy_EMAG8180,  xtrmm_oltncopy_EMAG8180,
#endif
  xtrmm_ounucopy_EMAG8180,  xtrmm_ounncopy_EMAG8180,  xtrmm_outucopy_EMAG8180,  xtrmm_outncopy_EMAG8180,
  xtrmm_olnucopy_EMAG8180,  xtrmm_olnncopy_EMAG8180,  xtrmm_oltucopy_EMAG8180,  xtrmm_oltncopy_EMAG8180,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_EMAG8180,  xsymm_iltcopy_EMAG8180,
#else
  xsymm_outcopy_EMAG8180,  xsymm_oltcopy_EMAG8180,
#endif
  xsymm_outcopy_EMAG8180,  xsymm_oltcopy_EMAG8180,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_EMAG8180,  xhemm_iltcopy_EMAG8180,
#else
  xhemm_outcopy_EMAG8180,  xhemm_oltcopy_EMAG8180,
#endif
  xhemm_outcopy_EMAG8180,  xhemm_oltcopy_EMAG8180,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_EMAG8180,

  xgemm3m_incopyb_EMAG8180,  xgemm3m_incopyr_EMAG8180,
  xgemm3m_incopyi_EMAG8180,  xgemm3m_itcopyb_EMAG8180,
  xgemm3m_itcopyr_EMAG8180,  xgemm3m_itcopyi_EMAG8180,
  xgemm3m_oncopyb_EMAG8180,  xgemm3m_oncopyr_EMAG8180,
  xgemm3m_oncopyi_EMAG8180,  xgemm3m_otcopyb_EMAG8180,
  xgemm3m_otcopyr_EMAG8180,  xgemm3m_otcopyi_EMAG8180,

  xsymm3m_iucopyb_EMAG8180,  xsymm3m_ilcopyb_EMAG8180,
  xsymm3m_iucopyr_EMAG8180,  xsymm3m_ilcopyr_EMAG8180,
  xsymm3m_iucopyi_EMAG8180,  xsymm3m_ilcopyi_EMAG8180,
  xsymm3m_oucopyb_EMAG8180,  xsymm3m_olcopyb_EMAG8180,
  xsymm3m_oucopyr_EMAG8180,  xsymm3m_olcopyr_EMAG8180,
  xsymm3m_oucopyi_EMAG8180,  xsymm3m_olcopyi_EMAG8180,

  xhemm3m_iucopyb_EMAG8180,  xhemm3m_ilcopyb_EMAG8180,
  xhemm3m_iucopyr_EMAG8180,  xhemm3m_ilcopyr_EMAG8180,
  xhemm3m_iucopyi_EMAG8180,  xhemm3m_ilcopyi_EMAG8180,

  xhemm3m_oucopyb_EMAG8180,  xhemm3m_olcopyb_EMAG8180,
  xhemm3m_oucopyr_EMAG8180,  xhemm3m_olcopyr_EMAG8180,
  xhemm3m_oucopyi_EMAG8180,  xhemm3m_olcopyi_EMAG8180,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_EMAG8180, xlaswp_ncopy_EMAG8180,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_EMAG8180,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_EMAG8180,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_EMAG8180,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_EMAG8180,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_EMAG8180, somatcopy_k_ct_EMAG8180, somatcopy_k_rn_EMAG8180, somatcopy_k_rt_EMAG8180,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_EMAG8180, domatcopy_k_ct_EMAG8180, domatcopy_k_rn_EMAG8180, domatcopy_k_rt_EMAG8180,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_EMAG8180, comatcopy_k_ct_EMAG8180, comatcopy_k_rn_EMAG8180, comatcopy_k_rt_EMAG8180,
  comatcopy_k_cnc_EMAG8180, comatcopy_k_ctc_EMAG8180, comatcopy_k_rnc_EMAG8180, comatcopy_k_rtc_EMAG8180,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_EMAG8180, zomatcopy_k_ct_EMAG8180, zomatcopy_k_rn_EMAG8180, zomatcopy_k_rt_EMAG8180,
  zomatcopy_k_cnc_EMAG8180, zomatcopy_k_ctc_EMAG8180, zomatcopy_k_rnc_EMAG8180, zomatcopy_k_rtc_EMAG8180,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_EMAG8180, simatcopy_k_ct_EMAG8180, simatcopy_k_rn_EMAG8180, simatcopy_k_rt_EMAG8180,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_EMAG8180, dimatcopy_k_ct_EMAG8180, dimatcopy_k_rn_EMAG8180, dimatcopy_k_rt_EMAG8180,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_EMAG8180, cimatcopy_k_ct_EMAG8180, cimatcopy_k_rn_EMAG8180, cimatcopy_k_rt_EMAG8180,
  cimatcopy_k_cnc_EMAG8180, cimatcopy_k_ctc_EMAG8180, cimatcopy_k_rnc_EMAG8180, cimatcopy_k_rtc_EMAG8180,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_EMAG8180, zimatcopy_k_ct_EMAG8180, zimatcopy_k_rn_EMAG8180, zimatcopy_k_rt_EMAG8180,
  zimatcopy_k_cnc_EMAG8180, zimatcopy_k_ctc_EMAG8180, zimatcopy_k_rnc_EMAG8180, zimatcopy_k_rtc_EMAG8180,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_EMAG8180,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_EMAG8180,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_EMAG8180,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_EMAG8180,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
