/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023, 2025 The OpenBLAS Project.                        */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_THUNDERX;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_THUNDERX.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_HFLOAT16
  0, 0, 0,
  SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N,
#ifdef SHGEMM_DEFAULT_UNROLL_MN
 SHGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SHGEMM_DEFAULT_UNROLL_M, SHGEMM_DEFAULT_UNROLL_N),
#endif
  shgemm_kernel_THUNDERX, shgemm_beta_THUNDERX,
#if SHGEMM_DEFAULT_UNROLL_M != SHGEMM_DEFAULT_UNROLL_N
  shgemm_incopy_THUNDERX, shgemm_itcopy_THUNDERX,
#else
  shgemm_oncopy_THUNDERX, shgemm_otcopy_THUNDERX,
#endif
  shgemm_oncopy_THUNDERX, shgemm_otcopy_THUNDERX,
  shgemv_n_THUNDERX, shgemv_t_THUNDERX,
#endif

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N,
#ifdef BGEMM_DEFAULT_UNROLL_MN
 BGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(BGEMM_DEFAULT_UNROLL_M, BGEMM_DEFAULT_UNROLL_N),
#endif
  BGEMM_ALIGN_K,

  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_THUNDERX, sbdtobf16_k_THUNDERX, sbf16tos_k_THUNDERX, dbf16tod_k_THUNDERX,

  samax_k_THUNDERX,  samin_k_THUNDERX,  smax_k_THUNDERX,  smin_k_THUNDERX,
  isamax_k_THUNDERX, isamin_k_THUNDERX, ismax_k_THUNDERX, ismin_k_THUNDERX,
  snrm2_k_THUNDERX,  sasum_k_THUNDERX,  ssum_k_THUNDERX, scopy_k_THUNDERX, sbdot_k_THUNDERX,
  dsdot_k_THUNDERX,
  srot_k_THUNDERX,   srotm_k_THUNDERX, bscal_k_THUNDERX, saxpy_k_THUNDERX,  sscal_k_THUNDERX, sswap_k_THUNDERX,
  bgemv_n_THUNDERX, bgemv_t_THUNDERX, sbgemv_n_THUNDERX, sbgemv_t_THUNDERX, sger_k_THUNDERX,
  ssymv_L_THUNDERX, ssymv_U_THUNDERX,

  bgemm_kernel_THUNDERX, bgemm_beta_THUNDERX,
#if BGEMM_DEFAULT_UNROLL_M != BGEMM_DEFAULT_UNROLL_N
  bgemm_incopy_THUNDERX, bgemm_itcopy_THUNDERX,
#else
  bgemm_oncopy_THUNDERX, bgemm_otcopy_THUNDERX,
#endif
  bgemm_oncopy_THUNDERX, bgemm_otcopy_THUNDERX,

  sbgemm_kernel_THUNDERX, sbgemm_beta_THUNDERX,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_THUNDERX, sbgemm_itcopy_THUNDERX,
#else
  sbgemm_oncopy_THUNDERX, sbgemm_otcopy_THUNDERX,
#endif
  sbgemm_oncopy_THUNDERX, sbgemm_otcopy_THUNDERX,

  strsm_kernel_LN_THUNDERX, strsm_kernel_LT_THUNDERX, strsm_kernel_RN_THUNDERX, strsm_kernel_RT_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_THUNDERX, strsm_iunncopy_THUNDERX, strsm_iutucopy_THUNDERX, strsm_iutncopy_THUNDERX,
  strsm_ilnucopy_THUNDERX, strsm_ilnncopy_THUNDERX, strsm_iltucopy_THUNDERX, strsm_iltncopy_THUNDERX,
#else
  strsm_ounucopy_THUNDERX, strsm_ounncopy_THUNDERX, strsm_outucopy_THUNDERX, strsm_outncopy_THUNDERX,
  strsm_olnucopy_THUNDERX, strsm_olnncopy_THUNDERX, strsm_oltucopy_THUNDERX, strsm_oltncopy_THUNDERX,
#endif
  strsm_ounucopy_THUNDERX, strsm_ounncopy_THUNDERX, strsm_outucopy_THUNDERX, strsm_outncopy_THUNDERX,
  strsm_olnucopy_THUNDERX, strsm_olnncopy_THUNDERX, strsm_oltucopy_THUNDERX, strsm_oltncopy_THUNDERX,
  strmm_kernel_RN_THUNDERX, strmm_kernel_RT_THUNDERX, strmm_kernel_LN_THUNDERX, strmm_kernel_LT_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_THUNDERX, strmm_iunncopy_THUNDERX, strmm_iutucopy_THUNDERX, strmm_iutncopy_THUNDERX,
  strmm_ilnucopy_THUNDERX, strmm_ilnncopy_THUNDERX, strmm_iltucopy_THUNDERX, strmm_iltncopy_THUNDERX,
#else
  strmm_ounucopy_THUNDERX, strmm_ounncopy_THUNDERX, strmm_outucopy_THUNDERX, strmm_outncopy_THUNDERX,
  strmm_olnucopy_THUNDERX, strmm_olnncopy_THUNDERX, strmm_oltucopy_THUNDERX, strmm_oltncopy_THUNDERX,
#endif
  strmm_ounucopy_THUNDERX, strmm_ounncopy_THUNDERX, strmm_outucopy_THUNDERX, strmm_outncopy_THUNDERX,
  strmm_olnucopy_THUNDERX, strmm_olnncopy_THUNDERX, strmm_oltucopy_THUNDERX, strmm_oltncopy_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_THUNDERX, ssymm_iltcopy_THUNDERX,
#else
  ssymm_outcopy_THUNDERX, ssymm_oltcopy_THUNDERX,
#endif
  ssymm_outcopy_THUNDERX, ssymm_oltcopy_THUNDERX,

#ifndef NO_LAPACK
  sneg_tcopy_THUNDERX, slaswp_ncopy_THUNDERX,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_THUNDERX,
  sbgemm_small_kernel_nn_THUNDERX, sbgemm_small_kernel_nt_THUNDERX, sbgemm_small_kernel_tn_THUNDERX, sbgemm_small_kernel_tt_THUNDERX,
  sbgemm_small_kernel_b0_nn_THUNDERX, sbgemm_small_kernel_b0_nt_THUNDERX, sbgemm_small_kernel_b0_tn_THUNDERX, sbgemm_small_kernel_b0_tt_THUNDERX,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_THUNDERX,  samin_k_THUNDERX,  smax_k_THUNDERX,  smin_k_THUNDERX,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_THUNDERX,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_THUNDERX, ismax_k_THUNDERX, ismin_k_THUNDERX,
  snrm2_k_THUNDERX,  sasum_k_THUNDERX,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_THUNDERX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_THUNDERX, sdot_k_THUNDERX,
//  dsdot_k_THUNDERX,
  srot_k_THUNDERX,  srotm_k_THUNDERX,  saxpy_k_THUNDERX,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_THUNDERX,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_THUNDERX,
  sgemv_n_THUNDERX,  sgemv_t_THUNDERX,
#endif
#if BUILD_SINGLE == 1
  sger_k_THUNDERX,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_THUNDERX, ssymv_U_THUNDERX,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_THUNDERX,
  sgemm_direct_performant_THUNDERX,	
#endif
#ifdef ARCH_ARM64
  sgemm_direct_THUNDERX,
  sgemm_direct_alpha_beta_THUNDERX,
  ssymm_direct_alpha_betaLU_THUNDERX,
  ssymm_direct_alpha_betaLL_THUNDERX,
  strmm_direct_LNUN_THUNDERX,
  strmm_direct_LNLN_THUNDERX,
  strmm_direct_LTUN_THUNDERX,
  strmm_direct_LTLN_THUNDERX,
  ssyrk_direct_alpha_betaUN_THUNDERX,
  ssyrk_direct_alpha_betaUT_THUNDERX,
  ssyrk_direct_alpha_betaLN_THUNDERX,
  ssyrk_direct_alpha_betaLT_THUNDERX,
  ssyr2k_direct_alpha_betaUN_THUNDERX,
  ssyr2k_direct_alpha_betaUT_THUNDERX,
  ssyr2k_direct_alpha_betaLN_THUNDERX,
  ssyr2k_direct_alpha_betaLT_THUNDERX,
#endif

  sgemm_kernel_THUNDERX, sgemm_beta_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_THUNDERX, sgemm_itcopy_THUNDERX,
#else
  sgemm_oncopy_THUNDERX, sgemm_otcopy_THUNDERX,
#endif
  sgemm_oncopy_THUNDERX, sgemm_otcopy_THUNDERX,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_THUNDERX,
  sgemm_small_kernel_nn_THUNDERX, sgemm_small_kernel_nt_THUNDERX, sgemm_small_kernel_tn_THUNDERX, sgemm_small_kernel_tt_THUNDERX,
  sgemm_small_kernel_b0_nn_THUNDERX, sgemm_small_kernel_b0_nt_THUNDERX, sgemm_small_kernel_b0_tn_THUNDERX, sgemm_small_kernel_b0_tt_THUNDERX,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_THUNDERX, strsm_kernel_LT_THUNDERX, strsm_kernel_RN_THUNDERX, strsm_kernel_RT_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_THUNDERX, strsm_iunncopy_THUNDERX, strsm_iutucopy_THUNDERX, strsm_iutncopy_THUNDERX,
  strsm_ilnucopy_THUNDERX, strsm_ilnncopy_THUNDERX, strsm_iltucopy_THUNDERX, strsm_iltncopy_THUNDERX,
#else
  strsm_ounucopy_THUNDERX, strsm_ounncopy_THUNDERX, strsm_outucopy_THUNDERX, strsm_outncopy_THUNDERX,
  strsm_olnucopy_THUNDERX, strsm_olnncopy_THUNDERX, strsm_oltucopy_THUNDERX, strsm_oltncopy_THUNDERX,
#endif
  strsm_ounucopy_THUNDERX, strsm_ounncopy_THUNDERX, strsm_outucopy_THUNDERX, strsm_outncopy_THUNDERX,
  strsm_olnucopy_THUNDERX, strsm_olnncopy_THUNDERX, strsm_oltucopy_THUNDERX, strsm_oltncopy_THUNDERX,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_THUNDERX, strmm_kernel_RT_THUNDERX, strmm_kernel_LN_THUNDERX, strmm_kernel_LT_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_THUNDERX, strmm_iunncopy_THUNDERX, strmm_iutucopy_THUNDERX, strmm_iutncopy_THUNDERX,
  strmm_ilnucopy_THUNDERX, strmm_ilnncopy_THUNDERX, strmm_iltucopy_THUNDERX, strmm_iltncopy_THUNDERX,
#else
  strmm_ounucopy_THUNDERX, strmm_ounncopy_THUNDERX, strmm_outucopy_THUNDERX, strmm_outncopy_THUNDERX,
  strmm_olnucopy_THUNDERX, strmm_olnncopy_THUNDERX, strmm_oltucopy_THUNDERX, strmm_oltncopy_THUNDERX,
#endif
  strmm_ounucopy_THUNDERX, strmm_ounncopy_THUNDERX, strmm_outucopy_THUNDERX, strmm_outncopy_THUNDERX,
  strmm_olnucopy_THUNDERX, strmm_olnncopy_THUNDERX, strmm_oltucopy_THUNDERX, strmm_oltncopy_THUNDERX,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_THUNDERX, ssymm_iltcopy_THUNDERX,
#else
  ssymm_outcopy_THUNDERX, ssymm_oltcopy_THUNDERX,
#endif
  ssymm_outcopy_THUNDERX, ssymm_oltcopy_THUNDERX,
#ifndef NO_LAPACK
  sneg_tcopy_THUNDERX, slaswp_ncopy_THUNDERX,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_THUNDERX,  damin_k_THUNDERX,  dmax_k_THUNDERX,  dmin_k_THUNDERX,
  idamax_k_THUNDERX, idamin_k_THUNDERX, idmax_k_THUNDERX, idmin_k_THUNDERX,
  dnrm2_k_THUNDERX, dasum_k_THUNDERX,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_THUNDERX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_THUNDERX, ddot_k_THUNDERX,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_THUNDERX,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_THUNDERX,
  drotm_k_THUNDERX,
  daxpy_k_THUNDERX,
  dscal_k_THUNDERX, 
  dswap_k_THUNDERX,
  dgemv_n_THUNDERX,  dgemv_t_THUNDERX,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_THUNDERX,
  dsymv_L_THUNDERX,  dsymv_U_THUNDERX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_THUNDERX, dgemm_beta_THUNDERX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_THUNDERX, dgemm_itcopy_THUNDERX,
#else
  dgemm_oncopy_THUNDERX, dgemm_otcopy_THUNDERX,
#endif
  dgemm_oncopy_THUNDERX, dgemm_otcopy_THUNDERX,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_THUNDERX,
  dgemm_small_kernel_nn_THUNDERX, dgemm_small_kernel_nt_THUNDERX, dgemm_small_kernel_tn_THUNDERX, dgemm_small_kernel_tt_THUNDERX,
  dgemm_small_kernel_b0_nn_THUNDERX, dgemm_small_kernel_b0_nt_THUNDERX, dgemm_small_kernel_b0_tn_THUNDERX, dgemm_small_kernel_b0_tt_THUNDERX,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_THUNDERX, dtrsm_kernel_LT_THUNDERX, dtrsm_kernel_RN_THUNDERX, dtrsm_kernel_RT_THUNDERX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_THUNDERX, dtrsm_iunncopy_THUNDERX, dtrsm_iutucopy_THUNDERX, dtrsm_iutncopy_THUNDERX,
  dtrsm_ilnucopy_THUNDERX, dtrsm_ilnncopy_THUNDERX, dtrsm_iltucopy_THUNDERX, dtrsm_iltncopy_THUNDERX,
#else
  dtrsm_ounucopy_THUNDERX, dtrsm_ounncopy_THUNDERX, dtrsm_outucopy_THUNDERX, dtrsm_outncopy_THUNDERX,
  dtrsm_olnucopy_THUNDERX, dtrsm_olnncopy_THUNDERX, dtrsm_oltucopy_THUNDERX, dtrsm_oltncopy_THUNDERX,
#endif
  dtrsm_ounucopy_THUNDERX, dtrsm_ounncopy_THUNDERX, dtrsm_outucopy_THUNDERX, dtrsm_outncopy_THUNDERX,
  dtrsm_olnucopy_THUNDERX, dtrsm_olnncopy_THUNDERX, dtrsm_oltucopy_THUNDERX, dtrsm_oltncopy_THUNDERX,
  dtrmm_kernel_RN_THUNDERX, dtrmm_kernel_RT_THUNDERX, dtrmm_kernel_LN_THUNDERX, dtrmm_kernel_LT_THUNDERX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_THUNDERX, dtrmm_iunncopy_THUNDERX, dtrmm_iutucopy_THUNDERX, dtrmm_iutncopy_THUNDERX,
  dtrmm_ilnucopy_THUNDERX, dtrmm_ilnncopy_THUNDERX, dtrmm_iltucopy_THUNDERX, dtrmm_iltncopy_THUNDERX,
#else
  dtrmm_ounucopy_THUNDERX, dtrmm_ounncopy_THUNDERX, dtrmm_outucopy_THUNDERX, dtrmm_outncopy_THUNDERX,
  dtrmm_olnucopy_THUNDERX, dtrmm_olnncopy_THUNDERX, dtrmm_oltucopy_THUNDERX, dtrmm_oltncopy_THUNDERX,
#endif
  dtrmm_ounucopy_THUNDERX, dtrmm_ounncopy_THUNDERX, dtrmm_outucopy_THUNDERX, dtrmm_outncopy_THUNDERX,
  dtrmm_olnucopy_THUNDERX, dtrmm_olnncopy_THUNDERX, dtrmm_oltucopy_THUNDERX, dtrmm_oltncopy_THUNDERX,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_THUNDERX, dsymm_iltcopy_THUNDERX,
#else
  dsymm_outcopy_THUNDERX, dsymm_oltcopy_THUNDERX,
#endif
  dsymm_outcopy_THUNDERX, dsymm_oltcopy_THUNDERX,

#ifndef NO_LAPACK
  dneg_tcopy_THUNDERX, dlaswp_ncopy_THUNDERX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_THUNDERX,  qamin_k_THUNDERX,  qmax_k_THUNDERX,  qmin_k_THUNDERX,
  iqamax_k_THUNDERX, iqamin_k_THUNDERX, iqmax_k_THUNDERX, iqmin_k_THUNDERX,
  qnrm2_k_THUNDERX,  qasum_k_THUNDERX,  qsum_k_THUNDERX, qcopy_k_THUNDERX, qdot_k_THUNDERX,
  qrot_k_THUNDERX,   qrotm_k_THUNDERX,  qaxpy_k_THUNDERX,  qscal_k_THUNDERX, qswap_k_THUNDERX,
  qgemv_n_THUNDERX,  qgemv_t_THUNDERX,  qger_k_THUNDERX,
  qsymv_L_THUNDERX,  qsymv_U_THUNDERX,
  qgemm_kernel_THUNDERX, qgemm_beta_THUNDERX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_THUNDERX, qgemm_itcopy_THUNDERX,
#else
  qgemm_oncopy_THUNDERX, qgemm_otcopy_THUNDERX,
#endif
  qgemm_oncopy_THUNDERX, qgemm_otcopy_THUNDERX,
  qtrsm_kernel_LN_THUNDERX, qtrsm_kernel_LT_THUNDERX, qtrsm_kernel_RN_THUNDERX, qtrsm_kernel_RT_THUNDERX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_THUNDERX, qtrsm_iunncopy_THUNDERX, qtrsm_iutucopy_THUNDERX, qtrsm_iutncopy_THUNDERX,
  qtrsm_ilnucopy_THUNDERX, qtrsm_ilnncopy_THUNDERX, qtrsm_iltucopy_THUNDERX, qtrsm_iltncopy_THUNDERX,
#else
  qtrsm_ounucopy_THUNDERX, qtrsm_ounncopy_THUNDERX, qtrsm_outucopy_THUNDERX, qtrsm_outncopy_THUNDERX,
  qtrsm_olnucopy_THUNDERX, qtrsm_olnncopy_THUNDERX, qtrsm_oltucopy_THUNDERX, qtrsm_oltncopy_THUNDERX,
#endif
  qtrsm_ounucopy_THUNDERX, qtrsm_ounncopy_THUNDERX, qtrsm_outucopy_THUNDERX, qtrsm_outncopy_THUNDERX,
  qtrsm_olnucopy_THUNDERX, qtrsm_olnncopy_THUNDERX, qtrsm_oltucopy_THUNDERX, qtrsm_oltncopy_THUNDERX,
  qtrmm_kernel_RN_THUNDERX, qtrmm_kernel_RT_THUNDERX, qtrmm_kernel_LN_THUNDERX, qtrmm_kernel_LT_THUNDERX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_THUNDERX, qtrmm_iunncopy_THUNDERX, qtrmm_iutucopy_THUNDERX, qtrmm_iutncopy_THUNDERX,
  qtrmm_ilnucopy_THUNDERX, qtrmm_ilnncopy_THUNDERX, qtrmm_iltucopy_THUNDERX, qtrmm_iltncopy_THUNDERX,
#else
  qtrmm_ounucopy_THUNDERX, qtrmm_ounncopy_THUNDERX, qtrmm_outucopy_THUNDERX, qtrmm_outncopy_THUNDERX,
  qtrmm_olnucopy_THUNDERX, qtrmm_olnncopy_THUNDERX, qtrmm_oltucopy_THUNDERX, qtrmm_oltncopy_THUNDERX,
#endif
  qtrmm_ounucopy_THUNDERX, qtrmm_ounncopy_THUNDERX, qtrmm_outucopy_THUNDERX, qtrmm_outncopy_THUNDERX,
  qtrmm_olnucopy_THUNDERX, qtrmm_olnncopy_THUNDERX, qtrmm_oltucopy_THUNDERX, qtrmm_oltncopy_THUNDERX,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_THUNDERX, qsymm_iltcopy_THUNDERX,
#else
  qsymm_outcopy_THUNDERX, qsymm_oltcopy_THUNDERX,
#endif
  qsymm_outcopy_THUNDERX, qsymm_oltcopy_THUNDERX,

#ifndef NO_LAPACK
  qneg_tcopy_THUNDERX, qlaswp_ncopy_THUNDERX,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_THUNDERX, camin_k_THUNDERX,
#endif
#if (BUILD_COMPLEX)
  icamax_k_THUNDERX, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_THUNDERX,
  cnrm2_k_THUNDERX, casum_k_THUNDERX, csum_k_THUNDERX,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_THUNDERX, cdotu_k_THUNDERX, cdotc_k_THUNDERX,
#endif
#if (BUILD_COMPLEX)
 csrot_k_THUNDERX,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_THUNDERX,
  caxpyc_k_THUNDERX, 
  cscal_k_THUNDERX, 
  cswap_k_THUNDERX,

  cgemv_n_THUNDERX, cgemv_t_THUNDERX, cgemv_r_THUNDERX, cgemv_c_THUNDERX,
  cgemv_o_THUNDERX, cgemv_u_THUNDERX, cgemv_s_THUNDERX, cgemv_d_THUNDERX,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_THUNDERX, cgerc_k_THUNDERX, cgerv_k_THUNDERX, cgerd_k_THUNDERX,
  csymv_L_THUNDERX, csymv_U_THUNDERX,
  chemv_L_THUNDERX, chemv_U_THUNDERX, chemv_M_THUNDERX, chemv_V_THUNDERX,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_THUNDERX, cgemm_kernel_l_THUNDERX, cgemm_kernel_r_THUNDERX, cgemm_kernel_b_THUNDERX,
  cgemm_beta_THUNDERX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_THUNDERX, cgemm_itcopy_THUNDERX,
#else
  cgemm_oncopy_THUNDERX, cgemm_otcopy_THUNDERX,
#endif
  cgemm_oncopy_THUNDERX, cgemm_otcopy_THUNDERX,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_THUNDERX,
  cgemm_small_kernel_nn_THUNDERX, cgemm_small_kernel_nt_THUNDERX, cgemm_small_kernel_nr_THUNDERX, cgemm_small_kernel_nc_THUNDERX,
  cgemm_small_kernel_tn_THUNDERX, cgemm_small_kernel_tt_THUNDERX, cgemm_small_kernel_tr_THUNDERX, cgemm_small_kernel_tc_THUNDERX,
  cgemm_small_kernel_rn_THUNDERX, cgemm_small_kernel_rt_THUNDERX, cgemm_small_kernel_rr_THUNDERX, cgemm_small_kernel_rc_THUNDERX,
  cgemm_small_kernel_cn_THUNDERX, cgemm_small_kernel_ct_THUNDERX, cgemm_small_kernel_cr_THUNDERX, cgemm_small_kernel_cc_THUNDERX,
  cgemm_small_kernel_b0_nn_THUNDERX, cgemm_small_kernel_b0_nt_THUNDERX, cgemm_small_kernel_b0_nr_THUNDERX, cgemm_small_kernel_b0_nc_THUNDERX,
  cgemm_small_kernel_b0_tn_THUNDERX, cgemm_small_kernel_b0_tt_THUNDERX, cgemm_small_kernel_b0_tr_THUNDERX, cgemm_small_kernel_b0_tc_THUNDERX,
  cgemm_small_kernel_b0_rn_THUNDERX, cgemm_small_kernel_b0_rt_THUNDERX, cgemm_small_kernel_b0_rr_THUNDERX, cgemm_small_kernel_b0_rc_THUNDERX,
  cgemm_small_kernel_b0_cn_THUNDERX, cgemm_small_kernel_b0_ct_THUNDERX, cgemm_small_kernel_b0_cr_THUNDERX, cgemm_small_kernel_b0_cc_THUNDERX,
#endif

  ctrsm_kernel_LN_THUNDERX, ctrsm_kernel_LT_THUNDERX, ctrsm_kernel_LR_THUNDERX, ctrsm_kernel_LC_THUNDERX,
  ctrsm_kernel_RN_THUNDERX, ctrsm_kernel_RT_THUNDERX, ctrsm_kernel_RR_THUNDERX, ctrsm_kernel_RC_THUNDERX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_THUNDERX,  ctrsm_iunncopy_THUNDERX,  ctrsm_iutucopy_THUNDERX,  ctrsm_iutncopy_THUNDERX,
  ctrsm_ilnucopy_THUNDERX,  ctrsm_ilnncopy_THUNDERX,  ctrsm_iltucopy_THUNDERX,  ctrsm_iltncopy_THUNDERX,
#else
  ctrsm_ounucopy_THUNDERX,  ctrsm_ounncopy_THUNDERX,  ctrsm_outucopy_THUNDERX,  ctrsm_outncopy_THUNDERX,
  ctrsm_olnucopy_THUNDERX,  ctrsm_olnncopy_THUNDERX,  ctrsm_oltucopy_THUNDERX,  ctrsm_oltncopy_THUNDERX,
#endif
  ctrsm_ounucopy_THUNDERX,  ctrsm_ounncopy_THUNDERX,  ctrsm_outucopy_THUNDERX,  ctrsm_outncopy_THUNDERX,
  ctrsm_olnucopy_THUNDERX,  ctrsm_olnncopy_THUNDERX,  ctrsm_oltucopy_THUNDERX,  ctrsm_oltncopy_THUNDERX,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_THUNDERX,  ctrmm_kernel_RT_THUNDERX,  ctrmm_kernel_RR_THUNDERX,  ctrmm_kernel_RC_THUNDERX,
  ctrmm_kernel_LN_THUNDERX,  ctrmm_kernel_LT_THUNDERX,  ctrmm_kernel_LR_THUNDERX,  ctrmm_kernel_LC_THUNDERX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_THUNDERX,  ctrmm_iunncopy_THUNDERX,  ctrmm_iutucopy_THUNDERX,  ctrmm_iutncopy_THUNDERX,
  ctrmm_ilnucopy_THUNDERX,  ctrmm_ilnncopy_THUNDERX,  ctrmm_iltucopy_THUNDERX,  ctrmm_iltncopy_THUNDERX,
#else
  ctrmm_ounucopy_THUNDERX,  ctrmm_ounncopy_THUNDERX,  ctrmm_outucopy_THUNDERX,  ctrmm_outncopy_THUNDERX,
  ctrmm_olnucopy_THUNDERX,  ctrmm_olnncopy_THUNDERX,  ctrmm_oltucopy_THUNDERX,  ctrmm_oltncopy_THUNDERX,
#endif
  ctrmm_ounucopy_THUNDERX,  ctrmm_ounncopy_THUNDERX,  ctrmm_outucopy_THUNDERX,  ctrmm_outncopy_THUNDERX,
  ctrmm_olnucopy_THUNDERX,  ctrmm_olnncopy_THUNDERX,  ctrmm_oltucopy_THUNDERX,  ctrmm_oltncopy_THUNDERX,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_THUNDERX,  csymm_iltcopy_THUNDERX,
#else
  csymm_outcopy_THUNDERX,  csymm_oltcopy_THUNDERX,
#endif
  csymm_outcopy_THUNDERX,  csymm_oltcopy_THUNDERX,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_THUNDERX,  chemm_iltcopy_THUNDERX,
#else
  chemm_outcopy_THUNDERX,  chemm_oltcopy_THUNDERX,
#endif
  chemm_outcopy_THUNDERX,  chemm_oltcopy_THUNDERX,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_THUNDERX,

  cgemm3m_incopyb_THUNDERX,  cgemm3m_incopyr_THUNDERX,
  cgemm3m_incopyi_THUNDERX,  cgemm3m_itcopyb_THUNDERX,
  cgemm3m_itcopyr_THUNDERX,  cgemm3m_itcopyi_THUNDERX,
  cgemm3m_oncopyb_THUNDERX,  cgemm3m_oncopyr_THUNDERX,
  cgemm3m_oncopyi_THUNDERX,  cgemm3m_otcopyb_THUNDERX,
  cgemm3m_otcopyr_THUNDERX,  cgemm3m_otcopyi_THUNDERX,

  csymm3m_iucopyb_THUNDERX,  csymm3m_ilcopyb_THUNDERX,
  csymm3m_iucopyr_THUNDERX,  csymm3m_ilcopyr_THUNDERX,
  csymm3m_iucopyi_THUNDERX,  csymm3m_ilcopyi_THUNDERX,
  csymm3m_oucopyb_THUNDERX,  csymm3m_olcopyb_THUNDERX,
  csymm3m_oucopyr_THUNDERX,  csymm3m_olcopyr_THUNDERX,
  csymm3m_oucopyi_THUNDERX,  csymm3m_olcopyi_THUNDERX,

  chemm3m_iucopyb_THUNDERX,  chemm3m_ilcopyb_THUNDERX,
  chemm3m_iucopyr_THUNDERX,  chemm3m_ilcopyr_THUNDERX,
  chemm3m_iucopyi_THUNDERX,  chemm3m_ilcopyi_THUNDERX,

  chemm3m_oucopyb_THUNDERX,  chemm3m_olcopyb_THUNDERX,
  chemm3m_oucopyr_THUNDERX,  chemm3m_olcopyr_THUNDERX,
  chemm3m_oucopyi_THUNDERX,  chemm3m_olcopyi_THUNDERX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_THUNDERX,
  
   claswp_ncopy_THUNDERX,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_THUNDERX, zamin_k_THUNDERX, izamax_k_THUNDERX, izamin_k_THUNDERX,
  znrm2_k_THUNDERX, zasum_k_THUNDERX, zsum_k_THUNDERX, zcopy_k_THUNDERX,
  zdotu_k_THUNDERX, zdotc_k_THUNDERX, zdrot_k_THUNDERX,
  zaxpy_k_THUNDERX, zaxpyc_k_THUNDERX, zscal_k_THUNDERX, zswap_k_THUNDERX,

  zgemv_n_THUNDERX, zgemv_t_THUNDERX, zgemv_r_THUNDERX, zgemv_c_THUNDERX,
  zgemv_o_THUNDERX, zgemv_u_THUNDERX, zgemv_s_THUNDERX, zgemv_d_THUNDERX,
  zgeru_k_THUNDERX, zgerc_k_THUNDERX, zgerv_k_THUNDERX, zgerd_k_THUNDERX,
  zsymv_L_THUNDERX, zsymv_U_THUNDERX,
  zhemv_L_THUNDERX, zhemv_U_THUNDERX, zhemv_M_THUNDERX, zhemv_V_THUNDERX,

  zgemm_kernel_n_THUNDERX, zgemm_kernel_l_THUNDERX, zgemm_kernel_r_THUNDERX, zgemm_kernel_b_THUNDERX,
  zgemm_beta_THUNDERX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_THUNDERX, zgemm_itcopy_THUNDERX,
#else
  zgemm_oncopy_THUNDERX, zgemm_otcopy_THUNDERX,
#endif
  zgemm_oncopy_THUNDERX, zgemm_otcopy_THUNDERX,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_THUNDERX,
  zgemm_small_kernel_nn_THUNDERX, zgemm_small_kernel_nt_THUNDERX, zgemm_small_kernel_nr_THUNDERX, zgemm_small_kernel_nc_THUNDERX,
  zgemm_small_kernel_tn_THUNDERX, zgemm_small_kernel_tt_THUNDERX, zgemm_small_kernel_tr_THUNDERX, zgemm_small_kernel_tc_THUNDERX,
  zgemm_small_kernel_rn_THUNDERX, zgemm_small_kernel_rt_THUNDERX, zgemm_small_kernel_rr_THUNDERX, zgemm_small_kernel_rc_THUNDERX,
  zgemm_small_kernel_cn_THUNDERX, zgemm_small_kernel_ct_THUNDERX, zgemm_small_kernel_cr_THUNDERX, zgemm_small_kernel_cc_THUNDERX,
  zgemm_small_kernel_b0_nn_THUNDERX, zgemm_small_kernel_b0_nt_THUNDERX, zgemm_small_kernel_b0_nr_THUNDERX, zgemm_small_kernel_b0_nc_THUNDERX,
  zgemm_small_kernel_b0_tn_THUNDERX, zgemm_small_kernel_b0_tt_THUNDERX, zgemm_small_kernel_b0_tr_THUNDERX, zgemm_small_kernel_b0_tc_THUNDERX,
  zgemm_small_kernel_b0_rn_THUNDERX, zgemm_small_kernel_b0_rt_THUNDERX, zgemm_small_kernel_b0_rr_THUNDERX, zgemm_small_kernel_b0_rc_THUNDERX,
  zgemm_small_kernel_b0_cn_THUNDERX, zgemm_small_kernel_b0_ct_THUNDERX, zgemm_small_kernel_b0_cr_THUNDERX, zgemm_small_kernel_b0_cc_THUNDERX,
#endif

  ztrsm_kernel_LN_THUNDERX, ztrsm_kernel_LT_THUNDERX, ztrsm_kernel_LR_THUNDERX, ztrsm_kernel_LC_THUNDERX,
  ztrsm_kernel_RN_THUNDERX, ztrsm_kernel_RT_THUNDERX, ztrsm_kernel_RR_THUNDERX, ztrsm_kernel_RC_THUNDERX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_THUNDERX,  ztrsm_iunncopy_THUNDERX,  ztrsm_iutucopy_THUNDERX,  ztrsm_iutncopy_THUNDERX,
  ztrsm_ilnucopy_THUNDERX,  ztrsm_ilnncopy_THUNDERX,  ztrsm_iltucopy_THUNDERX,  ztrsm_iltncopy_THUNDERX,
#else
  ztrsm_ounucopy_THUNDERX,  ztrsm_ounncopy_THUNDERX,  ztrsm_outucopy_THUNDERX,  ztrsm_outncopy_THUNDERX,
  ztrsm_olnucopy_THUNDERX,  ztrsm_olnncopy_THUNDERX,  ztrsm_oltucopy_THUNDERX,  ztrsm_oltncopy_THUNDERX,
#endif
  ztrsm_ounucopy_THUNDERX,  ztrsm_ounncopy_THUNDERX,  ztrsm_outucopy_THUNDERX,  ztrsm_outncopy_THUNDERX,
  ztrsm_olnucopy_THUNDERX,  ztrsm_olnncopy_THUNDERX,  ztrsm_oltucopy_THUNDERX,  ztrsm_oltncopy_THUNDERX,

  ztrmm_kernel_RN_THUNDERX,  ztrmm_kernel_RT_THUNDERX,  ztrmm_kernel_RR_THUNDERX,  ztrmm_kernel_RC_THUNDERX,
  ztrmm_kernel_LN_THUNDERX,  ztrmm_kernel_LT_THUNDERX,  ztrmm_kernel_LR_THUNDERX,  ztrmm_kernel_LC_THUNDERX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_THUNDERX,  ztrmm_iunncopy_THUNDERX,  ztrmm_iutucopy_THUNDERX,  ztrmm_iutncopy_THUNDERX,
  ztrmm_ilnucopy_THUNDERX,  ztrmm_ilnncopy_THUNDERX,  ztrmm_iltucopy_THUNDERX,  ztrmm_iltncopy_THUNDERX,
#else
  ztrmm_ounucopy_THUNDERX,  ztrmm_ounncopy_THUNDERX,  ztrmm_outucopy_THUNDERX,  ztrmm_outncopy_THUNDERX,
  ztrmm_olnucopy_THUNDERX,  ztrmm_olnncopy_THUNDERX,  ztrmm_oltucopy_THUNDERX,  ztrmm_oltncopy_THUNDERX,
#endif
  ztrmm_ounucopy_THUNDERX,  ztrmm_ounncopy_THUNDERX,  ztrmm_outucopy_THUNDERX,  ztrmm_outncopy_THUNDERX,
  ztrmm_olnucopy_THUNDERX,  ztrmm_olnncopy_THUNDERX,  ztrmm_oltucopy_THUNDERX,  ztrmm_oltncopy_THUNDERX,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_THUNDERX,  zsymm_iltcopy_THUNDERX,
#else
  zsymm_outcopy_THUNDERX,  zsymm_oltcopy_THUNDERX,
#endif
  zsymm_outcopy_THUNDERX,  zsymm_oltcopy_THUNDERX,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_THUNDERX,  zhemm_iltcopy_THUNDERX,
#else
  zhemm_outcopy_THUNDERX,  zhemm_oltcopy_THUNDERX,
#endif
  zhemm_outcopy_THUNDERX,  zhemm_oltcopy_THUNDERX,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_THUNDERX,

  zgemm3m_incopyb_THUNDERX,  zgemm3m_incopyr_THUNDERX,
  zgemm3m_incopyi_THUNDERX,  zgemm3m_itcopyb_THUNDERX,
  zgemm3m_itcopyr_THUNDERX,  zgemm3m_itcopyi_THUNDERX,
  zgemm3m_oncopyb_THUNDERX,  zgemm3m_oncopyr_THUNDERX,
  zgemm3m_oncopyi_THUNDERX,  zgemm3m_otcopyb_THUNDERX,
  zgemm3m_otcopyr_THUNDERX,  zgemm3m_otcopyi_THUNDERX,

  zsymm3m_iucopyb_THUNDERX,  zsymm3m_ilcopyb_THUNDERX,
  zsymm3m_iucopyr_THUNDERX,  zsymm3m_ilcopyr_THUNDERX,
  zsymm3m_iucopyi_THUNDERX,  zsymm3m_ilcopyi_THUNDERX,
  zsymm3m_oucopyb_THUNDERX,  zsymm3m_olcopyb_THUNDERX,
  zsymm3m_oucopyr_THUNDERX,  zsymm3m_olcopyr_THUNDERX,
  zsymm3m_oucopyi_THUNDERX,  zsymm3m_olcopyi_THUNDERX,

  zhemm3m_iucopyb_THUNDERX,  zhemm3m_ilcopyb_THUNDERX,
  zhemm3m_iucopyr_THUNDERX,  zhemm3m_ilcopyr_THUNDERX,
  zhemm3m_iucopyi_THUNDERX,  zhemm3m_ilcopyi_THUNDERX,

  zhemm3m_oucopyb_THUNDERX,  zhemm3m_olcopyb_THUNDERX,
  zhemm3m_oucopyr_THUNDERX,  zhemm3m_olcopyr_THUNDERX,
  zhemm3m_oucopyi_THUNDERX,  zhemm3m_olcopyi_THUNDERX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_THUNDERX, zlaswp_ncopy_THUNDERX,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_THUNDERX, xamin_k_THUNDERX, ixamax_k_THUNDERX, ixamin_k_THUNDERX,
  xnrm2_k_THUNDERX, xasum_k_THUNDERX, xsum_k_THUNDERX, xcopy_k_THUNDERX,
  xdotu_k_THUNDERX, xdotc_k_THUNDERX, xqrot_k_THUNDERX,
  xaxpy_k_THUNDERX, xaxpyc_k_THUNDERX, xscal_k_THUNDERX, xswap_k_THUNDERX,

  xgemv_n_THUNDERX, xgemv_t_THUNDERX, xgemv_r_THUNDERX, xgemv_c_THUNDERX,
  xgemv_o_THUNDERX, xgemv_u_THUNDERX, xgemv_s_THUNDERX, xgemv_d_THUNDERX,
  xgeru_k_THUNDERX, xgerc_k_THUNDERX, xgerv_k_THUNDERX, xgerd_k_THUNDERX,
  xsymv_L_THUNDERX, xsymv_U_THUNDERX,
  xhemv_L_THUNDERX, xhemv_U_THUNDERX, xhemv_M_THUNDERX, xhemv_V_THUNDERX,

  xgemm_kernel_n_THUNDERX, xgemm_kernel_l_THUNDERX, xgemm_kernel_r_THUNDERX, xgemm_kernel_b_THUNDERX,
  xgemm_beta_THUNDERX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_THUNDERX, xgemm_itcopy_THUNDERX,
#else
  xgemm_oncopy_THUNDERX, xgemm_otcopy_THUNDERX,
#endif
  xgemm_oncopy_THUNDERX, xgemm_otcopy_THUNDERX,

  xtrsm_kernel_LN_THUNDERX, xtrsm_kernel_LT_THUNDERX, xtrsm_kernel_LR_THUNDERX, xtrsm_kernel_LC_THUNDERX,
  xtrsm_kernel_RN_THUNDERX, xtrsm_kernel_RT_THUNDERX, xtrsm_kernel_RR_THUNDERX, xtrsm_kernel_RC_THUNDERX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_THUNDERX,  xtrsm_iunncopy_THUNDERX,  xtrsm_iutucopy_THUNDERX,  xtrsm_iutncopy_THUNDERX,
  xtrsm_ilnucopy_THUNDERX,  xtrsm_ilnncopy_THUNDERX,  xtrsm_iltucopy_THUNDERX,  xtrsm_iltncopy_THUNDERX,
#else
  xtrsm_ounucopy_THUNDERX,  xtrsm_ounncopy_THUNDERX,  xtrsm_outucopy_THUNDERX,  xtrsm_outncopy_THUNDERX,
  xtrsm_olnucopy_THUNDERX,  xtrsm_olnncopy_THUNDERX,  xtrsm_oltucopy_THUNDERX,  xtrsm_oltncopy_THUNDERX,
#endif
  xtrsm_ounucopy_THUNDERX,  xtrsm_ounncopy_THUNDERX,  xtrsm_outucopy_THUNDERX,  xtrsm_outncopy_THUNDERX,
  xtrsm_olnucopy_THUNDERX,  xtrsm_olnncopy_THUNDERX,  xtrsm_oltucopy_THUNDERX,  xtrsm_oltncopy_THUNDERX,

  xtrmm_kernel_RN_THUNDERX,  xtrmm_kernel_RT_THUNDERX,  xtrmm_kernel_RR_THUNDERX,  xtrmm_kernel_RC_THUNDERX,
  xtrmm_kernel_LN_THUNDERX,  xtrmm_kernel_LT_THUNDERX,  xtrmm_kernel_LR_THUNDERX,  xtrmm_kernel_LC_THUNDERX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_THUNDERX,  xtrmm_iunncopy_THUNDERX,  xtrmm_iutucopy_THUNDERX,  xtrmm_iutncopy_THUNDERX,
  xtrmm_ilnucopy_THUNDERX,  xtrmm_ilnncopy_THUNDERX,  xtrmm_iltucopy_THUNDERX,  xtrmm_iltncopy_THUNDERX,
#else
  xtrmm_ounucopy_THUNDERX,  xtrmm_ounncopy_THUNDERX,  xtrmm_outucopy_THUNDERX,  xtrmm_outncopy_THUNDERX,
  xtrmm_olnucopy_THUNDERX,  xtrmm_olnncopy_THUNDERX,  xtrmm_oltucopy_THUNDERX,  xtrmm_oltncopy_THUNDERX,
#endif
  xtrmm_ounucopy_THUNDERX,  xtrmm_ounncopy_THUNDERX,  xtrmm_outucopy_THUNDERX,  xtrmm_outncopy_THUNDERX,
  xtrmm_olnucopy_THUNDERX,  xtrmm_olnncopy_THUNDERX,  xtrmm_oltucopy_THUNDERX,  xtrmm_oltncopy_THUNDERX,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_THUNDERX,  xsymm_iltcopy_THUNDERX,
#else
  xsymm_outcopy_THUNDERX,  xsymm_oltcopy_THUNDERX,
#endif
  xsymm_outcopy_THUNDERX,  xsymm_oltcopy_THUNDERX,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_THUNDERX,  xhemm_iltcopy_THUNDERX,
#else
  xhemm_outcopy_THUNDERX,  xhemm_oltcopy_THUNDERX,
#endif
  xhemm_outcopy_THUNDERX,  xhemm_oltcopy_THUNDERX,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_THUNDERX,

  xgemm3m_incopyb_THUNDERX,  xgemm3m_incopyr_THUNDERX,
  xgemm3m_incopyi_THUNDERX,  xgemm3m_itcopyb_THUNDERX,
  xgemm3m_itcopyr_THUNDERX,  xgemm3m_itcopyi_THUNDERX,
  xgemm3m_oncopyb_THUNDERX,  xgemm3m_oncopyr_THUNDERX,
  xgemm3m_oncopyi_THUNDERX,  xgemm3m_otcopyb_THUNDERX,
  xgemm3m_otcopyr_THUNDERX,  xgemm3m_otcopyi_THUNDERX,

  xsymm3m_iucopyb_THUNDERX,  xsymm3m_ilcopyb_THUNDERX,
  xsymm3m_iucopyr_THUNDERX,  xsymm3m_ilcopyr_THUNDERX,
  xsymm3m_iucopyi_THUNDERX,  xsymm3m_ilcopyi_THUNDERX,
  xsymm3m_oucopyb_THUNDERX,  xsymm3m_olcopyb_THUNDERX,
  xsymm3m_oucopyr_THUNDERX,  xsymm3m_olcopyr_THUNDERX,
  xsymm3m_oucopyi_THUNDERX,  xsymm3m_olcopyi_THUNDERX,

  xhemm3m_iucopyb_THUNDERX,  xhemm3m_ilcopyb_THUNDERX,
  xhemm3m_iucopyr_THUNDERX,  xhemm3m_ilcopyr_THUNDERX,
  xhemm3m_iucopyi_THUNDERX,  xhemm3m_ilcopyi_THUNDERX,

  xhemm3m_oucopyb_THUNDERX,  xhemm3m_olcopyb_THUNDERX,
  xhemm3m_oucopyr_THUNDERX,  xhemm3m_olcopyr_THUNDERX,
  xhemm3m_oucopyi_THUNDERX,  xhemm3m_olcopyi_THUNDERX,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_THUNDERX, xlaswp_ncopy_THUNDERX,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_THUNDERX,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_THUNDERX,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_THUNDERX,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_THUNDERX,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_THUNDERX, somatcopy_k_ct_THUNDERX, somatcopy_k_rn_THUNDERX, somatcopy_k_rt_THUNDERX,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_THUNDERX, domatcopy_k_ct_THUNDERX, domatcopy_k_rn_THUNDERX, domatcopy_k_rt_THUNDERX,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_THUNDERX, comatcopy_k_ct_THUNDERX, comatcopy_k_rn_THUNDERX, comatcopy_k_rt_THUNDERX,
  comatcopy_k_cnc_THUNDERX, comatcopy_k_ctc_THUNDERX, comatcopy_k_rnc_THUNDERX, comatcopy_k_rtc_THUNDERX,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_THUNDERX, zomatcopy_k_ct_THUNDERX, zomatcopy_k_rn_THUNDERX, zomatcopy_k_rt_THUNDERX,
  zomatcopy_k_cnc_THUNDERX, zomatcopy_k_ctc_THUNDERX, zomatcopy_k_rnc_THUNDERX, zomatcopy_k_rtc_THUNDERX,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_THUNDERX, simatcopy_k_ct_THUNDERX, simatcopy_k_rn_THUNDERX, simatcopy_k_rt_THUNDERX,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_THUNDERX, dimatcopy_k_ct_THUNDERX, dimatcopy_k_rn_THUNDERX, dimatcopy_k_rt_THUNDERX,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_THUNDERX, cimatcopy_k_ct_THUNDERX, cimatcopy_k_rn_THUNDERX, cimatcopy_k_rt_THUNDERX,
  cimatcopy_k_cnc_THUNDERX, cimatcopy_k_ctc_THUNDERX, cimatcopy_k_rnc_THUNDERX, cimatcopy_k_rtc_THUNDERX,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_THUNDERX, zimatcopy_k_ct_THUNDERX, zimatcopy_k_rn_THUNDERX, zimatcopy_k_rt_THUNDERX,
  zimatcopy_k_cnc_THUNDERX, zimatcopy_k_ctc_THUNDERX, zimatcopy_k_rnc_THUNDERX, zimatcopy_k_rtc_THUNDERX,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_THUNDERX,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_THUNDERX,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_THUNDERX,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_THUNDERX,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static int get_L3_size() {
  int ret = 0, id = 0x14;
  __asm__ volatile (
    "cpucfg %[ret], %[id]"
    : [ret]"=r"(ret)
    : [id]"r"(id)
    : "memory"
  );
  return ((ret & 0xffff) + 1) * pow(2, ((ret >> 16) & 0xff)) * pow(2, ((ret >> 24) & 0x7f)) / 1024 / 1024; // MB
}
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif

#if defined(LA464)
  int L3_size = get_L3_size();
#ifdef SMP
  if(blas_num_threads == 1){
#endif
    //single thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 8192;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 4096;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 4096;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 2048;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 4096;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 3024;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 2048;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
#ifdef SMP
  }else{
    //multi thread
    if (L3_size == 32){ // 3C5000 and 3D5000
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 1024;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 289;
      TABLE_NAME.dgemm_r = 342;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 512;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 512;
    } else { // 3A5000 and 3C5000L
      TABLE_NAME.sgemm_p = 256;
      TABLE_NAME.sgemm_q = 384;
      TABLE_NAME.sgemm_r = 2048;

      TABLE_NAME.dgemm_p = 112;
      TABLE_NAME.dgemm_q = 300;
      TABLE_NAME.dgemm_r = 738;

      TABLE_NAME.cgemm_p = 128;
      TABLE_NAME.cgemm_q = 256;
      TABLE_NAME.cgemm_r = 1024;

      TABLE_NAME.zgemm_p = 128;
      TABLE_NAME.zgemm_q = 128;
      TABLE_NAME.zgemm_r = 1024;
    }
  }
#endif
#else
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
	TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
	TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
	TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#if (ARCH_RISCV64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.bgemm_r = BGEMM_DEFAULT_R;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_r = SHGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //RISCV64

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  l2 = readenv_atoi("OPENBLAS_L2_SIZE");
  if (l2 != 0)
    return l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
  TABLE_NAME.bgemm_p = BGEMM_DEFAULT_P;
  TABLE_NAME.bgemm_q = BGEMM_DEFAULT_Q;
#endif
#ifdef BUILD_HFLOAT16
  TABLE_NAME.shgemm_p = SHGEMM_DEFAULT_P;
  TABLE_NAME.shgemm_q = SHGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
  TABLE_NAME.bgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.bgemm_p * TABLE_NAME.bgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.bgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_HFLOAT16==1
  TABLE_NAME.shgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.shgemm_p * TABLE_NAME.shgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.shgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //RISCV64
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
