/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderFeatureTypeTrajectory;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.TimeFormatter;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayFeatureTypeTrajectory
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TContent tcontent_ = TContent.SINGLE;
    private VariableDS lonVarDS_;
    private VariableDS latVarDS_;
    private VariableDS timeVarDS_;
    private Array lonArray_;
    private Array latArray_;
    private Array timeArray_;
    private Index llCVIndex_;
    private Index timeCVIndex_;
    private boolean timeVarIsNumeric_;
    private boolean timeVarIsFloat_;
    private TimeFormatter timeParser_;
    protected int elemDimIndex_ = -1;
    private int instanceDimIndex_ = -1;
    private int cvInstanceDimIndex_ = -1;
    private NcAxis elemAxis_;
    private int elemAxisLength_ = -1;
    private int crntInstance_;
    private boolean needsCVSlice_ = true;

    public NcArrayFeatureTypeTrajectory(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() {
        NcDataset dataset = this.getDataset();
        Object njo = this.getNjObject();
        if (!(njo instanceof VariableDS)) {
            throw new NcException("Backing NJ object is not a VariableDS");
        }
        VariableDS njvarDS = (VariableDS)njo;
        VariableDS[] gridvars = NcArrayFeatureTypeTrajectory.getCoordinateVars(dataset, njvarDS);
        if (gridvars == null) {
            throw new NcNullException("Found null when retrieving coordinate vars.");
        }
        this.lonVarDS_ = gridvars[0];
        this.latVarDS_ = gridvars[1];
        this.timeVarDS_ = gridvars[2];
        Dimension elemAxisDim = null;
        Dimension instanceAxisDim = null;
        int llRank = this.lonVarDS_.getRank();
        LOGGER.trace("lon {}, lat {}", (Object)this.lonVarDS_.getShortName(), (Object)this.latVarDS_.getShortName());
        LOGGER.trace("llRank {}", (Object)llRank);
        if (llRank == 1) {
            this.tcontent_ = TContent.SINGLE;
            elemAxisDim = this.lonVarDS_.getDimension(0);
        } else if (llRank == 2) {
            Dimension time1d = null;
            if (this.timeVarDS_ == null) {
                this.tcontent_ = TContent.MULTI_TIME1D;
            } else if (this.timeVarDS_.getRank() == 1) {
                this.tcontent_ = TContent.MULTI_TIME1D;
                if (NcUtils.isRelativeTimeVar(null, this.timeVarDS_)) {
                    time1d = this.timeVarDS_.getDimension(0);
                }
            } else {
                this.tcontent_ = TContent.MULTI_CF;
                elemAxisDim = this.timeVarDS_.getDimension(1);
                this.cvInstanceDimIndex_ = 0;
            }
            for (int i = 0; i < 2; ++i) {
                Dimension dd = this.lonVarDS_.getDimension(i);
                if ((time1d == null || dd != time1d) && !NcArrayFeatureTypeTrajectory.validateDimensionName(dd)) continue;
                elemAxisDim = dd;
                this.cvInstanceDimIndex_ = 1 - i;
                break;
            }
            if (elemAxisDim == null) {
                elemAxisDim = this.lonVarDS_.getDimension(1);
                this.cvInstanceDimIndex_ = 0;
            }
            instanceAxisDim = this.lonVarDS_.getDimension(this.cvInstanceDimIndex_);
        } else {
            throw new NcException("CVs have unexpected rank: " + llRank);
        }
        LOGGER.trace("elemAxisDim {}", (Object)elemAxisDim);
        if (this.timeVarDS_ != null) {
            DataType dtype = this.timeVarDS_.getDataType();
            this.timeVarIsNumeric_ = dtype.isNumeric();
            this.timeVarIsFloat_ = dtype.isFloatingPoint();
            if (this.timeVarIsNumeric_ && NcUtils.isRelativeTimeVar(dataset, this.timeVarDS_)) {
                try {
                    this.timeParser_ = NcUtils.getRelativeTimeHandler(dataset, this.timeVarDS_);
                }
                catch (Exception exc) {
                    LOGGER.debug("Could not construct relative-time parser");
                }
            }
        } else {
            this.timeVarIsNumeric_ = true;
        }
        if (elemAxisDim == null) {
            throw new NcNullException("Found null when for trajectory's element dimension");
        }
        String elemAxisName = elemAxisDim.getShortName();
        this.elemAxisLength_ = elemAxisDim.getLength();
        LOGGER.trace("elem axis {}, {}", (Object)elemAxisName, (Object)this.elemAxisLength_);
        this.elemAxis_ = new NcAxis(NcAxisType.TIME, elemAxisName, this.elemAxisLength_);
        LOGGER.trace("look for dim {}", (Object)elemAxisName);
        if (elemAxisName != null) {
            this.elemDimIndex_ = this.findDimensionIndex(elemAxisName);
        }
        if (this.elemDimIndex_ < 0) {
            this.elemDimIndex_ = NcUtils.findDimensionIndex(this.getNcVariable(), elemAxisDim);
        }
        if (this.elemDimIndex_ < 0) {
            throw new NcException("Lon/lat coordinates use dimension '" + elemAxisName + "', but trajectory does not.");
        }
        if (this.tcontent_ != TContent.SINGLE) {
            if (instanceAxisDim == null) {
                throw new NcNullException("Found null when for trajectory's instance dimension");
            }
            String instanceAxisName = instanceAxisDim.getShortName();
            this.instanceDimIndex_ = this.findDimensionIndex(instanceAxisName);
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.elemDimIndex_ ? null : this.getNcDimension(i);
        }
    }

    public int getLength() {
        return this.elemAxisLength_;
    }

    public NcAxis getAxis() {
        return this.elemAxis_;
    }

    public PointLL lonLatAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            return null;
        }
        if (this.needsCVSlice_ || this.lonArray_ == null) {
            this.doCVSlice();
        }
        try {
            this.llCVIndex_.set(index);
        }
        catch (Exception exc) {
            LOGGER.debug("Exception! index {}, lcvIndex {}", (Object)index, (Object)this.llCVIndex_);
            return null;
        }
        double lon = this.lonArray_.getDouble(this.llCVIndex_);
        double lat = this.latArray_.getDouble(this.llCVIndex_);
        if (Double.isNaN(lon) || Double.isNaN(lat)) {
            return null;
        }
        if (lon > 7200.0 || lon < -7200.0) {
            LOGGER.trace("lon value is ridulous, index {}, val {}", (Object)lon);
            return null;
        }
        if (Math.abs(lat) > 90.0) {
            LOGGER.trace("lat value is not good, index {}, val {}", (Object)index, (Object)lat);
            return null;
        }
        return new PointLL(lon, lat);
    }

    public Object timeAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            return null;
        }
        if (this.timeVarDS_ == null) {
            return index;
        }
        if (this.needsCVSlice_ || this.timeArray_ == null) {
            this.doCVSlice();
        }
        try {
            this.timeCVIndex_.set(index);
        }
        catch (Exception exc) {
            LOGGER.debug("Exception! {}", exc);
            LOGGER.debug("index {}, tcvIndex {}", (Object)index, (Object)this.timeCVIndex_);
            return null;
        }
        Object tval = null;
        if (this.timeVarIsFloat_) {
            tval = this.timeArray_.getDouble(this.timeCVIndex_);
            if (this.timeParser_ != null) {
                tval = this.timeParser_.format((Double)tval);
            }
        } else if (this.timeVarIsNumeric_) {
            tval = this.timeArray_.getLong(this.timeCVIndex_);
            if (this.timeParser_ != null) {
                tval = this.timeParser_.format((Long)tval);
            }
        } else {
            tval = this.timeArray_.getObject(this.timeCVIndex_);
        }
        return tval;
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range [0," + (this.elemAxisLength_ - 1) + "]");
        }
        if (this.needsSlice_ || this.slice_ == null) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        super.setSliceIndex(dimNum, index);
        if (this.tcontent_ != TContent.SINGLE && dimNum == this.instanceDimIndex_) {
            this.needsCVSlice_ = true;
            this.crntInstance_ = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSlice() throws NcException {
        NcArrayFeatureTypeTrajectory ncArrayFeatureTypeTrajectory = this;
        synchronized (ncArrayFeatureTypeTrajectory) {
            int[] sOrigin = new int[this.rank_];
            int[] sShape = new int[this.rank_];
            try {
                this.needsSlice_ = true;
                for (int i = 0; i < this.rank_; ++i) {
                    sOrigin[i] = this.sIndex_[i];
                    sShape[i] = 1;
                }
                sOrigin[this.elemDimIndex_] = 0;
                sShape[this.elemDimIndex_] = this.elemAxisLength_;
                this.slice_ = this.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                this.needsSlice_ = false;
            }
            catch (Exception exc) {
                LOGGER.warn("Exception doing slice: {}, {}", (Object)exc.getClass().getSimpleName(), (Object)exc.getMessage());
                LOGGER.debug("EDM {}, length {}", (Object)this.elemDimIndex_, (Object)this.elemAxisLength_);
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException(exc.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCVSlice() throws NcException {
        NcArrayFeatureTypeTrajectory ncArrayFeatureTypeTrajectory = this;
        synchronized (ncArrayFeatureTypeTrajectory) {
            try {
                LOGGER.trace("content {}", (Object)this.tcontent_);
                if (this.tcontent_ == TContent.SINGLE) {
                    if (this.lonArray_ == null) {
                        this.lonArray_ = this.lonVarDS_.read();
                        this.latArray_ = this.latVarDS_.read();
                        this.llCVIndex_ = this.lonArray_.getIndex();
                    }
                    if (this.timeVarDS_ != null) {
                        this.timeArray_ = this.timeVarDS_.read();
                        this.timeCVIndex_ = this.llCVIndex_;
                    }
                } else {
                    int llrank = this.lonVarDS_.getRank();
                    int[] sOrigin = new int[llrank];
                    int[] sShape = new int[llrank];
                    for (int i = 0; i < llrank; ++i) {
                        sOrigin[i] = 0;
                        sShape[i] = 1;
                    }
                    LOGGER.trace("cvInstanceDimIndex_ {}", (Object)this.cvInstanceDimIndex_);
                    LOGGER.trace("elemDimIndex_ {}", (Object)this.elemDimIndex_);
                    sOrigin[this.cvInstanceDimIndex_] = this.crntInstance_;
                    sShape[this.elemDimIndex_] = this.elemAxisLength_;
                    LOGGER.trace("C");
                    this.lonArray_ = this.lonVarDS_.read(sOrigin, sShape).reduce();
                    LOGGER.trace("D");
                    this.latArray_ = this.latVarDS_.read(sOrigin, sShape).reduce();
                    LOGGER.trace("E");
                    this.llCVIndex_ = this.lonArray_.getIndex();
                    LOGGER.trace("F");
                    if (this.timeVarDS_ != null) {
                        if (this.tcontent_ == TContent.MULTI_TIME1D) {
                            this.timeArray_ = this.timeVarDS_.read();
                            this.timeCVIndex_ = this.timeArray_.getIndex();
                        } else {
                            this.timeArray_ = this.timeVarDS_.read(sOrigin, sShape).reduce();
                            this.timeCVIndex_ = this.llCVIndex_;
                        }
                    }
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to read trajectory coordinate vars: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException("Unable to read coordinate vars: " + exc.toString());
            }
            this.needsCVSlice_ = false;
        }
    }

    @Override
    protected void findExtremaImpl() {
        double[] range = this.getActualRangeAttrValues();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        for (int j = 0; j < this.elemAxisLength_; ++j) {
            this.findExtremaTestValue(this.valueAt(j));
        }
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.elemDimIndex_] = index;
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderFeatureTypeTrajectory();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        sb.append("Not yet implemented");
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS, boolean requireFeatureType) {
        LOGGER.trace("----------");
        LOGGER.trace("var {}, require FT {}", (Object)varDS.getFullName(), (Object)requireFeatureType);
        NcGeometryType geometry = ncd.getGeometry();
        if (requireFeatureType && geometry != NcGeometryType.TRAJECTORY && geometry != NcGeometryType.TRAJECTORY_PROFILE) {
            LOGGER.debug("FT attribute req'd but global metadata does not specify FT trajectory");
            return false;
        }
        if (geometry == NcGeometryType.POINT || geometry == NcGeometryType.TIME_SERIES || geometry == NcGeometryType.PROFILE || geometry == NcGeometryType.TIME_SERIES_PROFILE) {
            LOGGER.debug("A discrete FT is specified but is not a trajectory.");
            return false;
        }
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVars(ncd, varDS);
        return vars != null;
    }

    private static VariableDS[] getCoordinateVars(NcDataset ncd, VariableDS varDS) {
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsCS(varDS);
        if (vars != null) {
            return vars;
        }
        return NcArrayFeatureTypeTrajectory.getCoordinateVarsNoCS(ncd, varDS);
    }

    private static VariableDS[] getCoordinateVarsCS(VariableDS varDS) {
        List csList = varDS.getCoordinateSystems();
        if (csList == null) {
            LOGGER.trace("csList is null");
            return null;
        }
        LOGGER.trace("csList size {}", (Object)csList.size());
        if (csList.isEmpty()) {
            return null;
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        if (cs == null) {
            LOGGER.trace("cs is null", (Object)cs);
            return null;
        }
        LOGGER.trace("Coordinate system found {}", (Object)cs);
        CoordinateAxis lonCV = cs.getLonAxis();
        CoordinateAxis latCV = cs.getLatAxis();
        CoordinateAxis timeCV = cs.getTaxis();
        LOGGER.trace("lon {}, lat {}, time {}", lonCV != null, latCV != null, timeCV != null);
        boolean good = NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, lonCV, latCV, timeCV);
        if (good) {
            return new VariableDS[]{lonCV, latCV, timeCV};
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsNoCS(NcDataset ncd, VariableDS varDS) {
        String[] tokens = NcUtils.parseCoordinatesAttribute(varDS);
        LOGGER.trace("tokens? {}", (Object)(tokens != null ? 1 : 0));
        if (tokens == null || tokens.length == 0) {
            VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsNoTokens(ncd, varDS);
            if (vars != null) {
                return vars;
            }
            return null;
        }
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsAtPaths(ncd, tokens);
        if (vars == null) {
            vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsUpOneLevel(ncd, varDS, tokens);
        }
        if (vars == null) {
            return null;
        }
        boolean good = NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, vars[0], vars[1], vars[2]);
        if (good) {
            return new VariableDS[]{vars[0], vars[1], vars[2]};
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsNoTokens(NcDataset ncd, VariableDS varDS) {
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsTokensX(ncd, varDS, new String[]{"Longitude", "Latitude", "Time"});
        if (vars != null) {
            return vars;
        }
        vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsTokensX(ncd, varDS, new String[]{"Longitude", "Latitude", "Delta_Time"});
        if (vars != null) {
            return vars;
        }
        vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsTokensX(ncd, varDS, new String[]{"lon", "lat", "time"});
        if (vars != null) {
            return vars;
        }
        vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsTokensX(ncd, varDS, new String[]{"longitude", "latitude", "time"});
        if (vars != null) {
            return vars;
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsTokensX(NcDataset ncd, VariableDS varDS, String[] tokens) {
        String altgrpPath;
        Group grp = varDS.getParentGroup();
        String grpPath = grp.getFullName();
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, grp, tokens);
        if (vars != null && NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, vars[0], vars[1], vars[2])) {
            return vars;
        }
        vars = null;
        Group pgrp = grp.getParentGroup();
        if (pgrp == null) {
            return null;
        }
        vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, pgrp, tokens);
        if (vars != null && NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, vars[0], vars[1], vars[2])) {
            return vars;
        }
        vars = null;
        if (grpPath.endsWith("Data_Fields") && (vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, altgrpPath = grpPath.replace("Data_Fields", "Geolocation_Fields"), tokens)) != null && NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, vars[0], vars[1], vars[2])) {
            return vars;
        }
        String pgrpPath = pgrp.getFullName();
        String altgrpPath2 = pgrpPath + "/Geolocation";
        vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, altgrpPath2, tokens);
        if (vars != null && NcArrayFeatureTypeTrajectory.validateCoordinateVars(varDS, vars[0], vars[1], vars[2])) {
            return vars;
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsAtPaths(NcDataset ncd, String[] tokens) {
        LOGGER.trace("tokens {}", (Object)tokens.length);
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        VariableDS timeVarDS = null;
        for (String token : tokens) {
            String stdname;
            VariableDS tokenVar = ncd.getVariableDS(token);
            if (tokenVar == null) continue;
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcUtils.getUnitsStr(tokenVar);
            if ("longitude".equals(lcname) || "lon".equals(lcname) || NcUnitUtils.isDegreesEast(unitsStr)) {
                lonVarDS = tokenVar;
                continue;
            }
            if ("latitude".equals(lcname) || "lat".equals(lcname) || NcUnitUtils.isDegreesNorth(unitsStr)) {
                latVarDS = tokenVar;
                continue;
            }
            if (NcUtils.isRelativeTimeVar(ncd, tokenVar)) {
                timeVarDS = tokenVar;
                continue;
            }
            String str = NcUtils.getAttributeStringIgnoreCase(tokenVar, "standard_name");
            if (str == null || str.isEmpty() || !"time".equals(stdname = str.toLowerCase())) continue;
            timeVarDS = tokenVar;
        }
        if (lonVarDS == null || latVarDS == null || timeVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS, timeVarDS};
    }

    private static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, VariableDS varDS, String ... tokens) {
        Group grp = varDS.getParentGroup();
        String grpPath = grp.getFullName();
        return NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, grpPath, tokens);
    }

    private static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, Group njgrp, String ... tokens) {
        if (njgrp == null) {
            return null;
        }
        String grpPath = njgrp.getFullName();
        return NcArrayFeatureTypeTrajectory.getCoordinateVarsInGroup(ncd, grpPath, tokens);
    }

    private static VariableDS[] getCoordinateVarsInGroup(NcDataset ncd, String grpPath, String ... tokens) {
        if (tokens[0].lastIndexOf(47) >= 0) {
            return null;
        }
        String[] tokens2 = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i] = grpPath.length() > 0 ? grpPath + "/" + tokens[i] : tokens[i];
        }
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        VariableDS timeVarDS = null;
        for (String token : tokens2) {
            String stdname;
            VariableDS tokenVar = ncd.getVariableDS(token);
            if (tokenVar == null) continue;
            String lcname = tokenVar.getShortName().toLowerCase();
            String unitsStr = NcUtils.getUnitsStr(tokenVar);
            if ("longitude".equals(lcname) || NcUnitUtils.isDegreesEast(unitsStr)) {
                lonVarDS = tokenVar;
                continue;
            }
            if ("latitude".equals(lcname) || NcUnitUtils.isDegreesNorth(unitsStr)) {
                latVarDS = tokenVar;
                continue;
            }
            if (NcUtils.isRelativeTimeVar(ncd, tokenVar)) {
                timeVarDS = tokenVar;
                continue;
            }
            String str = NcUtils.getAttributeStringIgnoreCase(tokenVar, "standard_name");
            if (str == null || str.isEmpty() || !"time".equals(stdname = str.toLowerCase())) continue;
            timeVarDS = tokenVar;
        }
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS, timeVarDS};
    }

    private static VariableDS[] getCoordinateVarsUpOneLevel(NcDataset ncd, VariableDS varDS, String[] tokens) {
        LOGGER.trace("");
        String varFullName = varDS.getFullName();
        int slash = varFullName.lastIndexOf(47);
        if (slash < 0) {
            return null;
        }
        if (tokens[0].lastIndexOf(47) >= 0) {
            return null;
        }
        String[] tokens2 = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i] = varFullName.substring(0, slash + 1) + tokens[i];
        }
        VariableDS[] vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsAtPaths(ncd, tokens2);
        if (vars != null) {
            return vars;
        }
        String pgroup = varFullName.substring(0, slash);
        int pslash = pgroup.lastIndexOf(47);
        if (pslash > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                tokens2[i] = varFullName.substring(0, pslash + 1) + tokens[i];
            }
            vars = NcArrayFeatureTypeTrajectory.getCoordinateVarsAtPaths(ncd, tokens2);
        }
        return vars;
    }

    private static boolean validateCoordinateVars(VariableDS varDS, VariableDS lonCV, VariableDS latCV, VariableDS timeCV) {
        Dimension dd2;
        boolean nullTime;
        if (lonCV == null) {
            LOGGER.trace("Longitude CV is null");
            return false;
        }
        if (latCV == null) {
            LOGGER.trace("Latitude CV is null");
            return false;
        }
        boolean bl = nullTime = timeCV == null;
        if (nullTime) {
            LOGGER.trace("time CV is null, but we'll try to work with it");
        }
        int varRank = varDS.getRank();
        int lonRank = lonCV.getRank();
        int latRank = latCV.getRank();
        int timeRank = nullTime ? -1 : timeCV.getRank();
        LOGGER.trace("ranks: var {}, lon {}, lat {}, time {}", varRank, lonRank, latRank, timeRank);
        if (lonRank < 1 || latRank < 1) {
            return false;
        }
        if (lonRank > varRank) {
            LOGGER.trace("Lon rank greater than var rank.");
            return false;
        }
        if (lonRank != latRank) {
            LOGGER.trace("Lon and lat ranks don't match.");
            return false;
        }
        Dimension dd1 = lonCV.getDimension(0);
        if (!dd1.equals(dd2 = latCV.getDimension(0))) {
            return false;
        }
        int didx = NcUtils.findDimensionIndex((Variable)varDS, dd1);
        if (didx < 0) {
            return false;
        }
        boolean isSingleTraj = lonRank == 1 && timeRank < 2;
        boolean isMultiCFTraj = lonRank == 2 && timeRank == 2;
        boolean isMultiXTraj = lonRank == 2 && timeRank < 2;
        boolean good = false;
        try {
            if (isSingleTraj) {
                good = NcArrayFeatureTypeTrajectory.validateSingleTrajectory(lonCV, latCV, timeCV);
            } else if (isMultiCFTraj) {
                good = NcArrayFeatureTypeTrajectory.validateMultiTrajectoryCF(lonCV, latCV, timeCV);
            } else if (isMultiXTraj) {
                good = NcArrayFeatureTypeTrajectory.validateMultiTrajectoryOneTime(lonCV, latCV, timeCV);
            }
            LOGGER.trace("good {}", (Object)good);
        }
        catch (Exception exc) {
            return false;
        }
        return good;
    }

    private static boolean validateSingleTrajectory(VariableDS lonCV, VariableDS latCV, VariableDS timeCV) {
        LOGGER.trace("");
        Dimension londd = lonCV.getDimension(0);
        Dimension latdd = latCV.getDimension(0);
        if (!londd.equals(latdd)) {
            LOGGER.trace("lonCV dimension does not match latCV dimension");
            return false;
        }
        if (timeCV == null) {
            String dname = londd.getShortName();
            boolean isGoodDname = NcArrayFeatureTypeTrajectory.validateDimensionName(londd);
            LOGGER.trace("timeCV is null");
            LOGGER.trace("- lonCV dim {} has recognized element name {}", (Object)dname, (Object)isGoodDname);
            return isGoodDname;
        }
        Dimension timedd = timeCV.getDimension(0);
        if (!londd.equals(timedd)) {
            LOGGER.trace("lonCV dimension does not match apparent timeCV dimension");
            return false;
        }
        boolean isTimeCVRelative = NcUtils.isRelativeTimeVar(null, timeCV);
        LOGGER.trace("is timeCV relative {}", (Object)isTimeCVRelative);
        if (isTimeCVRelative) {
            return true;
        }
        return true;
    }

    private static boolean validateMultiTrajectoryCF(VariableDS lonCV, VariableDS latCV, VariableDS timeCV) {
        LOGGER.trace("");
        for (int i = 0; i < 2; ++i) {
            Dimension londim = lonCV.getDimension(i);
            Dimension latdim = latCV.getDimension(i);
            Dimension timedim = timeCV.getDimension(i);
            if (londim.equals(latdim) && londim.equals(timedim)) continue;
            return false;
        }
        if (LOGGER.isTraceEnabled()) {
            // empty if block
        }
        return true;
    }

    private static boolean validateMultiTrajectoryOneTime(VariableDS lonCV, VariableDS latCV, VariableDS timeCV) {
        LOGGER.trace("");
        for (int i = 0; i < 2; ++i) {
            Dimension latdim;
            Dimension londim = lonCV.getDimension(i);
            if (londim.equals(latdim = latCV.getDimension(i))) continue;
            return false;
        }
        if (timeCV != null) {
            Dimension tdim = timeCV.getDimension(0);
            if (!lonCV.getDimension(0).equals(tdim) && !lonCV.getDimension(1).equals(tdim)) {
                return false;
            }
            boolean isTimeCV = NcUtils.isRelativeTimeVar(null, timeCV);
            LOGGER.trace("Apparent timeCV looks like relative time {}", (Object)isTimeCV);
            if (isTimeCV) {
                return true;
            }
            return NcArrayFeatureTypeTrajectory.validateDimensionName(tdim);
        }
        return true;
    }

    private static boolean validateDimensionName(Dimension dd) {
        if (dd == null) {
            return false;
        }
        String dname = dd.getShortName();
        if (dname == null) {
            return false;
        }
        boolean result = "obs".equalsIgnoreCase(dname) || "sample".equalsIgnoreCase(dname) || "elem".equalsIgnoreCase(dname) || "element".equalsIgnoreCase(dname) || "time".equalsIgnoreCase(dname) || "ntime".equalsIgnoreCase(dname) || "ntimes".equalsIgnoreCase(dname) || "source".equalsIgnoreCase(dname) || "step".equalsIgnoreCase(dname) || "tdim".equalsIgnoreCase(dname) || "vector1".equalsIgnoreCase(dname) || "Footprints".equalsIgnoreCase(dname) || "n_grid_points".equalsIgnoreCase(dname);
        LOGGER.trace("Element dim has time-like name = {}", (Object)result);
        return result;
    }

    public static VariableDS getTimeCoordinateVar(NcDataset ncd, VariableDS varDS) {
        VariableDS[] cvars;
        for (VariableDS cvar : cvars = NcArrayFeatureTypeTrajectory.getCoordinateVars(ncd, varDS)) {
            if (!NcUtils.isUnixTime(cvar)) continue;
            return cvar;
        }
        return null;
    }

    private static enum TContent {
        SINGLE,
        MULTI_CF,
        MULTI_TIME1D;

    }
}

