/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjGridding;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;

public class NcArrayLonLatStereographic
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private static final double TINY_VALUE = 1.0E-8;
    private Projection njProj_;
    private boolean polar_;
    private boolean npolar_;
    private boolean equatorial_;
    private boolean usesPhiTS_;
    private double phiTS_;
    private double k0_ = 1.0;
    private double rk0_;
    private double oneOver2Rk0_;
    private double cosPhiC_;
    private double sinPhiC_;
    private double sin2PhiC_;
    private double m1_;
    private double sinChi1_;
    private double cosChi1_;
    private double rhoTerm_;

    public NcArrayLonLatStereographic(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjGridding.STEREOGRAPHIC);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.STEREOGRAPHIC)) {
            throw new NcException("Variable is not projected type sinSgraphic.");
        }
        LOGGER.trace("Using GISS proj");
        this.initGissProj();
    }

    private void initUnidataProj() {
        CoordinateSystem[] csarray = this.getCoordinateSystemArray();
        if (csarray.length == 0) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = csarray[0];
        if (cs == null) {
            throw new NcException("CoordinateSystem is null");
        }
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcNullException("CoordinateSystem returned null projection handler.");
        }
        LOGGER.trace("CoordinateSystem returned projection {}", (Object)pj.getClass().getSimpleName());
        if (!(pj instanceof Stereographic) && !(pj instanceof StereographicAzimuthalProjection)) {
            LOGGER.warn("Expected Stereographic class but got {}", (Object)pj.getClass().getSimpleName());
            throw new NcException("CoordinateSystem returned projection class " + pj.getClass().getSimpleName() + " when Stereographic was expected");
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("stereographic") && !this.mappingName_.equalsIgnoreCase("polar_stereographic")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not stereographic or polar_stereographic");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        boolean explicitSfactor = this.mappingVarDS_.hasAttribute("scale_factor_at_projection_origin");
        if (explicitSfactor) {
            Attribute sfactorA = this.mappingVarDS_.findAttribute("scale_factor_at_projection_origin");
            this.setScalingFactor(sfactorA.getNumericValue().doubleValue());
        } else {
            this.setScalingFactor(1.0);
        }
        this.usesPhiTS_ = this.mappingVarDS_.hasAttribute("standard_parallel");
        if (this.usesPhiTS_) {
            Attribute phiTSA = this.mappingVarDS_.findAttribute("standard_parallel");
            this.phiTS_ = phiTSA.getNumericValue().doubleValue();
        }
        if (Math.abs(this.phiC_) < 90.0 && this.mappingName_.equalsIgnoreCase("polar_stereographic")) {
            LOGGER.warn("Mapping var says polar stereographic but lat of origin {} is not a pole", (Object)this.phiC_);
            if (this.usesPhiTS_) {
                this.phiC_ = 90.0 * Math.signum(this.phiTS_);
                LOGGER.warn("Will use lat of origin {} based on std parallel {}", (Object)this.phiC_, (Object)this.phiTS_);
            } else {
                this.phiC_ = 90.0 * Math.signum(this.phiC_);
                LOGGER.warn("Will use lat of origin {} as no std parallel is specified", (Object)this.phiC_);
            }
            this.phiCRad_ = Math.toRadians(this.phiC_);
        }
        this.polar_ = this.phiC_ > 89.99999999;
        this.npolar_ = this.polar_ && this.phiC_ > 0.0;
        this.equatorial_ = Math.abs(this.phiC_) < 1.0E-8;
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
        this.sin2PhiC_ = this.sinPhiC_ * this.sinPhiC_;
        if (this.ellipsoid_) {
            this.initGissProjSphere(explicitSfactor);
        } else {
            this.initGissProjSphere(explicitSfactor);
        }
    }

    private void initGissProjSphere(boolean explicitSfactor) {
        if (this.mappingName_.equalsIgnoreCase("polar_stereographic") && this.usesPhiTS_) {
            double absSinPhiTS = Math.abs(Math.sin(Math.toRadians(this.phiTS_)));
            double k0 = 0.5 * (1.0 + absSinPhiTS);
            LOGGER.trace("phiTS {}, absSinPhiTS {}, k0 {}", this.phiTS_, absSinPhiTS, k0);
            if (explicitSfactor) {
                LOGGER.trace("Mapping var has both scale factor and standard parallel attributes.");
                if (Math.abs(this.k0_) == 90.0) {
                    LOGGER.warn("Specified scale factor is set to pole latitude!");
                    LOGGER.warn("Replacing it with calculated k0 {}.", (Object)k0);
                    this.setScalingFactor(k0);
                } else if (k0 != this.k0_) {
                    LOGGER.warn("Specified factor {} does not match calculated from std par {}", (Object)this.k0_, (Object)this.phiTS_);
                    LOGGER.warn("Using calculated factor {} instead", (Object)k0);
                    this.setScalingFactor(k0);
                }
            } else {
                this.setScalingFactor(k0);
            }
        }
    }

    private void initGissProjEllipsoid() {
        this.m1_ = this.cosPhiC_ * Math.sqrt(1.0 - this.eccenSq_ * this.sin2PhiC_);
        this.rhoTerm_ = 2.0 / Math.sqrt(Math.pow(1.0 + this.eccen_, 1.0 + this.eccen_) * Math.pow(1.0 - this.eccen_, 1.0 - this.eccen_));
        double chi1Rad = 0.0;
        if (this.equatorial_) {
            chi1Rad = 0.0;
        } else if (this.polar_) {
            chi1Rad = Math.signum(this.phiC_) * 1.5707963267948966;
        } else {
            double eSinPhiC = this.eccen_ * this.sinPhiC_;
            double chiGuts = (1.0 + this.sinPhiC_) / (1.0 - this.sinPhiC_) * Math.pow((1.0 - eSinPhiC) / (1.0 + eSinPhiC), this.eccen_);
            chi1Rad = 2.0 * Math.atan(Math.sqrt(chiGuts)) - 1.5707963267948966;
        }
        this.sinChi1_ = Math.sin(chi1Rad);
        this.cosChi1_ = Math.cos(chi1Rad);
        if (!this.mappingName_.equalsIgnoreCase("polar_stereographic") || this.usesPhiTS_) {
            // empty if block
        }
    }

    private void setScalingFactor(double k0) {
        this.k0_ = k0;
        this.rk0_ = this.radius_ * this.k0_;
        LOGGER.trace("S {} - RS {}", (Object)this.k0_, (Object)this.rk0_);
        this.oneOver2Rk0_ = 0.5 / this.rk0_;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        if (this.ellipsoid_) {
            return this.transformLL2XYSphere(lon, lat);
        }
        return this.transformLL2XYSphere(lon, lat);
    }

    public Point2D.Double transformLL2XYSphere(double lon, double lat) {
        double y;
        double x;
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double sinLambda = Math.sin(lambdaRad);
        double cosLambda = Math.cos(lambdaRad);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        if (this.polar_) {
            double halfPhiRad = 0.5 * phiRad;
            if (this.npolar_) {
                double twotan = 2.0 * Math.tan(0.7853981633974483 - halfPhiRad);
                x = twotan * sinLambda;
                y = -twotan * cosLambda;
            } else {
                double twotan = 2.0 * Math.tan(0.7853981633974483 + halfPhiRad);
                x = twotan * sinLambda;
                y = twotan * cosLambda;
            }
        } else if (this.equatorial_) {
            double k = 2.0 / (1.0 + cosPhi * cosLambda);
            x = k * cosPhi * sinLambda;
            y = k * sinPhi;
        } else {
            double k = 2.0 / (1.0 + this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda);
            if (k > 2.0) {
                return null;
            }
            x = k * cosPhi * sinLambda;
            y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        }
        return new Point2D.Double(x * this.rk0_ + this.falseEasting_, y * this.rk0_ + this.falseNorthing_);
    }

    public Point2D.Double transformLL2XYEllipsoid(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double sinLambda = Math.sin(lambdaRad);
        double cosLambda = Math.cos(lambdaRad);
        double sinPhi = Math.sin(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (this.polar_) {
            double t = Math.sqrt((1.0 - sinPhi) / (1.0 + sinPhi) * Math.pow((1.0 + this.eccen_ * sinPhi) / (1.0 - this.eccen_ * sinPhi), this.eccen_));
            double rho = this.semimajor_ * this.k0_ * t * this.rhoTerm_;
            x = rho * sinLambda;
            y = -rho * cosLambda;
        } else {
            double chiGuts = (1.0 + sinPhi) / (1.0 - sinPhi) * Math.pow((1.0 - this.eccen_ * sinPhi) / (1.0 + this.eccen_ * sinPhi), this.eccen_);
            double chiRad = 2.0 * Math.atan(Math.sqrt(chiGuts)) - 1.5707963267948966;
            double sinChi = Math.sin(chiRad);
            double cosChi = Math.cos(chiRad);
            if (this.equatorial_) {
                double capA = 2.0 * this.semimajor_ * this.k0_ / (1.0 * cosChi * cosLambda);
                x = capA * cosChi * sinLambda;
                y = capA * sinChi;
            } else {
                double capA = 2.0 * this.semimajor_ * this.k0_ * this.m1_ / (this.cosChi1_ * (1.0 + this.sinChi1_ * sinChi + this.cosChi1_ * cosChi * cosLambda));
                x = capA * cosChi * sinLambda;
                y = capA * (this.cosChi1_ * sinChi - this.sinChi1_ * cosChi * cosLambda);
            }
        }
        return null;
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        if (this.ellipsoid_) {
            return this.transformXY2LLSphere(xx, yy);
        }
        return this.transformXY2LLSphere(xx, yy);
    }

    public PointLL transformXY2LLSphere(double xx, double yy) {
        double rho = Math.hypot(xx, yy);
        double z = 2.0 * Math.atan(rho * this.oneOver2Rk0_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + yy * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = this.polar_ ? (this.npolar_ ? Math.atan2(xx, -yy) : Math.atan2(xx, yy)) : Math.atan2(xx * sinZ, rho * this.cosPhiC_ * cosZ - yy * this.sinPhiC_ * sinZ);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    public PointLL transformXY2LLEllipsoid(double xx, double yy) {
        if (this.polar_) {
            // empty if block
        }
        return null;
    }
}

