/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;

public class NcGridderLatTime
extends NcGridderXY {
    @Override
    public void setXAxisMethod(NcAxisMethod method) {
        if (method != NcAxisMethod.SCALAR) {
            throw new UnsupportedOperationException("Axis method not supported for lat-time gridding.");
        }
    }

    @Override
    public void setYAxisMethod(NcAxisMethod method) {
        if (method != NcAxisMethod.SCALAR) {
            throw new UnsupportedOperationException("Axis method not supported for lat-time gridding.");
        }
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        boolean northToSouth = xVals[0] > xVals[1];
        int northX = northToSouth ? 0 : lastX;
        int southX = northToSouth ? lastX : 0;
        double northXVal = xVals[northX];
        double southXVal = xVals[southX];
        double northEdge = northToSouth ? xBounds[0][0] : xBounds[lastX][1];
        double southEdge = northToSouth ? xBounds[lastX][1] : xBounds[0][0];
        double npExtend = northXVal + (northEdge - northXVal) * 1.75;
        double spExtend = southXVal + (southEdge - southXVal) * 1.75;
        int[] srcCol = new int[this.gridWidth_];
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.rowYY_[j] >= yVals[jj] && this.rowYY_[j] < yVals[jj + 1]) && (!(this.rowYY_[j] <= yVals[jj]) || !(this.rowYY_[j] > yVals[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            if (this.colXX_[i] >= northXVal && this.colXX_[i] <= npExtend) {
                srcCol[i] = -9000;
                continue;
            }
            if (this.colXX_[i] <= southXVal && this.colXX_[i] >= spExtend) {
                srcCol[i] = -8000;
                continue;
            }
            for (int ii = 0; ii < numXs - 1; ++ii) {
                if (!(this.colXX_[i] >= xVals[ii] && this.colXX_[i] < xVals[ii + 1]) && (!(this.colXX_[i] <= xVals[ii]) || !(this.colXX_[i] > xVals[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ < 0) continue;
            double yPct = (this.rowYY_[j] - yVals[rowJ]) / (yVals[rowJP1] - yVals[rowJ]);
            for (int i = 0; i < this.gridWidth_; ++i) {
                double valBR;
                double valBL;
                double valTR;
                double valTL;
                double xPct;
                int colI = srcCol[i];
                int colIP1 = srcCol[i] + 1;
                if (colI >= 0) {
                    xPct = (this.colXX_[i] - xVals[colI]) / (xVals[colIP1] - xVals[colI]);
                    valTL = nca2D.valueAt(colI, rowJ);
                    valTR = nca2D.valueAt(colIP1, rowJ);
                    valBL = nca2D.valueAt(colI, rowJP1);
                    valBR = nca2D.valueAt(colIP1, rowJP1);
                } else if (colI == -9000) {
                    xPct = 0.5;
                    valTR = valTL = nca2D.valueAt(northX, rowJ);
                    valBR = valBL = nca2D.valueAt(northX, rowJP1);
                } else {
                    if (colI != -8000) continue;
                    xPct = 0.5;
                    valTR = valTL = nca2D.valueAt(southX, rowJ);
                    valBR = valBL = nca2D.valueAt(southX, rowJP1);
                }
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }
}

