/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.SymbolFactory;
import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.OutlineSegment;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjParameterListener;
import gov.nasa.giss.map.proj.ui.ProjBooleanComponent;
import gov.nasa.giss.map.proj.ui.ProjDoubleComponent;
import gov.nasa.giss.map.proj.ui.ProjIntegerComponent;
import gov.nasa.giss.map.proj.ui.ProjListComponent;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.map.symbol.SymbolID;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProjection
implements ProjParameterListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int ITER_MAX = 33;
    protected static final double TINY_VALUE = 1.0E-10;
    protected static final double SMALL_VALUE = 1.0E-5;
    protected static final double CLOSE_MARGIN = 0.6;
    protected static final double LAX_MARGIN = 0.6;
    protected static final double ALMOST_90 = 89.99999;
    protected static final double ALMOST_M90 = -89.99999;
    protected static final double ALMOST_180 = 179.99999;
    protected static final double ALMOST_M180 = -179.99999;
    private static boolean devoEnabled_;
    protected static Locale locale_;
    private static PrintfFormat gridLabelFormatter_;
    private static DecimalFormatSymbols formatSymbols_;
    private static char decimalChar_;
    private int[] srcPixels_;
    private int srcWidth_ = 1;
    private int srcHeight_ = 1;
    private double srcCenterX_;
    private double srcCenterY_;
    private double srcCenterLon_;
    private double srcCenterLat_;
    private double srcWidthDeg_;
    private double srcHeightDeg_;
    private double srcPixelPerDegLon_;
    private double srcPixelPerDegLat_;
    private int outWidth_ = 2;
    private int outHeight_ = 2;
    protected int outCenterX_;
    protected int outCenterY_;
    private int lMargin_;
    private int rMargin_;
    private int tMargin_;
    private int bMargin_;
    private boolean needsInverseRefresh_ = true;
    private int[] invArray_;
    protected double lambdaC_;
    protected double lambdaCRad_;
    protected double phiC_;
    protected double phiCRad_;
    private boolean scalingEnabled_;
    private double scaling_ = 1.0;
    protected double rS_ = 1.0;
    protected double r2s2_ = 1.0;
    protected double invRS_ = 1.0;
    protected int dxMax_;
    protected int dyMax_;
    private double xMaxOverRS_ = 1.0;
    private double yMaxOverRS_ = 1.0;
    protected double xmRS_;
    protected double ymRS_;
    private final String name_;
    private final int properties_;
    private ArrayList<ProjExtraParameter> extraParams_;
    private static HashMap<ProjExtraParameter, ProjParamComponent> paramGuiHash_;
    private Color background_ = Color.WHITE;
    private Color borderColor_ = Color.BLACK;
    private BasicStroke borderStroke_ = new BasicStroke(1.75f);
    private Color gridColor_ = Color.GRAY;
    private BasicStroke gridStroke_ = new BasicStroke(1.0f);
    private double lonGridSpacing_ = 30.0;
    private double latGridSpacing_ = 30.0;
    private boolean latGridOffset_;
    private boolean meridiansPruned_;
    private boolean gridLabeled_;
    private int gridLabelStep_ = 1;
    private Font gridFont_ = new Font("SansSerif", 0, 10);
    private Color pathColor_ = Color.RED;
    private BasicStroke pathStroke_ = new BasicStroke(1.0f, 1, 1);
    private SymbolID ptSymbol_ = SymbolID.SALTIRE;
    private float ptSymbolSize_ = 3.0f;
    private boolean constructed_;

    private AbstractProjection() {
        throw new UnsupportedOperationException("Use a constructor that has arguments");
    }

    protected AbstractProjection(String name, int props, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        this.name_ = name;
        this.properties_ = props;
        this.setCenterPrivate(0.0, 0.0);
        this.setMaxXYOverRS(widthFactor, heightFactor);
        this.setSizeAndMargins(width, height, xmargin, ymargin);
        AbstractProjection.setLocale(null);
    }

    protected final void finishConstruction() {
        this.parameterChanged(null);
        this.constructed_ = true;
        this.autoscale();
    }

    public void setSizeAndMargins(int w, int h, int xm, int ym) {
        if (xm < 0) {
            throw new IllegalArgumentException("X margin cannot be negative.");
        }
        if (ym < 0) {
            throw new IllegalArgumentException("Y margin cannot be negative.");
        }
        this.invArray_ = null;
        this.outWidth_ = Math.max(w, 8);
        this.outHeight_ = Math.max(h, 4);
        if (this.outWidth_ < 2 * xm + 8) {
            throw new IllegalArgumentException("Width must be greater than 2*xm+8");
        }
        if (this.outHeight_ < 2 * ym + 4) {
            throw new IllegalArgumentException("Height must be greater than 2*ym+4");
        }
        this.lMargin_ = xm;
        this.tMargin_ = ym;
        this.rMargin_ = this.outWidth_ - xm;
        this.bMargin_ = this.outHeight_ - ym;
        this.outCenterX_ = (int)(0.5 * (double)w);
        this.outCenterY_ = (int)(0.5 * (double)h);
        this.autoscale();
    }

    public int getWidth() {
        return this.outWidth_;
    }

    public int getHeight() {
        return this.outHeight_;
    }

    public int getUsedWidth() {
        return this.outWidth_ - 2 * this.lMargin_;
    }

    public int getUsedHeight() {
        return this.outHeight_ - 2 * this.tMargin_;
    }

    public Insets getInsets() {
        return new Insets(this.tMargin_, this.lMargin_, this.tMargin_, this.lMargin_);
    }

    public Rectangle2D.Double getMarginRect0() {
        return new Rectangle2D.Double(this.lMargin_, this.tMargin_, this.rMargin_ - this.lMargin_, this.bMargin_ - this.tMargin_);
    }

    public Rectangle2D.Double getMarginRectClose() {
        return new Rectangle2D.Double((double)this.lMargin_ - 0.6, (double)this.tMargin_ - 0.6, (double)(this.rMargin_ - this.lMargin_) + 1.2, (double)(this.bMargin_ - this.tMargin_) + 1.2);
    }

    public Rectangle2D.Double getMarginRectLax() {
        return new Rectangle2D.Double((double)this.lMargin_ - 0.6, (double)this.tMargin_ - 0.6, (double)(this.rMargin_ - this.lMargin_) + 1.2, (double)(this.bMargin_ - this.tMargin_) + 1.2);
    }

    protected void setMaxXYOverRS(double sizeFactor) {
        this.setMaxXYOverRS(sizeFactor, sizeFactor);
    }

    protected void setMaxXYOverRS(double wf, double hf) {
        this.xMaxOverRS_ = wf;
        this.yMaxOverRS_ = hf;
    }

    protected final void autoscale() {
        if (!this.constructed_) {
            return;
        }
        this.prepareScaling();
        this.calculateScaling();
        this.finishScaling();
        this.needsInverseRefresh_ = true;
    }

    protected void prepareScaling() {
    }

    private void calculateScaling() {
        int uw = this.outWidth_ - 2 * this.lMargin_;
        int uh = this.outHeight_ - 2 * this.tMargin_;
        double r = this.xMaxOverRS_ > 0.0 && this.yMaxOverRS_ > 0.0 ? 0.5 * Math.min((double)uw / this.xMaxOverRS_, (double)uh / this.yMaxOverRS_) : (this.yMaxOverRS_ > 0.0 ? 0.5 * (double)uh / this.yMaxOverRS_ : 0.5 * (double)uw / this.xMaxOverRS_);
        this.rS_ = r * this.scaling_;
        this.invRS_ = 1.0 / this.rS_;
        this.r2s2_ = this.rS_ * this.rS_;
        this.xmRS_ = this.xMaxOverRS_ > 0.0 ? this.xMaxOverRS_ * this.rS_ : 0.5 * (double)uw;
        double d = this.ymRS_ = this.yMaxOverRS_ > 0.0 ? this.yMaxOverRS_ * this.rS_ : 0.5 * (double)uh;
        if (this.hasProperty(64) || this.hasProperty(16) || this.hasProperty(128) || this.hasProperty(2048)) {
            this.dxMax_ = (int)(0.5 * (double)uw + 0.5);
            this.dyMax_ = (int)(0.5 * (double)uh + 0.5);
        } else {
            this.dxMax_ = (int)(Math.min(0.5 * (double)uw, this.xmRS_ / this.scaling_) + 0.5);
            this.dyMax_ = (int)(Math.min(0.5 * (double)uh, this.ymRS_ / this.scaling_) + 0.5);
        }
        this.needsInverseRefresh_ = true;
    }

    protected void finishScaling() {
    }

    protected boolean isWithinMargins(Point2D.Double pt) {
        Objects.requireNonNull(pt, "Point cannot be null.");
        return this.isWithinMargins(pt.x, pt.y);
    }

    protected boolean isWithinMargins(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return false;
        }
        return !(x < (double)this.lMargin_ - 0.6 || y < (double)this.tMargin_ - 0.6 || x > (double)this.rMargin_ + 0.6) && !(y > (double)this.bMargin_ + 0.6);
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90].");
        }
        Point2D.Double result = this.transformLL2XYIgnoreMargins(lon, lat);
        if (result == null) {
            return null;
        }
        if (!this.isWithinMargins(result)) {
            return null;
        }
        return result;
    }

    public Point2D.Double transformLL2XY(PointLL ll) {
        return this.transformLL2XY(ll.getLon(), ll.getLat());
    }

    public Point transformLL2XYInt(double lon, double lat) {
        Point2D.Double p2d = this.transformLL2XY(lon, lat);
        if (p2d == null) {
            return null;
        }
        return new Point((int)p2d.x, (int)p2d.y);
    }

    protected abstract Point2D.Double transformLL2XYIgnoreMargins(double var1, double var3);

    public final Point2D.Double transformLL2XYIgnoreMargins(PointLL ll) {
        return this.transformLL2XY(ll.getLon(), ll.getLat());
    }

    public abstract PointLL transformXY2LL(double var1, double var3);

    public PointLL transformXY2LL(Point2D.Double xy) {
        return this.transformXY2LL(xy.x, xy.y);
    }

    private PointLL transformXY2LLaaa(Point xy) {
        return this.transformXY2LL((double)xy.x + 0.5, (double)xy.y + 0.5);
    }

    public double transformLLAngle2XYAngle(double lon, double lat, double azimuthAngleRad) {
        if (Math.abs(lat) > 89.99999) {
            return Double.NaN;
        }
        Point2D.Double dot1 = this.transformLL2XY(lon, lat);
        if (dot1 == null) {
            return Double.NaN;
        }
        double tinyStep = lat < 89.998 ? 0.001 : -0.001;
        Point2D.Double dot2 = this.transformLL2XY(lon, lat + tinyStep);
        if (dot2 == null) {
            return Double.NaN;
        }
        double lon3 = lon + tinyStep * Math.sin(azimuthAngleRad) / Math.cos(Math.toRadians(lat));
        double lat3 = lat + tinyStep * Math.cos(azimuthAngleRad);
        if (Math.abs(lat3) > 90.0) {
            return Double.NaN;
        }
        Point2D.Double dot3 = this.transformLL2XY(lon3, lat3);
        if (dot3 == null) {
            return Double.NaN;
        }
        double dx3 = dot3.x - dot1.x;
        double dy3 = dot3.y - dot1.y;
        return Math.atan2(dx3, -dy3);
    }

    public double transformLLAngle2XYAngle(PointLL ll, double azimuthAngleRad) {
        return this.transformLLAngle2XYAngle(ll.getLon(), ll.getLat(), azimuthAngleRad);
    }

    protected double lonToLambda(double lon) {
        return MapUtils.normalizeMP180(lon - this.lambdaC_);
    }

    protected double lonToLambdaRad(double lon) {
        return Math.toRadians(this.lonToLambda(lon));
    }

    public final PointLL getCenter() {
        return new PointLL(this.lambdaC_, this.phiC_);
    }

    public void setCenter(double lon) {
        this.setCenter(lon, 0.0);
    }

    public void setCenter(PointLL pt) {
        this.setCenter(pt.getLon(), pt.getLat());
    }

    public void setCenter(double lon, double lat) {
        this.setCenterPrivate(lon, lat);
    }

    private void setCenterPrivate(double lon, double lat) {
        LOGGER.trace("{}, {}", (Object)lon, (Object)lat);
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Invalid latitude value.");
        }
        this.lambdaC_ = MapUtils.normalizeMP180(lon);
        this.lambdaCRad_ = Math.toRadians(this.lambdaC_);
        this.phiC_ = lat;
        this.phiCRad_ = Math.toRadians(this.phiC_);
        this.needsInverseRefresh_ = true;
    }

    protected void setScalingEnabled() {
        this.scalingEnabled_ = true;
    }

    public boolean isScalingEnabled() {
        return this.scalingEnabled_;
    }

    public ProjDoubleParameter getScalingParameter() {
        return null;
    }

    protected void setScaling(double scaling) {
        if (this.scalingEnabled_) {
            this.scaling_ = scaling;
        } else {
            LOGGER.info("User-specified scaling is not enabled for {} projection", (Object)this.getName());
        }
        this.autoscale();
    }

    public final Color getBackground() {
        return this.background_;
    }

    public final void setBackground(Color c) {
        this.background_ = c;
    }

    @Deprecated
    public final Color getForeground() {
        return this.getBorderColor();
    }

    public final Color getBorderColor() {
        return this.borderColor_;
    }

    @Deprecated
    public final void setForeground(Color c) {
        this.setBorderColor(c);
    }

    public final void setBorderColor(Color c) {
        this.borderColor_ = c;
    }

    public final BasicStroke getBorderStroke() {
        return this.borderStroke_;
    }

    public final void setBorderStroke(BasicStroke s) {
        this.borderStroke_ = s;
    }

    public final Color getGridColor() {
        return this.gridColor_;
    }

    public final void setGridColor(Color c) {
        this.gridColor_ = c;
    }

    public final BasicStroke getGridStroke() {
        return this.gridStroke_;
    }

    public final void setGridStroke(BasicStroke s) {
        this.gridStroke_ = s;
    }

    public final void setGridSpacing(double spacing) {
        this.setGridSpacing(spacing, spacing);
    }

    public final void setGridSpacing(double lonSpacing, double latSpacing) {
        this.setLonGridSpacing(lonSpacing);
        this.setLatGridSpacing(latSpacing);
    }

    public final double getLonGridSpacing() {
        return this.lonGridSpacing_;
    }

    public final void setLonGridSpacing(double spacing) {
        this.lonGridSpacing_ = Math.max(spacing, 0.0);
    }

    public final double getLatGridSpacing() {
        return this.latGridSpacing_;
    }

    public final void setLatGridSpacing(double spacing) {
        this.latGridSpacing_ = Math.max(spacing, 0.0);
    }

    public final boolean getLatGridOffset() {
        return this.latGridOffset_;
    }

    public final void setLatGridOffset(boolean offset) {
        this.latGridOffset_ = offset;
    }

    public final Font getGridFont() {
        return this.gridFont_;
    }

    public final void setGridFont(Font f) {
        this.gridFont_ = f;
    }

    public boolean canLabelGrid() {
        return false;
    }

    public boolean isGridLabeled() {
        return this.gridLabeled_ && this.canLabelGrid();
    }

    public void setGridLabeled(boolean b) {
        this.gridLabeled_ = b;
    }

    public int getGridLabelStep() {
        return this.gridLabelStep_;
    }

    public void setGridLabelStep(int step) {
        if (step < 0 || step > 5) {
            throw new IllegalArgumentException("Grid label step must be in range [0,5].");
        }
        this.gridLabelStep_ = step;
    }

    public boolean canPruneMeridians() {
        return true;
    }

    public boolean areMeridiansPruned() {
        if (!this.canPruneMeridians()) {
            return false;
        }
        return this.meridiansPruned_;
    }

    public void setMeridiansPruned(boolean b) {
        if (!this.canPruneMeridians()) {
            return;
        }
        this.meridiansPruned_ = b;
    }

    public final Color getPathColor() {
        return this.pathColor_;
    }

    public final void setPathColor(Color c) {
        this.pathColor_ = c;
    }

    public final BasicStroke getPathStroke() {
        return this.pathStroke_;
    }

    public final void setPathStroke(BasicStroke s) {
        this.pathStroke_ = s;
    }

    public final void setPointSymbol(SymbolID symbol, float size) {
        this.ptSymbol_ = symbol;
        this.ptSymbolSize_ = size;
    }

    public final void setSourceImage(BufferedImage source) {
        this.setSourceImage(source, LonLatEdges.ENTIRE_GLOBE);
    }

    public final void setSourceImage(BufferedImage source, LonLatEdges xbounds) {
        int hpxl;
        int wpxl;
        double right;
        LonLatEdges bounds = source == null ? LonLatEdges.ENTIRE_GLOBE : xbounds;
        LOGGER.trace("bds {}", (Object)bounds);
        double top = bounds.getNorth();
        double bottom = bounds.getSouth();
        if (top == bottom) {
            throw new IllegalArgumentException("Top and bottom latitude bounds cannot be equal.");
        }
        if (top > 90.0) {
            LOGGER.info("Input map top cannot be > 90; resetting value to 90.");
            top = 90.0;
        }
        if (bottom < -90.0) {
            LOGGER.info("Input map bottom cannot be < -90; resetting value to -90.");
            bottom = -90.0;
        }
        double left = bounds.getWest();
        left = MapUtils.normalizeMP180(left);
        for (right = bounds.getEast(); right <= left; right += 360.0) {
        }
        double wdeg = right - left;
        double hdeg = top - bottom;
        if (wdeg != this.srcWidthDeg_) {
            this.srcWidthDeg_ = wdeg;
            this.needsInverseRefresh_ = true;
        }
        if (hdeg != this.srcHeightDeg_) {
            this.srcHeightDeg_ = hdeg;
            this.needsInverseRefresh_ = true;
        }
        double clon = 0.5 * (right + left);
        double clat = 0.5 * (top + bottom);
        if (clon != this.srcCenterLon_) {
            this.srcCenterLon_ = clon;
            this.needsInverseRefresh_ = true;
        }
        if (clat != this.srcCenterLat_) {
            this.srcCenterLat_ = clat;
            this.needsInverseRefresh_ = true;
        }
        if (source == null) {
            this.srcPixels_ = null;
            wpxl = 2;
            hpxl = 2;
        } else {
            wpxl = source.getWidth(null);
            hpxl = source.getHeight(null);
            this.srcPixels_ = ImageUtils.getARGBPixels(source);
        }
        if (wpxl != this.srcWidth_) {
            this.srcWidth_ = wpxl;
            this.needsInverseRefresh_ = true;
        }
        if (hpxl != this.srcHeight_) {
            this.srcHeight_ = hpxl;
            this.needsInverseRefresh_ = true;
        }
        this.srcCenterX_ = 0.5 * (double)wpxl;
        this.srcCenterY_ = 0.5 * (double)hpxl;
        this.srcPixelPerDegLon_ = (double)wpxl / wdeg;
        this.srcPixelPerDegLat_ = (double)hpxl / hdeg;
    }

    public final int getExtraParamCount() {
        if (this.extraParams_ == null) {
            return 0;
        }
        return this.extraParams_.size();
    }

    public final ProjExtraParameter getParameter(int pid) {
        if (this.extraParams_ == null) {
            throw new IllegalArgumentException(this.getName() + " projection has no additional params");
        }
        if (pid < 0 || pid >= this.extraParams_.size()) {
            throw new IllegalArgumentException("Param ID " + pid + " out of range for " + this.getName());
        }
        return this.extraParams_.get(pid);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
    }

    protected final void addParameter(ProjExtraParameter param) {
        if (this.extraParams_ == null) {
            this.extraParams_ = new ArrayList(5);
        }
        this.extraParams_.add(param);
        param.addParameterListener(this);
        try {
            this.parameterChanged(new ProjParameterEvent(param));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateParamComponents() {
    }

    public final ProjParamComponent getParamComponent(int pid) {
        ProjExtraParameter xp = this.extraParams_.get(pid);
        this.updateParamComponents();
        if (xp == null) {
            return null;
        }
        return this.getParamComponent(xp);
    }

    public final ProjParamComponent getParamComponent(ProjExtraParameter xp) {
        if (xp == null) {
            return null;
        }
        if (this.extraParams_.indexOf(xp) < 0) {
            return null;
        }
        ProjParamComponent comp = paramGuiHash_.get(xp);
        if (comp != null) {
            return comp;
        }
        if (xp instanceof ProjDoubleParameter) {
            comp = new ProjDoubleComponent((ProjDoubleParameter)xp);
        } else if (xp instanceof ProjBooleanParameter) {
            comp = new ProjBooleanComponent((ProjBooleanParameter)xp);
        } else if (xp instanceof ProjIntegerParameter) {
            comp = new ProjIntegerComponent((ProjIntegerParameter)xp);
        } else if (xp instanceof ProjListParameter) {
            comp = new ProjListComponent((ProjListParameter)xp);
        }
        if (comp != null) {
            paramGuiHash_.put(xp, comp);
            return comp;
        }
        throw new RuntimeException("No GUI component defined for " + xp.getClass());
    }

    public final void resetParamComponents() {
        int pcount = this.getExtraParamCount();
        for (int i = 0; i < pcount; ++i) {
            ProjParamComponent pf = this.getParamComponent(i);
            pf.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintMap(Graphics2D g2d) {
        AbstractProjection abstractProjection = this;
        synchronized (abstractProjection) {
            Graphics2D g2x;
            block13: {
                g2x = (Graphics2D)g2d.create();
                if (this.background_ == null) {
                    Composite oldComp = g2x.getComposite();
                    g2x.setComposite(AlphaComposite.Clear);
                    g2x.fillRect(0, 0, this.outWidth_, this.outHeight_);
                    g2x.setComposite(oldComp);
                } else {
                    g2x.setColor(this.background_);
                    g2x.fillRect(0, 0, this.outWidth_, this.outHeight_);
                }
                if (this.srcPixels_ == null) {
                    g2x.dispose();
                    return;
                }
                int backgroundRGB = this.background_ == null ? 0 : this.background_.getRGB();
                int[] dstPixels = new int[this.outWidth_ * this.outHeight_];
                if (this.needsInverseRefresh_) {
                    this.clearAndCalculateInverseArray();
                }
                int offset = 0;
                int rowOffset = 0;
                for (int row = 0; row < this.outHeight_; ++row) {
                    rowOffset = row * this.outWidth_;
                    for (int col = 0; col < this.outWidth_; ++col) {
                        offset = rowOffset + col;
                        if (this.invArray_[offset] >= 0 && this.invArray_[offset] < this.srcPixels_.length) {
                            if (this.srcPixels_[this.invArray_[offset]] == 0) {
                                dstPixels[offset] = backgroundRGB;
                                continue;
                            }
                            dstPixels[offset] = this.srcPixels_[this.invArray_[offset]];
                            continue;
                        }
                        dstPixels[offset] = backgroundRGB;
                    }
                }
                try {
                    g2x.drawImage(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.outWidth_, this.outHeight_, dstPixels, 0, this.outWidth_)), 0, 0, null);
                }
                catch (Exception exc) {
                    LOGGER.error("MemoryImageSource exception; drawImage halted.");
                    if (!LOGGER.isTraceEnabled()) break block13;
                    exc.printStackTrace();
                }
            }
            g2x.dispose();
        }
    }

    public final void drawMapVectorized(Graphics2D g2d) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        if (this.srcPixels_ == null && this.background_ != null) {
            g2x.setColor(this.background_);
            g2x.fillRect(0, 0, this.outWidth_, this.outHeight_);
            g2x.dispose();
            return;
        }
        int backgroundRGB = this.background_ == null ? 0 : this.background_.getRGB();
        int[] dstPixels = new int[this.outWidth_ * this.outHeight_];
        if (this.needsInverseRefresh_) {
            this.clearAndCalculateInverseArray();
        }
        int offset = 0;
        int rowOffset = 0;
        for (int row = 0; row < this.outHeight_; ++row) {
            rowOffset = row * this.outWidth_;
            for (int col = 0; col < this.outWidth_; ++col) {
                offset = rowOffset + col;
                dstPixels[offset] = this.invArray_[offset] >= 0 && this.invArray_[offset] < this.srcPixels_.length ? this.srcPixels_[this.invArray_[offset]] : backgroundRGB;
            }
        }
        g2x.setStroke(GraphicUtils.squareMiterStroke(5.0f));
        ArrayList<ColorArea> areas = new ArrayList<ColorArea>(3600);
        for (int row = 0; row < this.outHeight_; ++row) {
            rowOffset = row * this.outWidth_;
            int first = 0;
            for (int col = 1; col < this.outWidth_ - 1; ++col) {
                offset = rowOffset + col;
                if (dstPixels[offset] == dstPixels[rowOffset + first]) continue;
                Rectangle2D.Double area = new Rectangle2D.Double(first, row, col - first, 1.0);
                areas.add(new ColorArea(dstPixels[rowOffset + first], new Area(area)));
                first = col;
            }
            Rectangle2D.Double area = new Rectangle2D.Double(first, row, (double)this.outWidth_ - 1.0 - (double)first, 1.0);
            areas.add(new ColorArea(dstPixels[rowOffset + first], new Area(area)));
            if (areas.size() <= 3000) continue;
            this.drawAreaVectorized(g2x, areas);
            areas.clear();
        }
        this.drawAreaVectorized(g2x, areas);
        g2x.dispose();
    }

    private void drawAreaVectorized(Graphics2D g2d, ArrayList<ColorArea> areas) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        while (!areas.isEmpty()) {
            ColorArea carea = areas.remove(areas.size() - 1);
            int colorval = carea.colorval_;
            Area area = carea.area_;
            for (int i = areas.size() - 1; i >= 0; --i) {
                carea = areas.get(i);
                if (carea.colorval_ != colorval) continue;
                area.add(carea.area_);
                areas.remove(i);
            }
            Color cc = new Color(colorval);
            if (cc.equals(this.background_)) continue;
            g2x.setColor(cc);
            g2x.fill(area);
            g2x.draw(area);
        }
        g2x.dispose();
    }

    public final void drawGrid(Graphics2D g2d) {
        if (this.gridStroke_ == null || this.gridStroke_.getLineWidth() == 0.0f) {
            return;
        }
        if (this.gridColor_ == null) {
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(this.gridStroke_);
        g2x.setColor(this.gridColor_);
        g2x.setFont(this.gridFont_);
        Shape oldclip = g2x.getClip();
        if (devoEnabled_) {
            LOGGER.trace("DEVO: set full clip");
            g2x.setClip(new Rectangle2D.Double(0.0, 0.0, this.outWidth_, this.outHeight_));
        } else if (oldclip == null) {
            g2x.setClip(this.getMarginRectClose());
        }
        this.drawParallels(g2x);
        this.drawMeridians(g2x);
        g2x.dispose();
    }

    private void drawParallels(Graphics2D g2d) {
        if (this.latGridSpacing_ <= 0.0) {
            return;
        }
        int steps = (int)(90.0 / this.latGridSpacing_);
        double halfSpacing = 0.5 * this.latGridSpacing_;
        if ((double)steps * this.latGridSpacing_ < 90.0) {
            ++steps;
        }
        for (int j = 0; j < steps; ++j) {
            double lat = this.latGridSpacing_ * (double)j;
            if (this.latGridOffset_) {
                lat += halfSpacing;
            }
            if (lat >= 90.0) break;
            boolean showLabel = this.canLabelGrid() && this.gridLabeled_ && this.gridLabelStep_ > 0 && j % this.gridLabelStep_ == 0;
            String label = showLabel ? AbstractProjection.formatValue(lat) + "N" : null;
            this.drawParallel(g2d, lat, label);
            if (!(lat > 0.0)) continue;
            label = showLabel ? AbstractProjection.formatValue(lat) + "S" : null;
            this.drawParallel(g2d, -lat, label);
        }
    }

    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.lambdaC_ - 179.99999;
        ArrayList<PointLL> llpts = new ArrayList<PointLL>(1000);
        double istep = 0.5;
        int isteps = 720;
        for (int ilon = 0; ilon <= 720; ++ilon) {
            double lon = llon + 0.5 * (double)ilon;
            PointLL llpt = new PointLL(lon, lat);
            llpts.add(llpt);
        }
        PointLL[] llPtArray = llpts.toArray(new PointLL[llpts.size()]);
        ProjGraphicUtils.drawBezier(g2d, this.translatePath(llPtArray));
    }

    private void drawMeridians(Graphics2D g2d) {
        if (this.lonGridSpacing_ <= 0.0) {
            return;
        }
        double maxLat1 = 90.0;
        int skip = 1;
        if (this.areMeridiansPruned()) {
            if (this.lonGridSpacing_ < 2.0) {
                skip = 8;
            } else if (this.lonGridSpacing_ < 10.0) {
                skip = 4;
            } else if (this.lonGridSpacing_ < 30.0) {
                skip = 2;
            }
            if (this.latGridSpacing_ < 5.0) {
                maxLat1 = this.latGridSpacing_ * (double)((int)(82.0 / this.latGridSpacing_));
                if (this.latGridOffset_) {
                    maxLat1 += 0.5 * this.latGridSpacing_;
                }
                if (maxLat1 < 82.0 && maxLat1 + this.latGridSpacing_ < 90.0) {
                    maxLat1 += this.latGridSpacing_;
                }
            } else {
                maxLat1 = this.latGridSpacing_ * (double)((int)(80.0 / this.latGridSpacing_));
                if (this.latGridOffset_) {
                    maxLat1 += 0.5 * this.latGridSpacing_;
                }
                if (maxLat1 < 80.0 && maxLat1 + this.latGridSpacing_ < 90.0) {
                    maxLat1 += this.latGridSpacing_;
                }
            }
        }
        int steps = (int)(180.0 / this.lonGridSpacing_);
        for (int i = 0; i <= steps; ++i) {
            double lon = this.lonGridSpacing_ * (double)i;
            boolean showLabel = this.canLabelGrid() && this.gridLabeled_ && this.gridLabelStep_ > 0 && i % this.gridLabelStep_ == 0;
            String label = showLabel ? AbstractProjection.formatValue(lon) + "E" : null;
            double thisMax = 90.0;
            if (this.areMeridiansPruned() && skip > 1) {
                if (i % skip % 2 > 0) {
                    thisMax = maxLat1;
                } else if (i % skip > 0) {
                    thisMax = maxLat1;
                }
            }
            this.drawMeridian(g2d, lon, thisMax, label);
            if (!(lon > 0.0) || !(lon < 180.0)) continue;
            label = showLabel ? AbstractProjection.formatValue(lon) + "W" : null;
            this.drawMeridian(g2d, -lon, thisMax, label);
        }
    }

    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        ArrayList<PointLL> llpts = new ArrayList<PointLL>(1000);
        double lat = -maxLat;
        while (lat < maxLat) {
            llpts.add(new PointLL(lon, lat));
            if (Math.abs(lat) > 89.0) {
                lat += 0.05;
                continue;
            }
            if (Math.abs(lat) > 85.0) {
                lat += 0.125;
                continue;
            }
            lat += 0.25;
        }
        llpts.add(new PointLL(lon, maxLat));
        PointLL[] llPtArray = llpts.toArray(new PointLL[llpts.size()]);
        ProjGraphicUtils.drawBezier(g2d, this.translatePath(llPtArray));
    }

    public final void drawPath(Graphics2D g2d, PointLL ... llPoints) {
        this.drawPath(g2d, llPoints, (String)null, (Font)null);
    }

    public final void drawPath(Graphics2D g2d, OutlineOverlay path) {
        double[] bb1;
        double[] bb0 = this.getBounds().asArray();
        if (!AbstractProjection.rectBoundsIntersect(bb0, bb1 = path.getBounds().asArray())) {
            return;
        }
        int isize = path.size();
        for (int i = 0; i < isize; ++i) {
            OutlineArea area = path.getArea(i);
            bb1 = area.getBounds().asArray();
            if (!AbstractProjection.rectBoundsIntersect(bb0, bb1)) continue;
            int jsize = area.size();
            for (int j = 0; j < jsize; ++j) {
                OutlineSegment segment = area.getSegment(j);
                PointLL[] points = segment.getPoints();
                if (segment.isShapes()) {
                    this.drawPath(g2d, points, (String)null, (Font)null);
                    continue;
                }
                if (!segment.isPoints()) continue;
                this.markPoints(g2d, points, this.pathStroke_, this.pathColor_, null);
            }
        }
    }

    public final void drawPath(Graphics2D g2d, PointLL[] llPoints, String label, Font lfont) {
        if (llPoints == null || llPoints.length == 0) {
            return;
        }
        if (this.pathStroke_ == null || this.pathStroke_.getLineWidth() == 0.0f) {
            return;
        }
        if (this.pathColor_ == null || this.pathColor_.getAlpha() == 0) {
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(this.pathStroke_);
        g2x.setColor(this.pathColor_);
        int isize = llPoints.length;
        int maxPts = 50000;
        if (isize > 66500) {
            int numSects = isize / 50000 + 1;
            for (int i = 0; i < numSects; ++i) {
                int istart = i * 50000;
                int ilast = Math.min((i + 1) * 50000, isize - 1);
                if (istart < isize) {
                    PointLL[] range = Arrays.copyOfRange(llPoints, istart, ilast);
                    if (i == 0) {
                        this.drawPathSection(g2x, llPoints, label, lfont);
                        continue;
                    }
                    this.drawPathSection(g2x, llPoints, null, null);
                    continue;
                }
                break;
            }
        } else {
            this.drawPathSection(g2x, llPoints, label, lfont);
        }
        g2x.dispose();
    }

    protected void drawPathSection(Graphics2D g2d, PointLL[] llPoints, String label, Font lfont) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(this.pathStroke_);
        g2x.setColor(this.pathColor_);
        Point2D.Double[] xyPoints = this.translatePath(llPoints);
        Polygon lpoly = null;
        if (label != null && lfont != null && label.length() > 0 && xyPoints.length > 50) {
            g2x.setFont(lfont);
            FontMetrics fm = g2x.getFontMetrics();
            int twidth = fm.stringWidth(label);
            for (int i = xyPoints.length / 4; i < xyPoints.length - 10; i += 5) {
                boolean goodpt = true;
                for (int j = -5; j < 6; ++j) {
                    if (xyPoints[i + j] != null) continue;
                    goodpt = false;
                    break;
                }
                if (!goodpt) continue;
                Point2D.Double p0 = xyPoints[i];
                Point2D.Double pa = xyPoints[i - 3];
                Point2D.Double pb = xyPoints[i + 3];
                double dy = pb.y - pa.y;
                double dx = pb.x - pa.x;
                double rad = Math.atan2(dy, dx);
                if (rad > 1.5707963267948966) {
                    rad -= Math.PI;
                }
                if (rad < -1.5707963267948966) {
                    rad += Math.PI;
                }
                float px = (float)p0.x;
                float py = (float)p0.y;
                float hw = (float)(0.5 * (double)twidth);
                float hh = (float)(0.5 * (double)fm.getAscent());
                Point[] pc = this.findLabelCorners(px, py, twidth, fm.getAscent(), (float)rad);
                if (this.transformXY2LLaaa(pc[0]) == null || this.transformXY2LLaaa(pc[1]) == null || this.transformXY2LLaaa(pc[2]) == null || this.transformXY2LLaaa(pc[3]) == null) continue;
                g2x.translate(px, py);
                g2x.rotate(rad);
                g2x.drawString(label, -hw, hh);
                g2x.rotate(-rad);
                g2x.translate(-px, -py);
                lpoly = new Polygon(new int[]{pc[0].x, pc[1].x, pc[2].x, pc[3].x}, new int[]{pc[0].y, pc[1].y, pc[2].y, pc[3].y}, 4);
                break;
            }
        }
        Path2D.Double path = new Path2D.Double();
        for (Point2D.Double pt : xyPoints) {
            if (pt == null) {
                if (path.getCurrentPoint() != null) {
                    g2x.draw(path);
                }
                path.reset();
                continue;
            }
            float px = (float)pt.x;
            float py = (float)pt.y;
            if (lpoly != null && lpoly.contains(px, py)) {
                if (path.getCurrentPoint() != null) {
                    g2x.draw(path);
                }
                path.reset();
                continue;
            }
            if (path.getCurrentPoint() == null) {
                path.moveTo(px, py);
                continue;
            }
            path.lineTo(px, py);
        }
        if (path.getCurrentPoint() != null) {
            g2x.draw(path);
        }
        g2x.dispose();
    }

    public void markPoints(Graphics2D g2d, PointLL[] llPoints, BasicStroke stroke, Color edgeColor, Color fillColor) {
        Point2D.Double[] xyPoints;
        if (llPoints == null || llPoints.length == 0) {
            return;
        }
        if (edgeColor == null) {
            return;
        }
        if (stroke == null || stroke.getLineWidth() == 0.0f) {
            return;
        }
        Path2D.Float symbol = SymbolFactory.getSymbol(this.ptSymbol_, this.ptSymbolSize_);
        if (symbol == null) {
            return;
        }
        Rectangle2D sbounds = symbol.getBounds2D();
        double swidth = sbounds.getWidth();
        double sheight = sbounds.getHeight();
        if (swidth == 0.0 || sheight == 0.0) {
            return;
        }
        double cx = sbounds.getCenterX();
        double cy = sbounds.getCenterY();
        boolean fill = fillColor != null && this.ptSymbol_.isClosed();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(stroke);
        for (Point2D.Double pt : xyPoints = this.translatePath(llPoints)) {
            if (pt == null) continue;
            g2x.translate(pt.x - cx, pt.y - cy);
            if (fill) {
                g2x.setColor(fillColor);
                g2x.fill(symbol);
            }
            if (edgeColor != null) {
                g2x.setColor(edgeColor);
                g2x.draw(symbol);
            }
            g2x.translate(-(pt.x - cx), -(pt.y - cy));
        }
        g2x.dispose();
    }

    public void markPoint(Graphics2D g2d, PointLL llPoint, BasicStroke stroke, Color edgeColor, Color fillColor) {
        if (llPoint == null) {
            return;
        }
        if (edgeColor == null && fillColor == null) {
            return;
        }
        Path2D.Float symbol = SymbolFactory.getSymbol(this.ptSymbol_, this.ptSymbolSize_);
        if (symbol == null) {
            return;
        }
        Rectangle2D sbounds = symbol.getBounds2D();
        double swidth = sbounds.getWidth();
        double sheight = sbounds.getHeight();
        if (swidth == 0.0 || sheight == 0.0) {
            return;
        }
        Point2D.Double xy = this.transformLL2XY(llPoint.getLon(), llPoint.getLat());
        if (xy == null) {
            return;
        }
        double cx = sbounds.getCenterX();
        double cy = sbounds.getCenterY();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.translate(xy.x - cx, xy.y - cy);
        if (fillColor != null && this.ptSymbol_.isClosed()) {
            g2x.setColor(fillColor);
            g2x.fill(symbol);
        }
        if (edgeColor != null && stroke != null && stroke.getLineWidth() != 0.0f) {
            g2x.setStroke(stroke);
            g2x.setColor(edgeColor);
            g2x.draw(symbol);
        }
        g2x.dispose();
    }

    private final Point[] findLabelCorners(float px, float py, float w, float h, float angle) {
        float hw = (float)(0.6 * (double)w);
        float hh = (float)(0.6 * (double)h);
        float cosA = (float)Math.cos(angle);
        float sinA = (float)Math.sin(angle);
        int px1 = (int)(px + hw * cosA - hh * sinA);
        int px2 = (int)(px + hw * cosA + hh * sinA);
        int px3 = (int)(px - hw * cosA + hh * sinA);
        int px4 = (int)(px - hw * cosA - hh * sinA);
        int py1 = (int)(py + hw * sinA + hh * cosA);
        int py2 = (int)(py + hw * sinA - hh * cosA);
        int py3 = (int)(py - hw * sinA - hh * cosA);
        int py4 = (int)(py - hw * sinA + hh * cosA);
        return new Point[]{new Point(px1, py1), new Point(px2, py2), new Point(px3, py3), new Point(px4, py4)};
    }

    public void drawBorder(Graphics2D g2d) {
        BasicStroke stroke = this.getBorderStroke();
        if (stroke == null || stroke.getLineWidth() == 0.0f) {
            return;
        }
        Color color = this.getForeground();
        if (color == null) {
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(stroke);
        g2x.setColor(color);
        this.drawBorderLines(g2x);
        g2x.dispose();
    }

    protected abstract void drawBorderLines(Graphics2D var1);

    private void clearAndCalculateInverseArray() {
        if (this.invArray_ == null) {
            this.invArray_ = new int[this.outWidth_ * this.outHeight_];
        }
        for (int j = 0; j < this.outHeight_; ++j) {
            for (int i = 0; i < this.outWidth_; ++i) {
                int offset = j * this.outWidth_ + i;
                this.invArray_[offset] = Integer.MIN_VALUE;
            }
        }
        this.calculateInverseArray();
        this.needsInverseRefresh_ = false;
    }

    protected abstract void calculateInverseArray();

    protected void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    protected void setInverseArrayLocation(int col, int row, double lon, double lat) {
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        int index = row * this.outWidth_ + col;
        int srcX = this.getSrcPixelX(lon);
        if (srcX < 0 || srcX >= this.srcWidth_) {
            return;
        }
        int srcY = this.getSrcPixelY(lat);
        if (srcY < 0 || srcY >= this.srcHeight_) {
            return;
        }
        int srcIndex = srcY * this.srcWidth_ + srcX;
        if (srcIndex > -1) {
            this.invArray_[index] = srcIndex;
        }
    }

    private final int getSrcPixelX(double lon) {
        if (this.srcWidth_ < 1) {
            return -1;
        }
        double dlon = MapUtils.normalizeMP180(lon - this.srcCenterLon_);
        int x = (int)(this.srcCenterX_ + this.srcPixelPerDegLon_ * dlon);
        if (x < 0 || x >= this.srcWidth_) {
            return -1;
        }
        return x;
    }

    private final int getSrcPixelY(double lat) {
        if (this.srcHeight_ < 1) {
            return -1;
        }
        int y = (int)(this.srcCenterY_ - this.srcPixelPerDegLat_ * (lat - this.srcCenterLat_));
        if (y < 0 || y >= this.srcHeight_) {
            return -1;
        }
        return y;
    }

    protected final Point2D.Double[] translatePath(PointLL ... llPoints) {
        Point2D.Double prevDot = null;
        PointLL prevLL = null;
        Point2D.Double midDot = null;
        ArrayList<Point2D.Double> v = new ArrayList<Point2D.Double>(llPoints.length + 50);
        for (PointLL ll : llPoints) {
            Point2D.Double edgeDot;
            if (ll == null) {
                int vsize = v.size();
                if (vsize > 0 && v.get(vsize - 1) != null) {
                    v.add(null);
                }
                prevDot = null;
                prevLL = null;
                continue;
            }
            double lon = ll.getLon();
            double lat = ll.getLat();
            Point2D.Double dot = this.transformLL2XY(lon, lat);
            if (prevLL == null) {
                if (dot == null) {
                    prevDot = null;
                    prevLL = ll.copy();
                    continue;
                }
                v.add(dot);
                prevDot = dot;
                prevLL = ll.copy();
                continue;
            }
            if (dot == null && prevDot == null) {
                int vsize = v.size();
                if (vsize > 0 && v.get(vsize - 1) != null) {
                    v.add(null);
                }
                prevDot = null;
                prevLL = ll.copy();
                continue;
            }
            if (dot != null && prevDot != null) {
                Object[] mid = this.findMidpoint(ll, prevLL);
                midDot = mid == null ? null : (Point2D.Double)mid[1];
                if (midDot == null) {
                    v.add(null);
                } else {
                    double dx1 = midDot.x - prevDot.x;
                    double dx2 = dot.x - midDot.x;
                    double dx12 = dot.x - prevDot.x;
                    double dy1 = midDot.y - prevDot.y;
                    double dy2 = dot.y - midDot.y;
                    double dy12 = dot.y - prevDot.y;
                    double d1 = Math.hypot(dx1, dy1);
                    double d2 = Math.hypot(dx2, dy2);
                    double d12 = Math.hypot(dx12, dy12);
                    if (d12 > 1.0 && d1 / d12 < 0.25) {
                        v.add(midDot);
                        v.add(null);
                    } else if (d12 > 1.0 && d2 / d12 < 0.25) {
                        v.add(null);
                        v.add(midDot);
                    } else if (dx1 * dx2 < 0.0 && (d1 > d12 || d2 > d12)) {
                        v.add(null);
                    }
                }
                v.add(dot);
                prevDot = dot;
                prevLL = ll.copy();
                continue;
            }
            if (dot == null && prevDot != null) {
                Point2D.Double edgeDot2;
                Object[] edge = this.findEdgePoint(0, prevLL, ll);
                if (edge != null && (edgeDot2 = (Point2D.Double)edge[1]) != null) {
                    v.add(edgeDot2);
                }
                v.add(null);
                prevDot = null;
                prevLL = ll.copy();
                continue;
            }
            Object[] edge = this.findEdgePoint(0, ll, prevLL);
            if (edge != null && (edgeDot = (Point2D.Double)edge[1]) != null) {
                v.add(edgeDot);
            }
            v.add(dot);
            prevDot = dot;
            prevLL = ll.copy();
        }
        int vsize = v.size();
        return v.toArray(new Point2D.Double[vsize]);
    }

    private final Object[] findMidpoint(PointLL ll1, PointLL ll2) {
        double lon1 = ll1.getLon();
        double lon2 = ll2.getLon();
        PointLL ll = new PointLL();
        if (Math.abs(lon1 - lon2) < 180.0) {
            ll.setLon(0.5 * (lon1 + lon2));
        } else {
            ll.setLon(0.5 * (lon1 + lon2) + 180.0);
        }
        ll.setLat(0.5 * (ll1.getLat() + ll2.getLat()));
        return new Object[]{ll, this.transformLL2XY(ll)};
    }

    private final Object[] findEdgePoint(int iternum, PointLL insideLL, PointLL outsideLL) {
        if (iternum > 15) {
            return null;
        }
        Object[] o = this.findMidpoint(insideLL, outsideLL);
        PointLL ll = (PointLL)o[0];
        Point2D.Double dot = (Point2D.Double)o[1];
        if (dot == null) {
            return this.findEdgePoint(iternum + 1, insideLL, ll);
        }
        Point2D.Double insideDot = this.transformLL2XY(insideLL);
        double dx = Math.abs(dot.x - insideDot.x);
        double dy = Math.abs(dot.y - insideDot.y);
        if (dx < 2.0 && dy < 2.0) {
            return new Object[]{ll, dot};
        }
        if (dx > 50.0 || dy > 50.0) {
            return this.findEdgePoint(iternum + 1, insideLL, ll);
        }
        return this.findEdgePoint(iternum + 1, ll, outsideLL);
    }

    public LonLatEdges getBounds() {
        return LonLatEdges.ENTIRE_GLOBE;
    }

    public final String getName() {
        return this.name_;
    }

    public final String getNormalizedName() {
        return Normalizer.normalize(this.name_, Normalizer.Form.NFD).replaceAll("\\p{M}", "");
    }

    public final int getProperties() {
        return this.properties_;
    }

    public boolean isRecenterableLon() {
        return true;
    }

    public boolean isRecenterableLat() {
        return this.hasProperty(0x200000);
    }

    public final boolean hasProperty(int prop) {
        return (this.properties_ & prop) != 0;
    }

    private static final boolean rectBoundsIntersect(double[] bb0, double[] bb1) {
        Rectangle2D.Double rect0;
        double temp;
        if (bb0[1] > bb0[3]) {
            temp = bb0[1];
            bb0[1] = bb0[3];
            bb0[3] = temp;
        }
        if (bb1[1] > bb1[3]) {
            temp = bb1[1];
            bb1[1] = bb1[3];
            bb1[3] = temp;
        }
        if ((rect0 = new Rectangle2D.Double(bb0[0], bb0[1], bb0[2] - bb0[0], bb0[3] - bb0[1])).contains(bb1[0], bb1[1]) || rect0.contains(bb1[0], bb1[3]) || rect0.contains(bb1[2], bb1[1]) || rect0.contains(bb1[2], bb1[3])) {
            return true;
        }
        Rectangle2D.Double rect1 = new Rectangle2D.Double(bb1[0], bb1[1], bb1[2] - bb1[0], bb1[3] - bb1[1]);
        if (rect1.contains(bb0[0], bb0[1]) || rect1.contains(bb0[0], bb0[3]) || rect1.contains(bb0[2], bb0[1]) || rect1.contains(bb0[2], bb0[3])) {
            return true;
        }
        boolean intersects = rect1.intersects(rect0);
        if (intersects) {
            return true;
        }
        if ((rect0.outcode(bb1[0], bb1[1]) & 1) != 0) {
            rect0.x = bb0[0] - 360.0;
            rect0.y = bb0[1];
            rect0.width = bb0[2] - bb0[0];
            rect0.height = bb0[3] - bb0[1];
        } else if ((rect0.outcode(bb1[0], bb1[1]) & 4) != 0) {
            rect0.x = bb0[0] + 360.0;
            rect0.y = bb0[1];
            rect0.width = bb0[2] - bb0[0];
            rect0.height = bb0[3] - bb0[1];
        } else {
            return false;
        }
        if (rect0.contains(bb1[0], bb1[1]) || rect0.contains(bb1[0], bb1[3]) || rect0.contains(bb1[2], bb1[1]) || rect0.contains(bb1[2], bb1[3])) {
            return true;
        }
        if (rect1.contains(bb0[0], bb0[1]) || rect1.contains(bb0[0], bb0[3]) || rect1.contains(bb0[2], bb0[1]) || rect1.contains(bb0[2], bb0[3])) {
            return true;
        }
        intersects = rect1.intersects(rect0);
        return intersects;
    }

    public static synchronized void setLocale(Locale l) {
        locale_ = l;
        if (locale_ == null) {
            gridLabelFormatter_ = new PrintfFormat("%.5G");
            formatSymbols_ = new DecimalFormatSymbols();
        } else {
            gridLabelFormatter_ = new PrintfFormat(locale_, "%.5G");
            formatSymbols_ = new DecimalFormatSymbols(locale_);
        }
        decimalChar_ = formatSymbols_.getDecimalSeparator();
    }

    private static final String formatValue(double val) {
        String label = gridLabelFormatter_.sprintfx(val);
        if (label.endsWith(decimalChar_ + "0")) {
            return label.substring(0, label.length() - 2);
        }
        return label;
    }

    public static void setDevoEnabled() {
        devoEnabled_ = true;
    }

    public static boolean isDevoEnabled() {
        return devoEnabled_;
    }

    static {
        locale_ = null;
        gridLabelFormatter_ = new PrintfFormat("%.5G");
        formatSymbols_ = new DecimalFormatSymbols();
        decimalChar_ = formatSymbols_.getDecimalSeparator();
        paramGuiHash_ = new HashMap(5);
    }

    private class ColorArea {
        int colorval_;
        Area area_;

        ColorArea(int colorval, Area area) {
            this.colorval_ = colorval;
            this.area_ = area;
        }
    }
}

