/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baranyi3
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baranyi III";
    public static final int PROPERTIES = 8;
    private static final double CY = 1.843978;
    private static final double C1 = 0.6247786983;
    private static final double C3 = 0.0655077286;
    private static final double C5 = -0.0213008485;
    private static final double C7 = -0.0138266267;
    private static final double C9 = 0.0050611069;
    private static final double THREE_C3 = 0.1965231858;
    private static final double FIVE_C5 = -0.1065042425;
    private static final double SEVEN_C7 = -0.09678638690000001;
    private static final double NINE_C9 = 0.0455499621;
    private static final double B1 = 0.3699964825;
    private static final double B3 = -0.0220124305;
    private static final double B5 = 0.005102638;
    private static final double B7 = -5.647938E-4;
    private static final double B9 = 2.22912E-5;
    private static final double THREE_B3 = -0.0660372915;
    private static final double FIVE_B5 = 0.025513189999999998;
    private static final double SEVEN_B7 = -0.0039535566;
    private static final double NINE_B9 = 2.0062080000000002E-4;
    private static final double B11 = 2.361289;
    private static final double B31 = 1.604944;
    private static final double B12 = 22.961746;
    private static final double B32 = 2.832037;
    private static final double JOIN_PHI = 63.01388;
    private static final double JOIN_PHIRAD = Math.toRadians(63.01388);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.843978;

    public Baranyi3(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.843978);
        this.finishConstruction();
        LOGGER.trace("fPhi(pi/2) {}", (Object)Baranyi3.getFPhi(1.5707963267948966));
        LOGGER.trace("lLambda(pi) {}", (Object)Baranyi3.getLLambda(Math.PI));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double y = 1.843978 * Baranyi3.getFPhi(absPhiRad);
        double x = 0.0;
        double lLambda = Baranyi3.getLLambda(absLambdaRad);
        if (absPhiRad < JOIN_PHIRAD) {
            x = lLambda * (Math.sqrt(2.361289 - y * y) + 1.604944);
        } else {
            double sqterm = y + 2.832037;
            x = lLambda * Math.sqrt(22.961746 - sqterm * sqterm);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lLambda;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        if (phiRad < JOIN_PHIRAD) {
            lLambda = absXOverRS / (Math.sqrt(2.361289 - absYOverRS * absYOverRS) + 1.604944);
        } else {
            double sqterm = absYOverRS + 2.832037;
            lLambda = absXOverRS / Math.sqrt(22.961746 - sqterm * sqterm);
        }
        double lambdaRad = this.iterateLambdaRad(lLambda, absXOverRS);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi3 baranyi3 = this;
        synchronized (baranyi3) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double phiTerm;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = this.iteratePhiRad(yOverRS);
                if (phiRad < JOIN_PHIRAD) {
                    phiTerm = 1.0 / (Math.sqrt(2.361289 - yOverRS * yOverRS) + 1.604944);
                } else {
                    double sqterm = yOverRS + 2.832037;
                    phiTerm = 1.0 / Math.sqrt(22.961746 - sqterm * sqterm);
                }
                for (int ix = 0; ix < this.dxMax_ && !((x = (double)ix + 0.5) > (double)this.dxMax_); ++ix) {
                    double xOverRS = x * this.invRS_;
                    double lLambda = xOverRS * phiTerm;
                    double lambdaRad = this.iterateLambdaRad(lLambda, xOverRS);
                    if (Double.isNaN(lambdaRad)) {
                        LOGGER.trace("Got NaN lambda for x {}, dxMax_ {}", (Object)x, (Object)this.dxMax_);
                        continue block3;
                    }
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getFPhi(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        return phiRad * (0.6247786983 + phiRad2 * (0.0655077286 + phiRad2 * (-0.0213008485 + phiRad2 * (-0.0138266267 + phiRad2 * 0.0050611069))));
    }

    private static double getLLambda(double lambdaRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        return lambdaRad * (0.3699964825 + lambdaRad2 * (-0.0220124305 + lambdaRad2 * (0.005102638 + lambdaRad2 * (-5.647938E-4 + lambdaRad2 * 2.22912E-5))));
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * yOverRS / 1.843978;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = 1.843978 * Baranyi3.getFPhi(phiRad) - yOverRS;
            double dfunc = 1.843978 * (0.6247786983 + phiRad2 * (0.1965231858 + phiRad2 * (-0.1065042425 + phiRad2 * (-0.09678638690000001 + 0.0455499621 * phiRad2))));
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    private double iterateLambdaRad(double lLambda, double xOverRS) {
        double lambdaRad = xOverRS * Math.PI / Math.PI;
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double func = Baranyi3.getLLambda(lambdaRad) - lLambda;
            double dfunc = 0.3699964825 + lambdaRad2 * (-0.0660372915 + lambdaRad2 * (0.025513189999999998 + lambdaRad2 * (-0.0039535566 + 2.0062080000000002E-4 * lambdaRad2)));
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }
}

