/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.FlowerProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BartholomewTetrahedral
extends FlowerProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bartholomew Tetrahedral";
    public static final int PROPERTIES = 131074;
    private static final double JOIN_LAT = 23.4394;
    private static final double JOIN_LAT_RAD = Math.toRadians(23.4394);
    private static final double JOIN_COLAT_RAD = 1.5707963267948966 - JOIN_LAT_RAD;
    private static final double COS_JOIN = Math.cos(JOIN_LAT_RAD);
    private static final double SEC_JOIN = 1.0 / COS_JOIN;
    private static final int NUM_LOBES = 3;
    private static final double LOBE_WIDTH = 120.0;
    private static final double HALF_LOBE_WIDTH = 60.0;
    private static final double LOBE_WIDTH_RAD = Math.toRadians(120.0);
    private static final double HALF_LOBE_WIDTH_RAD = 0.5 * LOBE_WIDTH_RAD;
    private static final double PAR_SCALING = JOIN_COLAT_RAD * SEC_JOIN;
    private static final double INV_PAR_SCALING = COS_JOIN / JOIN_COLAT_RAD;
    private static final double COS_HALF_LOBE_WIDTH = Math.cos(HALF_LOBE_WIDTH_RAD);
    private static final double SIN_HALF_LOBE_WIDTH = Math.sin(HALF_LOBE_WIDTH_RAD);
    private static final double COS_LOBE_WIDTH = Math.cos(LOBE_WIDTH_RAD);
    private static final double SIN_LOBE_WIDTH = Math.sin(LOBE_WIDTH_RAD);
    private static final double MAX_X_OVER_RS = SIN_HALF_LOBE_WIDTH * Math.PI;
    private static final double MAX_Y_OVER_RS = 0.5 * (Math.PI + SIN_HALF_LOBE_WIDTH * (1.5707963267948966 - Math.toRadians(-44.468)));
    private static final double Y_SHIFT = MAX_Y_OVER_RS - Math.PI;
    private static final double REFERENCE_LON = -30.0;
    protected double outCenterYActual_;

    public BartholomewTetrahedral(int width, int height) {
        this(width, height, 0, 0);
    }

    public BartholomewTetrahedral(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 131074, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS, 23.4394, 3);
        super.setCenter(-30.0, 90.0);
        this.finishConstruction();
    }

    @Override
    public final void setCenter(double lon, double lat) {
        LOGGER.trace("Projection does not support changing center.");
    }

    @Override
    protected final void finishScaling() {
        this.outCenterYActual_ = (double)this.outCenterY_ - Y_SHIFT * this.rS_;
        LOGGER.trace("OCY {}, shift {}, OCYA {}", this.outCenterY_, Y_SHIFT, this.outCenterYActual_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double y;
        double x;
        if (lat > 89.99999) {
            return new Point2D.Double(this.outCenterX_, this.outCenterYActual_);
        }
        double phiRad = Math.toRadians(lat);
        if (lat >= 23.4394) {
            double sinPhi;
            double lambdaRad = this.lonToLambdaRad(lon);
            double cosPhi = Math.cos(phiRad);
            double cosZ = sinPhi = Math.sin(phiRad);
            double z = Math.acos(cosZ);
            double k = z / Math.sin(z);
            double rho = k * cosPhi;
            x = rho * Math.sin(lambdaRad);
            y = -rho * Math.cos(lambdaRad);
        } else {
            double alphaRad;
            double lambda;
            for (lambda = this.lonToLambda(lon); lambda < 0.0; lambda += 360.0) {
            }
            int lobe = (int)(lambda / 120.0);
            double rho = alphaRad = 1.5707963267948966 - phiRad;
            double rotateDeg = -(120.0 * (double)lobe + 60.0);
            double xlambdaRad = Math.toRadians(lambda + rotateDeg);
            double betaRad = lat < -89.99999 ? 0.0 : PAR_SCALING * xlambdaRad * Math.cos(phiRad) / alphaRad;
            double xx = rho * Math.sin(betaRad);
            double yy = -rho * Math.cos(betaRad);
            double xxx = COS_HALF_LOBE_WIDTH * xx - SIN_HALF_LOBE_WIDTH * yy;
            double yyy = SIN_HALF_LOBE_WIDTH * xx + COS_HALF_LOBE_WIDTH * yy;
            switch (lobe) {
                case 1: {
                    x = COS_LOBE_WIDTH * xxx - SIN_LOBE_WIDTH * yyy;
                    y = SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                    break;
                }
                case 2: {
                    x = COS_LOBE_WIDTH * xxx + SIN_LOBE_WIDTH * yyy;
                    y = -SIN_LOBE_WIDTH * xxx + COS_LOBE_WIDTH * yyy;
                    break;
                }
                default: {
                    x = xxx;
                    y = yyy;
                }
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = this.outCenterYActual_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lambdaRad;
        double yOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = this.outCenterYActual_ - yy;
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double absx = Math.abs(x);
        double xOverRS = absx * this.invRS_;
        double rho = Math.sqrt(xOverRS * xOverRS + (yOverRS = y * this.invRS_) * yOverRS);
        if (rho > Math.PI) {
            return null;
        }
        double phiRad = 1.5707963267948966 - rho;
        if (phiRad >= JOIN_LAT_RAD) {
            lambdaRad = Math.atan2(absx, -y);
        } else {
            double zetaRad;
            for (zetaRad = Math.atan2(absx, -y); zetaRad < 0.0; zetaRad += Math.PI * 2) {
            }
            int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
            double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
            double cosRotate = Math.cos(rotateRad);
            double sinRotate = Math.sin(rotateRad);
            double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
            double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
            double alphaRad = rho;
            double betaRad = Math.atan2(Math.abs(xrot), -yrot);
            lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
            if (lambdaRad > HALF_LOBE_WIDTH_RAD) {
                return null;
            }
            if (xrot < 0.0) {
                lambdaRad = -lambdaRad;
            }
            lambdaRad -= rotateRad;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        if ((phi = Math.toDegrees(phiRad)) < -90.0) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BartholomewTetrahedral bartholomewTetrahedral = this;
        synchronized (bartholomewTetrahedral) {
            for (int iiy = this.dyMax_; iiy > -this.dyMax_; --iiy) {
                int iy = -iiy;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y2OverR2S2 = yOverRS * yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rho = Math.sqrt(xOverRS * xOverRS + y2OverR2S2);
                    if (rho > Math.PI) continue;
                    double phiRad = 1.5707963267948966 - rho;
                    if (phiRad >= JOIN_LAT_RAD) {
                        lambdaRad = Math.atan2(xOverRS, -yOverRS);
                    } else {
                        double zetaRad = Math.atan2(xOverRS, -yOverRS);
                        int lobe = (int)(zetaRad / LOBE_WIDTH_RAD);
                        double rotateRad = -(HALF_LOBE_WIDTH_RAD + (double)lobe * LOBE_WIDTH_RAD);
                        double cosRotate = Math.cos(rotateRad);
                        double sinRotate = Math.sin(rotateRad);
                        double xrot = xOverRS * cosRotate - yOverRS * sinRotate;
                        double yrot = xOverRS * sinRotate + yOverRS * cosRotate;
                        double alphaRad = rho;
                        double betaRad = Math.atan2(Math.abs(xrot), -yrot);
                        lambdaRad = alphaRad * betaRad * INV_PAR_SCALING / Math.cos(phiRad);
                        if (lambdaRad > HALF_LOBE_WIDTH_RAD) continue;
                        if (xrot < 0.0) {
                            lambdaRad = -lambdaRad;
                        }
                        lambdaRad -= rotateRad;
                    }
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }
}

