/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class McBrydeP3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde P3";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 49.3393888889;
    private static final double JOIN_LAT_RAD = Math.toRadians(49.3393888889);
    private static final double YSHIFT = 0.035509;
    private static final double SQRT_3PI = 3.0699801238394655;
    private static final double SQRT_3OVERPI = 0.9772050238058397;
    private static final double THREE_SQRT6 = 3.0 * Math.sqrt(6.0);
    private static final double SQRT_6OVER7 = Math.sqrt(0.8571428571428571);
    private static final double SQRT_7OVER6 = 1.0 / SQRT_6OVER7;
    private static final double NINE_OVER_SQRT7 = 9.0 / Math.sqrt(7.0);
    private static final double MAX_X_OVER_RS = 3.0699801238394655;
    private static final double MAX_Y_OVER_RS = NINE_OVER_SQRT7 * Math.sin(Math.asin(7.0 / THREE_SQRT6) / 3.0) - 0.035509;
    private double joinYRS_;
    private double rSSqrt3OverPi_;
    private double invRSSqrt3Pi_;
    private double sqrt7Over6OverRs_;
    private double xFactor0_;

    public McBrydeP3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeP3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, 3.0699801238394655, MAX_Y_OVER_RS);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.MCBCONT.toString());
        interrupt.setValue(Interruption.MCBCONT.toString());
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.rSSqrt3OverPi_ = this.rS_ * 0.9772050238058397;
        this.invRSSqrt3Pi_ = 1.0 / (this.rS_ * 3.0699801238394655);
        this.sqrt7Over6OverRs_ = SQRT_7OVER6 * this.invRS_;
        this.xFactor0_ = 1.0 / this.rSSqrt3OverPi_;
        double yy = 3.0699801238394655 * Math.sin(JOIN_LAT_RAD / 3.0);
        this.joinYRS_ = yy * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        double absLat = Math.abs(lat);
        if (lat == 0.0 && !this.isInterrupted()) {
            double x2 = 0.9772050238058397 * this.lonToLambdaRad(lon);
            double y2 = 0.0;
            x2 = (double)this.outCenterX_ + x2 * this.rS_;
            y2 = (double)this.outCenterY_ - y2 * this.rS_;
            return new Point2D.Double(x2, y2);
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = 0.0;
        double phiRadOver3 = 0.0;
        if (absLat > 49.3393888889) {
            thetaRad = Math.asin(7.0 * Math.sin(phiRad) / THREE_SQRT6);
            y = NINE_OVER_SQRT7 * Math.sin(thetaRad / 3.0);
            y = lat > 0.0 ? (y -= 0.035509) : (y += 0.035509);
        } else {
            phiRadOver3 = phiRad / 3.0;
            y = 3.0699801238394655 * Math.sin(phiRadOver3);
        }
        if (this.isInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double nlon = MapUtils.normalizeMP180(lon);
            double dlon = nlon - gore[1];
            double dx = Math.toRadians(dlon);
            dx = absLat > 49.3393888889 ? (dx *= SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0)) : (dx *= 0.9772050238058397 * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0));
            double cx = this.lonToLambdaRad(gore[1]) * 0.9772050238058397;
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            x = absLat > 49.3393888889 ? (x *= SQRT_6OVER7 * (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0)) : (x *= 0.9772050238058397 * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinYRS_) {
            double yOverRS = Math.abs(y) * this.invRS_ + 0.035509;
            double thetaRad = 3.0 * Math.asin(yOverRS / NINE_OVER_SQRT7);
            double sinTheta = Math.sin(thetaRad);
            phiRad = Math.asin(sinTheta * THREE_SQRT6 / 7.0);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = -phiRad;
            }
            xFactor = this.sqrt7Over6OverRs_ / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
        } else {
            phiRad = 3.0 * Math.asin(y * this.invRSSqrt3Pi_);
            xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
        }
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeP3 mcBrydeP3 = this;
        synchronized (mcBrydeP3) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (Math.abs(y) > this.joinYRS_) {
                    double yOverRS = y * this.invRS_;
                    yOverRS = y > 0.0 ? (yOverRS += 0.035509) : (yOverRS -= 0.035509);
                    double thetaRad = 3.0 * Math.asin(yOverRS / NINE_OVER_SQRT7);
                    double sinTheta = Math.sin(thetaRad);
                    phiRad = Math.asin(sinTheta * THREE_SQRT6 / 7.0);
                    if (phiRad > 1.5707963267948966) continue;
                    xFactor = this.sqrt7Over6OverRs_ / (2.0 * Math.cos(thetaRad * 2.0 / 3.0) - 1.0);
                } else {
                    phiRad = 3.0 * Math.asin(y * this.invRSSqrt3Pi_);
                    xFactor = 1.0 / (this.rSSqrt3OverPi_ * (2.0 * Math.cos(phiRad * 2.0 / 3.0) - 1.0));
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

