/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanBackgroundAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long last_;
    private boolean busy_;
    private PanPlotMeta pmeta_;

    public PanBackgroundAction(PanPlotMeta pmeta) {
        super("background");
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanPlotFrame pframe = this.pmeta_.getFrame();
        if (pframe == null) {
            return;
        }
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        Object source = e == null ? null : e.getSource();
        Color newval = null;
        long now = System.currentTimeMillis();
        if (now - this.last_ < 200L) {
            // empty if block
        }
        if (source instanceof JMenuItem) {
            String ctext = ((JMenuItem)source).getText().toLowerCase();
            newval = ctext.startsWith("black") ? Color.BLACK : Color.WHITE;
        } else if (source instanceof ColorComboBox) {
            ColorComboBox combo = (ColorComboBox)source;
            newval = combo.getSelectedColor();
        } else if (source == null) {
            newval = this.pmeta_.getColor("color.background");
        } else {
            LOGGER.trace("Unexpected source: {}", (Object)source.getClass().getSimpleName());
            newval = this.pmeta_.getColor("color.background");
        }
        Color cold = this.pmeta_.getColor("color.background");
        if (!newval.equals(cold)) {
            this.pmeta_.setColor("color.background", newval);
        }
        EventQueue.invokeLater(() -> pframe.getPanMenuBar().refresh());
        this.last_ = now;
        this.busy_ = false;
    }
}

