/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.io.PanImageUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class PanSaveImageAsAction
extends AbstractAction {
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("save-image-as");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private final PanDisplayFrame parent_;
    private String fnameRoot_;
    private String fnameExt_;
    private File outputFile_;

    public PanSaveImageAsAction(PanDisplayFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
        this.fnameExt_ = PREFS.getString("files:save.image.fext").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanSaveImageAsAction panSaveImageAsAction = this;
        synchronized (panSaveImageAsAction) {
            this.fnameRoot_ = null;
            this.fnameExt_ = PREFS.getString("files:save.image.fext").toLowerCase();
            this.outputFile_ = null;
        }
    }

    public void setFnameRoot(String root) {
        this.fnameRoot_ = root;
        if (this.fnameExt_ == null || this.fnameExt_.isEmpty()) {
            this.fnameExt_ = PREFS.getString("files:save.image.fext").toLowerCase();
        }
        this.outputFile_ = null;
    }

    public File getFile() {
        return this.outputFile_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle().replaceAll("\\s+", "_");
        }
        if (this.fnameExt_ == null) {
            this.fnameExt_ = PREFS.getString("files:save.image.fext").toLowerCase();
        }
        if ((file = PanFileUtils.showSaveImageFileChooser(this.parent_, this.fnameRoot_, this.fnameExt_)) == null) {
            return;
        }
        this.outputFile_ = file;
        this.fnameRoot_ = FileUtils.extractFnameRoot(file);
        this.fnameExt_ = FileUtils.extractFnameExt(file);
        PanImageUtils.saveImage(file, this.parent_);
        PREFS.set("files:save.image.fext", this.fnameExt_.toUpperCase());
        this.parent_.setTitle(this.fnameRoot_);
        this.parent_.toFront();
    }
}

