/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.Data;
import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.panoply.data.PanDataEvent;
import gov.nasa.giss.panoply.data.PanDataListener;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanConstants;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.SlowMessage;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.DerivedUnit;
import ucar.units.SI;
import ucar.units.Unit;

public abstract class PanData
implements Data {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final double MIN_FOR_LOG_AXIS = 1.0E-50;
    private final Object lock_ = new Object();
    private PanPlotMeta pmeta_;
    protected PanCombinationType comboType_ = PanCombinationType.A1_ONLY;
    protected NcArray[] ncArrays_ = new NcArray[2];
    protected Unit[] ncaUdunits_ = new Unit[2];
    protected Converter[] ncarUnitConverters_ = new Converter[2];
    protected String targetUnitsString_;
    protected Unit targetUcarUnit_;
    protected Converter targetConverter_;
    protected PrintfFormat scaleFormatter_;
    protected boolean interpolated_;
    protected boolean needsGridding_ = true;
    protected boolean gridding_;
    protected boolean needsExtrema_ = true;
    protected double dataMin_;
    protected double dataMax_;
    private double scalingCoeff_;
    private int scalingExponent_;
    protected double scalingFactor_ = this.scalingCoeff_ = 1.0;
    protected double[][] outputVals_ = new double[2][];
    private static Unit SCALAR_UNIT;
    private static Unit SPEED_UNIT;
    private final EventListenerList listenerList_ = new EventListenerList();

    protected PanData(PanPlotMeta pmeta, NcArray nca) {
        if (!this.validateArrayType(nca)) {
            throw new IllegalArgumentException("Wrong type of NcArray.");
        }
        this.pmeta_ = pmeta;
        this.setArray(0, nca);
        this.setUnits(nca.getUnitsStr());
        if (pmeta.containsKey("interpolate")) {
            this.setInterpolated(pmeta.getBoolean("interpolate"));
        } else {
            this.setInterpolated(true);
        }
        this.setScalingCoefficient(pmeta.getDouble("scale.coefficient"));
        this.setScalingExponent(pmeta.getInt("scale.exponent"));
        this.setScaleFormat(pmeta.getString("scale.tick.format"));
    }

    protected abstract boolean validateArrayType(NcArray var1);

    public String[] getArraySource(int index) {
        if (this.ncArrays_[index] == null) {
            return null;
        }
        NcDataset ncd = this.ncArrays_[index].getDataset();
        String addrStr = ncd.getAddress();
        if (PanFileUtils.isLocalFile(addrStr)) {
            // empty if block
        }
        String vpath = this.ncArrays_[index].getNjPath();
        return new String[]{addrStr, vpath};
    }

    public NcArray[] getArrays() {
        return this.ncArrays_;
    }

    public NcArray getArray(int idx) {
        if (idx < 0 || idx > 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.ncArrays_[idx];
    }

    public final void setScaleFormat(String fmt) {
        Objects.requireNonNull(fmt, "Format string cannot be null.");
        this.scaleFormatter_ = new PrintfFormat(fmt);
    }

    protected void setBoundsChanged() {
        this.needsGridding_ = true;
        this.fireDataEvent(PanDataEvent.EType.BOUNDS_CHANGED);
    }

    public synchronized void setArray(int idx, NcArray nca) {
        if (idx < 0 || idx > 1) {
            throw new IndexOutOfBoundsException();
        }
        this.ncArrays_[idx] = nca;
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.ncaUdunits_[idx] = SCALAR_UNIT;
        Unit uu = nca.getUdunits();
        if (uu != null) {
            this.ncaUdunits_[idx] = uu;
        }
        this.findExtrema();
        this.fireDataEvent(PanDataEvent.EType.VARIABLE_CHANGED);
    }

    public int getSlice(int arrayNum, int dimNum) {
        return this.ncArrays_[arrayNum].getSliceIndex(dimNum);
    }

    public void setSlice(int arrayNum, int dimNum, int index) {
        this.ncArrays_[arrayNum].setSliceIndex(dimNum, index);
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public PanCombinationType getCombinationType() {
        return this.comboType_;
    }

    public void setCombinationType(PanCombinationType newtype) {
        LOGGER.trace("{}", (Object)newtype);
        if (this.comboType_ == newtype) {
            return;
        }
        this.comboType_ = newtype;
        LOGGER.trace("updateUnitConverters");
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        LOGGER.trace("findExtrema");
        this.findExtrema();
    }

    public boolean isInterpolated() {
        return this.interpolated_;
    }

    public void setInterpolated(boolean newval) {
        if (newval == this.interpolated_) {
            return;
        }
        this.interpolated_ = newval;
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public void setScalingCoefficient(double newval) {
        if (newval == this.scalingCoeff_) {
            return;
        }
        if (newval == 0.0) {
            throw new IllegalArgumentException("Scaling coefficient cannot be 0");
        }
        if (Math.abs(newval) > 1000.0) {
            throw new IllegalArgumentException("Scaling coefficient must be in range [-1000.0 - 1000.0].");
        }
        this.scalingCoeff_ = newval;
        this.scalingFactor_ = this.scalingCoeff_ * Math.pow(10.0, this.scalingExponent_);
        LOGGER.trace("{}, {} = {}", this.scalingCoeff_, this.scalingExponent_, this.scalingFactor_);
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public void setScalingExponent(int newval) {
        if (newval == this.scalingExponent_) {
            return;
        }
        if (newval < -50 || newval > 50) {
            throw new IllegalArgumentException("Scaling exponent must be in range [-50 - 50].");
        }
        this.scalingExponent_ = newval;
        this.scalingFactor_ = this.scalingCoeff_ * Math.pow(10.0, this.scalingExponent_);
        LOGGER.trace("{}, {} = {}", this.scalingCoeff_, this.scalingExponent_, this.scalingFactor_);
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    @Override
    public String getUnits() {
        return this.targetUnitsString_;
    }

    @Override
    public final void setUnits(String uStr) {
        String s = uStr;
        s = s == null || s.isEmpty() || "<scalar>".equals(s) ? "1" : uStr.replaceAll("\\*\\*", "^");
        if (this.comboType_ == PanCombinationType.A1_MINUS_A2_PCT || this.comboType_ == PanCombinationType.A2_MINUS_A1_PCT || this.comboType_ == PanCombinationType.A1_MINUS_A2_OVER_SUM || this.comboType_ == PanCombinationType.A2_MINUS_A1_OVER_SUM) {
            this.targetUnitsString_ = null;
            this.targetUcarUnit_ = null;
        } else if (s.charAt(0) == '[') {
            this.targetUnitsString_ = null;
            this.targetUcarUnit_ = null;
        } else {
            try {
                this.targetUnitsString_ = s;
                this.targetUcarUnit_ = NcUnitUtils.parse(s);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception parsing units string '{}'", (Object)this.targetUnitsString_);
                LOGGER.warn("Exception is {}", (Object)exc.toString());
                this.targetUnitsString_ = null;
                this.targetUcarUnit_ = null;
                this.showScaleWarning("I cannot create a UDUNITS object matching your specified units string.");
            }
        }
        this.updateUnitConverters();
        this.needsGridding_ = true;
        this.needsExtrema_ = true;
        this.findExtrema();
    }

    public String[] getUnitsChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        Unit baseUnit = null;
        switch (this.comboType_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx = this.comboType_ == PanCombinationType.A1_ONLY ? 0 : 1;
                String ustr = this.ncArrays_[idx].getUnitsStr();
                if (ustr != null) {
                    this.addToUnitsChoices(choices, ustr);
                }
                if (this.ncaUdunits_[idx] == null) break;
                baseUnit = this.ncaUdunits_[idx];
                this.addToUnitsChoices(choices, this.ncaUdunits_[idx]);
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE: 
            case MERGE: 
            case COMPARE: {
                if (this.ncaUdunits_[0] == null || this.ncaUdunits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (!this.ncArrays_[0].isCompatibleUnits(this.ncArrays_[1])) {
                    return new String[]{"[incompatible units?]"};
                }
                baseUnit = this.ncaUdunits_[0];
                for (int i = 0; i < 2; ++i) {
                    String ustr = this.ncArrays_[i].getUnitsStr();
                    if (ustr != null) {
                        this.addToUnitsChoices(choices, ustr);
                    }
                    this.addToUnitsChoices(choices, this.ncaUdunits_[i]);
                }
                break;
            }
            case VECTOR: {
                throw new RuntimeException("Got VECTOR type");
            }
            case A1_TIMES_A2: 
            case A1_OVER_A2: 
            case A2_OVER_A1: {
                if (this.ncaUdunits_[0] == null && this.ncaUdunits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                try {
                    Unit xx = null;
                    xx = this.comboType_ == PanCombinationType.A1_TIMES_A2 ? this.ncaUdunits_[0].multiplyBy(this.ncaUdunits_[1]) : (this.comboType_ == PanCombinationType.A1_OVER_A2 ? this.ncaUdunits_[0].divideBy(this.ncaUdunits_[1]) : this.ncaUdunits_[1].divideBy(this.ncaUdunits_[0]));
                    baseUnit = xx;
                    this.addToUnitsChoices(choices, xx);
                }
                catch (Exception exception) {}
                break;
            }
            case A1_MINUS_A2_PCT: 
            case A2_MINUS_A1_PCT: 
            case A1_MINUS_A2_OVER_SUM: 
            case A2_MINUS_A1_OVER_SUM: {
                if (this.ncaUdunits_[0] == null || this.ncaUdunits_[1] == null) {
                    return new String[]{"[null/unrecognized unit]"};
                }
                if (this.ncArrays_[0].isCompatibleUnits(this.ncArrays_[1])) break;
                return new String[]{"[incompatible units?]"};
            }
        }
        this.addCompatibleToUnitsChoices(choices, baseUnit);
        if (choices.isEmpty()) {
            return new String[]{"<scalar>"};
        }
        return choices.toArray(new String[0]);
    }

    protected void addCompatibleToUnitsChoices(ArrayList<String> choices, Unit baseUnit) {
        if (baseUnit == null) {
            return;
        }
        String[] compatibleStrs = null;
        if (baseUnit.isCompatible(SI.KELVIN)) {
            compatibleStrs = PanConstants.TEMPERATURE_UNITS;
        } else if (baseUnit.isCompatible(SI.METER)) {
            compatibleStrs = PanConstants.DISTANCE_UNITS;
        } else if (baseUnit.isCompatible(SI.PASCAL)) {
            compatibleStrs = PanConstants.PRESSURE_UNITS;
        } else if (baseUnit.isCompatible(SPEED_UNIT)) {
            compatibleStrs = PanConstants.SPEED_UNITS;
        } else if (baseUnit.isCompatible(SI.RADIAN)) {
            compatibleStrs = PanConstants.ANGLE_UNITS;
        }
        if (compatibleStrs != null) {
            for (String unitStr : compatibleStrs) {
                this.addToUnitsChoices(choices, unitStr);
            }
        }
    }

    protected void addToUnitsChoices(ArrayList<String> choices, Unit uu) {
        if (uu == null) {
            return;
        }
        this.addToUnitsChoices(choices, uu.toString());
        this.addToUnitsChoices(choices, uu.getSymbol());
        DerivedUnit dunit = uu.getDerivedUnit();
        if (dunit != null) {
            this.addToUnitsChoices(choices, dunit.toString());
            this.addToUnitsChoices(choices, dunit.getSymbol());
        }
    }

    protected void addToUnitsChoices(ArrayList<String> choices, String s) {
        if (s == null || s.isEmpty()) {
            return;
        }
        if ("1".equals(s)) {
            this.addToUnitsChoices(choices, "<scalar>");
        }
        for (String choice : choices) {
            if (!s.equals(choice)) continue;
            return;
        }
        choices.add(s);
    }

    protected void updateUnitConverters() {
        this.ncarUnitConverters_[0] = null;
        this.ncarUnitConverters_[1] = null;
        this.targetConverter_ = null;
        if (this.targetUcarUnit_ == null) {
            return;
        }
        switch (this.comboType_) {
            case A1_ONLY: 
            case A2_ONLY: {
                int idx;
                int n = idx = this.comboType_ == PanCombinationType.A1_ONLY ? 0 : 1;
                if (this.ncaUdunits_[idx] != null) {
                    try {
                        this.ncarUnitConverters_[idx] = this.ncaUdunits_[idx].getConverterTo(this.targetUcarUnit_);
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (A): {} -> {}", (Object)this.ncaUdunits_[idx], (Object)this.targetUcarUnit_);
                        LOGGER.warn("Exception is {}", (Object)exc.toString());
                        this.showScaleWarning(exc);
                    }
                }
                if (this.ncarUnitConverters_[idx] != null) break;
                this.targetUnitsString_ = null;
                this.targetUcarUnit_ = null;
                break;
            }
            case A1_PLUS_A2: 
            case A1_MINUS_A2: 
            case A2_MINUS_A1: 
            case AVERAGE: 
            case MERGE: 
            case COMPARE: 
            case VECTOR: {
                for (int i = 0; i < 2; ++i) {
                    if (this.ncaUdunits_[i] == null) continue;
                    try {
                        this.ncarUnitConverters_[i] = this.ncaUdunits_[i].getConverterTo(this.targetUcarUnit_);
                        continue;
                    }
                    catch (ConversionException exc) {
                        LOGGER.warn("Units conversion exception (B), {}: {} -> {}", i, this.ncaUdunits_[i], this.targetUcarUnit_);
                        LOGGER.warn("Exception is {}", (Object)exc.toString());
                        this.ncarUnitConverters_[0] = null;
                        this.ncarUnitConverters_[1] = null;
                        this.showScaleWarning(exc);
                        break;
                    }
                }
                if (this.ncarUnitConverters_[0] == null) {
                    this.targetUnitsString_ = null;
                    this.targetUcarUnit_ = null;
                }
                this.targetConverter_ = null;
                break;
            }
            case A1_MINUS_A2_PCT: 
            case A2_MINUS_A1_PCT: 
            case A1_MINUS_A2_OVER_SUM: 
            case A2_MINUS_A1_OVER_SUM: {
                try {
                    Converter c = this.ncaUdunits_[1].getConverterTo(this.ncaUdunits_[0]);
                    this.ncarUnitConverters_[0] = null;
                    this.ncarUnitConverters_[1] = c;
                }
                catch (ConversionException exc) {
                    LOGGER.warn("Units conversion exception for {}", (Object)this.comboType_);
                    LOGGER.warn("Exception is {}", (Object)exc.toString());
                    this.ncarUnitConverters_[0] = null;
                    this.ncarUnitConverters_[1] = null;
                    this.showScaleWarning(exc);
                    break;
                }
                this.makeTargetConverter(SCALAR_UNIT);
                break;
            }
            case A1_TIMES_A2: {
                Unit finalSrcUnit = null;
                if (this.ncaUdunits_[0] == null && this.ncaUdunits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUdunits_[0] == null) {
                    finalSrcUnit = this.ncaUdunits_[1];
                } else if (this.ncaUdunits_[1] == null) {
                    finalSrcUnit = this.ncaUdunits_[0];
                } else {
                    try {
                        finalSrcUnit = this.ncaUdunits_[0].multiplyBy(this.ncaUdunits_[1]);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A1_OVER_A2: {
                Unit finalSrcUnit = null;
                if (this.ncaUdunits_[0] == null && this.ncaUdunits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUdunits_[0] == null) {
                    try {
                        finalSrcUnit = this.ncaUdunits_[1].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A1_OVER_A2 - A");
                        LOGGER.warn("Exception is {}", (Object)exc.toString());
                        finalSrcUnit = null;
                        this.showScaleWarning(exc);
                    }
                } else if (this.ncaUdunits_[1] == null) {
                    finalSrcUnit = this.ncaUdunits_[0];
                } else {
                    try {
                        finalSrcUnit = this.ncaUdunits_[0].divideBy(this.ncaUdunits_[1]);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A1_OVER_A2 - B");
                        LOGGER.warn("Exception is {}", (Object)exc.toString());
                        finalSrcUnit = null;
                        this.showScaleWarning(exc);
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
            case A2_OVER_A1: {
                Unit finalSrcUnit = null;
                if (this.ncaUdunits_[0] == null && this.ncaUdunits_[1] == null) {
                    finalSrcUnit = null;
                } else if (this.ncaUdunits_[0] == null) {
                    finalSrcUnit = this.ncaUdunits_[1];
                } else if (this.ncaUdunits_[1] == null) {
                    try {
                        finalSrcUnit = this.ncaUdunits_[0].raiseTo(-1);
                    }
                    catch (Exception exc) {
                        finalSrcUnit = null;
                    }
                } else {
                    try {
                        finalSrcUnit = this.ncaUdunits_[1].divideBy(this.ncaUdunits_[0]);
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Units conversion exception A2_OVER_A1");
                        LOGGER.warn("Exception is {}", (Object)exc.toString());
                        finalSrcUnit = null;
                        this.showScaleWarning(exc);
                    }
                }
                this.makeTargetConverter(finalSrcUnit);
                break;
            }
        }
    }

    private void makeTargetConverter(Unit unit) {
        this.targetConverter_ = null;
        if (this.targetUcarUnit_ != null && unit == null) {
            try {
                LOGGER.trace("unit {}, target {}", (Object)unit, (Object)this.targetUcarUnit_);
                this.targetConverter_ = unit.getConverterTo(this.targetUcarUnit_);
            }
            catch (ConversionException exc) {
                LOGGER.warn("Could not create converter from {} to {}", (Object)unit, (Object)this.targetUcarUnit_);
                LOGGER.warn("Exception is {}", (Object)exc.toString());
                this.showScaleWarning("I cannot create a UDUNITS converter matching your specified units string.");
            }
        }
        if (this.targetConverter_ == null) {
            this.targetUnitsString_ = null;
            this.targetUcarUnit_ = null;
        }
    }

    protected abstract void regrid();

    protected abstract void prepareGrid();

    protected void fillArrayNaN(double[] array) {
        int isize = array.length;
        for (int i = 0; i < isize; ++i) {
            array[i] = Double.NaN;
        }
    }

    @Override
    public double getMinValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMin_;
    }

    @Override
    public double getMaxValue() {
        if (this.needsExtrema_) {
            this.findExtrema();
        }
        return this.dataMax_;
    }

    private final synchronized void findExtrema() {
        if (!this.needsExtrema_) {
            return;
        }
        this.dataMin_ = Double.NaN;
        this.dataMax_ = Double.NaN;
        if (this.comboType_ == PanCombinationType.A1_ONLY) {
            this.dataMin_ = this.ncArrays_[0].minimumValue();
            this.dataMax_ = this.ncArrays_[0].maximumValue();
            if (this.ncarUnitConverters_[0] != null) {
                this.dataMin_ = this.ncarUnitConverters_[0].convert(this.dataMin_);
                this.dataMax_ = this.ncarUnitConverters_[0].convert(this.dataMax_);
            }
        } else if (this.comboType_ == PanCombinationType.A2_ONLY) {
            this.dataMin_ = this.ncArrays_[1].minimumValue();
            this.dataMax_ = this.ncArrays_[1].maximumValue();
            if (this.ncarUnitConverters_[1] != null) {
                this.dataMin_ = this.ncarUnitConverters_[1].convert(this.dataMin_);
                this.dataMax_ = this.ncarUnitConverters_[1].convert(this.dataMax_);
            }
        } else if (this.comboType_ == PanCombinationType.COMPARE) {
            double min1 = this.ncArrays_[0].minimumValue();
            double max1 = this.ncArrays_[0].maximumValue();
            if (this.ncarUnitConverters_[0] != null) {
                min1 = this.ncarUnitConverters_[0].convert(min1);
                max1 = this.ncarUnitConverters_[0].convert(max1);
            }
            double min2 = this.ncArrays_[1].minimumValue();
            double max2 = this.ncArrays_[1].maximumValue();
            if (this.ncarUnitConverters_[1] != null) {
                min2 = this.ncarUnitConverters_[1].convert(min2);
                max2 = this.ncarUnitConverters_[1].convert(max2);
            }
            this.dataMin_ = Math.min(min1, min2);
            this.dataMax_ = Math.max(max1, max2);
        } else {
            if (this.needsGridding_) {
                this.regrid();
            }
            boolean onefound = false;
            for (double dval : this.outputVals_[0]) {
                if (Double.isNaN(dval) || Double.isInfinite(dval)) continue;
                if (onefound) {
                    if (dval < this.dataMin_) {
                        this.dataMin_ = dval;
                        continue;
                    }
                    if (!(dval > this.dataMax_)) continue;
                    this.dataMax_ = dval;
                    continue;
                }
                this.dataMin_ = dval;
                this.dataMax_ = dval;
                onefound = true;
            }
        }
        if (this.scalingFactor_ != 1.0) {
            this.dataMin_ /= this.scalingFactor_;
            this.dataMax_ /= this.scalingFactor_;
            if (this.dataMax_ < this.dataMin_) {
                double temp = this.dataMax_;
                this.dataMax_ = this.dataMin_;
                this.dataMin_ = temp;
            }
        }
        if (this.dataMax_ <= this.dataMin_) {
            this.dataMax_ = this.dataMin_ + 1.0E-25;
        }
        this.needsExtrema_ = false;
    }

    public String getVarShortName(int idx) {
        if (this.ncArrays_[idx] == null) {
            return null;
        }
        return this.ncArrays_[idx].getShortName();
    }

    public String getVarLongName(int idx) {
        if (this.ncArrays_[idx] == null) {
            return null;
        }
        String lname = this.ncArrays_[idx].getLongName();
        if (lname != null) {
            return lname;
        }
        return this.ncArrays_[idx].getShortName();
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("");
        if (this.comboType_ == PanCombinationType.A1_ONLY || this.comboType_ == PanCombinationType.A2_ONLY) {
            int idx = this.comboType_ == PanCombinationType.A1_ONLY ? 0 : 1;
            String lname = this.ncArrays_[idx].getLongName();
            if (lname != null) {
                sb.append(lname);
            } else {
                sb.append(this.ncArrays_[idx].getShortName());
            }
            sb.append(" (");
            this.appendScaling(sb);
            if (this.ncarUnitConverters_[idx] != null) {
                sb.append(this.targetUnitsString_);
            } else {
                String unitsStr = this.ncArrays_[idx].getUnitsStr();
                if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
                    sb.append(unitsStr);
                }
            }
            sb.append(')');
            return sb.toString();
        }
        String first = this.ncArrays_[0].getLongName();
        String second = this.ncArrays_[1].getLongName();
        if (first == null) {
            first = "null";
        }
        if (second == null) {
            second = "null";
        }
        if (first.equalsIgnoreCase(second)) {
            second = first;
        }
        switch (this.comboType_) {
            case A1_MINUS_A2: {
                sb.append(first).append(" - ").append(second);
                break;
            }
            case A2_MINUS_A1: {
                sb.append(second).append(" - ").append(first);
                break;
            }
            case A1_PLUS_A2: {
                sb.append(first).append(" + ").append(second);
                break;
            }
            case A1_TIMES_A2: {
                sb.append(first).append(" \u00d7 ").append(second);
                break;
            }
            case A1_OVER_A2: {
                sb.append(first).append(" / ").append(second);
                break;
            }
            case A2_OVER_A1: {
                sb.append(second).append(" / ").append(first);
                break;
            }
            case A1_MINUS_A2_PCT: {
                sb.append('(').append(first).append(" - ").append(second).append(')').append(" / ").append(second);
                break;
            }
            case A2_MINUS_A1_PCT: {
                sb.append('(').append(second).append(" - ").append(first).append(')').append(" / ").append(first);
                break;
            }
            case A1_MINUS_A2_OVER_SUM: {
                sb.append('(').append(first).append(" - ").append(second).append(')').append(" / ").append('(').append(first).append(" + ").append(second).append(')');
                break;
            }
            case A2_MINUS_A1_OVER_SUM: {
                sb.append('(').append(second).append(" - ").append(first).append(')').append(" / ").append('(').append(first).append(" + ").append(second).append(')');
                break;
            }
            case AVERAGE: {
                sb.append("0.5 \u00d7 ").append('(').append(first).append(" + ").append(second).append(')');
                break;
            }
            case MERGE: {
                sb.append("Combine ").append('(').append(first).append(", ").append(second).append(')');
                break;
            }
            case VECTOR: {
                throw new RuntimeException("Got VECTOR type");
            }
            case COMPARE: {
                sb.append(first).append(" vs ").append(second);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.comboType_);
            }
        }
        if (this.targetUnitsString_ != null && !this.targetUnitsString_.equals(Character.valueOf('1'))) {
            sb.append(" (");
            this.appendScaling(sb);
            if (this.targetUcarUnit_ != null) {
                sb.append(this.targetUnitsString_);
            } else {
                sb.append("Bad Units?");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private void appendScaling(StringBuilder sb) {
        if (this.scalingFactor_ == 1.0) {
            return;
        }
        String appendStr = new PrintfFormat("%.5g").sprintfx0(this.scalingFactor_);
        sb.append(appendStr).append(' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(PanDataListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.add(PanDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(PanDataListener l) {
        Object object = this.lock_;
        synchronized (object) {
            if (this.listenerList_ == null) {
                return;
            }
            this.listenerList_.remove(PanDataListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListeners() {
        if (this.listenerList_ == null) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            for (PanDataListener listener : (PanDataListener[])this.listenerList_.getListeners(PanDataListener.class)) {
                this.removeDataListener(listener);
            }
        }
    }

    public synchronized void fireDataEvent(PanDataEvent.EType id) {
        if (this.listenerList_ == null) {
            return;
        }
        PanDataEvent e = new PanDataEvent(this, id);
        for (PanDataListener listener : (PanDataListener[])this.listenerList_.getListeners(PanDataListener.class)) {
            EventQueue.invokeLater(() -> listener.dataChanged(e));
        }
    }

    protected void showScaleWarning(Exception exc) {
        String excstr = exc.toString();
        if (exc instanceof ConversionException) {
            this.showScaleWarning("There was an error converting the data units to your specified units.");
        } else {
            this.showScaleWarning(excstr);
        }
    }

    protected void showScaleWarning(String message) {
        PanPlotFrame pframe = this.pmeta_.getFrame();
        if (pframe == null || !pframe.isVisible()) {
            return;
        }
        SlowMessage.show((Component)pframe, "Plot Scale Warning", message);
    }

    static {
        try {
            SCALAR_UNIT = NcUnitUtils.parse("1");
            SPEED_UNIT = SI.METER.divideBy(SI.SECOND);
        }
        catch (Exception exc) {
            LOGGER.error("This is weird. I could not create the scalar or speed unit object: {}", (Object)exc.toString());
            throw new RuntimeException("This is weird. I could not create the scalar or speed unit object.");
        }
    }

    protected static enum CombineOperation {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        AVERAGE,
        MERGE,
        MAGNITUDE;

    }
}

