/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.ui.GuiUtils;
import javax.swing.Action;
import javax.swing.JButton;

public final class PanButton
extends JButton {
    private PanButton(String name, Action action, String text) {
        super(action);
        if (name != null) {
            this.setName(name);
        }
        if (text != null) {
            this.setText(text);
        }
    }

    public static PanButton create(String name, Action action) {
        return new PanButton(name, action, null);
    }

    public static PanButton create(String name, String text) {
        return new PanButton(name, null, text);
    }

    public static PanButton small(String name, Action action) {
        PanButton button = new PanButton(name, action, null);
        GuiUtils.setSizeSmall(button);
        return button;
    }

    public static PanButton small(String name, Action action, String text) {
        PanButton button = new PanButton(name, action, text);
        GuiUtils.setSizeSmall(button);
        return button;
    }

    public static PanButton small(Action action, String text) {
        PanButton button = new PanButton(null, action, null);
        button.setText(text);
        GuiUtils.setSizeSmall(button);
        return button;
    }

    public static PanButton small(String name, String text) {
        PanButton button = new PanButton(name, null, text);
        GuiUtils.setSizeSmall(button);
        return button;
    }

    public static PanButton small(String text) {
        PanButton button = new PanButton(null, null, text);
        GuiUtils.setSizeSmall(button);
        return button;
    }

    public static PanButton createSegmented(String text, String position) {
        PanButton button = new PanButton(null, null, text);
        button.putClientProperty("JButton.buttonType", "segmented");
        button.putClientProperty("JButton.segmentPosition", position);
        GuiUtils.restrictSize(button);
        return button;
    }
}

