/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.about.PanAboutFrame;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanWindowAdapter
extends WindowAdapter
implements ComponentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PanWindowAdapter getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanWindowAdapter() {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanPlotFrame) {
            PanPlotFrame ff = (PanPlotFrame)ww;
            ff.setControlWindoidsVisible(true);
        }
        if (ww instanceof PanFrame) {
            ((PanFrame)ww).refresh();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanAboutFrame) {
            ((PanAboutFrame)ww).setVisible(false);
        } else if (ww instanceof PanPlotFrame) {
            PanPlotFrame ff = (PanPlotFrame)ww;
            ff.setControlWindoidsVisible(false);
        }
        if (ww instanceof PanFrame) {
            ((PanFrame)ww).repaint();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanPlotFrame) {
            ((PanPlotFrame)ww).close();
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanPlotFrame) {
            PanPlotFrame ff = (PanPlotFrame)ww;
            if (PlatformUtils.isMacintosh()) {
                ff.setControlWindoidsVisible(true);
            }
        }
        if (ww instanceof PanFrame) {
            ((PanFrame)ww).refresh();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanAboutFrame) {
            ((PanAboutFrame)ww).setVisible(false);
        } else if (ww instanceof PanPlotFrame) {
            PanPlotFrame ff = (PanPlotFrame)ww;
            ff.refreshMenuBar();
        }
        if (ww instanceof PanFrame) {
            ((PanFrame)ww).repaint();
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        if (e == null) {
            return;
        }
        Window ww = e.getWindow();
        if (ww == null || LOGGER.isTraceEnabled()) {
            // empty if block
        }
        if (ww instanceof PanPlotFrame) {
            ((PanPlotFrame)ww).setControlWindoidsVisible(true);
        }
        if (ww instanceof PanFrame) {
            ((PanFrame)ww).refresh();
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        Window ww;
        if (e == null) {
            return;
        }
        if (!LOGGER.isTraceEnabled() || (ww = e.getWindow()) != null) {
            // empty if block
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        PanFrame pf;
        Component cc = e.getComponent();
        if (cc instanceof PanFrame && (pf = (PanFrame)cc).needsResizeToFitDisplay()) {
            pf.resizeToFitDisplay();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private static class Singleton {
        private static final PanWindowAdapter INSTANCE = new PanWindowAdapter();

        private Singleton() {
        }
    }
}

