/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.treetable.TreeTable;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import gov.nasa.giss.ui.treetable.TreeTablePanel;

public abstract class SearchableTreeTablePanel
extends TreeTablePanel {
    public SearchableTreeTablePanel(TreeTableModel model) {
        super(model);
    }

    public boolean searchFor(String sterm) {
        return this.searchFor(sterm, 0);
    }

    public boolean searchForNext(String sterm) {
        TreeTable tt = this.getTreeTable();
        if (this.searchFor(sterm, tt.getSelectedRow() + 1)) {
            return true;
        }
        return this.searchFor(sterm, 0);
    }

    private boolean searchFor(String sterm, int fromRow) {
        if (sterm == null || sterm.length() < 1) {
            return false;
        }
        TreeTable tt = this.getTreeTable();
        int irows = tt.getRowCount();
        for (int i = fromRow; i < irows; ++i) {
            TreeTableNode[] path;
            TreeTableNode node = tt.getNodeForRow(i);
            if (this.nodeMatches(node, sterm)) {
                tt.setSelectedNode(node);
                tt.makeNodeVisible(node);
                return true;
            }
            if (tt.isExpanded(i) || node.getChildCount() <= 0 || (path = this.searchChildrenFor(node, sterm)) == null) continue;
            int psize = path.length;
            for (int j = 0; j < psize; ++j) {
                int k = tt.getRowForNode(path[j]);
                tt.expandNodeAtRow(k);
            }
            tt.setSelectedNode(path[psize - 1]);
            tt.makeNodeVisible(path[psize - 1]);
            return true;
        }
        return false;
    }

    private TreeTableNode[] searchChildrenFor(TreeTableNode node, String sterm) {
        if (this.nodeMatches(node, sterm)) {
            return new TreeTableNode[]{node};
        }
        if (node.isLeaf() || node.getChildCount() == 0) {
            return null;
        }
        TreeTableNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            TreeTableNode[] path = this.searchChildrenFor(children[i], sterm);
            if (path == null) continue;
            TreeTableNode[] xpath = new TreeTableNode[path.length + 1];
            xpath[0] = node;
            for (int j = 0; j < path.length; ++j) {
                xpath[j + 1] = path[j];
            }
            return xpath;
        }
        return null;
    }

    protected abstract boolean nodeMatches(TreeTableNode var1, String var2);
}

