/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.vpx.vp9;

import java.nio.ByteBuffer;
import org.jcodec.codecs.vpx.VPXBooleanDecoder;
import org.jcodec.codecs.vpx.vp9.Consts;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.NIOUtils;

public class DecodingContext {
    private int profile;
    private int showExistingFrame;
    private int frameToShowMapIdx;
    private int frameType;
    private int showFrame;
    private int errorResilientMode;
    private int refreshFrameFlags;
    private int frameIsIntra;
    private int intraOnly;
    private int resetFrameContext;
    private int subsamplingX;
    private int colorSpace;
    private int subsamplingY;
    private int bitDepth;
    private int frameWidth;
    private int frameHeight;
    private int renderWidth;
    private int renderHeight;
    private int[] refFrameWidth = new int[4];
    private int[] refFrameHeight = new int[4];
    private int[] refFrameIdx = new int[3];
    private int[] refFrameSignBias = new int[3];
    private int allowHighPrecisionMv;
    private int interpolationFilter;
    private int frameParallelDecodingMode;
    private int refreshFrameContext;
    private int frameContextIdx;
    private int[] loopFilterRefDeltas = new int[4];
    private int[] loopFilterModeDeltas = new int[2];
    private int baseQIdx;
    private int deltaQYDc;
    private int deltaQUvDc;
    private int deltaQUvAc;
    private boolean lossless;
    private int segmentationEnabled;
    private int[] segmentationTreeProbs = new int[7];
    private int[] segmentationPredProb = new int[3];
    private int[][] featureEnabled = new int[8][4];
    private int[][] featureData = new int[8][4];
    private int miCols;
    private int miRows;
    private int sb64Cols;
    private int sb64Rows;
    private int tileRowsLog2;
    private int tileColsLog2;
    private int txMode;
    private int compFixedRef;
    private int compVarRef0;
    private int compVarRef1;
    private int[][] txProbs8x8 = new int[2][1];
    private int[][] txProbs16x16 = new int[2][2];
    private int[][] txProbs32x32 = new int[2][3];
    private int referenceMode;
    private int[][][][][][] coefProbs;
    private int[] skipProb = new int[3];
    private int[][] interModeProbs = new int[7][3];
    private int[][] interpFilterProbs = new int[4][2];
    private int[] isInterProb = new int[4];
    private int[] compModeProb = new int[5];
    private int[][] singleRefProb = new int[5][2];
    private int[] compRefProb = new int[5];
    private int[][] yModeProbs = new int[4][9];
    private int[][] partitionProbs = new int[16][3];
    private int[] mvJointProbs = new int[3];
    private int[] mvSignProb = new int[2];
    private int[][] mvClassProbs = new int[2][10];
    private int[] mvClass0BitProb = new int[2];
    private int[][] mvBitsProb = new int[2][10];
    private int[][][] mvClass0FrProbs = new int[2][2][3];
    private int[][] mvFrProbs = new int[2][3];
    private int[] mvClass0HpProb = new int[2];
    private int[] mvHpProb = new int[2];

    public static DecodingContext createFromHeaders(ByteBuffer bb) {
        DecodingContext dc = new DecodingContext();
        dc.readHeaders(bb);
        return dc;
    }

    public boolean isKeyIntraFrame() {
        return false;
    }

    public boolean isSegmentationEnabled() {
        return false;
    }

    public boolean isUpdateSegmentMap() {
        return false;
    }

    public boolean isSegmentFeatureActive(int segmentId, int segLvlSkip) {
        return false;
    }

    public boolean isSegmentMapConditionalUpdate() {
        return false;
    }

    public int getSegmentFeature(int segmentId, int segLvlRefFrame) {
        return 0;
    }

    public int getCompFixedRef() {
        return 0;
    }

    public int refFrameSignBias(int fixedRef) {
        return 0;
    }

    public int getInterpFilter() {
        return 0;
    }

    public int getRefMode() {
        return 0;
    }

    public long[][] getLeftMVs() {
        return null;
    }

    public long[][] getAboveMVs() {
        return null;
    }

    public long[][] getAboveLeftMVs() {
        return null;
    }

    public long[] getLeft4x4MVs() {
        return null;
    }

    public long[] getAbove4x4MVs() {
        return null;
    }

    public boolean[] getAboveCompound() {
        return null;
    }

    public boolean[] getLeftCompound() {
        return null;
    }

    public int[][][] getRefs() {
        return null;
    }

    public boolean isAllowHpMv() {
        return false;
    }

    public boolean isUsePrevFrameMvs() {
        return false;
    }

    public long[][] getPrevFrameMv() {
        return null;
    }

    public int getMiFrameHeight() {
        return 0;
    }

    public int getMiFrameWidth() {
        return 0;
    }

    public int getTileStart() {
        return 0;
    }

    public int[] getLeftInterpFilters() {
        return null;
    }

    public int[] getAboveInterpFilters() {
        return null;
    }

    public int[] getLeftLumaModes() {
        return null;
    }

    public int[] getAboveLumaModes() {
        return null;
    }

    public int getTileHeight() {
        return 0;
    }

    public int getTileWidth() {
        return 0;
    }

    public int getCompVarRef(int i) {
        return 0;
    }

    public int[] getAboveIntraModes() {
        return null;
    }

    public int[] getLeftIntraModes() {
        return null;
    }

    public int getTxMode() {
        return 0;
    }

    public int[][] getTxSizes() {
        return null;
    }

    public boolean[][] getSkippedBlockes() {
        return null;
    }

    public boolean[] getAboveSegIdPredicted() {
        return null;
    }

    public boolean[] getLeftSegIdPredicted() {
        return null;
    }

    public int[][] getPrevSegmentIds() {
        return null;
    }

    public int getSubX() {
        return 0;
    }

    public int getSubY() {
        return 0;
    }

    public int[] getScan(int plane, int txSz, int blockIdx) {
        return null;
    }

    public int getTxType(int plane, int txSz, int blockIdx) {
        return 0;
    }

    public int getBitDepth() {
        return 0;
    }

    public int[][] getAboveNonzeroContext() {
        return null;
    }

    public int[][] getLeftNonzeroContext() {
        return null;
    }

    public int[] getTokenCache() {
        return null;
    }

    public int[] getLeftPartitionSizes() {
        return null;
    }

    public int[] getAbovePartitionSizes() {
        return null;
    }

    private void readHeaders(ByteBuffer bb) {
        BitReader br = BitReader.createBitReader(bb);
        int frame_marker = br.readNBit(2);
        this.profile = br.read1Bit() | br.read1Bit() << 1;
        if (this.profile == 3) {
            br.read1Bit();
        }
        this.showExistingFrame = br.read1Bit();
        if (this.showExistingFrame == 1) {
            this.frameToShowMapIdx = br.readNBit(3);
        }
        this.frameType = br.read1Bit();
        this.showFrame = br.read1Bit();
        this.errorResilientMode = br.read1Bit();
        if (this.frameType == 0) {
            DecodingContext.frame_sync_code(br);
            this.readColorConfig(br);
            this.readFrameSize(br);
            this.readRenderSize(br);
            this.refreshFrameFlags = 255;
            this.frameIsIntra = 1;
        } else {
            this.intraOnly = 0;
            if (this.showFrame == 0) {
                this.intraOnly = br.read1Bit();
            }
            this.resetFrameContext = 0;
            if (this.errorResilientMode == 0) {
                this.resetFrameContext = br.readNBit(2);
            }
            if (this.intraOnly == 1) {
                DecodingContext.frame_sync_code(br);
                if (this.profile > 0) {
                    this.readColorConfig(br);
                } else {
                    this.colorSpace = 1;
                    this.subsamplingX = 1;
                    this.subsamplingY = 1;
                    this.bitDepth = 8;
                }
                this.refreshFrameFlags = br.readNBit(8);
                this.readFrameSize(br);
                this.readRenderSize(br);
            } else {
                int refreshFrameFlags = br.readNBit(8);
                for (int i = 0; i < 3; ++i) {
                    this.refFrameIdx[i] = br.readNBit(3);
                    this.refFrameSignBias[0 + i] = br.read1Bit();
                }
                this.readFrameSizeWithRefs(br);
                this.allowHighPrecisionMv = br.read1Bit();
                this.readInterpolationFilter(br);
            }
        }
        this.refreshFrameContext = 0;
        if (this.errorResilientMode == 0) {
            this.refreshFrameContext = br.read1Bit();
            this.frameParallelDecodingMode = br.read1Bit();
        }
        this.frameContextIdx = br.readNBit(2);
        this.readLoopFilterParams(br);
        this.readQuantizationParams(br);
        this.readSegmentationParams(br);
        this.readTileInfo(br);
        int headerSizeInBytes = br.readNBit(16);
        br.terminate();
        ByteBuffer compressedHeader = NIOUtils.read(bb, headerSizeInBytes);
        VPXBooleanDecoder boolDec = new VPXBooleanDecoder(compressedHeader, 0);
        this.readCompressedHeader(boolDec);
    }

    void computeImageSize() {
        this.miCols = this.frameWidth + 7 >> 3;
        this.miRows = this.frameHeight + 7 >> 3;
        this.sb64Cols = this.miCols + 7 >> 3;
        this.sb64Rows = this.miRows + 7 >> 3;
    }

    int calc_min_log2_tile_cols() {
        int minLog2 = 0;
        while (64 << minLog2 < this.sb64Cols) {
            ++minLog2;
        }
        return minLog2;
    }

    int calc_max_log2_tile_cols() {
        int maxLog2 = 1;
        while (this.sb64Cols >> maxLog2 >= 4) {
            ++maxLog2;
        }
        return maxLog2 - 1;
    }

    private void readTileInfo(BitReader br) {
        int increment_tile_cols_log2;
        int minLog2TileCols = this.calc_min_log2_tile_cols();
        int maxLog2TileCols = this.calc_max_log2_tile_cols();
        this.tileColsLog2 = minLog2TileCols;
        while (this.tileColsLog2 < maxLog2TileCols && (increment_tile_cols_log2 = br.read1Bit()) == 1) {
            ++this.tileColsLog2;
        }
        this.tileRowsLog2 = br.read1Bit();
        if (this.tileRowsLog2 == 1) {
            int increment_tile_rows_log2 = br.read1Bit();
            this.tileRowsLog2 += increment_tile_rows_log2;
        }
    }

    private static int readProb(BitReader br) {
        if (br.read1Bit() == 1) {
            return br.readNBit(8);
        }
        return 255;
    }

    private void readSegmentationParams(BitReader br) {
        this.segmentationEnabled = br.read1Bit();
        if (this.segmentationEnabled == 1) {
            int i;
            if (br.read1Bit() == 1) {
                for (int i2 = 0; i2 < 7; ++i2) {
                    this.segmentationTreeProbs[i2] = DecodingContext.readProb(br);
                }
                int segmentationTemporalUpdate = br.read1Bit();
                for (i = 0; i < 3; ++i) {
                    this.segmentationPredProb[i] = segmentationTemporalUpdate == 1 ? DecodingContext.readProb(br) : 255;
                }
            }
            if (br.read1Bit() == 1) {
                int segmentationAbsOrDeltaUpdate = br.read1Bit();
                for (i = 0; i < 8; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        if (br.read1Bit() != 1) continue;
                        this.featureEnabled[i][j] = 1;
                        int bits_to_read = Consts.SEGMENTATION_FEATURE_BITS[j];
                        int value = br.readNBit(bits_to_read);
                        if (Consts.SEGMENTATION_FEATURE_SIGNED[j] == 1 && br.read1Bit() == 1) {
                            value *= -1;
                        }
                        this.featureData[i][j] = value;
                    }
                }
            }
        }
    }

    private static int readDeltaQ(BitReader br) {
        int delta_coded = br.read1Bit();
        if (delta_coded == 1) {
            return br.readNBitSigned(5);
        }
        return 0;
    }

    private void readQuantizationParams(BitReader br) {
        this.baseQIdx = br.readNBit(8);
        this.deltaQYDc = DecodingContext.readDeltaQ(br);
        this.deltaQUvDc = DecodingContext.readDeltaQ(br);
        this.deltaQUvAc = DecodingContext.readDeltaQ(br);
        this.lossless = this.baseQIdx == 0 && this.deltaQYDc == 0 && this.deltaQUvDc == 0 && this.deltaQUvAc == 0;
    }

    private void readLoopFilterParams(BitReader br) {
        int loopFilterLevel = br.readNBit(6);
        int loopFilterSharpness = br.readNBit(3);
        if (br.read1Bit() == 1 && br.read1Bit() == 1) {
            int i;
            for (i = 0; i < 4; ++i) {
                if (br.read1Bit() != 1) continue;
                this.loopFilterRefDeltas[i] = br.readNBit(6);
            }
            for (i = 0; i < 2; ++i) {
                if (br.read1Bit() != 1) continue;
                this.loopFilterModeDeltas[i] = br.readNBit(6);
            }
        }
    }

    private void readInterpolationFilter(BitReader br) {
        this.interpolationFilter = 3;
        if (br.read1Bit() == 0) {
            this.interpolationFilter = Consts.LITERAL_TO_FILTER_TYPE[br.readNBit(2)];
        }
    }

    private void readFrameSizeWithRefs(BitReader br) {
        int i;
        for (i = 0; i < 3; ++i) {
            if (br.read1Bit() != 1) continue;
            this.frameWidth = this.refFrameWidth[this.refFrameIdx[i]];
            this.frameHeight = this.refFrameHeight[this.refFrameIdx[i]];
            break;
        }
        if (i == 3) {
            this.readFrameSize(br);
        } else {
            this.computeImageSize();
        }
        this.readRenderSize(br);
    }

    private void readRenderSize(BitReader br) {
        if (br.read1Bit() == 1) {
            this.renderWidth = br.readNBit(16) + 1;
            this.renderHeight = br.readNBit(16) + 1;
        } else {
            this.renderWidth = this.frameWidth;
            this.renderHeight = this.frameHeight;
        }
    }

    private void readFrameSize(BitReader br) {
        this.frameWidth = br.readNBit(16) + 1;
        this.frameHeight = br.readNBit(16) + 1;
        this.computeImageSize();
    }

    private void readColorConfig(BitReader br) {
        int ten_or_twelve_bit;
        this.bitDepth = this.profile >= 2 ? ((ten_or_twelve_bit = br.read1Bit()) == 1 ? 12 : 10) : 8;
        int colorSpace = br.readNBit(3);
        if (colorSpace != 7) {
            int color_range = br.read1Bit();
            if (this.profile == 1 || this.profile == 3) {
                this.subsamplingX = br.read1Bit();
                this.subsamplingY = br.read1Bit();
                int n = br.read1Bit();
            } else {
                this.subsamplingX = 1;
                this.subsamplingY = 1;
            }
        } else {
            boolean colorRange = true;
            if (this.profile == 1 || this.profile == 3) {
                this.subsamplingX = 0;
                this.subsamplingY = 0;
                int n = br.read1Bit();
            }
        }
    }

    private static void frame_sync_code(BitReader br) {
        int code = br.readNBit(24);
    }

    private void readCompressedHeader(VPXBooleanDecoder boolDec) {
        int maxTxSize = Consts.tx_mode_to_biggest_tx_size[this.txMode];
        this.coefProbs = new int[maxTxSize + 1][2][2][6][6][3];
        this.readTxMode(boolDec);
        if (this.txMode == 4) {
            this.readTxModeProbs(boolDec);
        }
        this.readCoefProbs(boolDec);
        this.readSkipProb(boolDec);
        if (this.frameIsIntra == 0) {
            this.readInterModeProbs(boolDec);
            if (this.interpolationFilter == 3) {
                this.readInterpFilterProbs(boolDec);
            }
            this.readIsInterProbs(boolDec);
            this.frameReferenceMode(boolDec);
            this.frameReferenceModeProbs(boolDec);
            this.readYModeProbs(boolDec);
            this.readPartitionProbs(boolDec);
            this.mvProbs(boolDec);
        }
    }

    private void readTxMode(VPXBooleanDecoder boolDec) {
        if (this.lossless) {
            this.txMode = 0;
        } else {
            int txMode = boolDec.decodeInt(2);
            if (txMode == 3) {
                int n = txMode + boolDec.decodeInt(1);
            }
        }
    }

    private void readTxModeProbs(VPXBooleanDecoder boolDec) {
        int j;
        int i;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 1; ++j) {
                this.txProbs8x8[i][j] = this.diffUpdateProb(boolDec, this.txProbs8x8[i][j]);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                this.txProbs16x16[i][j] = this.diffUpdateProb(boolDec, this.txProbs16x16[i][j]);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 3; ++j) {
                this.txProbs32x32[i][j] = this.diffUpdateProb(boolDec, this.txProbs32x32[i][j]);
            }
        }
    }

    private int diffUpdateProb(VPXBooleanDecoder boolDec, int prob) {
        int update_prob = boolDec.readBit(252);
        if (update_prob == 1) {
            int deltaProb = this.decodeTermSubexp(boolDec);
            prob = this.invRemapProb(deltaProb, prob);
        }
        return prob;
    }

    private int decodeTermSubexp(VPXBooleanDecoder boolDec) {
        int bit = boolDec.readBitEq();
        if (bit == 0) {
            return boolDec.decodeInt(4);
        }
        bit = boolDec.readBitEq();
        if (bit == 0) {
            return boolDec.decodeInt(4) + 16;
        }
        bit = boolDec.readBitEq();
        if (bit == 0) {
            return boolDec.decodeInt(5) + 32;
        }
        int v = boolDec.decodeInt(7);
        if (v < 65) {
            return v + 64;
        }
        bit = boolDec.readBitEq();
        return (v << 1) - 1 + bit;
    }

    private int invRemapProb(int deltaProb, int prob) {
        int m = prob;
        int v = deltaProb;
        v = Consts.INV_REMAP_TABLE[v];
        m = --m << 1 <= 255 ? 1 + this.invRecenterNonneg(v, m) : 255 - this.invRecenterNonneg(v, 254 - m);
        return m;
    }

    private int invRecenterNonneg(int v, int m) {
        if (v > 2 * m) {
            return v;
        }
        if ((v & 1) != 0) {
            return m - (v + 1 >> 1);
        }
        return m + (v >> 1);
    }

    private void readCoefProbs(VPXBooleanDecoder boolDec) {
        int maxTxSize = Consts.tx_mode_to_biggest_tx_size[this.txMode];
        for (int txSz = 0; txSz <= maxTxSize; ++txSz) {
            int update_probs = boolDec.readBitEq();
            if (update_probs != 1) continue;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 6; ++k) {
                        int maxL = k == 0 ? 3 : 6;
                        for (int l = 0; l < maxL; ++l) {
                            for (int m = 0; m < 3; ++m) {
                                this.coefProbs[txSz][i][j][k][l][m] = this.diffUpdateProb(boolDec, this.coefProbs[txSz][i][j][k][l][m]);
                            }
                        }
                    }
                }
            }
        }
    }

    private void readSkipProb(VPXBooleanDecoder boolDec) {
        for (int i = 0; i < 3; ++i) {
            this.skipProb[i] = this.diffUpdateProb(boolDec, this.skipProb[i]);
        }
    }

    private void readInterModeProbs(VPXBooleanDecoder boolDec) {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.interModeProbs[i][j] = this.diffUpdateProb(boolDec, this.interModeProbs[i][j]);
            }
        }
    }

    private void readInterpFilterProbs(VPXBooleanDecoder boolDec) {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 2; ++i) {
                this.interpFilterProbs[j][i] = this.diffUpdateProb(boolDec, this.interpFilterProbs[j][i]);
            }
        }
    }

    private void readIsInterProbs(VPXBooleanDecoder boolDec) {
        for (int i = 0; i < 4; ++i) {
            this.isInterProb[i] = this.diffUpdateProb(boolDec, this.isInterProb[i]);
        }
    }

    private void frameReferenceMode(VPXBooleanDecoder boolDec) {
        boolean compoundReferenceAllowed = false;
        for (int i = 1; i < 3; ++i) {
            if (this.refFrameSignBias[i + 1] == this.refFrameSignBias[1]) continue;
            compoundReferenceAllowed = true;
        }
        if (compoundReferenceAllowed) {
            int non_single_reference = boolDec.readBitEq();
            if (non_single_reference == 0) {
                this.referenceMode = 0;
            } else {
                int reference_select = boolDec.readBitEq();
                this.referenceMode = reference_select == 0 ? 1 : 2;
                this.setupCompoundReferenceMode();
            }
        } else {
            this.referenceMode = 0;
        }
    }

    private void frameReferenceModeProbs(VPXBooleanDecoder boolDec) {
        int i;
        if (this.referenceMode == 2) {
            for (i = 0; i < 5; ++i) {
                this.compModeProb[i] = this.diffUpdateProb(boolDec, this.compModeProb[i]);
            }
        }
        if (this.referenceMode != 1) {
            for (i = 0; i < 5; ++i) {
                this.singleRefProb[i][0] = this.diffUpdateProb(boolDec, this.singleRefProb[i][0]);
                this.singleRefProb[i][1] = this.diffUpdateProb(boolDec, this.singleRefProb[i][1]);
            }
        }
        if (this.referenceMode != 0) {
            for (i = 0; i < 5; ++i) {
                this.compRefProb[i] = this.diffUpdateProb(boolDec, this.compRefProb[i]);
            }
        }
    }

    private void readYModeProbs(VPXBooleanDecoder boolDec) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.yModeProbs[i][j] = this.diffUpdateProb(boolDec, this.yModeProbs[i][j]);
            }
        }
    }

    private void readPartitionProbs(VPXBooleanDecoder boolDec) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.partitionProbs[i][j] = this.diffUpdateProb(boolDec, this.partitionProbs[i][j]);
            }
        }
    }

    private void mvProbs(VPXBooleanDecoder boolDec) {
        int j;
        int i;
        for (int j2 = 0; j2 < 3; ++j2) {
            this.mvJointProbs[j2] = this.updateMvProb(boolDec, this.mvJointProbs[j2]);
        }
        for (i = 0; i < 2; ++i) {
            this.mvSignProb[i] = this.updateMvProb(boolDec, this.mvSignProb[i]);
            for (j = 0; j < 10; ++j) {
                this.mvClassProbs[i][j] = this.updateMvProb(boolDec, this.mvClassProbs[i][j]);
            }
            this.mvClass0BitProb[i] = this.updateMvProb(boolDec, this.mvClass0BitProb[i]);
            for (j = 0; j < 10; ++j) {
                this.mvBitsProb[i][j] = this.updateMvProb(boolDec, this.mvBitsProb[i][j]);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.mvClass0FrProbs[i][j][k] = this.updateMvProb(boolDec, this.mvClass0FrProbs[i][j][k]);
                }
            }
            for (int k = 0; k < 3; ++k) {
                this.mvFrProbs[i][k] = this.updateMvProb(boolDec, this.mvFrProbs[i][k]);
            }
        }
        if (this.allowHighPrecisionMv == 1) {
            for (i = 0; i < 2; ++i) {
                this.mvClass0HpProb[i] = this.updateMvProb(boolDec, this.mvClass0HpProb[i]);
                this.mvHpProb[i] = this.updateMvProb(boolDec, this.mvHpProb[i]);
            }
        }
    }

    private int updateMvProb(VPXBooleanDecoder boolDec, int prob) {
        int update_mv_prob = boolDec.readBit(252);
        if (update_mv_prob == 1) {
            int mv_prob = boolDec.decodeInt(7);
            prob = mv_prob << 1 | 1;
        }
        return prob;
    }

    private void setupCompoundReferenceMode() {
        if (this.refFrameSignBias[0] == this.refFrameSignBias[2]) {
            this.compFixedRef = 1;
            this.compVarRef0 = 0;
            this.compVarRef1 = 2;
        } else if (this.refFrameSignBias[0] == this.refFrameSignBias[1]) {
            this.compFixedRef = 2;
            this.compVarRef0 = 0;
            this.compVarRef1 = 1;
        } else {
            this.compFixedRef = 0;
            this.compVarRef0 = 2;
            this.compVarRef1 = 1;
        }
    }
}

