/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.SVGColor;
import io.sf.carte.echosvg.svggen.SVGConverter;
import io.sf.carte.echosvg.svggen.SVGCustomPaint;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGradient;
import io.sf.carte.echosvg.svggen.SVGLinearGradient;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import io.sf.carte.echosvg.svggen.SVGRadialGradient;
import io.sf.carte.echosvg.svggen.SVGTexturePaint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public class SVGPaint
implements SVGConverter {
    private SVGGradient svgGradient;
    private SVGLinearGradient svgLinearGradient;
    private SVGRadialGradient svgRadialGradient;
    private SVGTexturePaint svgTexturePaint;
    private SVGColor svgColor;
    private SVGCustomPaint svgCustomPaint;
    private SVGGeneratorContext generatorContext;

    public SVGPaint(SVGGeneratorContext generatorContext) {
        this.svgGradient = new SVGGradient(generatorContext);
        this.svgLinearGradient = new SVGLinearGradient(generatorContext);
        this.svgRadialGradient = new SVGRadialGradient(generatorContext);
        this.svgTexturePaint = new SVGTexturePaint(generatorContext);
        this.svgCustomPaint = new SVGCustomPaint(generatorContext);
        this.svgColor = new SVGColor(generatorContext);
        this.generatorContext = generatorContext;
    }

    @Override
    public List<Element> getDefinitionSet() {
        LinkedList<Element> paintDefs = new LinkedList<Element>(this.svgGradient.getDefinitionSet());
        paintDefs.addAll(this.svgLinearGradient.getDefinitionSet());
        paintDefs.addAll(this.svgRadialGradient.getDefinitionSet());
        paintDefs.addAll(this.svgTexturePaint.getDefinitionSet());
        paintDefs.addAll(this.svgCustomPaint.getDefinitionSet());
        paintDefs.addAll(this.svgColor.getDefinitionSet());
        return paintDefs;
    }

    public SVGTexturePaint getTexturePaintConverter() {
        return this.svgTexturePaint;
    }

    public SVGGradient getGradientPaintConverter() {
        return this.svgGradient;
    }

    public SVGLinearGradient getLinearGradientPaintConverter() {
        return this.svgLinearGradient;
    }

    public SVGRadialGradient getRadialGradientPaintConverter() {
        return this.svgRadialGradient;
    }

    public SVGCustomPaint getCustomPaintConverter() {
        return this.svgCustomPaint;
    }

    public SVGColor getColorConverter() {
        return this.svgColor;
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        return this.toSVG(gc.getPaint());
    }

    public SVGPaintDescriptor toSVG(Paint paint) {
        SVGPaintDescriptor paintDesc = this.svgCustomPaint.toSVG(paint);
        if (paintDesc != null) {
            return paintDesc;
        }
        if (paint instanceof Color) {
            paintDesc = SVGColor.toSVG((Color)paint, this.generatorContext);
        } else if (paint instanceof GradientPaint) {
            paintDesc = this.svgGradient.toSVG((GradientPaint)paint);
        } else if (paint instanceof LinearGradientPaint) {
            paintDesc = this.svgLinearGradient.toSVG((LinearGradientPaint)paint);
        } else if (paint instanceof RadialGradientPaint) {
            paintDesc = this.svgRadialGradient.toSVG((RadialGradientPaint)paint);
        } else if (paint instanceof TexturePaint) {
            paintDesc = this.svgTexturePaint.toSVG((TexturePaint)paint);
        }
        return paintDesc;
    }
}

